/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.update_cf;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.update_cf.CNFUploadThread;
import com.sec.osdm.update_cf.PackageUpdateRunner_cf;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class CardUpdate
extends JPanel
implements ActionListener {
    private JPanel panCardInfo = new JPanel();
    private JLabel lbCardIPTitle = new JLabel(AppLang.getText("Card IP Address"));
    private JLabel lbCardIPContents = new JLabel();
    private JLabel lbCurrentVerTitle = new JLabel(AppLang.getText("Current Version"));
    private JLabel lbCurrentVerContents = new JLabel();
    private JLabel lbDiskTotalTitle = new JLabel(AppLang.getText("Disk Total"));
    private JLabel lbDiskTotalContents = new JLabel();
    private JLabel lbDiskUsedTitle = new JLabel(AppLang.getText("Disk Used"));
    private JLabel lbDiskUsedContents = new JLabel();
    private JLabel lbDiskFreeTitle = new JLabel(AppLang.getText("Disk Free"));
    private JLabel lbDiskFreeContents = new JLabel();
    private JPanel panUpdateInfo = new JPanel();
    private JLabel lbSelectFile = new JLabel(AppLang.getText("Update File"));
    private JLabel lbSelectFilePath = new JLabel();
    private JButton btSelectFile = new JButton(AppLang.getText("..."));
    private JCheckBox cbRestart = new JCheckBox(AppLang.getText("Restart"), false);
    private JLabel lbFileVerTitle = new JLabel(AppLang.getText("The corresponding firmware's version"));
    private JLabel lbFileVerContents = new JLabel();
    public JProgressBar barProgress = new JProgressBar(0, 100);
    public JLabel lbUPdateStatus = new JLabel(AppLang.getText("Select File ..."));
    private JCheckBox cbSelect = new JCheckBox(AppLang.getText("Select"), false);
    private int iCardIndex;
    private String sCabSlot;
    private String sCardIP;
    private int iCardFTPPort;
    private int iMessagePort;
    private PackageUpdateRunner_cf frameCard;
    private String sFilePath;
    private Boolean bRestart;
    private String sFileVer;
    private CNFUploadThread uploadThread = null;

    public CardUpdate() {
        this.iCardIndex = 1;
        this.sCabSlot = "C1 - S1";
        this.sCardIP = "1.1.1.1";
        this.iCardFTPPort = 21;
        this.iMessagePort = 60024;
        this.makeGUI();
        this.getPackageInfo();
    }

    public CardUpdate(PackageUpdateRunner_cf frameCard, int iCardIndex, String sCabSlot, String sCardInfo) {
        this.iCardIndex = iCardIndex;
        this.sCabSlot = sCabSlot;
        String[] cardInfo = sCardInfo.split(";");
        this.sCardIP = cardInfo[0];
        this.iCardFTPPort = Integer.parseInt(cardInfo[1]);
        this.iMessagePort = Integer.parseInt(cardInfo[2]);
        this.frameCard = frameCard;
        this.makeGUI();
        this.getPackageInfo();
    }

    private void makeGUI() {
        this.setBorder(BorderFactory.createTitledBorder(" " + AppLang.getText("Card") + " " + this.iCardIndex + " (" + this.sCabSlot + ")"));
        this.setSize(794, 160);
        this.setLayout(null);
        this.panCardInfo.setBorder(BorderFactory.createTitledBorder(" " + AppLang.getText("Package Information") + " "));
        this.panCardInfo.setSize(240, 125);
        this.panCardInfo.setLocation(20, 20);
        this.panCardInfo.setLayout(null);
        int iStartX = 20;
        int iStartY = 20;
        int iMaginX = 100;
        int iMaginY = 20;
        int iHeightTitle = 15;
        int iWidthTitle = 100;
        int iHeightContents = 15;
        int iWidthContents = 100;
        this.lbCardIPTitle.setSize(iWidthTitle, iHeightTitle);
        this.lbCardIPTitle.setLocation(iStartX, iStartY);
        this.panCardInfo.add(this.lbCardIPTitle);
        this.lbCardIPContents.setSize(iWidthTitle, iHeightTitle);
        this.lbCardIPContents.setLocation(iStartX + iMaginX, iStartY);
        this.lbCardIPContents.setBorder(new LineBorder(Color.darkGray));
        this.lbCardIPContents.setText(" " + this.sCardIP);
        this.panCardInfo.add(this.lbCardIPContents);
        this.lbCurrentVerTitle.setSize(iWidthTitle, iHeightTitle);
        this.lbCurrentVerTitle.setLocation(iStartX, iStartY += iMaginY);
        this.panCardInfo.add(this.lbCurrentVerTitle);
        this.lbCurrentVerContents.setSize(iWidthTitle, iHeightTitle);
        this.lbCurrentVerContents.setLocation(iStartX + iMaginX, iStartY);
        this.lbCurrentVerContents.setBorder(new LineBorder(Color.darkGray));
        this.panCardInfo.add(this.lbCurrentVerContents);
        this.lbDiskTotalTitle.setSize(iWidthTitle, iHeightTitle);
        this.lbDiskTotalTitle.setLocation(iStartX, iStartY += iMaginY);
        this.panCardInfo.add(this.lbDiskTotalTitle);
        this.lbDiskTotalContents.setSize(iWidthTitle, iHeightTitle);
        this.lbDiskTotalContents.setLocation(iStartX + iMaginX, iStartY);
        this.lbDiskTotalContents.setBorder(new LineBorder(Color.darkGray));
        this.panCardInfo.add(this.lbDiskTotalContents);
        this.lbDiskUsedTitle.setSize(iWidthTitle, iHeightTitle);
        this.lbDiskUsedTitle.setLocation(iStartX, iStartY += iMaginY);
        this.panCardInfo.add(this.lbDiskUsedTitle);
        this.lbDiskUsedContents.setSize(iWidthTitle, iHeightTitle);
        this.lbDiskUsedContents.setLocation(iStartX + iMaginX, iStartY);
        this.lbDiskUsedContents.setBorder(new LineBorder(Color.darkGray));
        this.panCardInfo.add(this.lbDiskUsedContents);
        this.lbDiskFreeTitle.setSize(iWidthTitle, iHeightTitle);
        this.lbDiskFreeTitle.setLocation(iStartX, iStartY += iMaginY);
        this.panCardInfo.add(this.lbDiskFreeTitle);
        this.lbDiskFreeContents.setSize(iWidthTitle, iHeightTitle);
        this.lbDiskFreeContents.setLocation(iStartX + iMaginX, iStartY);
        this.lbDiskFreeContents.setBorder(new LineBorder(Color.darkGray));
        this.panCardInfo.add(this.lbDiskFreeContents);
        this.add(this.panCardInfo);
        this.panUpdateInfo.setBorder(BorderFactory.createTitledBorder(" " + AppLang.getText("Update Information") + " "));
        this.panUpdateInfo.setSize(440, 125);
        this.panUpdateInfo.setLocation(270, 20);
        this.panUpdateInfo.setLayout(null);
        this.lbSelectFile.setSize(100, 15);
        this.lbSelectFile.setLocation(20, 25);
        this.panUpdateInfo.add(this.lbSelectFile);
        this.lbSelectFilePath.setSize(300, 15);
        this.lbSelectFilePath.setLocation(100, 25);
        this.lbSelectFilePath.setBorder(new LineBorder(Color.darkGray));
        this.panUpdateInfo.add(this.lbSelectFilePath);
        this.btSelectFile.setSize(20, 14);
        this.btSelectFile.setLocation(402, 25);
        this.panUpdateInfo.add(this.btSelectFile);
        this.btSelectFile.addActionListener(this);
        this.cbRestart.setSize(70, 20);
        this.cbRestart.setLocation(350, 40);
        this.panUpdateInfo.add(this.cbRestart);
        this.lbFileVerTitle.setSize(250, 15);
        this.lbFileVerTitle.setLocation(20, 70);
        this.panUpdateInfo.add(this.lbFileVerTitle);
        this.lbFileVerContents.setSize(100, 15);
        this.lbFileVerContents.setLocation(300, 70);
        this.lbFileVerContents.setBorder(new LineBorder(Color.darkGray));
        this.panUpdateInfo.add(this.lbFileVerContents);
        this.barProgress.setSize(200, 13);
        this.barProgress.setLocation(23, 95);
        this.panUpdateInfo.add(this.barProgress);
        this.lbUPdateStatus.setSize(200, 15);
        this.lbUPdateStatus.setLocation(230, 95);
        this.panUpdateInfo.add(this.lbUPdateStatus);
        this.add(this.panUpdateInfo);
        this.cbSelect.setSize(65, 20);
        this.cbSelect.setLocation(719, 42);
        this.add(this.cbSelect);
    }

    private void getPackageInfo() {
        DatagramSocket socket = null;
        DatagramPacket out = null;
        DatagramPacket in = null;
        InetAddress serverInet = null;
        byte[] sendBuf = new byte[40];
        byte[] recvBuf = new byte[65508];
        String currVer = null;
        Object baseVer = null;
        byte[] diskTotal = new byte[4];
        byte[] diskUsed = new byte[4];
        byte[] diskFree = new byte[4];
        try {
            try {
                socket = new DatagramSocket();
                socket.setSoTimeout(1000);
                serverInet = InetAddress.getByName(this.sCardIP);
                out = new DatagramPacket(sendBuf, 40, serverInet, this.iMessagePort);
                System.arraycopy(CardUpdate.intToByteArray(0), 0, sendBuf, 0, 4);
                System.arraycopy(CardUpdate.intToByteArray(1), 0, sendBuf, 4, 4);
                System.arraycopy(CardUpdate.intToByteArray(2), 0, sendBuf, 8, 4);
                System.arraycopy(CardUpdate.intToByteArray(1), 0, sendBuf, 12, 4);
                System.arraycopy(CardUpdate.intToByteArray(40), 0, sendBuf, 16, 4);
                System.arraycopy(CardUpdate.intToByteArray(4), 0, sendBuf, 20, 4);
                System.arraycopy(CardUpdate.intToByteArray(0), 0, sendBuf, 24, 4);
                System.arraycopy(CardUpdate.intToByteArray(0), 0, sendBuf, 28, 4);
                System.arraycopy(CardUpdate.intToByteArray(0), 0, sendBuf, 32, 4);
                System.arraycopy(CardUpdate.intToByteArray(0), 0, sendBuf, 36, 4);
                socket.send(out);
                in = new DatagramPacket(recvBuf, 1024);
                socket.receive(in);
                currVer = new String(in.getData(), 40, 16);
                this.lbCurrentVerContents.setText(" " + currVer.trim().toUpperCase());
                System.arraycopy(CardUpdate.intToByteArray(5), 0, sendBuf, 20, 4);
                socket.send(out);
                socket.receive(in);
                System.arraycopy(in.getData(), 44, diskTotal, 0, 4);
                this.lbDiskTotalContents.setText(" " + CardUpdate.byteArrayToUnsignedInt(diskTotal) + " " + AppLang.getText("Kbytes"));
                System.arraycopy(in.getData(), 48, diskUsed, 0, 4);
                this.lbDiskUsedContents.setText(" " + CardUpdate.byteArrayToUnsignedInt(diskUsed) + " " + AppLang.getText("Kbytes"));
                System.arraycopy(in.getData(), 52, diskFree, 0, 4);
                this.lbDiskFreeContents.setText(" " + CardUpdate.byteArrayToUnsignedInt(diskFree) + " " + AppLang.getText("Kbytes"));
            }
            catch (Exception e2) {
                System.out.println(e2.getMessage());
                System.out.println(AppLang.getText("exception"));
                e2.printStackTrace();
                socket.close();
            }
        }
        finally {
            socket.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void SelectFile() {
        FileInputStream fis = null;
        BufferedReader br2 = null;
        try {
            JFileChooser jfc = new JFileChooser((String)AppProperty.m_properties.get("USER_DIR"));
            FileNameExtensionFilter filter = new FileNameExtensionFilter(String.valueOf(AppLang.getText("Program Files")) + "(*.tar;*.tgz)", "tar", "tgz");
            jfc.setFileFilter(filter);
            int yn = jfc.showOpenDialog(null);
            if (yn != 0) return;
            AppProperty.m_properties.put("USER_DIR", jfc.getSelectedFile().getParent());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            fis = new FileInputStream(jfc.getSelectedFile());
            br2 = new BufferedReader(new InputStreamReader(fis));
            String str = null;
            char[] tmp = new char[50];
            br2.read(tmp, 0, 50);
            int i2 = 0;
            while (i2 < tmp.length) {
                str = String.valueOf(str) + tmp[i2];
                ++i2;
            }
            if (str.contains("cnf") && str.indexOf("_") != -1) {
                this.sFilePath = jfc.getSelectedFile().toString();
                String[] arr = str.split("_");
                String firmVer = arr[1];
                this.sFileVer = firmVer.substring(0, 4).toUpperCase();
                int Reboot = JOptionPane.showConfirmDialog(this, AppLang.getText("Do you want to restart?"));
                if (Reboot == 0) {
                    this.bRestart = true;
                } else {
                    if (Reboot != 1) return;
                    this.bRestart = false;
                }
                int ApplyAllCard = JOptionPane.showConfirmDialog(this, AppLang.getText("Do you want to apply all card?"));
                if (ApplyAllCard == 0) {
                    this.frameCard.allCardInfoUpdate(this.sFilePath, this.sFileVer, this.bRestart);
                    return;
                } else {
                    if (ApplyAllCard != 1) return;
                    this.CardInfoUpdate(this.sFilePath, this.sFileVer, this.bRestart);
                }
                return;
            } else {
                try {
                    JOptionPane.showMessageDialog(this, AppLang.getText("Selected file is not CNF24 package."));
                    return;
                }
                catch (FileNotFoundException fnfe) {
                    JOptionPane.showMessageDialog(this, AppLang.getText("File not found."));
                    return;
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this, AppLang.getText("Cannot read the file."));
                }
            }
            return;
        }
        finally {
            try {
                br2.close();
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    public void CardInfoUpdate(String sFilePath, String sFileVer, Boolean bRestart) {
        this.lbSelectFilePath.setText(" " + sFilePath);
        this.lbFileVerContents.setText(" " + sFileVer);
        this.cbRestart.setSelected(bRestart);
        this.cbSelect.setSelected(true);
    }

    public void DoUpdate() {
        if (this.cbSelect.isSelected()) {
            this.sCabSlot.split(" - ");
            int iCabinet = Integer.parseInt(this.sCabSlot.substring(this.sCabSlot.indexOf("C") + 1, this.sCabSlot.indexOf(" - ")));
            int iSlot = Integer.parseInt(this.sCabSlot.substring(this.sCabSlot.indexOf("S") + 1));
            this.uploadThread = new CNFUploadThread(this, iCabinet, iSlot, this.sCardIP, this.iCardFTPPort, this.iMessagePort, this.lbSelectFilePath.getText().trim(), this.cbRestart.isSelected());
            this.uploadThread.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String ac = e2.getActionCommand();
        if (ac.equals(AppLang.getText("..."))) {
            this.SelectFile();
        }
    }

    private static byte[] intToByteArray(int integer) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.order(ByteOrder.BIG_ENDIAN);
        buff.putInt(integer);
        return buff.array();
    }

    private static int byteArrayToInt(byte[] bytes) {
        int size = 4;
        ByteBuffer buff = ByteBuffer.allocate(4);
        byte[] newBytes = new byte[4];
        int i2 = 0;
        while (i2 < 4) {
            newBytes[i2] = i2 + bytes.length < 4 ? (byte)0 : bytes[i2 + bytes.length - 4];
            ++i2;
        }
        buff.order(ByteOrder.BIG_ENDIAN);
        buff = ByteBuffer.wrap(newBytes);
        return buff.getInt();
    }

    private static long byteArrayToUnsignedInt(byte[] bytes) {
        long l2 = 0L;
        int pos = 0;
        l2 += (long)(CardUpdate.unsignedByteToInt(bytes[pos++]) << 24);
        l2 += (long)(CardUpdate.unsignedByteToInt(bytes[pos++]) << 16);
        l2 += (long)(CardUpdate.unsignedByteToInt(bytes[pos++]) << 8);
        return l2 += (long)(CardUpdate.unsignedByteToInt(bytes[pos++]) << 0);
    }

    private static int unsignedByteToInt(byte b2) {
        return b2 & 0xFF;
    }
}

