/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.tftp;

import com.oroinc.net.tftp.TFTPPacket;
import com.oroinc.net.tftp.TFTPPacketException;
import java.net.DatagramPacket;
import java.net.InetAddress;

public final class TFTPErrorPacket
extends TFTPPacket {
    public static final int UNDEFINED = 0;
    public static final int FILE_NOT_FOUND = 1;
    public static final int ACCESS_VIOLATION = 2;
    public static final int OUT_OF_SPACE = 3;
    public static final int ILLEGAL_OPERATION = 4;
    public static final int UNKNOWN_TID = 5;
    public static final int FILE_EXISTS = 6;
    public static final int NO_SUCH_USER = 7;
    int _error;
    String _message;

    public TFTPErrorPacket(InetAddress inetAddress, int n2, int n3, String string) {
        super(5, inetAddress, n2);
        this._error = n3;
        this._message = string;
    }

    TFTPErrorPacket(DatagramPacket datagramPacket) throws TFTPPacketException {
        super(5, datagramPacket.getAddress(), datagramPacket.getPort());
        byte[] byArray = datagramPacket.getData();
        int n2 = datagramPacket.getLength();
        if (this.getType() != byArray[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        this._error = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (n2 < 5) {
            throw new TFTPPacketException("Bad error packet. No message.");
        }
        int n3 = 4;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n2 && byArray[n3] != 0) {
            stringBuffer.append((char)byArray[n3]);
            ++n3;
        }
        this._message = stringBuffer.toString();
    }

    DatagramPacket _newDatagram(DatagramPacket datagramPacket, byte[] byArray) {
        int n2 = this._message.length();
        byArray[0] = 0;
        byArray[1] = (byte)this._type;
        byArray[2] = (byte)((this._error & 0xFFFF) >> 8);
        byArray[3] = (byte)(this._error & 0xFF);
        System.arraycopy(this._message.getBytes(), 0, byArray, 4, n2);
        byArray[n2 + 4] = 0;
        datagramPacket.setAddress(this._address);
        datagramPacket.setPort(this._port);
        datagramPacket.setData(byArray);
        datagramPacket.setLength(n2 + 4);
        return datagramPacket;
    }

    public DatagramPacket newDatagram() {
        int n2 = this._message.length();
        byte[] byArray = new byte[n2 + 5];
        byArray[0] = 0;
        byArray[1] = (byte)this._type;
        byArray[2] = (byte)((this._error & 0xFFFF) >> 8);
        byArray[3] = (byte)(this._error & 0xFF);
        System.arraycopy(this._message.getBytes(), 0, byArray, 4, n2);
        byArray[n2 + 4] = 0;
        return new DatagramPacket(byArray, byArray.length, this._address, this._port);
    }

    public int getError() {
        return this._error;
    }

    public String getMessage() {
        return this._message;
    }
}

