/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.pages.utils.AppNumPlan;
import java.util.ArrayList;
import java.util.Arrays;

public class AppUpRequest {
    private static AppComm m_comm = null;

    public static boolean requestUpload(AppComm comm) {
        ArrayList recordData = new ArrayList();
        ArrayList saveData = new ArrayList();
        byte[] sendPacket = null;
        String[] emptyValue = new String[]{"255", "256", "65535", "65536", "4294967295", "4294967296"};
        m_comm = comm;
        saveData = AppUpRequest.m_comm.m_pageInfo.getSaveData();
        int recordCount = saveData.size();
        int recordSize = AppUpRequest.m_comm.m_pageInfo.getRecordSize();
        int msgLen = recordCount * recordSize;
        try {
            int[] sizeList = AppUpRequest.m_comm.m_pageInfo.getDataSize();
            int[] typeList = AppUpRequest.m_comm.m_pageInfo.getDataType();
            AppUpRequest.m_comm.m_pageInfo.setMsgLength(msgLen);
            m_comm.makeMessageHeader();
            sendPacket = new byte[msgLen + 18];
            Arrays.fill(sendPacket, (byte)-1);
            System.arraycopy(AppUpRequest.m_comm.m_header, 0, sendPacket, 0, 18);
            int i2 = 0;
            int pos = 0;
            while (i2 < recordCount) {
                recordData = (ArrayList)saveData.get(i2);
                pos = i2 * recordSize + 18;
                int j2 = 0;
                while (j2 < typeList.length) {
                    if (pos >= (i2 + 1) * recordSize + 18) break;
                    String value = (String)recordData.get(j2);
                    if (value.equals("") && (typeList[j2] <= 5 || typeList[j2] == 13 || typeList[j2] == 14)) {
                        value = typeList[j2] == 13 || typeList[j2] == 14 ? "0" : emptyValue[typeList[j2]];
                    }
                    switch (typeList[j2]) {
                        case 0: 
                        case 13: {
                            sendPacket[pos] = (byte)Integer.parseInt(value);
                            break;
                        }
                        case 1: {
                            sendPacket[pos] = (byte)(Integer.parseInt(value) - 1);
                            break;
                        }
                        case 2: 
                        case 14: 
                        case 16: {
                            AppFunctions.short2byte(sendPacket, pos, (short)Integer.parseInt(value));
                            break;
                        }
                        case 3: {
                            AppFunctions.short2byte(sendPacket, pos, (short)(Integer.parseInt(value) - 1));
                            break;
                        }
                        case 4: {
                            AppFunctions.int2byte(sendPacket, pos, (int)Long.parseLong(value));
                            break;
                        }
                        case 5: {
                            AppFunctions.int2byte(sendPacket, pos, (int)Long.parseLong(value) - 1);
                            break;
                        }
                        case 6: {
                            AppFunctions.ip2byte(sendPacket, pos, sizeList[j2], value);
                            break;
                        }
                        case 7: {
                            AppFunctions.str2byte(sendPacket, pos, sizeList[j2], value);
                            break;
                        }
                        case 17: {
                            AppFunctions.str2byte(sendPacket, pos, sizeList[j2], value, "UTF-8");
                            break;
                        }
                        case 8: {
                            AppFunctions.tel2byte(sendPacket, pos, value);
                            break;
                        }
                        case 9: {
                            AppFunctions.short2byte(sendPacket, pos, (short)AppNumPlan.getPortNo(value));
                            break;
                        }
                        case 10: {
                            AppFunctions.mac2byte(sendPacket, pos, value);
                            break;
                        }
                        case 11: {
                            sendPacket[pos] = (byte)AppFunctions.bit2byte(value, true);
                            break;
                        }
                        case 12: {
                            sendPacket[pos] = (byte)AppFunctions.bit2byte(value, false);
                            break;
                        }
                        case 15: {
                            int port = AppNumPlan.getPortNo(value);
                            if (port == 65535) {
                                AppFunctions.tel2byte(sendPacket, pos, value);
                                break;
                            }
                            AppFunctions.short2byte(sendPacket, pos, (short)port);
                        }
                    }
                    pos += sizeList[j2];
                    ++j2;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            AppGlobal.showErrorMessage("", "Failed to make upload data.");
            return false;
        }
        boolean isResult = AppUpRequest.sendUploadPacket(sendPacket);
        if (isResult && AppUpRequest.m_comm.m_pageInfo.getMsgId().equals("2800")) {
            byte[] numData = new byte[msgLen];
            System.arraycopy(sendPacket, 18, numData, 0, msgLen);
            AppNumPlan.setNumPlanData(numData);
            AppNumPlan.makeInitialData();
        }
        return isResult;
    }

    public static boolean requestAllUpload(AppComm comm) {
        byte[] sendPacket = null;
        byte[] saveData = null;
        m_comm = comm;
        saveData = AppUpRequest.m_comm.m_pageInfo.getReqData();
        AppUpRequest.m_comm.m_pageInfo.setMsgLength(saveData.length);
        m_comm.makeMessageHeader();
        sendPacket = new byte[saveData.length + 18];
        Arrays.fill(sendPacket, (byte)-1);
        System.arraycopy(AppUpRequest.m_comm.m_header, 0, sendPacket, 0, 18);
        System.arraycopy(saveData, 0, sendPacket, 18, saveData.length);
        return AppUpRequest.sendUploadPacket(sendPacket);
    }

    private static boolean sendUploadPacket(byte[] sendPacket) {
        byte[] recvData = null;
        byte[] respData = null;
        AppGlobal.g_errorData.clear();
        if (m_comm.sendData(sendPacket)) {
            recvData = m_comm.recvData();
            if (AppUpRequest.m_comm.m_pageInfo.getUpMsgType() == -6) {
                AppUpRequest.m_comm.m_pageInfo.setRespData(recvData);
                return true;
            }
            if (recvData != null) {
                if (recvData[14] == 0) {
                    int len = AppFunctions.byte2int(recvData, 8);
                    if (len > 0) {
                        respData = new byte[len];
                        System.arraycopy(recvData, 18, respData, 0, len);
                        AppUpRequest.m_comm.m_pageInfo.setRespData(respData);
                    }
                } else if (recvData[14] == 1) {
                    AppGlobal.g_errorData.put(AppUpRequest.m_comm.m_pageInfo.getMsgId(), recvData);
                } else {
                    m_comm.dispErrorMessage(recvData[14]);
                }
                return true;
            }
        } else {
            AppGlobal.showErrorMessage("", "Disconnected link between DM and System.");
            AppMenuActions.disconnectSystem();
            return false;
        }
        AppGlobal.showErrorMessage("", "Failed to upload data to system.");
        AppMenuActions.disconnectSystem();
        return false;
    }
}

