/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunConference;
import com.sec.osdm.pages.conference.PA108CreateConference;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppCalendar
extends JDialog
implements ActionListener,
ChangeListener {
    private final int SIZE_WIDTH = 292;
    private final int SIZE_HEIGHT = 270;
    private Calendar m_calendar = null;
    private JPanel m_panMain = new JPanel();
    private JButton[] m_btnDays = new JButton[42];
    private JSpinner m_spinYear = null;
    private JComboBox m_cboMonth = null;
    private byte[] m_sysDate = new byte[8];
    private byte[] m_endDate = new byte[8];
    private int m_year;
    private int m_month;
    private int m_today;
    private int m_firstDay;
    private int m_lastDay;
    private AppLayout m_layout = new AppLayout(this.m_panMain, 292, 270);
    private PA108CreateConference m_parent = null;

    public AppCalendar(PA108CreateConference parent) {
        this.m_parent = parent;
        this.m_sysDate = AppRunConference.getSystemTime();
        this.m_calendar = Calendar.getInstance();
        this.setCalendar(this.m_sysDate[5] + 2000, this.m_sysDate[4] - 1, this.m_sysDate[3]);
        this.createComponents();
        this.openDialog();
    }

    private void setCalendar(int year, int month, int date) {
        this.m_year = year;
        this.m_month = month;
        this.m_today = date;
        this.m_calendar.set(year, month, date, this.m_sysDate[2], this.m_sysDate[1], this.m_sysDate[0]);
        Calendar m_firtCalendar = Calendar.getInstance();
        m_firtCalendar.set(year, month, 1, 0, 0, 0);
        this.m_firstDay = m_firtCalendar.get(7) - m_firtCalendar.getFirstDayOfWeek();
        this.m_lastDay = this.m_calendar.getActualMaximum(5);
    }

    private void applyEndDate() {
        this.m_endDate[0] = (byte)this.m_calendar.get(13);
        this.m_endDate[1] = (byte)this.m_calendar.get(12);
        this.m_endDate[2] = (byte)this.m_calendar.get(11);
        this.m_endDate[3] = (byte)this.m_calendar.get(5);
        this.m_endDate[4] = (byte)(this.m_calendar.get(2) + 1);
        this.m_endDate[5] = (byte)(this.m_calendar.get(1) - 2000);
        this.m_endDate[6] = (byte)this.m_calendar.get(7);
        this.m_endDate[7] = -1;
        int term = AppRunConference.getDifferentDate(this.m_sysDate, this.m_endDate);
        if (term < 0) {
            JOptionPane.showMessageDialog(null, "Reservation can not assign before time than current time.");
            return;
        }
        if (term > 100) {
            JOptionPane.showMessageDialog(null, "Conference duration time has exceed.");
            return;
        }
        System.arraycopy(this.m_endDate, 0, this.m_parent.m_endDate, 0, 8);
        this.m_parent.m_txtEndDate.setText(AppRunConference.szDate2LangLocale(this.m_calendar.getTime(), 1));
        this.closeDialog();
    }

    private void createComponents() {
        int j2;
        JButton apply = new JButton(AppLang.getText("Apply"));
        JLabel[] labels = new JLabel[7];
        String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        SpinnerNumberModel yearModel = new SpinnerNumberModel(this.m_year, this.m_year - 100, this.m_year + 100, 1);
        this.m_spinYear = new JSpinner(yearModel);
        this.m_spinYear.setEditor(new JSpinner.NumberEditor(this.m_spinYear, "#"));
        this.m_spinYear.addChangeListener(this);
        int i2 = 0;
        while (i2 < months.length) {
            months[i2] = AppLang.getText(months[i2]);
            ++i2;
        }
        this.m_cboMonth = new JComboBox<String>(months);
        this.m_cboMonth.setSelectedIndex(this.m_month);
        this.m_cboMonth.addActionListener(this);
        apply.setMargin(new Insets(0, 0, 0, 0));
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AppCalendar.this.applyEndDate();
            }
        });
        this.m_layout.addComponent(this.m_spinYear, 30, 5, 70, 22);
        this.m_layout.addComponent(this.m_cboMonth, 110, 5, 60, 22);
        this.m_layout.addComponent(apply, 222, 5, 60, 22);
        Calendar now = Calendar.getInstance();
        int i3 = 0;
        while (i3 < labels.length) {
            j2 = now.getFirstDayOfWeek() + i3 - 1;
            labels[i3] = new JLabel(AppLang.getText(days[j2 % 7]), 0);
            labels[i3].setBorder(new LineBorder(Color.darkGray));
            if (j2 % 7 == 0) {
                labels[i3].setForeground(Color.RED);
            } else if (j2 % 7 == 6) {
                labels[i3].setForeground(Color.BLUE);
            }
            this.m_layout.addComponent(labels[i3], i3 * 40 + 3, 30, 40, 25);
            ++i3;
        }
        i3 = 0;
        while (i3 < this.m_btnDays.length) {
            j2 = now.getFirstDayOfWeek() + i3 - 1;
            this.m_btnDays[i3] = new JButton("");
            this.m_btnDays[i3].setMargin(new Insets(0, 0, 0, 0));
            this.m_btnDays[i3].addActionListener(this);
            if (j2 % 7 == 0) {
                this.m_btnDays[i3].setForeground(Color.RED);
            } else if (j2 % 7 == 6) {
                this.m_btnDays[i3].setForeground(Color.BLUE);
            }
            this.m_layout.addComponent(this.m_btnDays[i3], i3 % 7 * 40 + 3, i3 / 7 * 30 + 55, 40, 30);
            ++i3;
        }
        this.setComponents();
    }

    private void setComponents() {
        int i2 = 0;
        while (i2 < this.m_firstDay) {
            this.m_btnDays[i2].setText("");
            this.m_btnDays[i2].setEnabled(false);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_lastDay) {
            this.m_btnDays[this.m_firstDay + i2].setText("" + (i2 + 1));
            this.m_btnDays[this.m_firstDay + i2].setActionCommand("" + (i2 + 1));
            this.m_btnDays[this.m_firstDay + i2].setEnabled(true);
            ++i2;
        }
        i2 = this.m_firstDay + this.m_lastDay;
        while (i2 < this.m_btnDays.length) {
            this.m_btnDays[i2].setText("");
            this.m_btnDays[i2].setEnabled(false);
            ++i2;
        }
        this.setDateColor();
    }

    private void setDateColor() {
        int i2 = 0;
        while (i2 < this.m_btnDays.length) {
            this.m_btnDays[i2].setBackground(new Color(238, 238, 238));
            if (!this.m_btnDays[i2].getText().trim().equals("") && Integer.parseInt(this.m_btnDays[i2].getText().trim()) == this.m_today) {
                this.m_btnDays[i2].setBackground(Color.GREEN);
            }
            ++i2;
        }
    }

    private void openDialog() {
        this.setTitle(AppLang.getText("Calendar"));
        this.setModal(true);
        this.setIconImage(AppImages.Img_Logo);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppCalendar.this.closeDialog();
            }
        });
        this.add(this.m_panMain);
        this.setSize(292, 270);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
        this.setVisible(true);
    }

    private void closeDialog() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object obj = ae.getSource();
        if (obj instanceof JComboBox) {
            this.m_month = this.m_cboMonth.getSelectedIndex();
            this.setCalendar(this.m_year, this.m_month, this.m_today);
            this.setComponents();
        } else {
            String command = ae.getActionCommand();
            this.m_today = Integer.parseInt(command);
            this.m_calendar.set(5, this.m_today);
            this.setDateColor();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce2) {
        JSpinner obj = (JSpinner)ce2.getSource();
        Integer y2 = (Integer)obj.getValue();
        int year = y2;
        this.setCalendar(year, this.m_month, this.m_today);
        this.setComponents();
    }
}

