/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.conference;

import com.sec.osdm.common.AppDateTimer;
import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunConference;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.pages.AppConference;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.conference.PA104SearchParty;
import com.sec.osdm.pages.conference.PA106EmailForm;
import com.sec.osdm.pages.utils.AppNumPlan;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppPattern;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class PA108CreateConference_old
extends AppConference
implements MouseListener,
ItemListener,
KeyListener {
    private final int SIZE_WIDTH = 500;
    private final int SIZE_HEIGHT = 578;
    private JTextField m_txtCard = new JTextField();
    private JTextField m_txtDate = new JTextField();
    public JTextField m_txtEndDate = new JTextField();
    private JTextField m_txtSubject = new JTextField();
    private JTextField m_txtId = new JTextField();
    private JTextField m_txtChannel = new JTextField();
    private JTextField m_txtPage = new JTextField();
    private JTextField m_txtOwner = new JTextField();
    private JScrollPane m_txtPartyScroll = new JScrollPane();
    private JTextArea m_txtParty = new JTextArea();
    private JPasswordField m_txtPassword = new JPasswordField();
    private JButton[] m_buttons = new JButton[8];
    private JButton m_buttons1 = new JButton(AppLang.getText("Select"));
    private JRadioButton m_rbNoCheck = new JRadioButton(AppLang.getText("No Check"));
    private JRadioButton m_rbCheck = new JRadioButton(AppLang.getText("Check"), true);
    public JRadioButton[] m_rbRepeat = new JRadioButton[4];
    private JCheckBox m_chkEmail = new JCheckBox(AppLang.getText("Send Invitation letter after confirming reservation"), false);
    private JCheckBox m_chkEarly = new JCheckBox(AppLang.getText("Early Entrance"));
    private JCheckBox m_chkRecording = new JCheckBox(AppLang.getText("Recording"));
    private JCheckBox m_chkPaging = new JCheckBox(AppLang.getText("Paging"));
    private JLabel m_lbChannel = new JLabel("");
    private JLabel m_lbFile = new JLabel("");
    private JLabel m_lbUseId = new JLabel("");
    private JLabel m_period = new JLabel("~");
    private AppComboBox m_cboStart = new AppComboBox();
    private AppComboBox m_cboEnd = new AppComboBox();
    private Hashtable m_partyInfo = new Hashtable();
    private String m_promptFile = "";
    private short[] m_partyList = new short[24];
    private int[] m_useChannel = new int[6];
    private boolean m_bIsCheckID = false;
    public int m_repeat = 0;
    private int m_maxChannel = 0;
    private AppDialog m_ownerDlg = null;

    public PA108CreateConference_old(AppConference parent) {
        this.m_parent = parent;
        System.arraycopy(this.m_parent.m_cardPos, 0, this.m_cardPos, 0, 2);
        this.m_layout = new AppLayout(this.m_panMain, 500, 578);
        this.createComponents();
        this.openDialog("Conference Reservation", 500, 578);
    }

    private void createComponents() {
        ButtonGroup bgPasscode = new ButtonGroup();
        ButtonGroup bgRepeat = new ButtonGroup();
        String[] btnTitles = new String[]{"Check", "", "...", "Upload", "OK", "Cancel", "Choose...", "Select"};
        String[] rbTitles = new String[]{"Once", "Daily", "Weekly", "Monthly"};
        byte[] temp = null;
        int[] cols = this.m_parent.m_table.getTable().getSelectedColumns();
        int[] rows = this.m_parent.m_table.getTable().getSelectedRows();
        temp = (byte[])this.m_parent.m_reqList.get(cols[0]);
        System.arraycopy(temp, 0, this.m_startTime, 0, 8);
        System.arraycopy(temp, 0, this.m_endTime, 0, 8);
        this.m_startMin = rows[0];
        this.m_endMin = rows[rows.length - 1] + 1;
        this.setDateMinute();
        System.arraycopy(this.m_endTime, 0, this.m_endDate, 0, 8);
        int i2 = 0;
        while (i2 < this.m_buttons.length) {
            this.m_buttons[i2] = new JButton(btnTitles[i2]);
            this.m_buttons[i2].setActionCommand(btnTitles[i2]);
            this.m_buttons[i2].setMargin(new Insets(0, 0, 0, 0));
            this.m_buttons[i2].addActionListener(this);
            ++i2;
        }
        this.m_buttons[1].setActionCommand("Calendar");
        this.m_buttons[1].setBorderPainted(false);
        this.m_txtCard.setEditable(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Card")), 10, 10, 100, 22);
        this.m_txtCard.setText("C" + (this.m_cardPos[0] + 1) + "-S" + (this.m_cardPos[1] + 1));
        this.m_layout.addComponent(this.m_txtCard, 110, 10, 380, 22);
        this.m_txtDate.setEditable(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Date")), 10, 37, 100, 22);
        this.m_txtDate.setText(AppRunConference.getCurrentDate(this.m_startTime));
        this.m_layout.addComponent(this.m_txtDate, 110, 37, 160, 22);
        this.m_layout.addComponent(this.m_period, 283, 37, 20, 22);
        this.m_txtEndDate.setEditable(false);
        this.m_txtEndDate.setText(AppRunConference.getCurrentDate(this.m_endDate));
        this.m_layout.addComponent(this.m_txtEndDate, 302, 37, 160, 22);
        this.m_buttons[1].setVisible(false);
        this.m_buttons[1].setIcon(AppImages.Img_Calendar);
        this.m_layout.addComponent(this.m_buttons[1], 467, 37, 22, 22);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Subject")), 10, 64, 100, 22);
        this.m_layout.addComponent(this.m_txtSubject, 110, 64, 380, 22);
        this.m_txtId.setDocument(new AppPattern(3, AppPattern.PATTERN2));
        this.m_layout.addComponent(new JLabel(AppLang.getText("Conference Id")), 10, 91, 100, 22);
        this.m_layout.addComponent(this.m_txtId, 110, 91, 140, 22);
        this.m_txtId.addKeyListener(this);
        this.m_layout.addComponent(this.m_buttons[0], 255, 91, 80, 22);
        this.m_layout.addComponent(this.m_lbUseId, 340, 91, 110, 22);
        i2 = 0;
        while (i2 < 96) {
            this.m_cboStart.addItem(AppRunConference.getDispTime(i2), i2);
            this.m_cboEnd.addItem(AppRunConference.getDispTime(i2), i2);
            ++i2;
        }
        this.m_cboEnd.removeItem(0);
        this.m_cboEnd.addItem(AppRunConference.getDispTime(96), 96);
        this.m_cboStart.setSelectedIndex(this.m_startMin);
        this.m_cboStart.addListener(this);
        this.m_cboEnd.setSelectedIndex(this.m_endMin);
        this.m_cboEnd.addListener(this);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Duration")), 10, 118, 100, 22);
        this.m_layout.addComponent(this.m_cboStart.getComponent(), 110, 118, 100, 22);
        this.m_layout.addComponent(new JLabel("~", 0), 210, 118, 40, 22);
        this.m_layout.addComponent(this.m_cboEnd.getComponent(), 250, 118, 100, 22);
        this.m_layout.addComponent(new JLabel("Repeat"), 10, 145, 100, 22);
        i2 = 0;
        while (i2 < this.m_rbRepeat.length) {
            this.m_rbRepeat[i2] = new JRadioButton(rbTitles[i2]);
            this.m_rbRepeat[i2].setActionCommand("" + i2);
            this.m_rbRepeat[i2].addItemListener(this);
            bgRepeat.add(this.m_rbRepeat[i2]);
            this.m_layout.addComponent(this.m_rbRepeat[i2], i2 * 80 + 110, 145, 70, 22);
            ++i2;
        }
        this.m_rbRepeat[0].setSelected(true);
        this.m_rbRepeat[3].setVisible(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Ch. Reserv")), 10, 172, 100, 22);
        this.m_txtChannel.setDocument(new AppPattern(2, "^[0-9]*$"));
        this.m_txtChannel.setToolTipText(AppLang.getText("Only Number Input"));
        this.m_layout.addComponent(this.m_txtChannel, 110, 172, 140, 22);
        this.m_layout.addComponent(new JLabel("Available Channel:"), 290, 172, 120, 22);
        this.m_layout.addComponent(this.m_lbChannel, 400, 172, 30, 22);
        this.m_txtOwner.setDocument(new AppPattern(4, AppPattern.PATTERN2));
        this.m_txtOwner.setEditable(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Owner Station")), 10, 200, 100, 22);
        this.m_layout.addComponent(this.m_txtOwner, 110, 200, 140, 22);
        this.m_layout.addComponent(this.m_buttons[7], 255, 200, 80, 22);
        this.m_txtPartyScroll.getViewport().add(this.m_txtParty);
        this.m_txtParty.setLineWrap(true);
        this.m_txtParty.setEditable(false);
        this.m_txtParty.addMouseListener(this);
        this.m_txtParty.setBorder(new LineBorder(Color.darkGray));
        this.m_layout.addComponent(new JLabel(AppLang.getText("Party List")), 10, 228, 100, 22);
        this.m_layout.addComponent(this.m_buttons[6], 110, 228, 80, 22);
        this.m_layout.addComponent(this.m_txtPartyScroll, 110, 256, 380, 82);
        Arrays.fill(this.m_partyList, 0, this.m_partyList.length, (short)-1);
        this.m_chkEmail.addItemListener(this);
        this.m_layout.addComponent(this.m_chkEmail, 110, 343, 380, 22);
        bgPasscode.add(this.m_rbNoCheck);
        bgPasscode.add(this.m_rbCheck);
        this.m_rbCheck.addActionListener(this);
        this.m_rbNoCheck.addActionListener(this);
        this.m_rbCheck.setActionCommand("PassCheck");
        this.m_rbNoCheck.setActionCommand("PassCheck");
        this.m_layout.addComponent(new JLabel(AppLang.getText("Passcode")), 10, 371, 100, 22);
        this.m_layout.addComponent(this.m_rbNoCheck, 110, 371, 100, 22);
        this.m_layout.addComponent(this.m_rbCheck, 240, 371, 61, 22);
        this.m_layout.addComponent(this.m_txtPassword, 302, 371, 100, 22);
        this.m_txtPassword.addKeyListener(this);
        JPanel optionPan = new JPanel(new BorderLayout());
        optionPan.setBorder(BorderFactory.createTitledBorder("Options"));
        AppLayout optionLayout = new AppLayout(optionPan, 500, 578);
        this.m_chkEarly.addItemListener(this);
        optionLayout.addComponent(this.m_chkEarly, 5, 20, 120, 22);
        this.m_chkRecording.addItemListener(this);
        optionLayout.addComponent(this.m_chkRecording, 135, 20, 120, 22);
        this.m_chkPaging.addItemListener(this);
        optionLayout.addComponent(this.m_chkPaging, 265, 20, 65, 22);
        this.m_txtPage.setEnabled(false);
        optionLayout.addComponent(this.m_txtPage, 330, 20, 80, 22);
        this.m_lbFile.setBorder(new LineBorder(Color.darkGray));
        optionLayout.addComponent(new JLabel(AppLang.getText("Greeting Prompt")), 8, 50, 100, 22);
        optionLayout.addComponent(this.m_lbFile, 107, 50, 275, 22);
        optionLayout.addComponent(this.m_buttons[2], 387, 50, 23, 22);
        optionLayout.addComponent(this.m_buttons[3], 414, 50, 60, 22);
        this.m_layout.addComponent(optionPan, 7, 413, 482, 90);
        this.m_layout.addComponent(this.m_buttons[4], 320, 518, 80, 22);
        this.m_layout.addComponent(this.m_buttons[5], 410, 518, 80, 22);
    }

    private void getUsableChannel() {
        ArrayList recvData = new ArrayList();
        this.m_reqData = new byte[28];
        this.m_pageInfo = new AppPageInfo("A102");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        System.arraycopy(this.m_startTime, 0, this.m_reqData, 0, 8);
        System.arraycopy(this.m_endTime, 0, this.m_reqData, 8, 8);
        System.arraycopy(this.m_cardPos, 0, this.m_reqData, 16, 2);
        this.m_reqData[18] = (byte)this.m_repeat;
        this.m_reqData[19] = -1;
        System.arraycopy(this.m_endDate, 0, this.m_reqData, 20, 8);
        if (this.readDataFromSystem()) {
            recvData = (ArrayList)this.m_recvData.get(0);
            int i2 = 0;
            while (i2 < this.m_useChannel.length) {
                this.m_useChannel[i2] = (byte)Integer.parseInt((String)recvData.get(i2));
                ++i2;
            }
        }
        this.m_chkEmail.setEnabled(this.m_useChannel[5] == 1);
        this.m_rbCheck.setSelected(this.m_useChannel[2] == 1);
        this.m_rbCheck.setEnabled(this.m_useChannel[2] == 1);
        this.m_rbNoCheck.setSelected(this.m_useChannel[2] != 1);
        this.m_rbNoCheck.setEnabled(this.m_useChannel[2] == 1);
        this.m_txtPassword.setEditable(this.m_useChannel[2] == 1);
        this.m_chkEarly.setSelected(this.m_useChannel[4] == 1);
        this.m_chkEarly.setEnabled(this.m_useChannel[4] == 1);
        this.m_buttons[2].setEnabled(this.m_useChannel[3] == 1);
        this.m_buttons[3].setEnabled(this.m_useChannel[3] == 1);
        this.setMaxChannel();
    }

    private boolean checkConferenceID() {
        ArrayList recvData = new ArrayList();
        this.m_reqData = new byte[30];
        this.m_pageInfo = new AppPageInfo("A103");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        System.arraycopy(this.m_startTime, 0, this.m_reqData, 0, 8);
        System.arraycopy(this.m_endTime, 0, this.m_reqData, 8, 8);
        System.arraycopy(this.m_cardPos, 0, this.m_reqData, 16, 2);
        AppFunctions.str2byte(this.m_reqData, 18, 3, this.m_txtId.getText().trim());
        this.m_reqData[21] = (byte)this.m_repeat;
        System.arraycopy(this.m_endDate, 0, this.m_reqData, 22, 8);
        if (!this.readDataFromSystem()) {
            return false;
        }
        if (this.m_recvData.size() > 0) {
            recvData = (ArrayList)this.m_recvData.get(0);
            if (!this.m_txtId.getText().equals((String)recvData.get(0)) && JOptionPane.showConfirmDialog(null, "Conference ID can not be used. System recommend [" + (String)recvData.get(0) + "] as conference ID.\n" + "Do you want to use this?", "Conference ID", 0) == 1) {
                this.m_lbUseId.setForeground(Color.RED);
                this.m_lbUseId.setText("Not available ID");
                this.m_txtId.setText("");
                this.m_txtId.requestFocus();
                return false;
            }
            this.m_lbUseId.setForeground(Color.BLUE);
            this.m_lbUseId.setText("Available ID");
            this.m_txtId.setText((String)recvData.get(0));
        }
        return true;
    }

    private boolean checkCreateData() {
        if (this.m_txtSubject.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Input the subject."));
            this.m_txtSubject.requestFocus();
            return false;
        }
        if (!this.m_bIsCheckID) {
            JOptionPane.showMessageDialog(null, AppLang.getText("The conference ID was not checked. You must first check the conference ID."));
            return false;
        }
        if (this.m_txtChannel.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Make a reservation ths channel."));
            this.m_txtChannel.requestFocus();
            return false;
        }
        if (Integer.parseInt(this.m_txtChannel.getText().trim()) > this.m_maxChannel) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Channel was exceeded."));
            this.m_txtChannel.setText("");
            this.m_txtChannel.requestFocus();
            return false;
        }
        if (Integer.parseInt(this.m_txtChannel.getText().trim()) < this.m_partyInfo.size()) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Member was exceeded."));
            this.m_txtChannel.setText("");
            this.m_txtChannel.requestFocus();
            return false;
        }
        if (this.m_rbCheck.isSelected() && String.valueOf(this.m_txtPassword.getPassword()).trim().equals("")) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Input the passcode."));
            this.m_txtPassword.requestFocus();
            return false;
        }
        if (this.m_rbCheck.isSelected() && this.m_txtPassword.getPassword().length != 4) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Input the just 4 charater for passcode."));
            this.m_txtPassword.requestFocus();
            return false;
        }
        if (this.m_txtOwner.getText().equals("")) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Select the Owner"));
            this.m_txtOwner.requestFocus();
            return false;
        }
        if (this.m_chkPaging.isSelected()) {
            try {
                int iTest = Integer.parseInt(this.m_txtPage.getText());
            }
            catch (NumberFormatException e2) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Input the Page Group."));
                this.m_txtPage.requestFocus();
                return false;
            }
        }
        this.createConference();
        return true;
    }

    private void createConference() {
        ArrayList<String> saveData = new ArrayList<String>();
        int i2 = 0;
        while (i2 < 8) {
            saveData.add(i2, AppFunctions.unsignedValue(this.m_startTime[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            saveData.add(i2 + 8, AppFunctions.unsignedValue(this.m_endTime[i2]));
            ++i2;
        }
        saveData.add(16, AppFunctions.unsignedValue(this.m_cardPos[0]));
        saveData.add(17, AppFunctions.unsignedValue(this.m_cardPos[1]));
        saveData.add(18, this.m_txtOwner.getText());
        saveData.add(19, this.m_txtId.getText().trim());
        saveData.add(20, "" + this.m_repeat);
        i2 = 0;
        while (i2 < 8) {
            saveData.add(i2 + 21, AppFunctions.unsignedValue(this.m_endDate[i2]));
            ++i2;
        }
        if (this.m_rbCheck.isSelected()) {
            saveData.add(29, String.valueOf(this.m_txtPassword.getPassword()).trim());
        } else {
            saveData.add(29, "");
        }
        saveData.add(30, this.m_txtChannel.getText().trim());
        saveData.add(31, this.m_chkRecording.isSelected() ? "1" : "0");
        saveData.add(32, this.m_chkPaging.isSelected() ? "1" : "0");
        if (this.m_txtPage.getText().trim().equals("")) {
            saveData.add(33, "255");
        } else {
            saveData.add(33, this.m_txtPage.getText().trim());
        }
        saveData.add(34, this.m_chkEarly.isSelected() ? "1" : "0");
        saveData.add(35, "255");
        i2 = 0;
        while (i2 < 24) {
            saveData.add(i2 + 36, AppFunctions.unsignedValue(this.m_partyList[i2]));
            ++i2;
        }
        saveData.add(60, this.m_promptFile);
        saveData.add(61, this.m_txtSubject.getText().trim());
        this.m_pageInfo = new AppPageInfo("A108");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        this.m_saveData = new ArrayList();
        this.m_saveData.add(0, saveData);
    }

    private void setMaxChannel() {
        this.m_maxChannel = (this.m_chkEarly.isSelected() ? this.m_useChannel[1] : this.m_useChannel[0]) - ((this.m_chkRecording.isSelected() ? 1 : 0) + (this.m_chkPaging.isSelected() ? 1 : 0));
        this.m_lbChannel.setText("" + this.m_maxChannel);
    }

    @Override
    public void runActionEvent(String command) {
        this.m_cnfId = this.m_txtId.getText().trim();
        this.m_cnfTitle = this.m_txtSubject.getText().trim();
        this.m_cnfOwner = this.m_txtOwner.getText().trim();
        if (command.equals("Check")) {
            if (this.m_txtId.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Input the conference ID."));
                this.m_txtId.requestFocus();
                return;
            }
            this.m_bIsCheckID = this.checkConferenceID();
        } else if (command.equals("Calendar")) {
            this.getUsableChannel();
        } else if (command.equals("...")) {
            AppFileBrowser browser = new AppFileBrowser();
            if (browser.openBrowser()) {
                this.m_lbFile.setText(browser.getFilePath());
            }
        } else if (command.equals("Upload")) {
            if (!this.m_bIsCheckID) {
                JOptionPane.showMessageDialog(null, AppLang.getText("The conference ID was not checked. You must first check the conference ID."));
            } else if (!this.m_lbFile.getText().trim().equals("")) {
                this.m_promptFile = String.format("grt_20%02d%02d%02d_%3s.snd", this.m_startTime[5], this.m_startTime[4], this.m_startTime[3], this.m_cnfId);
                this.sendFTPFile(this.m_lbFile.getText().trim(), String.valueOf(AppGlobal.g_greetingDir) + this.m_promptFile);
            }
        } else if (command.equals("OK")) {
            if (this.checkCreateData() && this.saveDataToSystem()) {
                if (!this.m_txtParty.getText().isEmpty() && this.m_chkEmail.isSelected()) {
                    this.setVisible(false);
                    this.m_cnfTitle = this.m_txtSubject.getText().trim();
                    this.m_cnfId = this.m_txtId.getText().trim();
                    this.m_cnfOwner = this.m_txtOwner.getText().trim();
                    new PA106EmailForm(this, this.m_partyInfo, this.m_chkEmail);
                }
                this.closeDialog();
            }
        } else if (command.equals("Cancel")) {
            if (this.m_bFtpResult) {
                this.deleteFTPFile(String.valueOf(AppGlobal.g_greetingDir) + this.m_promptFile);
            }
            this.closeDialog();
        } else if (command.equals("Choose...")) {
            if (this.m_txtChannel.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Make a reservation ths channel."));
                return;
            }
            this.setVisible(false);
            new PA104SearchParty(this, this.m_txtParty, this.m_partyInfo, this.m_partyList, Integer.parseInt(this.m_txtChannel.getText().trim()));
        } else if (command.equals("PassCheck")) {
            if (this.m_rbCheck.isSelected()) {
                this.m_txtPassword.setEditable(true);
            } else {
                this.m_txtPassword.setEditable(false);
            }
        } else if (command.equals("Select")) {
            this.createOwnerTable(AppNumPlan.getOwnerList());
        }
    }

    private AppTable createOwnerTable(String ownerList) {
        this.m_ownerDlg = new AppDialog();
        AppLayout layout = new AppLayout(this.m_ownerDlg.m_contentPane, 300, 200);
        final String[] list = ownerList.split(";");
        Object[][] rowTitle = new String[list.length][1];
        Object[][] colTitle = new String[][]{{"Owner List"}};
        final AppTableModel ownerModel = new AppTableModel(rowTitle, colTitle, ""){

            @Override
            public Object getValueAt(int row, int col) {
                return list[row];
            }
        };
        ownerModel.setRowHeaderHidden();
        ownerModel.setColWidth(new int[]{282});
        final AppTable ownerTable = new AppTable(ownerModel);
        ownerTable.getTable().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() >= 2) {
                    ownerTable.getTable().getSelectedRow();
                    String sValue = (String)ownerModel.getValueAt(ownerTable.getTable().getSelectedRow(), ownerTable.getTable().getSelectedColumn());
                    PA108CreateConference_old.this.m_txtOwner.setText(sValue);
                    PA108CreateConference_old.this.m_ownerDlg.closeDialog();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }
        });
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PA108CreateConference_old.this.m_ownerDlg.closeDialog();
            }
        });
        layout.addComponent(ownerTable, 5, 5, 285, 325);
        layout.addComponent(button, 90, 340, 120, 22);
        this.m_ownerDlg.openDialog("Station Owner", 300, 400);
        return ownerTable;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        me.getSource();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object obj = ie.getSource();
        if (obj instanceof JRadioButton) {
            if (ie.getStateChange() == 1) {
                JRadioButton rbRepeat = (JRadioButton)ie.getSource();
                this.m_repeat = Integer.parseInt(rbRepeat.getActionCommand());
                this.m_buttons[1].setVisible(true);
                this.m_period.setVisible(true);
                this.m_txtEndDate.setVisible(true);
                if (this.m_repeat == 0) {
                    this.m_buttons[1].setVisible(false);
                    this.m_period.setVisible(false);
                    this.m_txtEndDate.setVisible(false);
                }
                this.getUsableChannel();
                if (!this.m_txtId.getText().trim().equals("")) {
                    this.m_bIsCheckID = this.checkConferenceID();
                }
            }
        } else if (ie.getSource() == this.m_chkEarly) {
            this.setMaxChannel();
        } else if (ie.getSource() == this.m_chkRecording) {
            this.setMaxChannel();
        } else if (ie.getSource() == this.m_chkPaging) {
            this.setMaxChannel();
            this.m_txtPage.setEnabled(this.m_chkPaging.isSelected());
        } else if (ie.getStateChange() == 1 && ie.getSource() != this.m_chkEmail) {
            if (ie.getSource() == this.m_cboStart.getComponent()) {
                long curTime;
                if (this.m_cboStart.getSelectedIndex() >= this.m_endMin) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("The start time is later than end time."));
                    this.m_cboStart.setSelectedIndex(this.m_startMin);
                    return;
                }
                this.m_startMin = this.m_cboStart.getSelectedIndex();
                this.m_startTime[1] = (byte)(this.m_startMin % 4 * 15);
                this.m_startTime[2] = (byte)(this.m_startMin / 4);
                long startTime = AppRunConference.getCurrentTime(this.m_startTime);
                if (startTime < (curTime = AppDateTimer.getTimeInMillis())) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("The reservation time must be earlier than current system time."));
                    return;
                }
            } else {
                if (this.m_startMin >= this.m_cboEnd.getSelectedIndex()) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("The end time is earlier than start time."));
                    this.m_cboEnd.setSelectedIndex(this.m_endMin);
                    return;
                }
                this.m_endMin = this.m_cboEnd.getSelectedIndex();
                this.m_endTime[1] = (byte)(this.m_endMin % 4 * 15);
                this.m_endTime[2] = (byte)(this.m_endMin / 4);
            }
            this.getUsableChannel();
            if (!this.m_txtId.getText().trim().equals("")) {
                this.m_bIsCheckID = this.checkConferenceID();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getSource() == this.m_txtId && ke.getKeyCode() == 10) {
            this.m_buttons[0].requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (ke.getSource() == this.m_txtId && this.m_txtId.getText().length() >= 3) {
            ke.consume();
        } else if (ke.getSource() == this.m_txtPassword && this.m_txtPassword.getPassword().length >= 4) {
            ke.consume();
        }
    }
}

