/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.configuration;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.configuration.AppDuplicateDlg;
import com.sec.osdm.pages.utils.AppFeatures;
import com.sec.osdm.pages.utils.AppNumPlan;
import com.sec.osdm.pages.utils.components.AppNewText;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class P2800NumberingPlan
extends AppPage {
    private final int SW_CABINET = 100;
    private final int FEAT_CABINET = 102;
    private Hashtable m_numPlan = new Hashtable();
    private Hashtable m_telNoList = null;
    private ArrayList[][] m_hwPort = new ArrayList[13][13];
    private ArrayList[][] m_swPort = new ArrayList[5][1];
    private int maxSlot = AppRunInfo.getRealCabSlot(0);
    private String[] m_swTitle = new String[]{"STN-GRP", "TRK-GRP", "FEATURES", "N-LCR", "R-STN"};
    private JPanel m_subPane = new JPanel(new BorderLayout());
    private JComboBox m_group = new JComboBox();
    private JLabel m_title = new JLabel(String.valueOf(AppLang.getText("Cabinet")) + " ", 4);
    private Hashtable<String, Integer> m_feature = new Hashtable();
    private boolean m_bFlg = false;

    public P2800NumberingPlan(AppPageInfo pageInfo) {
        super(pageInfo);
    }

    @Override
    public void createPage() {
        this.m_telNoList = AppNumPlan.getTelNumberList();
        ArrayList recvData = new ArrayList();
        int i2 = 0;
        while (i2 < this.m_hwPort.length) {
            int j2 = 0;
            while (j2 < this.m_hwPort[i2].length) {
                this.m_hwPort[i2][j2] = new ArrayList();
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_swPort.length) {
            this.m_swPort[i2][0] = new ArrayList();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_recvData.size()) {
            recvData = (ArrayList)this.m_recvData.get(i2);
            if (recvData.get(2).toString().equals("" + (AppRunInfo.getTenantNo() + 1))) {
                int cabinet = Integer.parseInt((String)recvData.get(4)) - 1;
                int slot = Integer.parseInt((String)recvData.get(5)) - 1;
                if (cabinet < 100) {
                    if (cabinet == 0) {
                        slot = AppRunInfo.getSystem() != 4 && slot == this.maxSlot ? 0 : ++slot;
                    } else if (cabinet >= 10) {
                        cabinet = AppRunInfo.getRealCabinet() + (cabinet - 10);
                    }
                    this.m_hwPort[cabinet][slot].add(recvData);
                } else {
                    this.m_swPort[cabinet - 100][0].add(recvData);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < AppRunInfo.getRealCabinet() + AppRunInfo.getVirtCabinet()) {
            this.m_numPlan.put("C" + (i2 + 1), this.m_hwPort[i2]);
            int cnt = 0;
            ArrayList[] slotData = this.m_hwPort[i2];
            int j3 = 0;
            while (j3 < slotData.length) {
                if (cnt > 0) break;
                int k2 = 0;
                while (k2 < slotData[j3].size()) {
                    ArrayList portData = (ArrayList)slotData[j3].get(k2);
                    if (portData.size() > 0) {
                        ++cnt;
                        break;
                    }
                    ++k2;
                }
                ++j3;
            }
            if (cnt > 0) {
                this.m_group.addItem("C" + (i2 + 1));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_swTitle.length) {
            this.m_numPlan.put(this.m_swTitle[i2], this.m_swPort[i2]);
            this.m_group.addItem(this.m_swTitle[i2]);
            ++i2;
        }
        this.m_group.setSelectedIndex(0);
        this.m_group.addItemListener(new CabinetChangeListener());
        this.m_group.addItem("ALL");
        JPanel topPane = new JPanel();
        AppLayout layout = new AppLayout(topPane, 210, 30);
        layout.addComponent(this.m_title, 5, 5, 60, 20);
        layout.addComponent(this.m_group, 70, 5, 100, 20);
        JScrollPane jspSub = new JScrollPane();
        jspSub.getViewport().setView(topPane);
        jspSub.setPreferredSize(new Dimension(2000, 34));
        this.m_subPane.add((Component)jspSub, "West");
        this.createTable((String)this.m_group.getSelectedItem());
    }

    @Override
    public void createTable() {
    }

    public void createTable(final String cab) {
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_table.removeAll();
            this.m_model = null;
            this.m_table = null;
        }
        ArrayList[] slotData = null;
        ArrayList portData = null;
        ArrayList<Object> compData = null;
        ArrayList<String> rowTitle = new ArrayList<String>();
        String sValue = "";
        int nRSTNCnt = 0;
        slotData = (ArrayList[])this.m_numPlan.get(cab);
        int i2 = 0;
        int row = 0;
        while (i2 < slotData.length) {
            int j2 = 0;
            while (j2 < slotData[i2].size()) {
                portData = (ArrayList)slotData[i2].get(j2);
                int cabinet = Integer.parseInt((String)portData.get(4)) - 1;
                int slot = Integer.parseInt((String)portData.get(5)) - 1;
                if (cabinet < 100) {
                    if (cabinet == 0 && slot == this.maxSlot) {
                        if (AppRunInfo.getSystem() == 4) {
                            rowTitle.add(row, "LP");
                        } else {
                            rowTitle.add(row, "MP");
                        }
                    } else {
                        rowTitle.add(row, "S" + (slot + 1));
                    }
                } else if (cabinet == 102) {
                    String featName = AppFeatures.getFeatureName(Integer.parseInt((String)portData.get(6)) - 1);
                    rowTitle.add(row, featName);
                    this.m_feature.put(featName, row);
                } else {
                    rowTitle.add(row, this.m_swTitle[cabinet - 100]);
                }
                compData = new ArrayList<Object>();
                int k2 = 0;
                while (k2 < 4) {
                    sValue = k2 == 0 && portData.get(this.m_pageInfo.getDataPosition(2)).equals("208") ? "" + ++nRSTNCnt : (String)portData.get(this.m_pageInfo.getDataPosition(k2));
                    compData.add(k2, this.createComponent(k2, sValue));
                    ++k2;
                }
                this.m_components.add(row, compData);
                ++j2;
                ++row;
            }
            ++i2;
        }
        if (((String)this.m_group.getSelectedItem()).equals("FEATURES")) {
            Collections.sort(rowTitle);
        }
        this.m_rowTitle = new String[rowTitle.size()][1];
        i2 = 0;
        while (i2 < rowTitle.size()) {
            this.m_rowTitle[i2][0] = (String)rowTitle.get(i2);
            ++i2;
        }
        this.m_corner = new String[][]{{"Slot"}};
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                if (((String)P2800NumberingPlan.this.m_group.getSelectedItem()).equals("FEATURES")) {
                    return ((ArrayList)P2800NumberingPlan.this.m_components.get((Integer)P2800NumberingPlan.this.m_feature.get(P2800NumberingPlan.this.m_rowTitle[row][0]))).get(col);
                }
                return ((ArrayList)P2800NumberingPlan.this.m_components.get(row)).get(col);
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                ArrayList[] slotData = (ArrayList[])P2800NumberingPlan.this.m_numPlan.get(cab);
                ArrayList portData = new ArrayList();
                String curValue = ((AppNewText)aValue).getText().trim();
                String preValue = "";
                int curPort = Integer.parseInt(((AppNewText)this.getValueAt(row, 1)).getText().trim());
                int port = 0;
                int posRow = 0;
                int posCol = 0;
                int i2 = 0;
                while (i2 < slotData.length) {
                    int j2 = 0;
                    while (j2 < slotData[i2].size()) {
                        portData = (ArrayList)slotData[i2].get(j2);
                        port = Integer.parseInt((String)portData.get(0));
                        if (port == curPort) {
                            preValue = (String)portData.get(3);
                            posRow = i2;
                            posCol = j2;
                            break;
                        }
                        ++j2;
                    }
                    ++i2;
                }
                if (!P2800NumberingPlan.this.checkDuplicate(curPort, curValue)) {
                    portData = (ArrayList)slotData[posRow].get(posCol);
                    portData.set(3, curValue);
                    slotData[posRow].set(posCol, portData);
                    P2800NumberingPlan.this.m_numPlan.put(cab, slotData);
                    i2 = 0;
                    while (i2 < P2800NumberingPlan.this.m_recvData.size()) {
                        if (Integer.parseInt((String)((ArrayList)P2800NumberingPlan.this.m_recvData.get(i2)).get(0)) == curPort) {
                            portData = (ArrayList)P2800NumberingPlan.this.m_recvData.get(i2);
                            portData.set(3, curValue);
                            P2800NumberingPlan.this.m_recvData.set(i2, portData);
                            P2800NumberingPlan.this.m_telNoList.put(curPort, curValue);
                            break;
                        }
                        ++i2;
                    }
                    if (!P2800NumberingPlan.this.m_bIsChanged && !preValue.equals(curValue)) {
                        P2800NumberingPlan.this.m_bIsChanged = true;
                    }
                } else {
                    P2800NumberingPlan.this.m_bIsChanged = P2800NumberingPlan.this.m_bFlg;
                    return;
                }
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3;
            }
        };
        this.m_model.setRowWidth(new int[]{100});
        this.m_model.setColWidth(new int[]{80, 80, 150, 100});
        i2 = 0;
        row = 0;
        while (i2 < slotData.length) {
            if (slotData[i2].size() > 0 && !cab.equals("FEATURES")) {
                this.m_model.setRowHeaderRowSpan(row, 0, slotData[i2].size());
                row += slotData[i2].size();
            }
            ++i2;
        }
        this.m_table = new AppTable(this.m_model);
        this.setTableColHidden();
        this.m_contentPane.add((Component)this.m_subPane, "North");
        this.m_contentPane.add((Component)this.m_table, "Center");
    }

    private void createTable_All() {
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_table.removeAll();
            this.m_model = null;
            this.m_table = null;
        }
        ArrayList AllRowName = new ArrayList();
        ArrayList AllCabName = new ArrayList();
        ArrayList<ArrayList[]> sloatData_tmp = new ArrayList<ArrayList[]>();
        int rowCount = 0;
        int rowIdx = 0;
        int featStart = 0;
        int nRSTNCnt = 0;
        int kk = 0;
        while (kk < this.m_group.getItemCount() - 1) {
            ArrayList[] slotData = null;
            ArrayList portData = null;
            ArrayList<Object> compData = null;
            ArrayList<String> rowTitle = new ArrayList<String>();
            ArrayList<String> cabTitle = new ArrayList<String>();
            String sValue = "";
            String cab = (String)this.m_group.getItemAt(kk);
            slotData = (ArrayList[])this.m_numPlan.get(cab);
            sloatData_tmp.add(slotData);
            if (cab.equals("FEATURES")) {
                featStart = rowIdx;
            }
            int i2 = 0;
            int row = 0;
            while (i2 < slotData.length) {
                int j2 = 0;
                while (j2 < slotData[i2].size()) {
                    portData = (ArrayList)slotData[i2].get(j2);
                    int cabinet = Integer.parseInt((String)portData.get(4)) - 1;
                    int slot = Integer.parseInt((String)portData.get(5)) - 1;
                    if (cabinet < 100) {
                        if (cabinet == 0 && slot == this.maxSlot) {
                            if (AppRunInfo.getSystem() == 4) {
                                rowTitle.add(row, "LP");
                            } else {
                                rowTitle.add(row, "MP");
                            }
                        } else {
                            rowTitle.add(row, "S" + (slot + 1));
                        }
                    } else if (cabinet == 102) {
                        String featName = AppFeatures.getFeatureName(Integer.parseInt((String)portData.get(6)) - 1);
                        rowTitle.add(row, featName);
                        this.m_feature.put(featName, rowIdx);
                    } else {
                        rowTitle.add(row, this.m_swTitle[cabinet - 100]);
                    }
                    cabTitle.add(cab);
                    compData = new ArrayList<Object>();
                    int k2 = 0;
                    while (k2 < 4) {
                        sValue = k2 == 0 && portData.get(this.m_pageInfo.getDataPosition(2)).equals("208") ? "" + ++nRSTNCnt : (String)portData.get(this.m_pageInfo.getDataPosition(k2));
                        compData.add(k2, this.createComponent(k2, sValue));
                        ++k2;
                    }
                    this.m_components.add(rowIdx, compData);
                    ++rowIdx;
                    ++j2;
                    ++row;
                }
                ++i2;
            }
            if (cab.equals("FEATURES")) {
                Collections.sort(rowTitle);
            }
            rowCount += rowTitle.size();
            AllRowName.add(rowTitle);
            AllCabName.add(cabTitle);
            ++kk;
        }
        rowIdx = 0;
        this.m_rowTitle = new String[rowCount][2];
        int jj = 0;
        while (jj < AllRowName.size()) {
            ArrayList rowTitle = (ArrayList)AllRowName.get(jj);
            ArrayList cabTitle = (ArrayList)AllCabName.get(jj);
            int i3 = 0;
            while (i3 < rowTitle.size()) {
                this.m_rowTitle[rowIdx][0] = (String)cabTitle.get(i3);
                this.m_rowTitle[rowIdx][1] = (String)rowTitle.get(i3);
                ++rowIdx;
                ++i3;
            }
            ++jj;
        }
        this.m_corner = new String[][]{{"Cabinet", "Slot"}};
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                if (((ArrayList)P2800NumberingPlan.this.m_components.get(row)).get(2).toString().toLowerCase().equals("features")) {
                    return ((ArrayList)P2800NumberingPlan.this.m_components.get((Integer)P2800NumberingPlan.this.m_feature.get(P2800NumberingPlan.this.m_rowTitle[row][1]))).get(col);
                }
                return ((ArrayList)P2800NumberingPlan.this.m_components.get(row)).get(col);
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                ArrayList[] slotData = (ArrayList[])P2800NumberingPlan.this.m_numPlan.get(P2800NumberingPlan.this.m_rowTitle[row][0]);
                ArrayList portData = new ArrayList();
                String curValue = ((AppNewText)aValue).getText().trim();
                String preValue = "";
                int curPort = Integer.parseInt(((AppNewText)this.getValueAt(row, 1)).getText().trim());
                int port = 0;
                int posRow = 0;
                int posCol = 0;
                int i2 = 0;
                while (i2 < slotData.length) {
                    int j2 = 0;
                    while (j2 < slotData[i2].size()) {
                        portData = (ArrayList)slotData[i2].get(j2);
                        port = Integer.parseInt((String)portData.get(0));
                        if (port == curPort) {
                            preValue = (String)portData.get(3);
                            posRow = i2;
                            posCol = j2;
                            break;
                        }
                        ++j2;
                    }
                    ++i2;
                }
                if (!P2800NumberingPlan.this.checkDuplicate(curPort, curValue)) {
                    portData = (ArrayList)slotData[posRow].get(posCol);
                    portData.set(3, curValue);
                    slotData[posRow].set(posCol, portData);
                    P2800NumberingPlan.this.m_numPlan.put(P2800NumberingPlan.this.m_rowTitle[row][0], slotData);
                    i2 = 0;
                    while (i2 < P2800NumberingPlan.this.m_recvData.size()) {
                        if (Integer.parseInt((String)((ArrayList)P2800NumberingPlan.this.m_recvData.get(i2)).get(0)) == curPort) {
                            portData = (ArrayList)P2800NumberingPlan.this.m_recvData.get(i2);
                            portData.set(3, curValue);
                            P2800NumberingPlan.this.m_recvData.set(i2, portData);
                            P2800NumberingPlan.this.m_telNoList.put(curPort, curValue);
                            break;
                        }
                        ++i2;
                    }
                    if (!P2800NumberingPlan.this.m_bIsChanged && !preValue.equals(curValue)) {
                        P2800NumberingPlan.this.m_bIsChanged = true;
                    }
                } else {
                    P2800NumberingPlan.this.m_bIsChanged = P2800NumberingPlan.this.m_bFlg;
                    return;
                }
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3;
            }
        };
        this.m_model.setRowWidth(new int[]{100, 100});
        this.m_model.setColWidth(new int[]{80, 80, 150, 100});
        int idx = 0;
        int pp = 0;
        while (pp < sloatData_tmp.size()) {
            ArrayList[] slotData = (ArrayList[])sloatData_tmp.get(pp);
            int count = 0;
            int i4 = 0;
            while (i4 < slotData.length) {
                if (slotData[i4].size() > 0) {
                    count += slotData[i4].size();
                    if (featStart == idx) {
                        idx += slotData[i4].size();
                    } else {
                        this.m_model.setRowHeaderRowSpan(idx, 1, slotData[i4].size());
                        idx += slotData[i4].size();
                    }
                }
                ++i4;
            }
            if (count != 0) {
                this.m_model.setRowHeaderRowSpan(idx - count, 0, count);
            }
            ++pp;
        }
        this.m_table = new AppTable(this.m_model);
        this.setTableColHidden();
        this.m_contentPane.add((Component)this.m_subPane, "North");
        this.m_contentPane.add((Component)this.m_table, "Center");
    }

    public boolean checkDuplicate(int port, String tel) {
        ArrayList<String> dupData = new ArrayList<String>();
        if (tel != null && !tel.equals("")) {
            Iterator it = this.m_telNoList.keySet().iterator();
            while (it.hasNext()) {
                int key = (Integer)it.next();
                if (port != key && ((String)this.m_telNoList.get(key)).startsWith(tel)) {
                    dupData.add(String.valueOf(key) + ";" + (String)this.m_telNoList.get(key));
                }
                int i2 = 0;
                while (i2 < tel.length()) {
                    String s2 = tel.substring(0, i2 + 1);
                    if (port != key && ((String)this.m_telNoList.get(key)).equals(s2)) {
                        String strData = String.valueOf(key) + ";" + (String)this.m_telNoList.get(key);
                        dupData.remove(strData);
                        dupData.add(strData);
                    }
                    ++i2;
                }
            }
        }
        if (dupData.size() > 0) {
            Collections.sort(dupData);
            AppDuplicateDlg dupDlg = new AppDuplicateDlg(dupData, this.m_recvData, port, tel, this.m_telNoList);
            if (dupDlg.getConvertData().size() > 0) {
                this.m_bFlg = true;
                this.m_recvData = dupDlg.getConvertData();
                this.m_telNoList = dupDlg.getTelnumberList();
                int i3 = 0;
                while (i3 < this.m_model.getRowHdrRowCount()) {
                    block11: {
                        int key = 0;
                        try {
                            key = Integer.parseInt(this.m_model.getValueAt(i3, 1).toString());
                        }
                        catch (NumberFormatException e2) {
                            System.out.println("Numberformat Exception");
                            break block11;
                        }
                        ((AppNewText)this.m_model.getValueAt(i3, 3)).setText((String)this.m_telNoList.get(key));
                    }
                    ++i3;
                }
                this.m_table.repaint();
            } else {
                this.m_bFlg = false;
            }
            dupDlg.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void actionToolButton(String command) {
        this.actionPageToolButton(command);
    }

    class CabinetChangeListener
    implements ItemListener {
        CabinetChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            if (e2.getStateChange() == 1) {
                if (((String)P2800NumberingPlan.this.m_group.getSelectedItem()).equals("ALL")) {
                    P2800NumberingPlan.this.clearPrintTable();
                    P2800NumberingPlan.this.createTable_All();
                    P2800NumberingPlan.this.setPrintableComponent(P2800NumberingPlan.this.m_table);
                } else {
                    P2800NumberingPlan.this.clearPrintTable();
                    P2800NumberingPlan.this.createTable((String)P2800NumberingPlan.this.m_group.getSelectedItem());
                    P2800NumberingPlan.this.setPrintableComponent(P2800NumberingPlan.this.m_table);
                }
            }
        }
    }
}

