/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppRunInfo;
import java.util.Hashtable;

public class AppNumPlan {
    public static final int STRING_B = 61152;
    public static final int STRING_TONE = 61153;
    public static final int STRING_ALL = 61154;
    public static final int STRING_D = 61155;
    public static final int STRING_A = 61156;
    public static final int STRING_LCR = 61157;
    public static final int STRING_IT = 61434;
    public static final int STRING_WEB = 61435;
    public static final int STRING_C = 61168;
    public static final int STRING_P1 = 61169;
    public static final int STRING_P12 = 61180;
    public static final int STRING_S000 = 57344;
    public static final int STRING_S999 = 58343;
    public static byte[] m_numPlan = null;
    private static Hashtable<String, Integer> m_portNumber = null;
    private static Hashtable<Integer, String> m_telNumber = null;
    private static Hashtable<Integer, Integer> m_devType = null;

    public static void setNumPlanData(byte[] num) {
        m_numPlan = num;
        AppNumPlan.removeHashTable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTelNumber(int port) {
        String tel;
        try {
            tel = "";
            if (m_telNumber == null) {
                AppNumPlan.makeInitialData();
            }
            if (m_telNumber.containsKey(port)) {
                return m_telNumber.get(port);
            }
            switch (port) {
                case 61156: {
                    return "A";
                }
                case 61152: {
                    return "B";
                }
                case 61155: {
                    return "D";
                }
                case 61153: {
                    return "TONE";
                }
                case 61154: {
                    return "ALL";
                }
                case 61157: {
                    return "LCR";
                }
                case 61434: {
                    return "Management Tool";
                }
                case 61435: {
                    return "WebMMC";
                }
                case 61168: {
                    return "C";
                }
            }
        }
        catch (Exception exception) {
            return "";
        }
        if (port >= 61169 && port <= 61180) {
            return "P" + (port - 61169 + 1);
        }
        if (port < 57344) return tel;
        if (port > 58343) return tel;
        return "S" + (port - 57344);
    }

    public static String getTelNumber(int cab, int slot, int ch2) {
        int port = AppNumPlan.getPortNo(cab, slot, ch2);
        return AppNumPlan.getTelNumber(port);
    }

    public static Hashtable getTelNumberList() {
        if (m_telNumber == null) {
            AppNumPlan.makeInitialData();
        }
        return m_telNumber;
    }

    public static void setTelNumber(int port, String tel) {
        if (m_telNumber == null) {
            AppNumPlan.makeInitialData();
        }
        m_telNumber.put(port, tel);
        m_portNumber.put(tel, port);
    }

    public static byte getDeviceType(int port) {
        int device = 255;
        if (m_devType == null) {
            AppNumPlan.makeInitialData();
        }
        if (m_devType.containsKey(port)) {
            device = m_devType.get(port);
        }
        return (byte)device;
    }

    public static byte getDeviceType(int cab, int slot, int ch2) {
        int port = AppNumPlan.getPortNo(cab, slot, ch2);
        return AppNumPlan.getDeviceType(port);
    }

    public static int getPortNo(String tel) {
        int port = 65535;
        if (m_portNumber == null) {
            AppNumPlan.makeInitialData();
        }
        if (!tel.equals("") && m_portNumber.containsKey(tel)) {
            port = m_portNumber.get(tel);
        } else if (tel.toUpperCase().equals("A")) {
            port = 61156;
        } else if (tel.toUpperCase().equals("B")) {
            port = 61152;
        } else if (tel.toUpperCase().equals("D")) {
            port = 61155;
        } else if (tel.toUpperCase().equals("TONE")) {
            port = 61153;
        } else if (tel.toUpperCase().equals("ALL")) {
            port = 61154;
        } else if (tel.toUpperCase().equals("LCR")) {
            port = 61157;
        } else if (tel.toUpperCase().equals("Management Tool")) {
            port = 61434;
        } else if (tel.toUpperCase().equals("WebMMC")) {
            port = 61435;
        } else if (tel.toUpperCase().equals("C")) {
            port = 61168;
        } else if (tel.toUpperCase().trim().startsWith("P")) {
            try {
                int ext = Integer.parseInt(tel.substring(1));
                port = 61169 + ext - 1;
            }
            catch (Exception ext) {}
        } else if (tel.toUpperCase().trim().startsWith("S")) {
            try {
                int ext = Integer.parseInt(tel.substring(1));
                port = 57344 + ext;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return port;
    }

    public static int getPortNo(int cab, int slot, int ch2) {
        int i2 = 0;
        while (i2 < m_numPlan.length) {
            if (m_numPlan[i2 + 6] == (byte)cab && m_numPlan[i2 + 7] == (byte)slot && m_numPlan[i2 + 8] == (byte)ch2) {
                short port = AppFunctions.byte2short(m_numPlan, i2);
                return port;
            }
            i2 += 10;
        }
        return 65535;
    }

    public static String getOwnerList() {
        String owner = "";
        for (int port : m_telNumber.keySet()) {
            int devType = m_devType.get(port);
            if (!AppNumPlan.checkOwnerDeviceType(devType) || m_telNumber.get(port).equals("")) continue;
            owner = String.valueOf(m_telNumber.get(port)) + ";" + owner;
        }
        return owner;
    }

    private static boolean checkOwnerDeviceType(int dev) {
        switch (dev) {
            case 0: 
            case 1: 
            case 5: 
            case 19: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 42: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 108: 
            case 109: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 194: 
            case 195: 
            case 196: {
                return true;
            }
        }
        return false;
    }

    public static void makeInitialData() {
        AppNumPlan.createHashTable();
        int i2 = 0;
        while (i2 < m_numPlan.length) {
            if (m_numPlan[i2 + 3] == AppRunInfo.getTenantNo()) {
                m_portNumber.put(AppFunctions.byte2tel(m_numPlan[i2 + 4], m_numPlan[i2 + 5]), Integer.valueOf(AppFunctions.byte2short(m_numPlan, i2)));
                m_telNumber.put(Integer.valueOf(AppFunctions.byte2short(m_numPlan, i2)), AppFunctions.byte2tel(m_numPlan[i2 + 4], m_numPlan[i2 + 5]));
                m_devType.put(Integer.valueOf(AppFunctions.byte2short(m_numPlan, i2)), Integer.parseInt(AppFunctions.unsignedValue(m_numPlan[i2 + 2])));
            }
            i2 += 10;
        }
    }

    private static void createHashTable() {
        m_portNumber = new Hashtable();
        m_telNumber = new Hashtable();
        m_devType = new Hashtable();
    }

    private static void removeHashTable() {
        m_portNumber = null;
        m_telNumber = null;
        m_devType = null;
    }
}

