/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.components;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.utils.components.AppSelect;
import com.sec.osdm.pages.utils.table.ICellComponent;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;

public class AppComboBox
implements ICellComponent {
    public static Border g_CellborderColor = BorderFactory.createLineBorder(new Color(188, 189, 190));
    private JComboBox m_component = null;
    private Hashtable m_htItems = null;
    private JTable m_owner = null;

    public AppComboBox() {
        this.createComponent(null);
    }

    public AppComboBox(int idx) {
        String[] items = null;
        if (idx > 0) {
            items = AppSelect.getItems(idx);
        }
        this.createComponent(items);
    }

    public AppComboBox(String[] items) {
        this.createComponent(items);
    }

    private void createComponent(String[] items) {
        this.m_component = new JComboBox();
        this.m_htItems = new Hashtable();
        if (items != null) {
            int i2 = 0;
            int j2 = 0;
            while (i2 < items.length) {
                String[] item = items[i2].split(":");
                if (item.length > 1) {
                    j2 = Integer.parseInt(item[0]);
                    this.addItem(AppLang.getText(item[1].trim()), j2);
                } else {
                    this.addItem(AppLang.getText(items[i2].trim()), j2);
                }
                ++i2;
                ++j2;
            }
        }
    }

    public void addItem(String item) {
        item = AppLang.getText(item);
        this.m_component.addItem(item);
        this.m_htItems.put(this.m_htItems.size(), item);
    }

    public void addItem(String item, int index) {
        item = AppLang.getText(item);
        this.m_component.addItem(item);
        this.m_htItems.put(index, item);
    }

    public void addItems(String[] items, int[] index) {
        int i2 = 0;
        while (i2 < items.length) {
            items[i2] = AppLang.getText(items[i2]);
            this.m_component.addItem(items[i2]);
            if (index == null) {
                this.m_htItems.put(i2, items[i2]);
            } else {
                this.m_htItems.put(index[i2], items[i2]);
            }
            ++i2;
        }
    }

    public void removeItem(int index) {
        this.m_component.removeItemAt(index);
        if (this.m_htItems.containsKey(index)) {
            this.m_htItems.remove(index);
        }
    }

    public void removeAllItems() {
        this.m_component.removeAllItems();
    }

    public void addListener(ItemListener listener) {
        this.m_component.addItemListener(listener);
    }

    public int getSelectedIndex() {
        return this.getSelectedIndex((String)this.m_component.getSelectedItem());
    }

    public int getSelectedIndex(String item) {
        Iterator it = this.m_htItems.keySet().iterator();
        while (it.hasNext()) {
            int key = (Integer)it.next();
            if (!((String)this.m_htItems.get(key)).equals(item)) continue;
            return key;
        }
        return 0;
    }

    public String getSelectedItem() {
        return (String)this.m_component.getSelectedItem();
    }

    public String getSelectedItem(int idx) {
        if (this.m_htItems.containsKey(idx)) {
            return (String)this.m_htItems.get(idx);
        }
        return "";
    }

    public void setSelectedItem(String item) {
        this.m_component.setSelectedItem(item);
    }

    public void setSelectedIndex(int index) {
        if (this.m_htItems.containsKey(index)) {
            this.m_component.setSelectedItem((String)this.m_htItems.get(index));
        } else {
            this.m_component.setSelectedIndex(0);
        }
    }

    public void setActionListener(ActionListener al) {
        this.m_component.addActionListener(al);
    }

    public void setActionCommand(String command) {
        this.m_component.setActionCommand(command);
    }

    @Override
    public void finishEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this.m_component;
    }

    @Override
    public JTable getOwner() {
        return this.m_owner;
    }

    @Override
    public void setOwner(JTable table) {
        this.m_owner = table;
    }

    @Override
    public String toString() {
        return (String)this.m_component.getSelectedItem();
    }

    @Override
    public void clear() {
        this.m_component.setSelectedIndex(0);
    }

    @Override
    public boolean checkValue(String strData) {
        int i2 = 0;
        while (i2 < this.m_component.getItemCount()) {
            if (strData.trim().equals(this.m_component.getItemAt(i2).toString().trim())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public void fromString(String strData) {
        this.m_component.setSelectedItem(strData);
    }
}

