/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.printpreview;

import com.sec.osdm.pages.utils.table.AppTable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppPrintPage
implements Printable {
    private static final double SCALE_RATE = 0.5;
    private static final int POS_HEADER_Y = 20;
    private static final int POS_FOOTER_Y = 1500;
    private static final int POS_FOOTER_X = 960;
    private static final int CLIP_X = -10;
    private static final int CLIP_Y = -20;
    private static final int CLIP_WIDTH = 1160;
    private static final int CLIP_HEIGHT = 1600;
    private static final float HEADER_FONT_SIZE = 16.0f;
    private static final float FOOTER_FONT_SIZE = 14.0f;
    private AppTable mTable;
    private Font mHeaderFont;
    private Font mFooterFont;
    private String mHeaderText;
    private String mFooterText;
    private String mDateText;
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public AppPrintPage(AppTable table, String header, String footer) {
        this.mTable = table;
        this.mHeaderText = header;
        this.mFooterText = footer;
        this.mDateText = this.mDateFormat.format(new Date());
        this.mHeaderFont = this.mTable.getFont().deriveFont(1, 16.0f);
        this.mFooterFont = this.mTable.getFont().deriveFont(0, 14.0f);
    }

    public AppTable getTable() {
        return this.mTable;
    }

    public void setFooterText(String footer) {
        this.mFooterText = footer;
    }

    @Override
    public int print(Graphics g2, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex <= 0) {
            Graphics2D g2d = (Graphics2D)g2;
            g2d.translate(36, 50);
            g2d.scale(0.5, 0.5);
            g2d.setClip(-10, -20, 1160, 1600);
            this.printText(g2d, this.mHeaderText, this.mHeaderFont, 0, 0);
            g2d.translate(0, 20);
            this.mTable.getCorner("UPPER_LEFT_CORNER").print(g2d);
            g2d.drawLine(0, 0, (int)this.mTable.getViewport().getView().getSize().getWidth() + (int)this.mTable.getRowHeader().getView().getSize().getWidth(), 0);
            g2d.drawLine(0, 0, 0, (int)this.mTable.getViewport().getView().getSize().getHeight() + (int)this.mTable.getColumnHeader().getView().getSize().getHeight());
            int y2 = (int)this.mTable.getCorner("UPPER_LEFT_CORNER").getSize().getHeight();
            g2d.translate(0, y2);
            this.mTable.getRowHeader().getView().paint(g2d);
            int x2 = (int)this.mTable.getCorner("UPPER_LEFT_CORNER").getSize().getWidth();
            y2 = (int)this.mTable.getCorner("UPPER_LEFT_CORNER").getSize().getHeight();
            g2d.translate(x2, -y2);
            this.mTable.getColumnHeader().getView().paint(g2d);
            y2 = (int)this.mTable.getCorner("UPPER_LEFT_CORNER").getSize().getHeight();
            g2d.translate(0, y2);
            this.mTable.getViewport().getView().paint(g2d);
            g2d.translate(-x2, 1500 - y2);
            this.printText(g2d, this.mFooterText, this.mFooterFont, 0, 0);
            this.printText(g2d, this.mDateText, this.mFooterFont, 960, 0);
            return 0;
        }
        return 1;
    }

    private void printText(Graphics2D g2d, String text, Font font, int tx, int ty) {
        g2d.setColor(Color.BLACK);
        g2d.setFont(font);
        g2d.drawString(text, tx, ty);
    }
}

