/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.pages.utils.table.AppClipboardManager;
import com.sec.osdm.pages.utils.table.AppKeyHandler;
import com.sec.osdm.pages.utils.table.ICellComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class AppHandlerCut
extends AppKeyHandler {
    public static final String KEY_COMMAND = "Cut";

    public AppHandlerCut(JTable table) {
        super(table, 88, 2, KEY_COMMAND);
    }

    @Override
    public void bindAction() {
        Object aCellComp;
        int j2;
        StringBuffer strBuffer = new StringBuffer();
        int iSelectedColCount = this.m_table.getSelectedColumnCount();
        int iSelectedRowCount = this.m_table.getSelectedRowCount();
        int[] arrSelectedRows = this.m_table.getSelectedRows();
        int[] arrSelectedCols = this.m_table.getSelectedColumns();
        if (arrSelectedRows.length == 0 || arrSelectedCols.length == 0) {
            return;
        }
        if (iSelectedRowCount - 1 != arrSelectedRows[arrSelectedRows.length - 1] - arrSelectedRows[0] || iSelectedRowCount != arrSelectedRows.length || iSelectedColCount - 1 != arrSelectedCols[arrSelectedCols.length - 1] - arrSelectedCols[0] || iSelectedColCount != arrSelectedCols.length) {
            JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
            return;
        }
        int i2 = 0;
        while (i2 < iSelectedRowCount) {
            if (!this.isRowHidden(arrSelectedRows[i2])) {
                j2 = 0;
                while (j2 < iSelectedColCount) {
                    aCellComp = this.m_table.getValueAt(arrSelectedRows[i2], arrSelectedCols[j2]);
                    if (!this.isColHidden(arrSelectedCols[j2])) {
                        strBuffer.append(aCellComp == null ? "" : aCellComp.toString());
                        if (j2 < iSelectedColCount - 1) {
                            strBuffer.append("\t");
                        }
                    }
                    ++j2;
                }
                strBuffer.append("\n");
            }
            ++i2;
        }
        AppClipboardManager.getInstance().write(strBuffer.toString());
        if (iSelectedRowCount - 1 != arrSelectedRows[arrSelectedRows.length - 1] - arrSelectedRows[0] || iSelectedRowCount != arrSelectedRows.length || iSelectedColCount - 1 != arrSelectedCols[arrSelectedCols.length - 1] - arrSelectedCols[0] || iSelectedColCount != arrSelectedCols.length) {
            JOptionPane.showMessageDialog(null, "Invalid Delete Selection", "Input Error", 0);
            return;
        }
        i2 = 0;
        while (i2 < iSelectedRowCount) {
            j2 = 0;
            while (j2 < iSelectedColCount) {
                aCellComp = this.m_table.getValueAt(arrSelectedRows[i2], arrSelectedCols[j2]);
                boolean fEditable = this.m_table.isCellEditable(arrSelectedRows[i2], arrSelectedCols[j2]);
                if (aCellComp instanceof ICellComponent && fEditable && (!this.isColHidden(arrSelectedCols[j2]) || !this.isRowHidden(arrSelectedRows[i2]))) {
                    ((ICellComponent)aCellComp).clear();
                    this.m_table.setValueAt(aCellComp, arrSelectedRows[i2], arrSelectedCols[j2]);
                }
                ++j2;
            }
            ++i2;
        }
        this.m_table.updateUI();
    }

    @Override
    public String getKeyCommand() {
        return KEY_COMMAND;
    }
}

