/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.pages.vmaa.P2006PromptEncodeState;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class P2006PromptEncodeMain {
    static int out_buffer;
    static int out_bits;
    static byte code;
    static byte out_byte;
    static final boolean debugFlag = false;

    public P2006PromptEncodeMain(String path, String codec) {
        if (path == null) {
            AppGlobal.showErrorMessage("", "File not found");
            return;
        }
        FileInputStream inputFile = null;
        FileOutputStream outputFile = null;
        try {
            inputFile = new FileInputStream(path);
            if (codec.equals("g726")) {
                outputFile = new FileOutputStream(String.valueOf(path.split("\\.")[0]) + ".726");
            } else if (codec.equals("g711u")) {
                outputFile = new FileOutputStream(String.valueOf(path.split("\\.")[0]) + ".711");
            } else if (codec.equals("g711a")) {
                outputFile = new FileOutputStream(String.valueOf(path.split("\\.")[0]) + ".alaw");
            } else {
                return;
            }
            try {
                byte[] arr = new byte[2];
                P2006PromptEncodeState state = new P2006PromptEncodeState();
                while (true) {
                    byte arr2;
                    int num = inputFile.read(arr);
                    short tmp1 = (short)(arr[1] << 8);
                    P2006PromptEncodeMain.mcldebug("tmp1 = %x", tmp1);
                    short tmp2 = arr[0];
                    tmp2 = (short)(tmp2 & 0xFF);
                    P2006PromptEncodeMain.mcldebug(" tmp2 = %x", tmp2);
                    short tmp = (short)(tmp1 | tmp2);
                    P2006PromptEncodeMain.mcldebug(" tmp = %x", tmp);
                    P2006PromptEncodeMain.mcldebug(" tmp = %d\n", tmp);
                    P2006PromptEncodeMain.mcldebug("input = %x", arr[0]);
                    P2006PromptEncodeMain.mcldebug("  %x\n", arr[1]);
                    if (num < 0) {
                        break;
                    }
                    if (codec.equals("g726")) {
                        code = (byte)P2006PromptEncodeMain.Encode2G726(tmp, 3, state);
                        P2006PromptEncodeMain.mcldebug("code = %d\n", code);
                        P2006PromptEncodeMain.pack_output(code, 4);
                        if (out_bits >= 8) {
                            out_byte = (byte)(out_buffer & 0xFF);
                            out_bits -= 8;
                            out_buffer >>= 8;
                            arr2 = out_byte;
                            P2006PromptEncodeMain.mcldebug("arr2 = %x\n", arr2);
                            outputFile.write(arr2);
                        }
                    }
                    if (codec.equals("g711u")) {
                        code = P2006PromptEncodeMain.Encode2ulaw(tmp);
                        P2006PromptEncodeMain.mcldebug("code = %d\n", code);
                        P2006PromptEncodeMain.pack_output(code, 4);
                        arr2 = code;
                        P2006PromptEncodeMain.mcldebug("arr2 = %x\n", arr2);
                        outputFile.write(arr2);
                    }
                    if (!codec.equals("g711a")) continue;
                    code = P2006PromptEncodeMain.Encode2alaw(tmp);
                    P2006PromptEncodeMain.mcldebug("code = %d\n", code);
                    P2006PromptEncodeMain.pack_output(code, 4);
                    arr2 = code;
                    P2006PromptEncodeMain.mcldebug("arr2 = %x\n", arr2);
                    outputFile.write(arr2);
                }
            }
            catch (FileNotFoundException fnfe) {
                AppGlobal.showErrorMessage("", String.valueOf(path) + "File not found");
            }
            catch (IOException ioe) {
                AppGlobal.showErrorMessage("", String.valueOf(path) + "can't read or write this file");
            }
        }
        finally {
            try {
                inputFile.close();
                outputFile.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int Encode2G726(short sl, int in_coding, P2006PromptEncodeState state) {
        short[] qtab_721 = new short[]{-124, 80, 178, 246, 300, 349, 400};
        short[] _dqlntab = new short[]{-2048, 4, 135, 213, 273, 323, 373, 425, 425, 373, 323, 273, 213, 135, 4, -2048};
        short[] _witab = new short[]{-12, 18, 41, 64, 112, 198, 355, 1122, 1122, 355, 198, 112, 64, 41, 18, -12};
        short[] sArray = new short[16];
        sArray[3] = 512;
        sArray[4] = 512;
        sArray[5] = 512;
        sArray[6] = 1536;
        sArray[7] = 3584;
        sArray[8] = 3584;
        sArray[9] = 1536;
        sArray[10] = 512;
        sArray[11] = 512;
        sArray[12] = 512;
        short[] _fitab = sArray;
        switch (in_coding) {
            case 0: 
            case 3: {
                sl = (short)(sl >> 2);
                break;
            }
        }
        P2006PromptEncodeMain.mcldebug("sl = %x\n", sl);
        short sezi = (short)state.predictorZero();
        P2006PromptEncodeMain.mcldebug("sezi = %x\n", sezi);
        short sez = (short)(sezi >> 1);
        P2006PromptEncodeMain.mcldebug("sez = %x\n", sez);
        short se = (short)(sezi + state.predictorPole() >> 1);
        P2006PromptEncodeMain.mcldebug("se = %x\n", se);
        short d2 = (short)(sl - se);
        P2006PromptEncodeMain.mcldebug("d = %x\n", d2);
        short y2 = (short)state.stepSize();
        P2006PromptEncodeMain.mcldebug("y = %x\n", y2);
        short i2 = (short)state.quantize(d2, y2, qtab_721, 7);
        P2006PromptEncodeMain.mcldebug("i = %x\n", i2);
        short dq2 = (short)state.reconstruct(i2 & 8, _dqlntab[i2], y2);
        P2006PromptEncodeMain.mcldebug("dq = %x\n", dq2);
        short sr = (short)(dq2 < 0 ? se - (dq2 & 0x3FFF) : se + dq2);
        P2006PromptEncodeMain.mcldebug("sr = %x\n", sr);
        short dqsez = (short)(sr + sez - se);
        P2006PromptEncodeMain.mcldebug("dqsez = %x\n", dqsez);
        state.update(4, y2, _witab[i2] << 5, _fitab[i2], dq2, sr, dqsez);
        return i2;
    }

    public static byte Encode2ulaw(int pcm_val) {
        int mask;
        short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
        if (pcm_val < 0) {
            pcm_val = 132 - pcm_val;
            mask = 127;
        } else {
            pcm_val += 132;
            mask = 255;
        }
        int seg = P2006PromptEncodeMain.search(pcm_val, seg_end, 8);
        if (seg >= 8) {
            return (byte)(0x7F ^ mask);
        }
        byte uval = (byte)(seg << 4 | pcm_val >> seg + 3 & 0xF);
        return (byte)(uval ^ mask);
    }

    public static byte Encode2alaw(int pcm_val) {
        int mask;
        short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
        if (pcm_val >= 0) {
            mask = 213;
        } else {
            mask = 85;
            pcm_val = -pcm_val - 8;
        }
        int seg = P2006PromptEncodeMain.search(pcm_val, seg_end, 8);
        if (seg >= 8) {
            return (byte)(0x7F ^ mask);
        }
        byte aval = (byte)(seg << 4);
        aval = seg < 2 ? (byte)(aval | pcm_val >> 4 & 0xF) : (byte)(aval | pcm_val >> seg + 3 & 0xF);
        return (byte)(aval ^ mask);
    }

    public static void pack_output(int code, int bits) {
        out_buffer |= code << out_bits;
        out_bits += bits;
    }

    public static int search(int val, short[] table, int size) {
        int i2 = 0;
        while (i2 < size) {
            if (val <= table[i2]) {
                return i2;
            }
            ++i2;
        }
        return size;
    }

    public static void mcldebug(String str, Object obj) {
    }
}

