/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P2011SubscriberImport
extends AppPage {
    private AppTable m_table1 = null;
    private AppTableModel m_model1 = null;
    private String[][] m_rowTitle1 = null;
    private String[][] m_colTitle1 = null;
    private String[][] m_corner1 = null;
    private ArrayList m_components1 = new ArrayList();
    private JButton m_btFile = new JButton(String.valueOf(AppLang.getText("File")) + "..");
    private JRadioButton[] m_rdSelect = new JRadioButton[4];
    private File m_selFile = null;
    private JFileChooser m_jfcFile = null;
    private int m_selIndex = -1;
    private JComboBox m_cbVM = null;
    private JLabel m_lbVM = null;
    private JButton m_btnSubmit = null;
    private AppFTPClient m_ftp = new AppFTPClient();

    public P2011SubscriberImport(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        this.createComponents();
    }

    public void createComponents() {
        String[] strGroup = new String[99];
        int i2 = 0;
        while (i2 < 99) {
            strGroup[i2] = String.format("%02d", i2 + 1);
            ++i2;
        }
        this.m_lbVM = new JLabel(AppLang.getText("VMS Group"));
        this.m_cbVM = new JComboBox<String>(strGroup);
        this.m_btnSubmit = new JButton(AppLang.getText("Submit"));
        this.m_btnSubmit.addActionListener(this);
        this.m_btnSubmit.setActionCommand("Submit");
        AppGlobal.fixSize(this.m_btnSubmit, new Dimension(80, 22));
        JPanel topLeftPan = new JPanel();
        JPanel topRightPan = new JPanel();
        topLeftPan.add(this.m_lbVM);
        topLeftPan.add(this.m_cbVM);
        topRightPan.add(this.m_btnSubmit);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)topLeftPan, "Before");
        topPanel.add((Component)topRightPan, "After");
        this.m_jspTop.getViewport().setView(topPanel);
        this.m_jspTop.setVisible(true);
        this.m_corner = new String[][]{{""}};
        this.m_colTitle = new String[][]{{"", ""}};
        this.m_rowTitle = new String[][]{{"Import Text File"}};
        this.m_corner1 = new String[][]{{""}};
        this.m_colTitle1 = new String[][]{{""}};
        this.m_rowTitle1 = new String[][]{{"You can create"}};
        this.setComponents();
    }

    private void setComponents() {
        String[] rdTitle = new String[]{AppLang.getText("Extension blocks only"), AppLang.getText("Mailbox blocks only"), AppLang.getText("Network Mailbox blocks"), AppLang.getText("Both Ext and Mbx blocks")};
        String[] rdCommand = new String[]{"0", "1", "2", "3"};
        ButtonGroup group = new ButtonGroup();
        this.m_compText = new AppTextBox();
        this.m_components.add(0, this.m_compText);
        this.m_btFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (P2011SubscriberImport.this.m_jfcFile == null) {
                    P2011SubscriberImport.this.m_jfcFile = new JFileChooser();
                }
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Text file", "TXT");
                P2011SubscriberImport.this.m_jfcFile.setFileFilter(filter);
                int yn = P2011SubscriberImport.this.m_jfcFile.showOpenDialog(null);
                if (yn == 0) {
                    P2011SubscriberImport.this.m_selFile = P2011SubscriberImport.this.m_jfcFile.getSelectedFile();
                    ((AppTextBox)P2011SubscriberImport.this.m_components.get(0)).setText("  " + P2011SubscriberImport.this.m_selFile);
                    P2011SubscriberImport.this.m_contentPane.repaint();
                }
            }
        });
        this.m_components.add(1, this.m_btFile);
        JPanel jpRadio = new JPanel(new GridLayout(4, 1));
        int i2 = 0;
        while (i2 < this.m_rdSelect.length) {
            this.m_rdSelect[i2] = new JRadioButton(rdTitle[i2], false);
            this.m_rdSelect[i2].setBackground(Color.white);
            this.m_rdSelect[i2].setForeground(Color.darkGray);
            this.m_rdSelect[i2].setActionCommand(rdCommand[i2]);
            this.m_rdSelect[i2].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    P2011SubscriberImport.this.m_selIndex = Integer.parseInt(e2.getActionCommand());
                }
            });
            group.add(this.m_rdSelect[i2]);
            jpRadio.add(this.m_rdSelect[i2]);
            ++i2;
        }
        this.m_components1.add(0, jpRadio);
        this.createTable();
    }

    @Override
    public void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return (AppTextBox)P2011SubscriberImport.this.m_components.get(col);
                }
                return (JButton)P2011SubscriberImport.this.m_components.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0;
            }
        };
        this.m_model.setRowWidth(new int[]{120});
        this.m_model.setColWidth(new int[]{500, 80});
        this.m_model.setColHeaderHidden();
        this.m_table = new AppTable(this.m_model);
        this.m_model1 = new AppTableModel(this.m_rowTitle1, this.m_colTitle1, this.m_corner1){

            @Override
            public Object getValueAt(int row, int col) {
                return (JPanel)P2011SubscriberImport.this.m_components1.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        this.m_model1.setRowWidth(new int[]{120});
        this.m_model1.setColWidth(new int[]{280});
        this.m_model1.setColHeaderHidden();
        this.m_table1 = new AppTable(this.m_model1);
        this.m_table1.setRowHeight(0, 100);
        this.m_table.setPreferredSize(new Dimension(600, 40));
        this.m_contentPane.add((Component)this.m_table, "North");
        this.m_contentPane.add((Component)this.m_table1, "Center");
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("Submit")) {
            boolean bol = false;
            int index = 0;
            int i2 = 0;
            while (i2 < this.m_rdSelect.length) {
                if (this.m_rdSelect[i2].isSelected()) {
                    bol = true;
                    index = i2 + 1;
                    break;
                }
                ++i2;
            }
            if (!bol) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Please select the Blocks"));
                return;
            }
            if (this.m_selFile == null || ((AppTextBox)this.m_components.get(0)).getText().equals("")) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Please import text file"));
                return;
            }
            if (this.m_selFile.getName().toUpperCase().indexOf(".TXT") <= -1) {
                JOptionPane.showMessageDialog(null, String.valueOf(AppLang.getText("Error")) + "!! " + AppLang.getText("File Type Is Not") + " !!", AppLang.getText("Error"), 0);
                return;
            }
            if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 2) {
                this.m_ftp.setServerIP(AppNetwork.m_address_SVMi20i);
                this.m_ftp.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
            }
            this.m_ftp.connect("admin", "samsung");
            bol = this.m_ftp.putFile(this.m_selFile.getPath(), "/tmp/" + this.m_selFile.getName());
            this.m_ftp.disConnect();
            if (index == 3) {
                index = 4;
            } else if (index == 4) {
                index = 3;
            }
            if (bol) {
                byte[] reqData = new byte[66];
                reqData[0] = (byte)index;
                reqData[1] = (byte)(this.m_cbVM.getSelectedIndex() + 1);
                AppFunctions.str2byte(reqData, 2, 64, "/tmp/" + this.m_selFile.getName());
                this.m_recvData.clear();
                AppRequestInfo reqInfo = new AppRequestInfo(this.m_pageInfo.getMsgId());
                reqInfo.setDownMsgType((byte)-55);
                reqInfo.setReqData(reqData);
                bol = AppComm.getInstance().requestDownload(reqInfo.getPageInfo());
                if (bol) {
                    this.m_recvData = reqInfo.getRecvData();
                    ArrayList alData = (ArrayList)this.m_recvData.get(0);
                    if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 2) {
                        this.m_ftp.setServerIP(AppNetwork.m_address_SVMi20i);
                        this.m_ftp.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
                    }
                    this.m_ftp.connect("admin", "samsung");
                    ArrayList data = this.m_ftp.getFileContents((String)alData.get(0));
                    this.m_ftp.disConnect();
                    if (data != null && data.size() > 0) {
                        new ImportDataDlg(data, reqData);
                    }
                }
            }
        } else {
            this.actionPageToolButton(command);
        }
    }

    @Override
    public void createPage() {
    }

    public class ImportDataDlg
    extends JDialog
    implements ActionListener {
        private JButton m_btnOk;
        private JButton m_btnCancel;
        private JTextArea m_taTop;
        private JTextArea m_taData;
        private JScrollPane scrollPane;
        private byte[] m_reqData;
        private AppLayout layout;

        public ImportDataDlg(ArrayList data, byte[] reqData) {
            super(AppGlobal.g_frmMain, AppLang.getText("Subscriber Import"), true);
            this.m_btnOk = new JButton("OK");
            this.m_btnCancel = new JButton("Cancel");
            this.m_taTop = null;
            this.m_taData = null;
            this.scrollPane = new JScrollPane();
            this.m_reqData = null;
            this.layout = null;
            AppGlobal.g_dialogList.add(this);
            this.m_reqData = reqData;
            this.setInit(data);
            JPanel m_btnPan = new JPanel(new FlowLayout());
            m_btnPan.add(this.m_btnOk);
            m_btnPan.add(this.m_btnCancel);
            this.layout.addComponent(this.m_taTop, 5, 5, 435, 38);
            this.layout.addComponent(this.scrollPane, 5, 53, 435, 155);
            this.layout.addComponent(m_btnPan, 5, 213, 435, 35);
            this.setVisible(true);
        }

        private void setInit(ArrayList data) {
            this.setSize(450, 280);
            this.setResizable(false);
            this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    ImportDataDlg.this.dispose();
                    if (AppGlobal.g_dialogList.size() > 0) {
                        AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                    }
                }
            });
            this.layout = new AppLayout(this.getContentPane(), this.getWidth(), this.getHeight());
            AppGlobal.fixSize(this.m_btnOk, new Dimension(80, 22));
            AppGlobal.fixSize(this.m_btnCancel, new Dimension(80, 22));
            this.m_btnOk.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_btnOk.setActionCommand("Ok");
            this.m_btnCancel.setActionCommand("Cancel");
            this.m_taTop = new JTextArea();
            this.m_taTop.setText(" " + AppLang.getText("Scroll through the list below, If it is correct, press OK to continue.") + "\n" + " " + AppLang.getText("Otherwise, press CANCEL the import procedure"));
            this.m_taTop.setBorder(BorderFactory.createLineBorder(Color.BLUE));
            this.m_taTop.setEditable(false);
            this.m_taTop.setBackground(new Color(238, 238, 238));
            this.m_taData = new JTextArea();
            this.m_taData.setEditable(false);
            String content = "";
            int i2 = 0;
            while (i2 < data.size()) {
                content = String.valueOf(content) + " " + data.get(i2) + "\n";
                ++i2;
            }
            this.m_taData.setText(content);
            this.scrollPane.getViewport().add((Component)this.m_taData, null);
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String cmd = e2.getActionCommand();
            if (cmd.equals("Ok")) {
                P2011SubscriberImport.this.m_recvData.clear();
                AppRequestInfo reqInfo = new AppRequestInfo("7F06");
                reqInfo.getPageInfo().setMsgId("2011");
                reqInfo.setReqData(this.m_reqData);
                reqInfo.setDownMsgType((byte)-62);
                boolean bol = AppComm.getInstance().requestDownload(reqInfo.getPageInfo());
                if (bol) {
                    P2011SubscriberImport.this.m_recvData = reqInfo.getRecvData();
                    ArrayList alData = (ArrayList)P2011SubscriberImport.this.m_recvData.get(0);
                    JOptionPane.showMessageDialog(null, "Successfully imported [" + alData.get(1) + "] out of [" + alData.get(0) + "] subscribers.");
                    P2011SubscriberImport.this.actionPageToolButton("Reload");
                }
            }
            this.dispose();
            if (AppGlobal.g_dialogList.size() > 0) {
                AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
            }
        }
    }
}

