/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.common.SecurityUtil;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.main.view.AppCardPane;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.main.view.AppMenuBar;
import com.sec.osdm.main.view.AppPagePane;
import com.sec.osdm.main.view.AppSearchPane;
import com.sec.osdm.main.view.AppStatusBar;
import com.sec.osdm.main.view.AppToolBar;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.main.view.AppTreePane;
import com.sec.osdm.pages.AppPageInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class AppMain
extends JFrame {
    public AppMenuBar m_menuBar = null;
    public AppToolBar m_toolBar = null;
    public AppTreePane m_treePane = null;
    public AppCardPane m_cardPane = null;
    public AppSearchPane m_searchPane = null;
    public AppPagePane m_pagePane = null;
    public AppStatusBar m_statusBar = null;
    private JTabbedPane m_treeTab = new JTabbedPane();

    public AppMain() {
        String sJavaVersion = System.getProperties().getProperty("java.version");
        this.setTitle("OfficeServ Device Manager");
        this.setIconImage(AppImages.Img_Logo);
        AppProperty.setProperties();
        this.setMainWindow();
        try {
            byte[] encrypted = SecurityUtil.getCryptoAESByte("");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void setMainWindow() {
        this.createMenuBar();
        this.createToolBar();
        this.createCenterPane();
        this.createStatusBar();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppMain.this.exitProgram();
            }
        });
    }

    private void createMenuBar() {
        this.m_menuBar = new AppMenuBar();
        this.setJMenuBar(this.m_menuBar);
    }

    private void createToolBar() {
        JPanel panMain = new JPanel(new BorderLayout());
        JPanel panTop = new JPanel(new BorderLayout());
        JPanel panTopL = AppImages.getImage(AppImages.Img_Top_L1);
        JPanel panTopC = AppImages.getImage(AppImages.Img_Top_C, AppGlobal.g_maxWidth, AppImages.Img_Top_C.getIconHeight());
        JPanel panTopR = AppImages.getImage(AppImages.Img_Top_R);
        panTopL.setPreferredSize(new Dimension(AppImages.Img_Top_L1.getIconWidth(), AppImages.Img_Top_L1.getIconHeight()));
        panTopR.setPreferredSize(new Dimension(AppImages.Img_Top_R.getIconWidth(), AppImages.Img_Top_C.getIconHeight()));
        panTop.add((Component)panTopL, "West");
        panTop.add((Component)panTopC, "Center");
        panTop.add((Component)panTopR, "East");
        this.m_toolBar = new AppToolBar();
        panMain.add((Component)this.m_toolBar, "North");
        panMain.add((Component)panTop, "Center");
        this.getContentPane().add((Component)panMain, "First");
        this.m_toolBar.setVisible((Boolean)AppProperty.m_properties.get("USE_TOOLBAR"));
    }

    private void createCenterPane() {
        this.setTreePane();
        this.m_pagePane = new AppPagePane();
        JSplitPane panSplit = new JSplitPane(1);
        panSplit.setLeftComponent(this.m_treeTab);
        panSplit.setRightComponent(this.m_pagePane);
        panSplit.setOneTouchExpandable(true);
        panSplit.setDividerLocation(270);
        panSplit.getLeftComponent().setMinimumSize(new Dimension(270, 0));
        this.getContentPane().add((Component)panSplit, "Center");
    }

    public void setAppRunMode(int mode) {
        AppRunInfo.setRunMode(mode);
        switch (mode) {
            case 0: {
                AppMenuActions.enableOnLineModeActs(false);
                AppMenuActions.enableOffLineModeActs(false);
                AppMenuActions.enableNormalModeActs(true);
                break;
            }
            case 2: {
                AppMenuActions.enableOffLineModeActs(false);
                AppMenuActions.enableNormalModeActs(false);
                AppMenuActions.enableOnLineModeActs(true);
                break;
            }
            case 1: {
                AppMenuActions.enableNormalModeActs(false);
                AppMenuActions.enableOnLineModeActs(false);
                AppMenuActions.enableOffLineModeActs(true);
            }
        }
        this.setTreePane();
        this.m_statusBar.setStatusBar();
    }

    public void setTreePane() {
        if (this.m_treePane != null) {
            this.m_treeTab.removeAll();
        }
        if (AppRunInfo.getRunMode() == 0) {
            this.m_treePane = null;
            this.m_cardPane = null;
            this.m_searchPane = null;
        } else {
            this.m_treePane = new AppTreePane();
            this.m_cardPane = new AppCardPane();
            this.m_searchPane = new AppSearchPane();
            this.m_treeTab.add((Component)this.m_treePane.createTreeNodes(), 0);
            this.m_treeTab.add((Component)this.m_cardPane, 1);
            this.m_treeTab.add((Component)this.m_searchPane, 2);
            this.m_treeTab.setTitleAt(0, AppLang.getText("Port Base"));
            this.m_treeTab.setTitleAt(1, AppLang.getText("Card Base"));
            this.m_treeTab.setTitleAt(2, AppLang.getText("Page Search"));
            this.m_treeTab.setSelectedIndex(2);
            this.m_treeTab.setSelectedIndex(1);
            this.m_treeTab.setSelectedIndex(0);
            this.m_searchPane.setMMCList();
            this.m_treeTab.repaint();
        }
    }

    private void createStatusBar() {
        this.m_statusBar = new AppStatusBar();
        this.getContentPane().add((Component)this.m_statusBar, "Last");
    }

    public static void main(String[] args) {
        boolean bol = AppProperty.createFileForWebStart(args.length);
        AppGlobal.g_frmMain = new AppMain();
        AppGlobal.setUIManager();
        if (args.length == 2) {
            AppMain.getFileForWebStart(args[0], false);
        } else if (args.length == 3) {
            if (args[2].equals("vxworks")) {
                AppMain.getFileForWebStart(args[0], true);
            } else {
                AppMain.getFileForWebStart(args[0], false);
            }
        }
        AppGlobal.g_frmMain.setAppRunMode(0);
        AppGlobal.g_frmMain.setDefaultCloseOperation(0);
        AppGlobal.g_frmMain.setVisible(true);
        AppGlobal.g_frmMain.setSize(850, 650);
        if (args.length > 1) {
            Hashtable siteList = null;
            siteList = (Hashtable)AppProperty.m_sitelist.get(0);
            ArrayList<String> siteData = new ArrayList<String>();
            String[] ipAddr = args[0].split(":");
            siteData.add(0, ipAddr[0]);
            siteData.add(1, "5090");
            siteData.add(2, "5003");
            siteList.put("Default", siteData);
            AppProperty.m_sitelist.set(0, siteList);
            AppProperty.saveDataToFile(AppProperty.m_fileSiteList, AppProperty.m_sitelist);
            AppMain.autoConnect(ipAddr[0]);
        }
    }

    private static void getFileForWebStart(String ipAddr, boolean isVxworks) {
        String sExeUrl;
        String sHelpUrl;
        String[] paths = new String[]{String.valueOf(AppProperty.m_runDirectory) + "osdmhelp.jar", String.valueOf(AppProperty.m_runDirectory) + "AccessDB.exe"};
        File file = null;
        int i2 = 0;
        while (i2 < paths.length) {
            file = new File(paths[i2]);
            if (file.exists()) {
                file.delete();
            }
            ++i2;
        }
        if (isVxworks) {
            sHelpUrl = "http://" + ipAddr + "/card/osdmhelp.jar";
            sExeUrl = "http://" + ipAddr + "/card/AccessDB.exe";
        } else {
            sHelpUrl = "https://" + ipAddr + "/osdmhelp.jar";
            sExeUrl = "https://" + ipAddr + "/AccessDB.exe";
        }
        try {
            AppMain.downloadFile(sHelpUrl, paths[0]);
            AppMain.downloadFile(sExeUrl, paths[1]);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static boolean downloadFile(String serverFile, String localFile) throws IOException {
        URL url = new URL(serverFile);
        URLConnection urlc = url.openConnection();
        int i2 = 0;
        byte[] bytesIn = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(urlc.getInputStream());
        FileOutputStream out = new FileOutputStream(localFile);
        while ((i2 = in.read(bytesIn)) >= 0) {
            out.write(bytesIn, 0, i2);
        }
        out.close();
        return true;
    }

    private static void runIVMProgram(String link) {
        AppPageInfo pageInfo = new AppPageInfo((AppTreeNode)AppProperty.m_allMmcList.get("0000"));
        String szPassword = null;
        byte[] m_reqData = new byte[9];
        Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        String[] addr = link.split(":");
        linkInfo.put("IP_ADDRESS", addr[0]);
        AppProperty.m_properties.put("LINK_INFO", linkInfo);
        AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
        AppComm.getInstance().setComm(AppNetwork.getInstance());
        while (true) {
            if ((szPassword = JOptionPane.showInputDialog(null, AppLang.getText("Input your passcode."), AppLang.getText("Login"), 3)) == null) {
                System.exit(0);
            }
            if (szPassword.length() > 8) {
                AppGlobal.showWarnMessage("", AppLang.getText("Passcord is less than 8 digits."));
                continue;
            }
            AppFunctions.str2byte(m_reqData, 0, 8, szPassword.trim());
            pageInfo.setReqData(m_reqData);
            if (AppComm.getInstance().requestDownload(pageInfo)) break;
        }
    }

    public void exitProgram() {
        if (AppGlobal.showConfirmMessage(AppLang.getText("Exit"), AppLang.getText("Do you really want to exit the application?")) == 1) {
            return;
        }
        if (AppRunInfo.getRunMode() == 2) {
            AppMenuActions.s_actDisconnect.actionPerformed(null);
        }
        if (AppGlobal.g_helpProcess != null) {
            AppGlobal.g_helpProcess.destroy();
        } else if (AppGlobal.g_dataProcess != null) {
            AppGlobal.g_dataProcess.destroy();
        } else if (AppGlobal.g_accessProcess != null) {
            AppGlobal.g_accessProcess.destroy();
        }
        System.exit(0);
    }

    public static void autoConnect(String ipAddr) {
        Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        linkInfo.put("LINK_KIND", "LAN");
        linkInfo.put("SITE_NAME", "Default");
        linkInfo.put("IP_ADDRESS", ipAddr);
        linkInfo.put("DATA_PORT", "5090");
        linkInfo.put("FILE_PORT", "5003");
        linkInfo.put("FTP_PORT", "21");
        linkInfo.put("VM_PORT", "6001");
        linkInfo.put("TEL_NUMBER", "");
        linkInfo.put("COM_PORT", "1");
        linkInfo.put("BAUD_RATE", "38400");
        AppProperty.m_properties.put("LINK_INFO", linkInfo);
        AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
        AppMenuActions.s_actConnect.actionPerformed(null);
    }
}

