/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppSelect;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class AppImport
extends AppDialog {
    private final int SIZE_WIDTH = 800;
    private final int SIZE_HEIGHT = 610;
    private AppTable m_table1 = null;
    private AppTableModel m_model1 = null;
    private ArrayList m_components1 = new ArrayList();
    private AppTextBox m_compText = null;
    private AppComboBox m_compCombo = null;
    private String[] m_mmcList = new String[]{"2402", "2403", "2601", "3203", "3205", "3206", "4400", "4502", "4503", "5F06", "5F07"};
    private JLabel m_file = new JLabel();
    private JComboBox m_cbSheet = new JComboBox();
    private JComboBox m_cbFeature = new JComboBox();
    private Workbook m_workBook = null;

    public AppImport() {
        this.m_layout = new AppLayout(this.m_contentPane, 800, 610);
        this.createComponents();
        this.createFunctionTable();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppImport.this.openDialog("DB Import", 800, 610);
            }
        });
    }

    private void createComponents() {
        String[] btTitle = new String[]{"File", "Get", "Import", "Close"};
        JButton[] buttons = new JButton[4];
        this.m_file.setBorder(new LineBorder(Color.darkGray));
        int i2 = 0;
        while (i2 < buttons.length) {
            buttons[i2] = new JButton(AppLang.getText(btTitle[i2]));
            buttons[i2].setActionCommand(btTitle[i2]);
            buttons[i2].setFont(new Font("SansSerif", 0, 12));
            buttons[i2].setMargin(new Insets(0, 0, 0, 0));
            buttons[i2].addActionListener(this);
            ++i2;
        }
        this.m_cbSheet.addItemListener(this);
        i2 = 0;
        while (i2 < this.m_mmcList.length) {
            this.m_cbFeature.addItem(AppLang.getText(((AppTreeNode)AppProperty.m_allMmcList.get(this.m_mmcList[i2])).getTabTitle()));
            ++i2;
        }
        this.m_cbFeature.addItemListener(this);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Import File"), 4), 5, 5, 75, 20);
        this.m_layout.addComponent(this.m_file, 83, 5, 565, 20);
        this.m_layout.addComponent(buttons[0], 653, 5, 50, 20);
        this.m_layout.addComponent(buttons[3], 719, 5, 70, 20);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Sheet"), 4), 5, 30, 75, 20);
        this.m_layout.addComponent(this.m_cbSheet, 83, 30, 235, 20);
        this.m_layout.addComponent(buttons[1], 320, 30, 50, 20);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Feature"), 4), 390, 30, 60, 20);
        this.m_layout.addComponent(this.m_cbFeature, 453, 30, 250, 20);
        this.m_layout.addComponent(buttons[2], 719, 30, 70, 20);
    }

    private void createFunctionTable() {
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.getColTitle();
        int i2 = 0;
        while (i2 < this.m_colTitle[0].length) {
            if (i2 == 0) {
                this.m_compText = new AppTextBox(9, 9999);
                this.m_components.add(i2, this.m_compText);
            } else {
                this.m_compCombo = new AppComboBox();
                this.m_components.add(i2, this.m_compCombo);
            }
            ++i2;
        }
        this.m_model = new AppTableModel(new String[][]{{"Column"}}, this.m_colTitle, new String[][]{{"Item"}}){

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return (AppTextBox)AppImport.this.m_components.get(col);
                }
                return (AppComboBox)AppImport.this.m_components.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        this.m_model.setRowWidth(new int[]{80});
        int[] colWidth = new int[this.m_model.getColHdrColCount()];
        int i3 = 0;
        while (i3 < colWidth.length) {
            colWidth[i3] = 80;
            ++i3;
        }
        this.m_model.setColWidth(colWidth);
        this.m_table = new AppTable(this.m_model, 2);
        this.m_layout.addComponent(this.m_table, 5, 55, 785, 60);
    }

    private void createSheetTable() {
        if (this.m_table1 != null) {
            this.m_contentPane.remove(this.m_table1);
            this.m_model1 = null;
            this.m_table1 = null;
        }
        Sheet sheet = this.m_workBook.getSheet(this.m_cbSheet.getSelectedIndex());
        Object[][] colTitle = new String[1][sheet.getColumns()];
        Object[][] rowTitle = new String[sheet.getRows()][1];
        int i2 = 0;
        while (i2 < colTitle[0].length) {
            int first = i2 / 26;
            int second = i2 % 26;
            if (first > 0) {
                colTitle[0][i2] = String.valueOf((char)(first + 64));
                String[] stringArray = colTitle[0];
                int n2 = i2;
                stringArray[n2] = String.valueOf(stringArray[n2]) + String.valueOf((char)(second + 65));
            } else {
                colTitle[0][i2] = String.valueOf((char)(second + 65));
            }
            ++i2;
        }
        AppComboBox compCombo = null;
        int i3 = 1;
        while (i3 < this.m_model.getColHdrColCount()) {
            compCombo = (AppComboBox)this.m_model.getValueAt(0, i3);
            compCombo.removeAllItems();
            compCombo.addItems(colTitle[0], null);
            compCombo.addItem(" ");
            compCombo.setSelectedItem(" ");
            ++i3;
        }
        this.m_table.repaint();
        i3 = 0;
        while (i3 < rowTitle.length) {
            rowTitle[i3][0] = "" + (i3 + 1);
            ++i3;
        }
        ArrayList<AppTextBox> compData = null;
        Cell cell = null;
        int i4 = 0;
        while (i4 < rowTitle.length) {
            compData = new ArrayList<AppTextBox>();
            int j2 = 0;
            while (j2 < colTitle[0].length) {
                this.m_compText = new AppTextBox(0, 0);
                cell = sheet.getCell(j2, i4);
                this.m_compText.setText(cell.getContents());
                compData.add(j2, this.m_compText);
                ++j2;
            }
            this.m_components1.add(i4, compData);
            ++i4;
        }
        this.m_model1 = new AppTableModel(rowTitle, colTitle, new String[][]{{""}}){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppImport.this.m_components1.get(row);
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model1.setRowWidth(new int[]{40});
        int[] colWidth = new int[this.m_model1.getColHdrColCount()];
        int i5 = 0;
        while (i5 < colWidth.length) {
            colWidth[i5] = 80;
            ++i5;
        }
        this.m_model1.setColWidth(colWidth);
        this.m_table1 = new AppTable(this.m_model1, 2);
        this.m_layout.addComponent(this.m_table1, 5, 125, 785, 445);
    }

    private void importSheetData() {
        ArrayList saveData = new ArrayList();
        this.m_pageInfo = new AppPageInfo(this.m_mmcList[this.m_cbFeature.getSelectedIndex()]);
        int row = 0;
        if (!((AppTextBox)this.m_model.getValueAt(0, 0)).getText().trim().equals("")) {
            row = Integer.parseInt(((AppTextBox)this.m_model.getValueAt(0, 0)).getText().trim());
            if (this.m_pageInfo.getMsgId().equals("2402")) {
                saveData = this.setImportData2402(row);
            } else if (this.m_pageInfo.getMsgId().equals("2403")) {
                saveData = this.setImportData2403(row);
            } else if (this.m_pageInfo.getMsgId().equals("2601")) {
                saveData = this.setImportData2601(row);
            } else if (this.m_pageInfo.getMsgId().equals("3203")) {
                saveData = this.setImportData3203(row);
            } else if (this.m_pageInfo.getMsgId().equals("3205")) {
                saveData = this.setImportData3205(row);
            } else if (this.m_pageInfo.getMsgId().equals("3206")) {
                saveData = this.setImportData3206(row);
            } else if (this.m_pageInfo.getMsgId().equals("4400")) {
                saveData = this.setImportData4400(row);
            } else if (this.m_pageInfo.getMsgId().equals("4502")) {
                saveData = this.setImportData4502(row);
            } else if (this.m_pageInfo.getMsgId().equals("4503")) {
                saveData = this.setImportData4503(row);
            } else if (this.m_pageInfo.getMsgId().equals("5F06")) {
                saveData = this.setImportData5F06(row);
            } else if (this.m_pageInfo.getMsgId().equals("5F07")) {
                saveData = this.setImportData5F07(row);
            } else {
                return;
            }
            this.m_pageInfo.setSaveData(saveData);
            AppComm.getInstance().requestUpload(this.m_pageInfo);
        }
    }

    private ArrayList setImportData2402(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"65535", "", "0", "65535", "0", "0", "0", "0", "0", "0"};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                rowData.add(j2 - 1, defData[j2 - 1]);
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    if (j2 == 1 || j2 == 2 || j2 == 4 || j2 == 5) {
                        rowData.set(j2 - 1, sValue);
                    } else if (j2 == 3) {
                        if (sValue.toUpperCase().equals("BUSY")) {
                            rowData.set(j2 - 1, "1");
                        }
                    } else if (j2 >= 6 && j2 <= 8) {
                        if (!sValue.toUpperCase().equals("NO")) {
                            rowData.set(j2 - 1, "" + (Integer.parseInt(sValue) + 1));
                        }
                    } else if (sValue.toUpperCase().equals("ON")) {
                        rowData.set(j2 - 1, "1");
                    }
                }
                ++j2;
            }
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData2403(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"65535", "", "", "", "", ""};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                rowData.add(j2 - 1, defData[j2 - 1]);
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    rowData.set(j2 - 1, sValue);
                }
                ++j2;
            }
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData2601(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"65535", "", "0", "", "1", "6", "3"};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                rowData.add(j2 - 1, defData[j2 - 1]);
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    if (j2 == 3) {
                        if (sValue.toUpperCase().equals("PULSE")) {
                            rowData.set(j2 - 1, "1");
                        } else if (sValue.toUpperCase().equals("R2MFC")) {
                            rowData.set(j2 - 1, "2");
                        }
                    } else {
                        rowData.set(j2 - 1, sValue);
                    }
                }
                ++j2;
            }
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData3203(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"0", "255", "0", "", "65535", "65535", "65535", "65535", "65535", "65535", "", "", "", "0", "65535", "0", "0", "0", "255", "255", "255"};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            rowData.add(0, defData[0]);
            rowData.add(1, defData[1]);
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                if (j2 == 1) {
                    rowData.add(2, "" + k2);
                } else {
                    rowData.add(j2 + 1, defData[j2 + 1]);
                }
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    if (j2 >= 1 && j2 <= 11 || j2 == 13) {
                        rowData.set(j2 + 1, sValue);
                    } else if (j2 == 12) {
                        if (sValue.toUpperCase().equals("YES")) {
                            rowData.set(j2 + 1, "1");
                        } else if (sValue.toUpperCase().equals("B")) {
                            rowData.set(j2 + 1, "2");
                        }
                    } else if (!sValue.toUpperCase().equals("NO")) {
                        rowData.set(j2 + 1, "" + (Integer.parseInt(sValue) + 1));
                    }
                }
                ++j2;
            }
            j2 = 18;
            while (j2 < 21) {
                rowData.add(j2, defData[j2]);
                ++j2;
            }
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData3205(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"0", "", "65535", "65535", "65535", "65535", "65535", "65535", "0", "0", "0", "0", "255", "255"};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                if (j2 == 1) {
                    rowData.add(0, "" + k2);
                } else {
                    rowData.add(j2 - 1, defData[j2 - 1]);
                }
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    if (j2 >= 1 && j2 <= 8) {
                        rowData.set(j2 - 1, sValue);
                    } else if (j2 == 9) {
                        if (sValue.toUpperCase().equals("YES")) {
                            rowData.set(j2 - 1, "1");
                        }
                    } else if (!sValue.toUpperCase().equals("NO")) {
                        rowData.set(j2 - 1, "" + (Integer.parseInt(sValue) + 1));
                    }
                }
                ++j2;
            }
            rowData.add(12, defData[12]);
            rowData.add(13, defData[13]);
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData3206(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"0", "", ""};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                if (j2 == 1) {
                    rowData.add(0, "" + k2);
                } else {
                    rowData.add(j2 - 1, defData[j2 - 1]);
                }
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    rowData.set(j2 - 1, sValue);
                }
                ++j2;
            }
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData4400(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"65535", "65535", "", "", "255"};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                rowData.add(j2 - 1, defData[j2 - 1]);
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    rowData.set(j2 - 1, sValue);
                }
                ++j2;
            }
            rowData.add(4, defData[4]);
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData4502(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"0", "255", "0", ""};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            rowData.add(0, defData[0]);
            rowData.add(1, defData[1]);
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                if (j2 == 1) {
                    rowData.add(0, "" + k2);
                } else {
                    rowData.add(j2 + 1, defData[j2 + 1]);
                }
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    rowData.set(j2 + 1, sValue);
                }
                ++j2;
            }
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData4503(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"0", "255", "0", "", "0", "255"};
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            rowData.add(0, defData[0]);
            rowData.add(1, defData[1]);
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                if (j2 == 1) {
                    rowData.add(0, "" + k2);
                } else {
                    rowData.add(j2 + 1, defData[j2 + 1]);
                }
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    rowData.set(j2 + 1, sValue);
                }
                ++j2;
            }
            rowData.add(5, defData[5]);
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData5F06(int row) {
        ArrayList saveData = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"65535", "0", "255", "65535", "", "65535", "", "65535", "", "65535", "", "65535"};
        String[] fwdType = AppSelect.getItems(158);
        int i2 = row - 1;
        int k2 = 0;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                int col;
                String sValue;
                rowData.add(j2 - 1, defData[j2 - 1]);
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    if (j2 == 2) {
                        int n2 = 0;
                        while (n2 < fwdType.length) {
                            if (sValue.equals(fwdType[n2])) {
                                rowData.set(j2 - 1, "" + n2);
                                break;
                            }
                            ++n2;
                        }
                    } else {
                        rowData.set(j2 - 1, sValue);
                    }
                }
                ++j2;
            }
            saveData.add(k2, rowData);
            ++i2;
            ++k2;
        }
        return saveData;
    }

    private ArrayList setImportData5F07(int row) {
        ArrayList<ArrayList> saveData = new ArrayList<ArrayList>();
        ArrayList saveData_Tel = new ArrayList();
        ArrayList<String> rowData = null;
        String[] defData = new String[]{"65535", "0", "0", "", "", "", "255"};
        boolean startTel = false;
        int spdCnt = 0;
        int i2 = row - 1;
        while (i2 < this.m_model1.getRowHdrRowCount()) {
            rowData = new ArrayList<String>();
            int col = ((AppComboBox)this.m_model.getValueAt(0, 1)).getSelectedIndex();
            String strTel = ((AppTextBox)this.m_model1.getValueAt(i2, col)).getText().trim();
            String strNextTel = i2 + 1 == this.m_model1.getRowHdrRowCount() ? "" : ((AppTextBox)this.m_model1.getValueAt(i2 + 1, col)).getText().trim();
            int j2 = 0;
            while (j2 < defData.length) {
                rowData.add(j2, defData[j2]);
                ++j2;
            }
            j2 = 1;
            while (j2 < this.m_model.getColHdrColCount()) {
                String sValue;
                if (!((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedItem().trim().equals("") && !(sValue = ((AppTextBox)this.m_model1.getValueAt(i2, col = ((AppComboBox)this.m_model.getValueAt(0, j2)).getSelectedIndex())).getText().trim()).equals("")) {
                    if (j2 == 2) {
                        rowData.set(2, sValue);
                    } else if (j2 == 3) {
                        rowData.set(5, sValue);
                    } else if (j2 == 4) {
                        rowData.set(3, sValue);
                    } else if (j2 == 5) {
                        rowData.set(4, sValue);
                    }
                }
                ++j2;
            }
            rowData.set(0, strTel);
            saveData_Tel.add(spdCnt, rowData);
            if (strTel.equals(strNextTel)) {
                ++spdCnt;
            } else {
                int start_row = saveData.size();
                int z2 = 0;
                while (z2 < saveData_Tel.size()) {
                    ArrayList rowData_Tel = (ArrayList)saveData_Tel.get(z2);
                    rowData_Tel.set(1, "" + spdCnt);
                    saveData.add(start_row + z2, rowData_Tel);
                    ++z2;
                }
                saveData_Tel = new ArrayList();
                spdCnt = 0;
            }
            ++i2;
        }
        return saveData;
    }

    private void openExcelFile() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("Excel File")) + "(*.xls)", "xls");
        if (browser.openBrowser()) {
            this.m_cbSheet.removeAllItems();
            File fd = new File(browser.getFilePath());
            try {
                this.m_workBook = Workbook.getWorkbook(fd);
                String[] items = this.m_workBook.getSheetNames();
                int i2 = 0;
                while (i2 < items.length) {
                    this.m_cbSheet.addItem(items[i2]);
                    ++i2;
                }
                this.m_file.setText(browser.getFilePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void getColTitle() {
        String msgId = this.m_mmcList[this.m_cbFeature.getSelectedIndex()];
        this.m_pageInfo = new AppPageInfo(msgId);
        this.m_page.setPageInfo(this.m_pageInfo);
        this.m_page.setTableTitle();
        if (msgId.equals("5F07")) {
            this.m_colTitle = new String[1][6];
            this.m_colTitle[0][0] = "Start Row";
            this.m_colTitle[0][1] = "Tel Number";
            this.m_colTitle[0][2] = "Speed No";
            this.m_colTitle[0][3] = "Speed Name";
            this.m_colTitle[0][4] = "Trunk No";
            this.m_colTitle[0][5] = "Outgoing Digits";
        } else {
            this.m_colTitle = new String[1][this.m_page.m_colTitle[0].length + 2];
            this.m_colTitle[0][0] = "Start Row";
            this.m_colTitle[0][1] = msgId.equals("4400") ? "Speed No" : (msgId.equals("2402") || msgId.equals("2403") || msgId.equals("2601") || msgId.equals("5F06") || msgId.equals("5F07") ? "Tel Number" : "Entry No");
            if (this.m_page.m_colTitle.length == 1) {
                System.arraycopy(this.m_page.m_colTitle[0], 0, this.m_colTitle[0], 2, this.m_page.m_colTitle[0].length);
            } else {
                String sTitle = "";
                int i2 = 0;
                while (i2 < this.m_page.m_colTitle[0].length) {
                    sTitle = this.m_page.m_colTitle[0][i2].equals("") ? sTitle : this.m_page.m_colTitle[0][i2];
                    this.m_colTitle[0][i2 + 2] = this.m_page.m_colTitle[1][i2].equals("") ? sTitle : String.valueOf(sTitle) + " " + this.m_page.m_colTitle[1][i2];
                    ++i2;
                }
            }
        }
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("File")) {
            this.openExcelFile();
        } else if (command.equals("Get")) {
            if (this.m_workBook != null && !this.m_file.getText().trim().equals("") && this.m_cbSheet.getSelectedIndex() >= 0) {
                ExecuteImport m_import = new ExecuteImport(0);
                m_import.start();
            }
        } else if (command.equals("Import")) {
            if (this.m_workBook != null && !this.m_file.getText().trim().equals("") && this.m_cbSheet.getSelectedIndex() >= 0) {
                ExecuteImport m_import = new ExecuteImport(1);
                m_import.start();
            }
        } else if (command.equals("Close")) {
            this.closeDialog();
        }
    }

    @Override
    public void runItemChangeEvent(ItemEvent ie) {
        if (this.m_table1 != null) {
            this.m_contentPane.remove(this.m_table1);
            this.m_model1 = null;
            this.m_table1 = null;
        }
        if (this.m_table != null) {
            ((AppTextBox)this.m_model.getValueAt(0, 0)).setText("");
            int i2 = 1;
            while (i2 < this.m_model.getColHdrColCount()) {
                ((AppComboBox)this.m_model.getValueAt(0, i2)).removeAllItems();
                ++i2;
            }
        }
        this.m_contentPane.repaint();
        if (ie.getSource() == this.m_cbFeature) {
            this.createFunctionTable();
        }
    }

    class ExecuteImport
    extends Thread {
        private int m_mode = 0;

        public ExecuteImport(int mode) {
            this.m_mode = mode;
        }

        @Override
        public void run() {
            AppGlobal.showProgress(AppLang.getText("Import data from excel file..."), (String)AppImport.this.m_cbFeature.getSelectedItem());
            if (this.m_mode == 0) {
                AppImport.this.createSheetTable();
            } else {
                AppImport.this.importSheetData();
            }
            AppGlobal.hideProgress();
        }
    }
}

