/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.utils.AppDialog;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class AppNewConvert
extends AppDialog {
    private final int SIZE_WIDTH = 720;
    private final int SIZE_HEIGHT = 270;
    private JLabel[] m_lbData = new JLabel[7];
    private String[] m_lbTitles = new String[]{"", "Kind", "", "Version", "", "", "Version"};
    private JComboBox m_cbVersion = new JComboBox();
    private Socket m_sock = null;
    private OutputStream m_os = null;
    private ArrayList m_tableList = new ArrayList();
    private Hashtable m_recvData = new Hashtable();
    private Hashtable m_readData = null;
    private String m_source = "";
    private String m_target = "";
    private boolean m_isDbOsdm = true;

    public AppNewConvert() {
        this.m_layout = new AppLayout(this.m_contentPane, 720, 270);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppNewConvert.this.openDialog("DB Conversion", 720, 270);
            }
        });
    }

    private void createComponents() {
        JPanel panSource = new JPanel();
        JPanel panTarget = new JPanel();
        AppLayout layout1 = new AppLayout(panSource, 700, 100);
        AppLayout layout2 = new AppLayout(panTarget, 700, 100);
        String[] titles = new String[]{"...", "...", AppLang.getText("Start"), AppLang.getText("Close")};
        String[] command = new String[]{"File1", "File2", "Start", "Close"};
        JButton[] buttons = new JButton[4];
        panSource.setBorder(new TitledBorder(new LineBorder(Color.darkGray), AppLang.getText("Source File")));
        panTarget.setBorder(new TitledBorder(new LineBorder(Color.darkGray), AppLang.getText("Target File")));
        int i2 = 0;
        while (i2 < 4) {
            buttons[i2] = new JButton(titles[i2]);
            buttons[i2].setActionCommand(command[i2]);
            buttons[i2].addActionListener(this);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_lbData.length) {
            this.m_lbData[i2] = new JLabel(AppLang.getText(this.m_lbTitles[i2]));
            ++i2;
        }
        this.m_lbData[1].setHorizontalAlignment(4);
        this.m_lbData[2].setHorizontalAlignment(0);
        this.m_lbData[3].setHorizontalAlignment(4);
        this.m_lbData[4].setHorizontalAlignment(0);
        this.m_lbData[6].setHorizontalAlignment(4);
        this.m_lbData[0].setBorder(new LineBorder(Color.darkGray));
        this.m_lbData[2].setBorder(new LineBorder(Color.darkGray));
        this.m_lbData[4].setBorder(new LineBorder(Color.darkGray));
        this.m_lbData[5].setBorder(new LineBorder(Color.darkGray));
        layout1.addComponent(this.m_lbData[0], 5, 30, 660, 20);
        layout1.addComponent(buttons[0], 670, 30, 30, 20);
        layout1.addComponent(this.m_lbData[1], 5, 60, 80, 20);
        layout1.addComponent(this.m_lbData[2], 90, 60, 150, 20);
        layout1.addComponent(this.m_lbData[3], 260, 60, 80, 20);
        layout1.addComponent(this.m_lbData[4], 345, 60, 150, 20);
        layout2.addComponent(this.m_lbData[5], 5, 30, 660, 20);
        layout2.addComponent(buttons[1], 670, 30, 30, 20);
        layout2.addComponent(this.m_lbData[6], 5, 60, 80, 20);
        layout2.addComponent(this.m_cbVersion, 90, 60, 150, 20);
        this.m_layout.addComponent(panSource, 5, 10, 705, 90);
        this.m_layout.addComponent(panTarget, 5, 120, 705, 90);
        this.m_layout.addComponent(buttons[2], 555, 213, 70, 20);
        this.m_layout.addComponent(buttons[3], 638, 213, 70, 20);
    }

    private void openBackupDatabase() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("Backup Database")) + "(*.IUD;*.odm)", "IUD", "odm");
        if (browser.openBrowser()) {
            this.m_source = browser.getFilePath();
            boolean bl2 = this.m_isDbOsdm = this.m_source.indexOf("IUD") < 0;
            if (this.m_isDbOsdm) {
                if (browser.checkDatabaseFile()) {
                    this.m_readData = browser.getDatabase();
                    if (this.checkPassword()) {
                        AppRunInfo.setLinkData((byte[])this.m_readData.get("0000"));
                        this.m_lbData[0].setText(this.m_source);
                        this.m_lbData[2].setText("OSDM Database");
                        this.m_lbData[4].setText(AppRunInfo.getSysVersion());
                    }
                }
            } else {
                if (AppGlobal.g_accessProcess != null) {
                    this.disconnect();
                }
                if (this.connect()) {
                    this.m_lbData[0].setText(this.m_source);
                    this.m_lbData[2].setText("Installation Database");
                }
            }
        }
    }

    private void createDatabase() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("OSDM File")) + "(*.odm)", "odm");
        if (browser.saveBrowserWithExtender("odm")) {
            this.m_target = browser.getFilePath();
            this.m_lbData[5].setText(this.m_target);
        }
    }

    private boolean connect() {
        try {
            File file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "AccessDB.exe");
            String path = file.exists() ? String.valueOf(System.getProperty("user.dir")) + File.separator + "AccessDB.exe " + this.m_source : String.valueOf(AppProperty.m_runDirectory) + "AccessDB.exe " + this.m_source;
            AppGlobal.g_accessProcess = Runtime.getRuntime().exec(path);
            this.m_sock = new Socket("127.0.0.1", 9000);
            this.m_os = this.m_sock.getOutputStream();
            this.m_recvData.clear();
            return this.checkPassword();
        }
        catch (Exception e2) {
            AppGlobal.hideProgress();
            return false;
        }
    }

    private boolean checkPassword() {
        String m_password;
        byte[] reqData = new byte[52];
        byte[] recv = null;
        reqData[0] = -45;
        reqData[1] = 50;
        while ((m_password = JOptionPane.showInputDialog(AppLang.getText("Input the password of Installation DB."))) != null && !m_password.trim().equals("")) {
            if (this.m_isDbOsdm) {
                recv = (byte[])this.m_readData.get("0001");
                if (m_password.equals(AppFunctions.byte2str(recv, 0, 50))) {
                    return true;
                }
            } else {
                AppFunctions.str2byte(reqData, 2, 50, m_password);
                if (this.sendData(reqData) && (recv = this.recvData()) != null && recv[0] == 1) {
                    byte[] password = new byte[50];
                    AppFunctions.str2byte(password, 0, 50, m_password);
                    this.m_recvData.put("0001", password);
                    return true;
                }
            }
            AppGlobal.showErrorMessage("", AppLang.getText("Inputted password is wrong. Again input the password."));
        }
        return false;
    }

    private void startConversion() {
    }

    private void getTableList() {
        byte[] reqData = new byte[2];
        byte[] temp = null;
        this.m_tableList.clear();
        temp = new byte[]{0, 0};
        this.m_tableList.add(0, temp);
        try {
            byte[] recv;
            reqData[0] = -47;
            reqData[1] = 0;
            if (this.sendData(reqData) && (recv = this.recvData()) != null) {
                int i2 = 0;
                while (i2 < recv.length) {
                    temp = new byte[2];
                    System.arraycopy(recv, i2, temp, 0, 2);
                    this.m_tableList.add(this.m_tableList.size(), temp);
                    i2 += 2;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void getTableData() {
        byte[] reqData = new byte[4];
        byte[] temp = null;
        String msgId = "";
        try {
            int i2 = 0;
            while (i2 < this.m_tableList.size()) {
                byte[] recv;
                temp = (byte[])this.m_tableList.get(i2);
                msgId = AppFunctions.unsignedValue(AppFunctions.byte2short(temp, 0));
                reqData[0] = -46;
                reqData[1] = 2;
                System.arraycopy(temp, 0, reqData, 2, 2);
                if (this.sendData(reqData) && (recv = this.recvData()) != null) {
                    String key = String.format("%04x", Integer.parseInt(msgId)).toUpperCase();
                    this.m_recvData.put(key, recv);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void disconnect() {
        byte[] reqData = new byte[]{-48, 0};
        this.sendData(reqData);
        try {
            Thread.sleep(1000L);
            this.m_os = null;
            this.m_sock = null;
            AppGlobal.g_accessProcess = null;
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    private boolean sendData(byte[] req) {
        try {
            this.m_os.write(req);
            this.m_os.flush();
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] recvData() {
        byte[] m_bTemp = new byte[2048000];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        int msgLen = -1;
        InputStream is = null;
        try {
            is = this.m_sock.getInputStream();
            do {
                if ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) < 4 || msgLen != -1 || (msgLen = AppFunctions.byte2int(m_bTemp, 0)) != 0) continue;
                return null;
            } while (msgLen < 0 || (nOffset += nRead) < msgLen + 4);
            m_bData = new byte[msgLen];
            System.arraycopy(m_bTemp, 4, m_bData, 0, msgLen);
            return m_bData;
        }
        catch (IOException e2) {
            return null;
        }
    }

    @Override
    public void closeDialog() {
        if (AppGlobal.g_accessProcess != null) {
            this.disconnect();
        }
        this.dispose();
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Start")) {
            if (this.m_lbData[0].getText().trim().equals("") || this.m_lbData[5].getText().trim().equals("")) {
                return;
            }
            if (!this.m_isDbOsdm) {
                this.getTableList();
                this.getTableData();
                this.disconnect();
            }
            this.startConversion();
        } else if (command.equals("File1")) {
            this.m_lbData[0].setText("");
            this.m_lbData[2].setText("");
            this.m_lbData[4].setText("");
            this.m_cbVersion.removeAll();
            this.openBackupDatabase();
        } else if (command.equals("File2")) {
            this.m_lbData[5].setText("");
            this.createDatabase();
        } else if (command.equals("Close")) {
            this.closeDialog();
        }
    }
}

