/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa.openblock;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.vmaa.openblock.AppBlockListDetailDlg;
import com.sec.osdm.pages.vmaa.openblock.AppNewBlockDlg;
import com.sec.osdm.pages.vmaa.openblock.IOpenBlock;
import com.sec.osdm.pages.vmaa.openblock.P1001AnnouncementBlock;
import com.sec.osdm.pages.vmaa.openblock.P1004AudiotexLibBlock;
import com.sec.osdm.pages.vmaa.openblock.P1007ByeBlock;
import com.sec.osdm.pages.vmaa.openblock.P1009DialBlock;
import com.sec.osdm.pages.vmaa.openblock.P100DDirectoryBlock;
import com.sec.osdm.pages.vmaa.openblock.P1010DocumentLibBlock;
import com.sec.osdm.pages.vmaa.openblock.P1015EClassBlock;
import com.sec.osdm.pages.vmaa.openblock.P101AExtensionBlock;
import com.sec.osdm.pages.vmaa.openblock.P1021FaxBlock;
import com.sec.osdm.pages.vmaa.openblock.P1024ListBlock;
import com.sec.osdm.pages.vmaa.openblock.P1028MailboxBlock;
import com.sec.osdm.pages.vmaa.openblock.P102EMClassBlock;
import com.sec.osdm.pages.vmaa.openblock.P1032MenuBlock;
import com.sec.osdm.pages.vmaa.openblock.P1035ModeBlock;
import com.sec.osdm.pages.vmaa.openblock.P1038NetworkBlock;
import com.sec.osdm.pages.vmaa.openblock.P103DPortBlock;
import com.sec.osdm.pages.vmaa.openblock.P103FQueryBlock;
import com.sec.osdm.pages.vmaa.openblock.P1043SpeakBlock;
import com.sec.osdm.pages.vmaa.openblock.P1046StationBlock;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AppOpenBlockDlg
extends JDialog
implements ActionListener,
IOpenBlock {
    private AppTable m_table = null;
    private AppTableModel m_model = null;
    private String[][] m_RowNames = null;
    private String[][] m_ColNames = new String[][]{{"No.", "Label Name", "Edit"}};
    public AppOpenBlockDlg m_this = null;
    private ArrayList m_recvData = null;
    private String m_titleName = null;
    private String m_msgId = "";
    private int m_blockIndex = 0;
    private byte m_groupNumber = 0;
    private byte[] m_schduleTbReqData = null;
    private JButton m_btnClose = new JButton(AppLang.getText("Close"));
    private JButton m_btnNew = new JButton(AppLang.getText("New"));
    private JButton m_btnRelod = new JButton(AppLang.getText("Reload"));
    private JButton[] m_btnEdit = null;
    private AppTextBox[] m_tfLabel = null;
    private JLabel[] m_lbNumber = null;
    private JLabel m_lbVmsGroup = new JLabel(AppLang.getText(" VMS Group"));
    private JComboBox m_comboGroup = null;
    private JPanel m_pnVmsGroup = new JPanel(new FlowLayout(0));
    private String[] m_serial = null;
    private String[] m_label = null;
    private String m_blockSerial = "";
    private String m_blockLabelName = "";
    private AppRequestInfo m_reqData = null;
    private AppBlockListDetailDlg m_blockPage = null;
    private OpenBlockDialogTableListener m_tableListener = new OpenBlockDialogTableListener();

    public AppOpenBlockDlg(JDialog dialog, int blockIndex, int groupNumber) {
        super((Dialog)dialog, true);
        AppGlobal.g_dialogList.add(this);
        this.setIconImage(AppImages.Img_Logo);
        this.m_this = this;
        this.m_blockIndex = blockIndex;
        this.m_groupNumber = (byte)groupNumber;
        this.setDialog();
        this.initial();
        this.requestData();
        this.createComponent();
        this.setData();
        this.createTable();
        JPanel btnPan = new JPanel(new FlowLayout());
        btnPan.add(this.m_btnNew);
        btnPan.add(this.m_btnRelod);
        btnPan.add(this.m_btnClose);
        this.setMouseListener();
        if (blockIndex == 6 || blockIndex == 7 || blockIndex == 9 || blockIndex == 10 || blockIndex == 11 || blockIndex == 14) {
            this.m_comboGroup = new JComboBox();
            int i2 = 1;
            while (i2 <= 99) {
                this.m_comboGroup.addItem(String.format("%02d", i2));
                ++i2;
            }
            this.m_comboGroup.setSelectedIndex(groupNumber - 1);
            this.m_pnVmsGroup.add(this.m_lbVmsGroup);
            this.m_pnVmsGroup.add(this.m_comboGroup);
            this.m_comboGroup.setActionCommand("group_change");
            this.m_comboGroup.addActionListener(this);
            this.add((Component)this.m_pnVmsGroup, "North");
        }
        this.add((Component)this.m_table, "Center");
        this.add((Component)btnPan, "South");
        this.setTitle(this.m_titleName);
        this.setVisible(true);
    }

    public AppOpenBlockDlg(JDialog dialog, int blockIndex, byte[] reqData) {
        super((Dialog)dialog, true);
        AppGlobal.g_dialogList.add(this);
        this.m_this = this;
        this.m_blockIndex = blockIndex;
        this.m_schduleTbReqData = reqData;
        this.setDialog();
        this.initial();
        this.requestData(this.m_schduleTbReqData);
        this.createComponent();
        this.setData();
        this.createTable();
        JPanel btnPan = new JPanel(new FlowLayout());
        btnPan.add(this.m_btnRelod);
        btnPan.add(this.m_btnClose);
        this.setMouseListener();
        this.add((Component)this.m_table, "Center");
        this.add((Component)btnPan, "South");
        this.setTitle(this.m_titleName);
        this.setVisible(true);
    }

    private boolean requestData() {
        byte[] m_req = new byte[]{0, 0, 0, 1, (byte)this.m_blockIndex, this.m_groupNumber};
        this.m_reqData = new AppRequestInfo("1006");
        this.m_reqData.getPageInfo().setMsgId(this.m_msgId);
        this.m_reqData.getPageInfo().setRecordSize(6);
        this.m_reqData.setDownMsgType((byte)-41);
        this.m_reqData.setReqData(m_req);
        this.m_reqData.setResult(AppComm.getInstance().requestDownload(this.m_reqData.getPageInfo()));
        this.m_recvData = this.m_reqData.getRecvData();
        return this.m_reqData.getResult();
    }

    private boolean requestData(byte[] reqData) {
        this.m_reqData = new AppRequestInfo(this.m_msgId, -41, -1);
        this.m_reqData.setReqData(reqData);
        this.m_reqData.setResult(AppComm.getInstance().requestDownload(this.m_reqData.getPageInfo()));
        this.m_recvData = this.m_reqData.getRecvData();
        return this.m_reqData.getResult();
    }

    private void initial() {
        switch (this.m_blockIndex) {
            case 0: {
                this.m_msgId = "1000";
                this.m_titleName = AppLang.getText("Announcement Block List");
                break;
            }
            case 1: {
                this.m_msgId = "1003";
                this.m_titleName = AppLang.getText("Audio TextLib Block List");
                break;
            }
            case 2: {
                this.m_msgId = "1006";
                this.m_titleName = AppLang.getText("Bye Block List");
                break;
            }
            case 3: {
                this.m_msgId = "1008";
                this.m_titleName = AppLang.getText("Dial Block List");
                break;
            }
            case 4: {
                this.m_msgId = "100C";
                this.m_titleName = AppLang.getText("Directory Block List");
                break;
            }
            case 5: {
                this.m_msgId = "100F";
                this.m_titleName = AppLang.getText("DocumentLib Block List");
                break;
            }
            case 6: {
                this.m_msgId = "1014";
                this.m_titleName = AppLang.getText("Eclass Block List");
                break;
            }
            case 7: {
                this.m_msgId = "1019";
                this.m_titleName = AppLang.getText("Extension Block List");
                break;
            }
            case 8: {
                this.m_msgId = "1020";
                this.m_titleName = AppLang.getText("Fax Block List");
                break;
            }
            case 9: {
                this.m_msgId = "1023";
                this.m_titleName = AppLang.getText("List Block List");
                break;
            }
            case 10: {
                this.m_msgId = "1027";
                this.m_titleName = AppLang.getText("Mailbox Block List");
                break;
            }
            case 11: {
                this.m_msgId = "102D";
                this.m_titleName = AppLang.getText("Mclass Block List");
                break;
            }
            case 12: {
                this.m_msgId = "1031";
                this.m_titleName = AppLang.getText("Menu Block List");
                break;
            }
            case 13: {
                this.m_msgId = "1034";
                this.m_titleName = AppLang.getText("Mode Block List");
                break;
            }
            case 14: {
                this.m_msgId = "1037";
                this.m_titleName = AppLang.getText("Network Mailbox Block List");
                break;
            }
            case 15: {
                this.m_msgId = "103C";
                this.m_titleName = AppLang.getText("Port Block List");
                break;
            }
            case 16: {
                this.m_msgId = "103E";
                this.m_titleName = AppLang.getText("Query Block List");
                break;
            }
            case 17: {
                this.m_msgId = "1042";
                this.m_titleName = AppLang.getText("Speak Block List");
                break;
            }
            case 18: {
                this.m_msgId = "1045";
                this.m_titleName = AppLang.getText("Station Block List");
            }
        }
    }

    private void setDialog() {
        this.setSize(500, 350);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.m_btnClose.addActionListener(this);
        this.m_btnClose.setActionCommand("close");
        this.m_btnNew.addActionListener(this);
        this.m_btnNew.setActionCommand("new");
        this.m_btnRelod.addActionListener(this);
        this.m_btnRelod.setActionCommand("reload");
        AppGlobal.fixSize(this.m_btnClose, new Dimension(115, 22));
        AppGlobal.fixSize(this.m_btnNew, new Dimension(115, 22));
        AppGlobal.fixSize(this.m_btnRelod, new Dimension(115, 22));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppOpenBlockDlg.this.m_this.setVisible(false);
                if (AppGlobal.g_dialogList.size() > 0) {
                    AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                }
            }
        });
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_RowNames, this.m_ColNames, "No."){

            @Override
            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return AppOpenBlockDlg.this.m_lbNumber[row];
                    }
                    case 1: {
                        return AppOpenBlockDlg.this.m_tfLabel[row];
                    }
                    case 2: {
                        if (AppOpenBlockDlg.this.m_tfLabel[row].getText().equals(AppLang.getText("SYSTEM_AUTO"))) {
                            return "";
                        }
                        return AppOpenBlockDlg.this.m_btnEdit[row];
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0 && col != 1;
            }
        };
        this.m_model.setRowWidth(new int[1]);
        this.m_model.setColWidth(new int[]{60, 300, 100});
        this.m_model.setRowHeaderHidden();
        this.m_table = new AppTable(this.m_model);
    }

    private void setData() {
        if (this.m_schduleTbReqData == null) {
            if (this.m_recvData.size() > 0) {
                this.m_serial = AppBlockListDetailDlg.getRecevData(this.m_recvData, 0);
                this.m_label = this.m_blockIndex != 13 ? AppBlockListDetailDlg.getRecevData(this.m_recvData, 1) : AppBlockListDetailDlg.getRecevData(this.m_recvData, 2);
                int i2 = 0;
                while (i2 < this.m_recvData.size()) {
                    this.m_tfLabel[i2].setText(this.m_label[i2]);
                    ++i2;
                }
            }
        } else if (this.m_recvData.size() > 0) {
            this.m_serial = AppBlockListDetailDlg.getRecevData(this.m_recvData, 0);
            this.m_label = AppBlockListDetailDlg.getRecevData(this.m_recvData, 1);
            int i3 = 0;
            while (i3 < this.m_recvData.size()) {
                this.m_tfLabel[i3].setText(this.m_label[i3]);
                ++i3;
            }
            this.m_tfLabel[this.m_recvData.size()].setText(AppLang.getText("SYSTEM_AUTO"));
        }
    }

    private void createComponent() {
        this.m_RowNames = null;
        if (this.m_schduleTbReqData == null) {
            this.m_RowNames = new String[this.m_recvData.size()][1];
            this.m_lbNumber = new JLabel[this.m_recvData.size()];
            this.m_tfLabel = new AppTextBox[this.m_recvData.size()];
            this.m_btnEdit = new JButton[this.m_recvData.size()];
            int i2 = 0;
            while (i2 < this.m_recvData.size()) {
                this.m_lbNumber[i2] = new JLabel("" + (i2 + 1));
                this.m_lbNumber[i2].setHorizontalAlignment(0);
                this.m_tfLabel[i2] = new AppTextBox();
                this.m_btnEdit[i2] = new JButton(AppLang.getText("Edit"));
                this.m_btnEdit[i2].addActionListener(this);
                this.m_btnEdit[i2].setActionCommand("edit_" + i2);
                ++i2;
            }
        } else {
            this.m_RowNames = new String[this.m_recvData.size() + 1][1];
            this.m_lbNumber = new JLabel[this.m_recvData.size() + 1];
            this.m_tfLabel = new AppTextBox[this.m_recvData.size() + 1];
            this.m_btnEdit = new JButton[this.m_recvData.size() + 1];
            int i3 = 0;
            while (i3 < this.m_recvData.size() + 1) {
                this.m_lbNumber[i3] = new JLabel("" + (i3 + 1));
                this.m_lbNumber[i3].setHorizontalAlignment(0);
                this.m_tfLabel[i3] = new AppTextBox();
                this.m_btnEdit[i3] = new JButton(AppLang.getText("Edit"));
                this.m_btnEdit[i3].addActionListener(this);
                this.m_btnEdit[i3].setActionCommand("edit_" + i3);
                ++i3;
            }
        }
    }

    public void setMouseListener() {
        this.m_table.getTable().removeMouseListener(this.m_tableListener);
        this.m_table.getTable().addMouseListener(this.m_tableListener);
    }

    private void setSerialNumber(String serialNum) {
        this.m_blockSerial = serialNum;
    }

    public String getSerialNumber() {
        return this.m_blockSerial.trim();
    }

    private void setLabelName(String labelName) {
        this.m_blockLabelName = labelName;
    }

    public String getLabelName() {
        return this.m_blockLabelName.trim();
    }

    private boolean createBlockClass() {
        switch (this.m_blockIndex) {
            case 0: {
                this.m_blockPage = new P1001AnnouncementBlock();
                return true;
            }
            case 1: {
                this.m_blockPage = new P1004AudiotexLibBlock();
                return true;
            }
            case 2: {
                this.m_blockPage = new P1007ByeBlock();
                return true;
            }
            case 3: {
                this.m_blockPage = new P1009DialBlock();
                return true;
            }
            case 4: {
                this.m_blockPage = new P100DDirectoryBlock();
                return true;
            }
            case 5: {
                this.m_blockPage = new P1010DocumentLibBlock();
                return true;
            }
            case 6: {
                this.m_blockPage = new P1015EClassBlock();
                return true;
            }
            case 7: {
                this.m_blockPage = new P101AExtensionBlock();
                return true;
            }
            case 8: {
                this.m_blockPage = new P1021FaxBlock();
                return true;
            }
            case 9: {
                this.m_blockPage = new P1024ListBlock();
                return true;
            }
            case 10: {
                this.m_blockPage = new P1028MailboxBlock();
                return true;
            }
            case 11: {
                this.m_blockPage = new P102EMClassBlock();
                return true;
            }
            case 12: {
                this.m_blockPage = new P1032MenuBlock();
                return true;
            }
            case 13: {
                this.m_blockPage = new P1035ModeBlock();
                return true;
            }
            case 14: {
                this.m_blockPage = new P1038NetworkBlock();
                return true;
            }
            case 15: {
                this.m_blockPage = new P103DPortBlock();
                return true;
            }
            case 16: {
                this.m_blockPage = new P103FQueryBlock();
                return true;
            }
            case 17: {
                this.m_blockPage = new P1043SpeakBlock();
                return true;
            }
            case 18: {
                this.m_blockPage = new P1046StationBlock();
                return true;
            }
        }
        return false;
    }

    private String getDetailMsgId() {
        String detailMsgId = "";
        switch (this.m_blockIndex) {
            case 0: {
                detailMsgId = "1001";
                break;
            }
            case 1: {
                detailMsgId = "1004";
                break;
            }
            case 2: {
                detailMsgId = "1007";
                break;
            }
            case 3: {
                detailMsgId = "1009";
                break;
            }
            case 4: {
                detailMsgId = "100D";
                break;
            }
            case 5: {
                detailMsgId = "1010";
                break;
            }
            case 6: {
                detailMsgId = "1015";
                break;
            }
            case 7: {
                detailMsgId = "101A";
                break;
            }
            case 8: {
                detailMsgId = "1021";
                break;
            }
            case 9: {
                detailMsgId = "1024";
                break;
            }
            case 10: {
                detailMsgId = "1028";
                break;
            }
            case 11: {
                detailMsgId = "102E";
                break;
            }
            case 12: {
                detailMsgId = "1032";
                break;
            }
            case 13: {
                detailMsgId = "1035";
                break;
            }
            case 14: {
                detailMsgId = "1038";
                break;
            }
            case 15: {
                detailMsgId = "103D";
                break;
            }
            case 16: {
                detailMsgId = "103F";
                break;
            }
            case 17: {
                detailMsgId = "1043";
                break;
            }
            case 18: {
                detailMsgId = "1046";
            }
        }
        return detailMsgId;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        if (command.equals("close")) {
            this.m_this.setVisible(false);
            if (AppGlobal.g_dialogList.size() > 0) {
                AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
            }
        } else if (command.equals("new")) {
            new AppNewBlockDlg(this.getDetailMsgId(), new ArrayList());
            this.requestData();
            this.createComponent();
            this.setData();
            this.m_model.setRowHeaderNames(this.m_RowNames);
            this.m_table.tableChanged(null);
            this.setMouseListener();
        } else if (command.equals("reload")) {
            if (this.m_schduleTbReqData == null) {
                this.requestData();
            } else {
                this.requestData(this.m_schduleTbReqData);
            }
            this.createComponent();
            this.setData();
            this.m_model.setRowHeaderNames(this.m_RowNames);
            this.m_table.tableChanged(null);
            this.setMouseListener();
        } else if (command.indexOf("edit") > -1) {
            int idx = Integer.parseInt(command.substring(5, command.length()));
            int i2 = 0;
            while (i2 < this.m_btnEdit.length) {
                if (idx == i2) {
                    try {
                        if (this.createBlockClass()) {
                            this.m_blockPage.createPage(this.m_serial[idx], new ArrayList());
                            this.m_btnRelod.doClick();
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                ++i2;
            }
        } else if (command.equals("group_change")) {
            this.m_groupNumber = (byte)(this.m_comboGroup.getSelectedIndex() + 1);
            this.requestData();
            this.createComponent();
            this.setData();
            this.m_model.setRowHeaderNames(this.m_RowNames);
            this.m_table.tableChanged(null);
            this.setMouseListener();
        }
    }

    private class OpenBlockDialogTableListener
    extends MouseAdapter {
        private OpenBlockDialogTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (e2.getClickCount() >= 2 && AppOpenBlockDlg.this.m_table.getTable().getSelectedColumn() == 1 && AppOpenBlockDlg.this.m_recvData.size() > 0) {
                try {
                    int rowIndex = AppOpenBlockDlg.this.m_table.getTable().getSelectedRow();
                    AppOpenBlockDlg.this.setLabelName(AppOpenBlockDlg.this.m_tfLabel[rowIndex].getText());
                    if (AppOpenBlockDlg.this.m_schduleTbReqData == null) {
                        AppOpenBlockDlg.this.setSerialNumber(AppOpenBlockDlg.this.m_serial[rowIndex]);
                    }
                    AppOpenBlockDlg.this.m_this.setVisible(false);
                    if (AppGlobal.g_dialogList.size() > 0) {
                        AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
                    }
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }
    }
}

