/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ftp;

import com.sun.misc.REException;
import com.sun.misc.RegexpPool;
import com.sun.net.TelnetInputStream;
import com.sun.net.TelnetOutputStream;
import com.sun.net.TransferProtocolClient;
import com.sun.net.ftp.FtpLoginException;
import com.sun.net.ftp.FtpProtocolException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.action.GetPropertyAction;

public class FtpClient
extends TransferProtocolClient {
    public static final int FTP_PORT = 21;
    static int FTP_SUCCESS = 1;
    static int FTP_TRY_AGAIN = 2;
    static int FTP_ERROR = 3;
    private String serverName = null;
    private boolean replyPending = false;
    private boolean binaryMode = false;
    private boolean loggedIn = false;
    private static RegexpPool nonProxyHostsPool = null;
    private static String nonProxyHostsSource = null;
    String command;
    int lastReplyCode;
    public String welcomeMsg;

    public static boolean getUseFtpProxy() {
        return FtpClient.getFtpProxyHost() != null;
    }

    public static String getFtpProxyHost() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String result = System.getProperty("ftp.proxyHost");
                if (result == null) {
                    result = System.getProperty("ftpProxyHost");
                }
                if (result == null && Boolean.getBoolean("ftp.useProxy")) {
                    result = System.getProperty("proxyHost");
                }
                return result;
            }
        });
    }

    public static int getFtpProxyPort() {
        final int[] result = new int[]{80};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String tmp = System.getProperty("ftp.proxyPort");
                if (tmp == null) {
                    tmp = System.getProperty("ftpProxyPort");
                }
                if (tmp == null && Boolean.getBoolean("ftp.useProxy")) {
                    tmp = System.getProperty("proxyPort");
                }
                if (tmp != null) {
                    result[0] = Integer.parseInt(tmp);
                }
                return null;
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matchNonProxyHosts(String host) {
        Class<FtpClient> clazz = FtpClient.class;
        synchronized (FtpClient.class) {
            String rawList = AccessController.doPrivileged(new GetPropertyAction("ftp.nonProxyHosts"));
            if (rawList == null) {
                nonProxyHostsPool = null;
            } else if (!rawList.equals(nonProxyHostsSource)) {
                RegexpPool pool = new RegexpPool();
                StringTokenizer st = new StringTokenizer(rawList, "|", false);
                try {
                    while (st.hasMoreTokens()) {
                        pool.add(st.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (REException ex) {
                    System.err.println("Error in http.nonProxyHosts system property: " + ex);
                }
                nonProxyHostsPool = pool;
            }
            nonProxyHostsSource = rawList;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (nonProxyHostsPool == null) {
                return false;
            }
            return nonProxyHostsPool.match(host) != null;
        }
    }

    @Override
    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.issueCommand("QUIT");
            super.closeServer();
        }
    }

    protected int issueCommand(String cmd) throws IOException {
        int reply;
        this.command = cmd;
        while (this.replyPending) {
            this.replyPending = false;
            if (this.readReply() != FTP_ERROR) continue;
            throw new FtpProtocolException("Error reading FTP pending reply\n");
        }
        do {
            this.sendServer(String.valueOf(cmd) + "\r\n");
        } while ((reply = this.readReply()) == FTP_TRY_AGAIN);
        return reply;
    }

    protected void issueCommandCheck(String cmd) throws IOException {
        if (this.issueCommand(cmd) != FTP_SUCCESS) {
            throw new FtpProtocolException(String.valueOf(cmd) + ":" + this.getResponseString());
        }
    }

    protected int readReply() throws IOException {
        this.lastReplyCode = this.readServerResponse();
        switch (this.lastReplyCode / 100) {
            case 1: {
                this.replyPending = true;
            }
            case 2: 
            case 3: {
                return FTP_SUCCESS;
            }
            case 5: {
                if (this.lastReplyCode == 530) {
                    if (!this.loggedIn) {
                        throw new FtpLoginException("Not logged in");
                    }
                    return FTP_ERROR;
                }
                if (this.lastReplyCode != 550) break;
                throw new FileNotFoundException(String.valueOf(this.command) + ": " + this.getResponseString());
            }
        }
        return FTP_ERROR;
    }

    protected Socket openPassiveDataConnection() throws IOException {
        Pattern p2;
        InetSocketAddress dest = null;
        if (this.issueCommand("EPSV ALL") == FTP_SUCCESS) {
            if (this.issueCommand("EPSV") == FTP_ERROR) {
                throw new FtpProtocolException("EPSV Failed: " + this.getResponseString());
            }
            String serverAnswer = this.getResponseString();
            p2 = Pattern.compile("^229 .* \\(\\|\\|\\|(\\d+)\\|\\)");
            Matcher m2 = p2.matcher(serverAnswer);
            if (!m2.find()) {
                throw new FtpProtocolException("EPSV failed : " + serverAnswer);
            }
            String s2 = m2.group(1);
            int port = Integer.parseInt(s2);
            InetAddress add = this.serverSocket.getInetAddress();
            dest = add != null ? new InetSocketAddress(add, port) : InetSocketAddress.createUnresolved(this.serverName, port);
        } else {
            if (this.issueCommand("PASV") == FTP_ERROR) {
                throw new FtpProtocolException("PASV failed: " + this.getResponseString());
            }
            String serverAnswer = this.getResponseString();
            p2 = Pattern.compile("227 .* \\(?(\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)?");
            Matcher m3 = p2.matcher(serverAnswer);
            if (!m3.find()) {
                throw new FtpProtocolException("PASV failed : " + serverAnswer);
            }
            int port = Integer.parseInt(m3.group(3)) + (Integer.parseInt(m3.group(2)) << 8);
            String s3 = m3.group(1).replace(',', '.');
            dest = new InetSocketAddress(s3, port);
        }
        Socket s4 = this.proxy != null ? (this.proxy.type() == Proxy.Type.SOCKS ? (Socket)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Socket(FtpClient.this.proxy);
            }
        }) : new Socket(Proxy.NO_PROXY)) : new Socket();
        if (this.connectTimeout >= 0) {
            s4.connect(dest, this.connectTimeout);
        } else if (defaultConnectTimeout > 0) {
            s4.connect(dest, defaultConnectTimeout);
        } else {
            s4.connect(dest);
        }
        if (this.readTimeout >= 0) {
            s4.setSoTimeout(this.readTimeout);
        } else if (defaultSoTimeout > 0) {
            s4.setSoTimeout(defaultSoTimeout);
        }
        return s4;
    }

    protected Socket openDataConnection(String cmd) throws IOException {
        Socket clientSocket = null;
        try {
            clientSocket = this.openPassiveDataConnection();
        }
        catch (IOException ex) {
            clientSocket = null;
        }
        if (clientSocket != null) {
            try {
                if (this.issueCommand(cmd) == FTP_ERROR) {
                    clientSocket.close();
                    throw new FtpProtocolException(this.getResponseString());
                }
                return clientSocket;
            }
            catch (IOException ioe) {
                clientSocket.close();
                throw ioe;
            }
        }
        assert (clientSocket == null);
        if (this.proxy != null && this.proxy.type() == Proxy.Type.SOCKS) {
            throw new FtpProtocolException("Passive mode failed");
        }
        ServerSocket portSocket = new ServerSocket(0, 1);
        try {
            String portCmd;
            InetAddress myAddress = portSocket.getInetAddress();
            if (myAddress.isAnyLocalAddress()) {
                myAddress = this.getLocalAddress();
            }
            if (this.issueCommand(portCmd = "EPRT |" + (myAddress instanceof Inet6Address ? "2" : "1") + "|" + myAddress.getHostAddress() + "|" + portSocket.getLocalPort() + "|") == FTP_ERROR || this.issueCommand(cmd) == FTP_ERROR) {
                portCmd = "PORT ";
                byte[] addr = myAddress.getAddress();
                int i2 = 0;
                while (i2 < addr.length) {
                    portCmd = String.valueOf(portCmd) + (addr[i2] & 0xFF) + ",";
                    ++i2;
                }
                if (this.issueCommand(portCmd = String.valueOf(portCmd) + (portSocket.getLocalPort() >>> 8 & 0xFF) + "," + (portSocket.getLocalPort() & 0xFF)) == FTP_ERROR) {
                    FtpProtocolException e2 = new FtpProtocolException("PORT :" + this.getResponseString());
                    throw e2;
                }
                if (this.issueCommand(cmd) == FTP_ERROR) {
                    FtpProtocolException e3 = new FtpProtocolException(String.valueOf(cmd) + ":" + this.getResponseString());
                    throw e3;
                }
            }
            if (this.connectTimeout >= 0) {
                portSocket.setSoTimeout(this.connectTimeout);
            } else if (defaultConnectTimeout > 0) {
                portSocket.setSoTimeout(defaultConnectTimeout);
            }
            clientSocket = portSocket.accept();
            if (this.readTimeout >= 0) {
                clientSocket.setSoTimeout(this.readTimeout);
            } else if (defaultSoTimeout > 0) {
                clientSocket.setSoTimeout(defaultSoTimeout);
            }
        }
        finally {
            portSocket.close();
        }
        return clientSocket;
    }

    public void openServer(String host) throws IOException {
        this.openServer(host, 21);
    }

    @Override
    public void openServer(String host, int port) throws IOException {
        this.serverName = host;
        super.openServer(host, port);
        if (this.readReply() == FTP_ERROR) {
            throw new FtpProtocolException("Welcome message: " + this.getResponseString());
        }
    }

    public void login(String user, String password) throws IOException {
        if (!this.serverIsOpen()) {
            throw new FtpLoginException("not connected to host");
        }
        if (user == null || user.length() == 0) {
            return;
        }
        if (this.issueCommand("USER " + user) == FTP_ERROR) {
            throw new FtpLoginException("user " + user + " : " + this.getResponseString());
        }
        if (this.lastReplyCode == 331 && (password == null || password.length() == 0 || this.issueCommand("PASS " + password) == FTP_ERROR)) {
            throw new FtpLoginException("password: " + this.getResponseString());
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < this.serverResponse.size()) {
            String l2 = (String)this.serverResponse.elementAt(i2);
            if (l2 != null) {
                if (l2.length() >= 4 && l2.startsWith("230")) {
                    l2 = l2.substring(4);
                }
                sb.append(l2);
            }
            ++i2;
        }
        this.welcomeMsg = sb.toString();
        this.loggedIn = true;
    }

    /*
     * Unable to fully structure code
     */
    public TelnetInputStream get(String filename) throws IOException {
        block8: {
            try {
                s = this.openDataConnection("RETR " + filename);
                break block8;
            }
            catch (FileNotFoundException fileException) {
                if (filename.indexOf(47) == -1) {
                    throw fileException;
                }
                t = new StringTokenizer(filename, "/");
                pathElement = null;
                ** while (t.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                pathElement = t.nextToken();
                if (!t.hasMoreElements()) break;
                try {
                    this.cd(pathElement);
                    continue;
                }
                catch (FtpProtocolException e) {
                    throw fileException;
                }
            }
lbl17:
            // 2 sources

            if (pathElement != null) {
                s = this.openDataConnection("RETR " + pathElement);
            } else {
                throw fileException;
            }
        }
        return new TelnetInputStream(s.getInputStream(), this.binaryMode);
    }

    public TelnetOutputStream put(String filename) throws IOException {
        Socket s2 = this.openDataConnection("STOR " + filename);
        TelnetOutputStream out = new TelnetOutputStream(s2.getOutputStream(), this.binaryMode);
        if (!this.binaryMode) {
            out.setStickyCRLF(true);
        }
        return out;
    }

    public TelnetOutputStream append(String filename) throws IOException {
        Socket s2 = this.openDataConnection("APPE " + filename);
        TelnetOutputStream out = new TelnetOutputStream(s2.getOutputStream(), this.binaryMode);
        if (!this.binaryMode) {
            out.setStickyCRLF(true);
        }
        return out;
    }

    public TelnetInputStream list() throws IOException {
        Socket s2 = this.openDataConnection("LIST");
        return new TelnetInputStream(s2.getInputStream(), this.binaryMode);
    }

    public TelnetInputStream nameList(String path) throws IOException {
        Socket s2 = path != null ? this.openDataConnection("NLST " + path) : this.openDataConnection("NLST");
        return new TelnetInputStream(s2.getInputStream(), this.binaryMode);
    }

    public void cd(String remoteDirectory) throws IOException {
        if (remoteDirectory == null || "".equals(remoteDirectory)) {
            return;
        }
        this.issueCommandCheck("CWD " + remoteDirectory);
    }

    public void cdUp() throws IOException {
        this.issueCommandCheck("CDUP");
    }

    public String pwd() throws IOException {
        this.issueCommandCheck("PWD");
        String answ = this.getResponseString();
        if (!answ.startsWith("257")) {
            throw new FtpProtocolException("PWD failed. " + answ);
        }
        return answ.substring(5, answ.lastIndexOf(34));
    }

    public void binary() throws IOException {
        this.issueCommandCheck("TYPE I");
        this.binaryMode = true;
    }

    public void ascii() throws IOException {
        this.issueCommandCheck("TYPE A");
        this.binaryMode = false;
    }

    public void rename(String from, String to) throws IOException {
        this.issueCommandCheck("RNFR " + from);
        this.issueCommandCheck("RNTO " + to);
    }

    public String system() throws IOException {
        this.issueCommandCheck("SYST");
        String answ = this.getResponseString();
        if (!answ.startsWith("215")) {
            throw new FtpProtocolException("SYST failed." + answ);
        }
        return answ.substring(4);
    }

    public void noop() throws IOException {
        this.issueCommandCheck("NOOP");
    }

    public void reInit() throws IOException {
        this.issueCommandCheck("REIN");
        this.loggedIn = false;
    }

    public FtpClient(String host) throws IOException {
        this.openServer(host, 21);
    }

    public FtpClient(String host, int port) throws IOException {
        this.openServer(host, port);
    }

    public FtpClient() {
    }

    public FtpClient(Proxy p2) {
        this.proxy = p2;
    }

    protected void finalize() throws IOException {
        if (this.serverIsOpen()) {
            super.closeServer();
        }
    }
}

