/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import jxl.biff.formula.ExternalSheet;

public final class CellReferenceHelper {
    private static Logger logger = Logger.getLogger(class$jxl$biff$CellReferenceHelper == null ? (class$jxl$biff$CellReferenceHelper = CellReferenceHelper.class$("jxl.biff.CellReferenceHelper")) : class$jxl$biff$CellReferenceHelper);
    private static final char fixedInd = '$';
    static /* synthetic */ Class class$jxl$biff$CellReferenceHelper;

    private CellReferenceHelper() {
    }

    public static void getCellReference(int column, int row, StringBuffer buf) {
        CellReferenceHelper.getColumnReference(column, buf);
        buf.append(Integer.toString(row + 1));
    }

    public static void getCellReference(int column, boolean colabs, int row, boolean rowabs, StringBuffer buf) {
        if (colabs) {
            buf.append('$');
        }
        CellReferenceHelper.getColumnReference(column, buf);
        if (rowabs) {
            buf.append('$');
        }
        buf.append(Integer.toString(row + 1));
    }

    public static String getColumnReference(int column) {
        StringBuffer buf = new StringBuffer();
        CellReferenceHelper.getColumnReference(column, buf);
        return buf.toString();
    }

    public static void getColumnReference(int column, StringBuffer buf) {
        char col;
        int r2 = column % 26;
        StringBuffer tmp = new StringBuffer();
        for (int v2 = column / 26; v2 != 0; v2 /= 26) {
            col = (char)(65 + r2);
            tmp.append(col);
            r2 = v2 % 26 - 1;
        }
        col = (char)(65 + r2);
        tmp.append(col);
        for (int i2 = tmp.length() - 1; i2 >= 0; --i2) {
            buf.append(tmp.charAt(i2));
        }
    }

    public static void getCellReference(int sheet, int column, int row, ExternalSheet workbook, StringBuffer buf) {
        buf.append('\'');
        buf.append(workbook.getExternalSheetName(sheet));
        buf.append('\'');
        buf.append('!');
        CellReferenceHelper.getCellReference(column, row, buf);
    }

    public static void getCellReference(int sheet, int column, boolean colabs, int row, boolean rowabs, ExternalSheet workbook, StringBuffer buf) {
        buf.append('\'');
        buf.append(workbook.getExternalSheetName(sheet));
        buf.append('\'');
        buf.append('!');
        CellReferenceHelper.getCellReference(column, colabs, row, rowabs, buf);
    }

    public static String getCellReference(int sheet, int column, int row, ExternalSheet workbook) {
        StringBuffer sb = new StringBuffer();
        CellReferenceHelper.getCellReference(sheet, column, row, workbook, sb);
        return sb.toString();
    }

    public static String getCellReference(int column, int row) {
        StringBuffer buf = new StringBuffer();
        CellReferenceHelper.getCellReference(column, row, buf);
        return buf.toString();
    }

    public static int getColumn(String s2) {
        int colnum = 0;
        int numindex = CellReferenceHelper.getNumberIndex(s2);
        String s22 = s2.toUpperCase();
        int startPos = 0;
        if (s2.charAt(0) == '$') {
            startPos = 1;
        }
        int endPos = numindex;
        if (s2.charAt(numindex - 1) == '$') {
            --endPos;
        }
        for (int i2 = startPos; i2 < endPos; ++i2) {
            if (i2 != startPos) {
                colnum = (colnum + 1) * 26;
            }
            colnum += s22.charAt(i2) - 65;
        }
        return colnum;
    }

    public static int getRow(String s2) {
        try {
            return Integer.parseInt(s2.substring(CellReferenceHelper.getNumberIndex(s2))) - 1;
        }
        catch (NumberFormatException e2) {
            logger.warn(e2, e2);
            return 65535;
        }
    }

    private static int getNumberIndex(String s2) {
        boolean numberFound = false;
        int pos = 0;
        char c2 = '\u0000';
        while (!numberFound && pos < s2.length()) {
            c2 = s2.charAt(pos);
            if (c2 >= '0' && c2 <= '9') {
                numberFound = true;
                continue;
            }
            ++pos;
        }
        return pos;
    }

    public static boolean isColumnRelative(String s2) {
        return s2.charAt(0) != '$';
    }

    public static boolean isRowRelative(String s2) {
        return s2.charAt(CellReferenceHelper.getNumberIndex(s2) - 1) != '$';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

