/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.Cell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.format.CellFormat;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;

class MulBlankCell
implements Cell {
    private int row;
    private int column;
    private CellFormat cellFormat;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private SheetImpl sheet;

    public MulBlankCell(int r2, int c2, int xfi, FormattingRecords fr, SheetImpl si) {
        this.row = r2;
        this.column = c2;
        this.xfIndex = xfi;
        this.formattingRecords = fr;
        this.sheet = si;
        this.initialized = false;
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public String getContents() {
        return "";
    }

    public CellType getType() {
        return CellType.EMPTY;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.cellFormat = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.cellFormat;
    }

    public boolean isHidden() {
        ColumnInfoRecord cir = this.sheet.getColumnInfo(this.column);
        if (cir != null && cir.getWidth() == 0) {
            return true;
        }
        RowRecord rr = this.sheet.getRowInfo(this.row);
        return rr != null && (rr.getRowHeight() == 0 || rr.isCollapsed());
    }
}

