/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.telnet;

import com.oroinc.net.telnet.TelnetClient;
import com.oroinc.net.telnet.TelnetOption;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

final class TelnetInputStream
extends BufferedInputStream
implements Runnable {
    static final int _STATE_DATA = 0;
    static final int _STATE_IAC = 1;
    static final int _STATE_WILL = 2;
    static final int _STATE_WONT = 3;
    static final int _STATE_DO = 4;
    static final int _STATE_DONT = 5;
    static final int _STATE_SB = 6;
    static final int _STATE_SE = 7;
    static final int _STATE_CR = 8;
    private boolean __hasReachedEOF;
    private boolean __isClosed;
    private boolean __readIsWaiting;
    private int __receiveState;
    private int __queueHead;
    private int __queueTail;
    private int __bytesAvailable;
    private int[] __queue;
    private TelnetClient __client;
    private Thread __thread;
    private IOException __ioException;

    TelnetInputStream(InputStream inputStream, TelnetClient telnetClient) {
        super(inputStream);
        this.__client = telnetClient;
        this.__receiveState = 0;
        this.__isClosed = true;
        this.__hasReachedEOF = false;
        this.__queue = new int[2049];
        this.__queueHead = 0;
        this.__queueTail = 0;
        this.__bytesAvailable = 0;
        this.__ioException = null;
        this.__readIsWaiting = false;
        this.__thread = new Thread(this);
    }

    void _start() {
        this.__isClosed = false;
        int n2 = Thread.currentThread().getPriority() + 1;
        if (n2 > 10) {
            n2 = 10;
        }
        this.__thread.setPriority(n2);
        this.__thread.setDaemon(true);
        this.__thread.start();
    }

    private int __read() throws IOException {
        int n2;
        block31: while (true) {
            if ((n2 = super.read()) < 0) {
                return -1;
            }
            n2 &= 0xFF;
            switch (this.__receiveState) {
                case 8: {
                    if (n2 == 0) continue block31;
                }
                case 0: {
                    TelnetClient telnetClient;
                    if (n2 == 255) {
                        this.__receiveState = 1;
                        continue block31;
                    }
                    if (n2 == 13) {
                        telnetClient = this.__client;
                        synchronized (telnetClient) {
                            this.__receiveState = this.__client._requestedDont(TelnetOption.BINARY) ? 8 : 0;
                            break block31;
                        }
                    }
                    this.__receiveState = 0;
                    break block31;
                }
                case 1: {
                    switch (n2) {
                        case 251: {
                            this.__receiveState = 2;
                            continue block31;
                        }
                        case 252: {
                            this.__receiveState = 3;
                            continue block31;
                        }
                        case 253: {
                            this.__receiveState = 4;
                            continue block31;
                        }
                        case 254: {
                            this.__receiveState = 5;
                            continue block31;
                        }
                        case 255: {
                            this.__receiveState = 0;
                            break;
                        }
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 2: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processWill(n2);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 3: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processWont(n2);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 4: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processDo(n2);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 5: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processDont(n2);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
            }
            break;
        }
        return n2;
    }

    public int read() throws IOException {
        int[] nArray = this.__queue;
        synchronized (nArray) {
            while (true) {
                if (this.__ioException != null) {
                    IOException iOException = this.__ioException;
                    this.__ioException = null;
                    throw iOException;
                }
                if (this.__bytesAvailable != 0) break;
                if (this.__hasReachedEOF) {
                    int n2 = -1;
                    return n2;
                }
                this.__queue.notify();
                try {
                    this.__readIsWaiting = true;
                    this.__queue.wait();
                    this.__readIsWaiting = false;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Fatal thread interruption during read.");
                }
            }
            int n3 = this.__queue[this.__queueHead];
            if (++this.__queueHead >= this.__queue.length) {
                this.__queueHead = 0;
            }
            --this.__bytesAvailable;
            int n4 = n3;
            return n4;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 < 1) {
            return 0;
        }
        int[] nArray = this.__queue;
        synchronized (nArray) {
            if (n3 > this.__bytesAvailable) {
                n3 = this.__bytesAvailable;
            }
        }
        int n4 = this.read();
        if (n4 == -1) {
            return -1;
        }
        int n5 = n2;
        do {
            byArray[n2++] = (byte)n4;
        } while (--n3 > 0 && (n4 = this.read()) != -1);
        return n2 - n5;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        int[] nArray = this.__queue;
        synchronized (nArray) {
            int n2 = this.__bytesAvailable;
            return n2;
        }
    }

    public void close() throws IOException {
        super.close();
        int[] nArray = this.__queue;
        synchronized (nArray) {
            this.__hasReachedEOF = true;
            if (this.__thread.isAlive()) {
                this.__isClosed = true;
                this.__thread.interrupt();
            }
            this.__queue.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block22: {
            try {
                block16: while (!this.__isClosed) {
                    block21: {
                        try {
                            var1_1 = this.__read();
                            if (var1_1 >= 0) break block21;
                            break;
                        }
                        catch (InterruptedIOException var2_3) {
                            var3_5 = this.__queue;
                            synchronized (var3_5) {
                                block23: {
                                    this.__ioException = var2_3;
                                    this.__queue.notify();
                                    try {
                                        this.__queue.wait();
                                    }
                                    catch (InterruptedException var4_8) {
                                        if (!this.__isClosed) break block23;
                                        break;
                                    }
                                }
                                continue;
                            }
                        }
                    }
                    var2_2 = this.__queue;
                    synchronized (var2_2) {
                        while (true) {
                            if (this.__bytesAvailable < this.__queue.length - 1) {
                                if (this.__readIsWaiting) {
                                    this.__queue.notify();
                                }
                                this.__queue[this.__queueTail] = var1_1;
                                ++this.__bytesAvailable;
                                if (++this.__queueTail >= this.__queue.length) {
                                    this.__queueTail = 0;
                                }
                                continue block16;
                            }
                            this.__queue.notify();
                            try {
                                this.__queue.wait();
                                continue;
                            }
                            catch (InterruptedException var3_6) {
                                if (this.__isClosed) ** break;
                                continue;
                                break block22;
                            }
                            break;
                        }
                    }
                }
            }
            catch (IOException var2_4) {
                var3_7 = this.__queue;
                synchronized (var3_7) {
                    this.__ioException = var2_4;
                }
            }
        }
        var2_2 = this.__queue;
        synchronized (var2_2) {
            this.__isClosed = true;
            this.__hasReachedEOF = true;
            this.__queue.notify();
            return;
        }
    }
}

