/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.ITableModel;
import com.sec.osdm.pages.utils.table.SpanInfo;

public class AppTableModel
implements ITableModel {
    protected boolean m_rowHdrHidden = false;
    protected boolean m_colHdrHidden = false;
    protected SpanInfo m_rowHeader = null;
    protected SpanInfo m_columnHeader = null;
    protected SpanInfo m_cornerHeader = null;
    protected Object[][] m_arrColNames = null;
    protected Object[][] m_arrRowNames = null;
    protected String[][] m_arrCorner = null;
    protected String m_corner = null;
    protected int[] m_arrRowWidths = null;
    protected int[] m_arrColWidths = null;
    protected int[] m_arrCornerWidths = null;
    protected boolean m_fChanged = false;
    protected AppTable m_table = null;
    protected boolean m_b4601UCDGroup = false;
    public boolean m_searchTable = false;

    public AppTableModel() {
    }

    public AppTableModel(Object[][] arrRowNames, Object[][] arrColNames, String strCorner) {
        this.m_arrRowNames = arrRowNames;
        this.m_arrColNames = arrColNames;
        this.m_corner = strCorner;
        this.m_rowHeader = new SpanInfo(this.getRowHdrRowCount(), this.getRowHdrColCount());
        this.m_columnHeader = new SpanInfo(this.getColHdrRowCount(), this.getColHdrColCount());
    }

    public AppTableModel(Object[][] arrRowNames, Object[][] arrColNames, String[][] strCorner) {
        this.m_arrRowNames = arrRowNames;
        this.m_arrColNames = arrColNames;
        this.m_arrCorner = strCorner;
        this.m_rowHeader = new SpanInfo(this.getRowHdrRowCount(), this.getRowHdrColCount());
        this.m_columnHeader = new SpanInfo(this.getColHdrRowCount(), this.getColHdrColCount());
        this.m_cornerHeader = new SpanInfo(this.getCornerHdrRowCount(), this.getCornerHdrColCount());
    }

    @Override
    public void setRowHeaderHidden() {
        this.m_rowHdrHidden = true;
    }

    @Override
    public boolean IsRowHeaderHidden() {
        return this.m_rowHdrHidden;
    }

    @Override
    public void setColHeaderHidden() {
        this.m_colHdrHidden = true;
    }

    @Override
    public boolean IsColHeaderHidden() {
        return this.m_colHdrHidden;
    }

    public void setRowHeaderRowSpan(int row, int col, int spanNum) {
        this.m_rowHeader.setRowSpan(row, col, spanNum);
    }

    public void setRowHeaderColSpan(int row, int col, int spanNum) {
        this.m_rowHeader.setColSpan(row, col, spanNum);
    }

    public void setColHeaderRowSpan(int row, int col, int spanNum) {
        this.m_columnHeader.setRowSpan(row, col, spanNum);
    }

    public void setColHeaderColSpan(int row, int col, int spanNum) {
        this.m_columnHeader.setColSpan(row, col, spanNum);
    }

    public void setCornerHeaderRowSpan(int row, int col, int spanNum) {
        this.m_cornerHeader.setRowSpan(row, col, spanNum);
    }

    public void setCornerHeaderColSpan(int row, int col, int spanNum) {
        this.m_cornerHeader.setColSpan(row, col, spanNum);
    }

    public void setRowWidth(int[] arrRowWidths) {
        this.m_arrRowWidths = arrRowWidths;
    }

    public void setColWidth(int[] arrColWidths) {
        this.m_arrColWidths = arrColWidths;
    }

    public void setCornerWidth(int[] arrCornerWidths) {
        this.m_arrCornerWidths = arrCornerWidths;
    }

    public void setRowHeaderNames(Object[][] arrRowNames) {
        this.m_arrRowNames = arrRowNames;
    }

    public void setColHeaderNames(Object[][] arrColNames) {
        this.m_arrColNames = arrColNames;
    }

    @Override
    public void onCreate(AppTable table) {
        this.m_table = table;
    }

    @Override
    public String[][] getRowHdrNames() {
        String[][] arrRowHdrNames = new String[this.getRowHdrRowCount()][this.getRowHdrColCount()];
        int i2 = 0;
        while (i2 < this.getRowHdrRowCount()) {
            int j2 = 0;
            while (j2 < this.getRowHdrColCount()) {
                arrRowHdrNames[i2][j2] = AppLang.getText((String)this.m_arrRowNames[i2][j2]);
                ++j2;
            }
            ++i2;
        }
        return arrRowHdrNames;
    }

    @Override
    public Object getCornerHdrNames(int row, int col) {
        return AppLang.getText(this.m_arrCorner[row][col]);
    }

    @Override
    public Object getRowHdrName(int row, int col) {
        return AppLang.getText((String)this.m_arrRowNames[row][col]);
    }

    @Override
    public int getRowHdrRowCount() {
        if (this.m_arrRowNames == null) {
            return 0;
        }
        return this.m_arrRowNames.length;
    }

    @Override
    public int getRowHdrColCount() {
        if (this.m_arrRowNames == null || this.m_arrRowNames.length == 0) {
            return 0;
        }
        return this.m_arrRowNames[0].length;
    }

    @Override
    public int getCornerHdrRowCount() {
        if (this.m_arrCorner == null) {
            return 0;
        }
        return this.m_arrCorner.length;
    }

    @Override
    public int getCornerHdrColCount() {
        if (this.m_arrCorner == null) {
            return 0;
        }
        return this.m_arrCorner[0].length;
    }

    @Override
    public int getRowHdrWidth(int col) {
        if (this.m_arrRowWidths == null || col >= this.m_arrRowWidths.length) {
            return -1;
        }
        return this.m_arrRowWidths[col];
    }

    @Override
    public int getCornerHdrWidth(int col) {
        if (this.m_arrCornerWidths == null || col >= this.m_arrCornerWidths.length) {
            return -1;
        }
        return this.m_arrCornerWidths[col];
    }

    public int[] getRowHdrWidth() {
        return this.m_arrRowWidths;
    }

    public int[] getColHdrWidth() {
        return this.m_arrColWidths;
    }

    public int[] getCornerHdrWidth() {
        return this.m_arrCornerWidths;
    }

    @Override
    public String[][] getColHdrNames() {
        String[][] arrColHdrNames = new String[this.getColHdrRowCount()][this.getColHdrColCount()];
        int i2 = 0;
        while (i2 < this.getColHdrRowCount()) {
            int j2 = 0;
            while (j2 < this.getColHdrColCount()) {
                arrColHdrNames[i2][j2] = AppLang.getText((String)this.m_arrColNames[i2][j2]);
                ++j2;
            }
            ++i2;
        }
        return arrColHdrNames;
    }

    @Override
    public Object getColHdrName(int row, int col) {
        return AppLang.getText((String)this.m_arrColNames[row][col]);
    }

    @Override
    public int getColHdrRowCount() {
        if (this.m_arrColNames == null) {
            return 0;
        }
        return this.m_arrColNames.length;
    }

    @Override
    public int getColHdrColCount() {
        if (this.m_arrColNames == null || this.m_arrColNames.length == 0) {
            return 0;
        }
        return this.m_arrColNames[0].length;
    }

    @Override
    public int getColHdrWidth(int col) {
        if (this.m_arrColWidths == null || col >= this.m_arrColWidths.length) {
            return -1;
        }
        return this.m_arrColWidths[col];
    }

    @Override
    public String getCornerName(int col) {
        return AppLang.getText(this.m_corner);
    }

    public Object getCornerName(int row, int col) {
        return AppLang.getText(this.m_arrCorner[row][col]);
    }

    public String[][] getCornerHdrNames() {
        return this.m_arrCorner;
    }

    @Override
    public int getCornerCount() {
        return 1;
    }

    @Override
    public SpanInfo getRowHeaderSpanInfo() {
        return this.m_rowHeader;
    }

    @Override
    public SpanInfo getColHeaderSpanInfo() {
        return this.m_columnHeader;
    }

    @Override
    public SpanInfo getCornerHeaderSpanInfo() {
        return this.m_cornerHeader;
    }

    @Override
    public SpanInfo getDataSpanInfo() {
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public boolean isChanged() {
        return this.m_fChanged;
    }

    public void setChanged() {
        this.m_fChanged = true;
    }

    public void clearChanged() {
        this.m_fChanged = false;
    }

    @Override
    public boolean isRowHidden(int row) {
        return this.m_table.m_rowHeaderTable.getRowHeight(row) <= 0;
    }

    @Override
    public boolean isColHidden(int col) {
        return this.m_table.m_table.isColHidden(col);
    }

    @Override
    public void setRowHeaderSpanInfo(SpanInfo spanInfo) {
    }

    @Override
    public void setColHeaderSpanInfo(SpanInfo spanInfo) {
    }

    @Override
    public void setDataSpanInfo(SpanInfo spanInfo) {
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
    }

    @Override
    public boolean get4601UCDGroup() {
        return this.m_b4601UCDGroup;
    }

    @Override
    public void set4601UCDGroup(boolean bol) {
        this.m_b4601UCDGroup = bol;
    }

    @Override
    public boolean getIsA104SearchTable() {
        return this.m_searchTable;
    }
}

