/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.telnet;

import com.oroinc.net.SocketClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;

class Telnet
extends SocketClient {
    static final boolean debug = false;
    static final byte[] _COMMAND_DO = new byte[]{-1, -3};
    static final byte[] _COMMAND_DONT = new byte[]{-1, -2};
    static final byte[] _COMMAND_WILL = new byte[]{-1, -5};
    static final byte[] _COMMAND_WONT = new byte[]{-1, -4};
    static final byte[] _COMMAND_SB = new byte[]{-1, -6};
    static final byte[] _COMMAND_SE = new byte[]{-1, -16};
    static final int _WILL_MASK = 1;
    static final int _DO_MASK = 2;
    static final int _REQUESTED_WILL_MASK = 4;
    static final int _REQUESTED_DO_MASK = 8;
    static final int DEFAULT_PORT = 23;
    int[] _doResponse;
    int[] _willResponse;
    int[] _options;

    Telnet() {
        this.setDefaultPort(23);
        this._doResponse = new int[256];
        this._willResponse = new int[256];
        this._options = new int[256];
    }

    boolean _stateIsWill(int n2) {
        return (this._options[n2] & 1) != 0;
    }

    boolean _stateIsWont(int n2) {
        return !this._stateIsWill(n2);
    }

    boolean _stateIsDo(int n2) {
        return (this._options[n2] & 2) != 0;
    }

    boolean _stateIsDont(int n2) {
        return !this._stateIsDo(n2);
    }

    boolean _requestedWill(int n2) {
        return (this._options[n2] & 4) != 0;
    }

    boolean _requestedWont(int n2) {
        return !this._requestedWill(n2);
    }

    boolean _requestedDo(int n2) {
        return (this._options[n2] & 8) != 0;
    }

    boolean _requestedDont(int n2) {
        return !this._requestedDo(n2);
    }

    void _setWill(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] | 1;
    }

    void _setDo(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] | 2;
    }

    void _setWantWill(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] | 4;
    }

    void _setWantDo(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] | 8;
    }

    void _setWont(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] & 0xFFFFFFFE;
    }

    void _setDont(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] & 0xFFFFFFFD;
    }

    void _setWantWont(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] & 0xFFFFFFFB;
    }

    void _setWantDont(int n2) {
        int n3 = n2;
        this._options[n3] = this._options[n3] & 0xFFFFFFF7;
    }

    void _processDo(int n2) throws IOException {
        boolean bl2 = false;
        if (this._willResponse[n2] > 0) {
            int n3 = n2;
            this._willResponse[n3] = this._willResponse[n3] - 1;
            if (this._willResponse[n2] > 0 && this._stateIsWill(n2)) {
                int n4 = n2;
                this._willResponse[n4] = this._willResponse[n4] - 1;
            }
        }
        if (this._willResponse[n2] == 0) {
            if (this._requestedWont(n2)) {
                switch (n2) {
                    default: 
                }
                if (bl2) {
                    this._setWantWill(n2);
                    this._sendWill(n2);
                } else {
                    int n5 = n2;
                    this._willResponse[n5] = this._willResponse[n5] + 1;
                    this._sendWont(n2);
                }
            } else {
                switch (n2) {
                    default: 
                }
            }
        }
        this._setWill(n2);
    }

    void _processDont(int n2) throws IOException {
        if (this._willResponse[n2] > 0) {
            int n3 = n2;
            this._willResponse[n3] = this._willResponse[n3] - 1;
            if (this._willResponse[n2] > 0 && this._stateIsWont(n2)) {
                int n4 = n2;
                this._willResponse[n4] = this._willResponse[n4] - 1;
            }
        }
        if (this._willResponse[n2] == 0 && this._requestedWill(n2)) {
            switch (n2) {
                default: 
            }
            this._setWantWont(n2);
            if (this._stateIsWill(n2)) {
                this._sendWont(n2);
            }
        }
        this._setWont(n2);
    }

    void _processWill(int n2) throws IOException {
        boolean bl2 = false;
        if (this._doResponse[n2] > 0) {
            int n3 = n2;
            this._doResponse[n3] = this._doResponse[n3] - 1;
            if (this._doResponse[n2] > 0 && this._stateIsDo(n2)) {
                int n4 = n2;
                this._doResponse[n4] = this._doResponse[n4] - 1;
            }
        }
        if (this._doResponse[n2] == 0 && this._requestedDont(n2)) {
            switch (n2) {
                default: 
            }
            if (bl2) {
                this._setWantDo(n2);
                this._sendDo(n2);
            } else {
                int n5 = n2;
                this._doResponse[n5] = this._doResponse[n5] + 1;
                this._sendDont(n2);
            }
        }
        this._setDo(n2);
    }

    void _processWont(int n2) throws IOException {
        if (this._doResponse[n2] > 0) {
            int n3 = n2;
            this._doResponse[n3] = this._doResponse[n3] - 1;
            if (this._doResponse[n2] > 0 && this._stateIsDont(n2)) {
                int n4 = n2;
                this._doResponse[n4] = this._doResponse[n4] - 1;
            }
        }
        if (this._doResponse[n2] == 0 && this._requestedDo(n2)) {
            switch (n2) {
                default: 
            }
            this._setWantDont(n2);
            if (this._stateIsDo(n2)) {
                this._sendDont(n2);
            }
        }
        this._setDont(n2);
    }

    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this._input_ = new BufferedInputStream(this._input_);
        this._output_ = new BufferedOutputStream(this._output_);
    }

    final synchronized void _sendDo(int n2) throws IOException {
        this._output_.write(_COMMAND_DO);
        this._output_.write(n2);
    }

    final synchronized void _requestDo(int n2) throws IOException {
        if (this._doResponse[n2] == 0 && this._stateIsDo(n2) || this._requestedDo(n2)) {
            return;
        }
        this._setWantDo(n2);
        int n3 = n2;
        this._doResponse[n3] = this._doResponse[n3] + 1;
        this._sendDo(n2);
    }

    final synchronized void _sendDont(int n2) throws IOException {
        this._output_.write(_COMMAND_DONT);
        this._output_.write(n2);
    }

    final synchronized void _requestDont(int n2) throws IOException {
        if (this._doResponse[n2] == 0 && this._stateIsDont(n2) || this._requestedDont(n2)) {
            return;
        }
        this._setWantDont(n2);
        int n3 = n2;
        this._doResponse[n3] = this._doResponse[n3] + 1;
        this._sendDont(n2);
    }

    final synchronized void _sendWill(int n2) throws IOException {
        this._output_.write(_COMMAND_WILL);
        this._output_.write(n2);
    }

    final synchronized void _requestWill(int n2) throws IOException {
        if (this._willResponse[n2] == 0 && this._stateIsWill(n2) || this._requestedWill(n2)) {
            return;
        }
        this._setWantWill(n2);
        int n3 = n2;
        this._doResponse[n3] = this._doResponse[n3] + 1;
        this._sendWill(n2);
    }

    final synchronized void _sendWont(int n2) throws IOException {
        this._output_.write(_COMMAND_WONT);
        this._output_.write(n2);
    }

    final synchronized void _requestWont(int n2) throws IOException {
        if (this._willResponse[n2] == 0 && this._stateIsWont(n2) || this._requestedWont(n2)) {
            return;
        }
        this._setWantWont(n2);
        int n3 = n2;
        this._doResponse[n3] = this._doResponse[n3] + 1;
        this._sendWont(n2);
    }

    final synchronized void _sendByte(int n2) throws IOException {
        this._output_.write(n2);
    }
}

