/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.update_cf;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppDownRequest;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.update_cf.CardUpdate;
import com.sun.org.apache.xalan.internal.xsltc.runtime.Hashtable;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;

public class PackageUpdateRunner_cf
extends JFrame
implements ActionListener {
    Container contentPane;
    JButton btUpload;
    String host;
    CardUpdate[] panCard;
    private Hashtable m_htCardInfo = new Hashtable();
    private int m_iCardTotal;
    public static final String CARD_CNF = "CNF";
    public static final String CARD_SVMi20i = "SVMi-20i";

    public PackageUpdateRunner_cf(String title, String[] args) {
        super(title);
        this.getCardInfo();
        this.makeGUI();
        String[] addr = args[0].split(":");
        this.host = addr[0];
    }

    public PackageUpdateRunner_cf(String title) {
        super(title);
        this.getCardInfo();
        this.getSVMi20iCardInfo();
        if (this.m_htCardInfo.size() == 0) {
            AppGlobal.showInfoMessage("Package Update", "Available cards are not attached to the system.");
            this.dispose();
        } else {
            this.makeGUI();
            this.host = "";
        }
    }

    public static void main(String[] args) {
        new PackageUpdateRunner_cf(AppLang.getText("Package Update"), args);
    }

    public void makeGUI() {
        this.setLocation(0, 0);
        this.setPreferredSize(new Dimension(850, 70 + this.m_iCardTotal * 170));
        this.setResizable(false);
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(null);
        this.panCard = new CardUpdate[this.m_iCardTotal];
        int i2 = 0;
        while (i2 < this.m_iCardTotal) {
            this.panCard[i2] = new CardUpdate(this, i2 + 1, (String)this.m_htCardInfo.get((Object)i2));
            this.panCard[i2].setLocation(0, i2 * 170);
            this.contentPane.add(this.panCard[i2]);
            ++i2;
        }
        this.btUpload = new JButton(AppLang.getText("Upload"));
        this.btUpload.setSize(100, 20);
        this.btUpload.setLocation(700, 3 + this.m_iCardTotal * 170);
        this.contentPane.add(this.btUpload);
        this.btUpload.addActionListener(this);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    public void allCardInfoUpdate(String sFilePath, String sFileVer, Boolean bRestart, String sCardName) {
        int i2 = 0;
        while (i2 < this.m_iCardTotal) {
            this.panCard[i2].CardInfoUpdate(sFilePath, sFileVer, bRestart, sCardName);
            ++i2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String ac = e2.getActionCommand();
        if (ac.equals(AppLang.getText("Upload"))) {
            int i2 = 0;
            while (i2 < this.m_iCardTotal) {
                this.panCard[i2].DoUpdate();
                ++i2;
            }
        }
    }

    private void getCardInfo() {
        AppPageInfo reqCardInfo = new AppPageInfo("9102");
        AppComm comm2 = AppComm.getInstance();
        if (AppDownRequest.requestDownloadByPageInfo(comm2, reqCardInfo)) {
            ArrayList cardInfoData = (ArrayList)reqCardInfo.getRecvData().get(0);
            int i2 = 0;
            int k2 = 0;
            while (i2 < 4) {
                if (((String)cardInfoData.get(k2 + 13)).equals("1")) {
                    String cab = (String)cardInfoData.get(k2 + 4);
                    String slot = (String)cardInfoData.get(k2 + 5);
                    this.m_htCardInfo.put((Object)this.m_iCardTotal++, (Object)("C" + cab + " - " + "S" + slot + ";" + (String)cardInfoData.get(k2 + 11) + ";" + (String)cardInfoData.get(k2 + 15) + ";" + (String)cardInfoData.get(i2 + 68) + ";" + CARD_CNF));
                }
                ++i2;
                k2 += 12;
            }
        }
    }

    private void getSVMi20iCardInfo() {
        try {
            ArrayList cardInfoData;
            AppPageInfo reqCardInfo = new AppPageInfo("2217");
            AppComm comm2 = AppComm.getInstance();
            if (AppDownRequest.requestDownloadByPageInfo(comm2, reqCardInfo) && (cardInfoData = (ArrayList)reqCardInfo.getRecvData().get(0)).get(22).equals("255")) {
                String cab = (String)cardInfoData.get(0);
                String slot = (String)cardInfoData.get(1);
                this.m_htCardInfo.put((Object)this.m_iCardTotal++, (Object)("C" + cab + " - " + "S" + slot + ";" + (String)cardInfoData.get(19) + ";" + (String)cardInfoData.get(20) + ";" + (String)cardInfoData.get(21) + ";" + CARD_SVMi20i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

