/*
 * Decompiled with CFR 0.152.
 */
package com.sun.misc;

import com.sun.misc.REException;
import com.sun.misc.RegexpNode;
import com.sun.misc.RegexpTarget;
import java.io.PrintStream;

public class RegexpPool {
    private RegexpNode prefixMachine = new RegexpNode();
    private RegexpNode suffixMachine = new RegexpNode();
    private static final int BIG = Integer.MAX_VALUE;
    private int lastDepth = Integer.MAX_VALUE;

    public void add(String re, Object ret) throws REException {
        this.add(re, ret, false);
    }

    public void replace(String re, Object ret) {
        try {
            this.add(re, ret, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object delete(String re) {
        RegexpNode p2;
        Object o2 = null;
        RegexpNode best = p2 = this.prefixMachine;
        int len = re.length() - 1;
        boolean prefix = true;
        if (!re.startsWith("*") || !re.endsWith("*")) {
            ++len;
        }
        if (len <= 0) {
            return null;
        }
        int i2 = 0;
        while (p2 != null) {
            if (!(p2.result == null || p2.depth >= Integer.MAX_VALUE || p2.exact && i2 != len)) {
                best = p2;
            }
            if (i2 >= len) break;
            p2 = p2.find(re.charAt(i2));
            ++i2;
        }
        p2 = this.suffixMachine;
        i2 = len;
        while (--i2 >= 0 && p2 != null) {
            if (p2.result != null && p2.depth < Integer.MAX_VALUE) {
                prefix = false;
                best = p2;
            }
            p2 = p2.find(re.charAt(i2));
        }
        if (prefix) {
            if (re.equals(best.re)) {
                o2 = best.result;
                best.result = null;
            }
        } else if (re.equals(best.re)) {
            o2 = best.result;
            best.result = null;
        }
        return o2;
    }

    public Object match(String s2) {
        return this.matchAfter(s2, Integer.MAX_VALUE);
    }

    public Object matchNext(String s2) {
        return this.matchAfter(s2, this.lastDepth);
    }

    private void add(String re, Object ret, boolean replace) throws REException {
        RegexpNode p2;
        int len = re.length();
        if (re.charAt(0) == '*') {
            p2 = this.suffixMachine;
            while (len > 1) {
                p2 = p2.add(re.charAt(--len));
            }
        } else {
            boolean exact = false;
            if (re.charAt(len - 1) == '*') {
                --len;
            } else {
                exact = true;
            }
            p2 = this.prefixMachine;
            int i2 = 0;
            while (i2 < len) {
                p2 = p2.add(re.charAt(i2));
                ++i2;
            }
            p2.exact = exact;
        }
        if (p2.result != null && !replace) {
            throw new REException(String.valueOf(re) + " is a duplicate");
        }
        p2.re = re;
        p2.result = ret;
    }

    private Object matchAfter(String s2, int lastMatchDepth) {
        RegexpNode p2;
        RegexpNode best = p2 = this.prefixMachine;
        int bst = 0;
        int bend = 0;
        int len = s2.length();
        if (len <= 0) {
            return null;
        }
        int i2 = 0;
        while (p2 != null) {
            if (!(p2.result == null || p2.depth >= lastMatchDepth || p2.exact && i2 != len)) {
                this.lastDepth = p2.depth;
                best = p2;
                bst = i2;
                bend = len;
            }
            if (i2 >= len) break;
            p2 = p2.find(s2.charAt(i2));
            ++i2;
        }
        p2 = this.suffixMachine;
        i2 = len;
        while (--i2 >= 0 && p2 != null) {
            if (p2.result != null && p2.depth < lastMatchDepth) {
                this.lastDepth = p2.depth;
                best = p2;
                bst = 0;
                bend = i2 + 1;
            }
            p2 = p2.find(s2.charAt(i2));
        }
        Object o2 = best.result;
        if (o2 != null && o2 instanceof RegexpTarget) {
            o2 = ((RegexpTarget)o2).found(s2.substring(bst, bend));
        }
        return o2;
    }

    public void reset() {
        this.lastDepth = Integer.MAX_VALUE;
    }

    public void print(PrintStream out) {
        out.print("Regexp pool:\n");
        if (this.suffixMachine.firstchild != null) {
            out.print(" Suffix machine: ");
            this.suffixMachine.firstchild.print(out);
            out.print("\n");
        }
        if (this.prefixMachine.firstchild != null) {
            out.print(" Prefix machine: ");
            this.prefixMachine.firstchild.print(out);
            out.print("\n");
        }
    }
}

