/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import jxl.biff.IntegerHelper;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

final class EscherRecordData {
    private int pos;
    private int instance;
    private int version;
    private int recordId;
    private int length;
    private boolean container;
    private EscherRecordType type;
    private EscherStream escherStream;

    public EscherRecordData(EscherStream dg2, int p2) {
        this.escherStream = dg2;
        this.pos = p2;
        byte[] data = this.escherStream.getData();
        int value = IntegerHelper.getInt(data[this.pos], data[this.pos + 1]);
        this.instance = (value & 0xFFF0) >> 4;
        this.version = value & 0xF;
        this.recordId = IntegerHelper.getInt(data[this.pos + 2], data[this.pos + 3]);
        this.length = IntegerHelper.getInt(data[this.pos + 4], data[this.pos + 5], data[this.pos + 6], data[this.pos + 7]);
        this.container = this.version == 15;
    }

    public EscherRecordData(EscherRecordType t2) {
        this.type = t2;
        this.recordId = this.type.getValue();
    }

    public boolean isContainer() {
        return this.container;
    }

    public int getLength() {
        return this.length;
    }

    public int getRecordId() {
        return this.recordId;
    }

    EscherStream getDrawingGroup() {
        return this.escherStream;
    }

    int getPos() {
        return this.pos;
    }

    EscherRecordType getType() {
        if (this.type == null) {
            this.type = EscherRecordType.getType(this.recordId);
        }
        return this.type;
    }

    int getInstance() {
        return this.instance;
    }

    void setContainer(boolean c2) {
        this.container = c2;
    }

    void setInstance(int inst) {
        this.instance = inst;
    }

    void setLength(int l2) {
        this.length = l2;
    }

    void setVersion(int v2) {
        this.version = v2;
    }

    byte[] setHeaderData(byte[] d2) {
        byte[] data = new byte[d2.length + 8];
        System.arraycopy(d2, 0, data, 8, d2.length);
        if (this.container) {
            this.version = 15;
        }
        int value = this.instance << 4;
        IntegerHelper.getTwoBytes(value |= this.version, data, 0);
        IntegerHelper.getTwoBytes(this.recordId, data, 2);
        IntegerHelper.getFourBytes(d2.length, data, 4);
        return data;
    }

    EscherStream getEscherStream() {
        return this.escherStream;
    }

    byte[] getBytes() {
        byte[] d2 = new byte[this.length];
        System.arraycopy(this.escherStream.getData(), this.pos + 8, d2, 0, this.length);
        return d2;
    }
}

