/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.pages.utils.table.AppDataTable;
import com.sec.osdm.pages.utils.table.ISpanModel;
import com.sec.osdm.pages.utils.table.SpanInfo;
import com.sec.osdm.pages.utils.table.SpanTableCellRenderer;
import com.sec.osdm.pages.utils.table.SpanTableUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SpanTable
extends AppDataTable {
    private SpanTableCellRenderer m_rendererOfNull = new SpanTableCellRenderer();
    private SpanTableCellRenderer m_rendererOfReadOnly = new SpanTableCellRenderer(false, Color.black, Color.white);

    public SpanTable(TableModel model, boolean isPage) {
        super(model, isPage);
        this.setUI(new SpanTableUI());
        this.getTableHeader().setReorderingAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(1);
        this.setDefaultRenderer(Object.class, new SpanTableCellRenderer());
    }

    @Override
    public void setUI(TableUI ui) {
        if (ui instanceof SpanTableUI) {
            super.setUI(ui);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle sRect = super.getCellRect(row, column, includeSpacing);
        if (row < 0 || column < 0 || this.getRowCount() <= row || this.getColumnCount() <= column) {
            return sRect;
        }
        SpanInfo spanInfo = ((ISpanModel)((Object)this.getModel())).getSpanInfo();
        if (!spanInfo.isVisible(row, column)) {
            int temp_row = row;
            int temp_column = column;
            row += spanInfo.getSpan(temp_row, temp_column)[0];
            column += spanInfo.getSpan(temp_row, temp_column)[1];
        }
        int[] n2 = spanInfo.getSpan(row, column);
        int index = 0;
        int nColumnMargin = this.getColumnModel().getColumnMargin() - 1;
        int nRowMargin = this.rowMargin - 1;
        Rectangle cellFrame = new Rectangle();
        cellFrame.y = 0;
        int i2 = 0;
        while (i2 < row) {
            cellFrame.y += super.getRowHeight(i2) + nRowMargin;
            ++i2;
        }
        int aCellHeight = 0;
        int i3 = 0;
        while (i3 < n2[0]) {
            aCellHeight += super.getRowHeight(row + i3) + nRowMargin;
            ++i3;
        }
        cellFrame.height = aCellHeight;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width = aColumn.getWidth() + nColumnMargin;
            if (index == column) break;
            cellFrame.x += cellFrame.width;
            ++index;
        }
        int i4 = 0;
        while (i4 < n2[1] - 1) {
            TableColumn aColumn = enumeration.nextElement();
            cellFrame.width += aColumn.getWidth() + nColumnMargin;
            ++i4;
        }
        if (!includeSpacing) {
            Dimension spacing = this.getIntercellSpacing();
            cellFrame.setBounds(cellFrame.x + spacing.width / 2, cellFrame.y + spacing.height / 2, cellFrame.width - spacing.width, cellFrame.height - spacing.height);
        }
        return cellFrame;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            Class<?> c2 = this.getColumnClass(column);
            if (c2.equals(Object.class)) {
                Object o2 = this.getValueAt(row, column);
                if (o2 != null) {
                    if (!this.getModel().isCellEditable(row, column) || o2 instanceof String) {
                        return this.m_rendererOfReadOnly;
                    }
                    c2 = this.getValueAt(row, column).getClass();
                } else {
                    return this.m_rendererOfNull;
                }
            }
            renderer = this.getDefaultRenderer(c2);
        }
        return renderer;
    }
}

