/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.update_cf;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.update_cf.CardUpdate;
import com.sec.osdm.update_cf.SunFtpWrapper_cf;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.SwingWorker;

public class CNFUploadThread
extends Thread {
    private CardUpdate panelCard;
    private int iCabinet;
    private int iSlot;
    private String sCardIP;
    private int iCardFTPPort;
    private int iMessagePort;
    private String sFilePath;
    private Boolean bRestart;
    private String sCardName;
    private int m_progress = 0;
    private Random m_random = new Random();
    public static final String PATH_CNF = "/initrd/img/";
    public static final String PATH_SVMi20i = "/vm/system/var/ftp/";

    public CNFUploadThread(CardUpdate panelCard, int iCabinet, int iSlot, String sCardIP, int iCardFTPPort, int iMessagePort, String sFilePath, Boolean bRestart, String sCardName) {
        this.panelCard = panelCard;
        this.iCabinet = iCabinet;
        this.iSlot = iSlot;
        this.sCardIP = sCardIP;
        this.iCardFTPPort = iCardFTPPort;
        this.iMessagePort = iMessagePort;
        this.sFilePath = sFilePath;
        this.bRestart = bRestart;
        this.sCardName = sCardName;
    }

    @Override
    public void run() {
        boolean ret = this.UploadFile();
        if (ret && this.bRestart.booleanValue() && !this.CardRestart()) {
            this.panelCard.lbUPdateStatus.setText(AppLang.getText("Restart fail."));
        }
    }

    public boolean UploadFile() {
        boolean ret;
        block21: {
            DatagramSocket socket = null;
            DatagramPacket out = null;
            DatagramPacket in = null;
            InetAddress serverInet = null;
            byte[] sendBuf = new byte[132];
            byte[] recvBuf = new byte[65508];
            byte[] recvMsgID = new byte[4];
            byte[] recvResult = new byte[4];
            ret = false;
            boolean isUpdating = false;
            String[] userPath = this.sFilePath.split("\\\\");
            String fileName = userPath[userPath.length - 1];
            String systemPath = fileName;
            int pathLen = systemPath.length();
            if (pathLen > 80) {
                System.out.println(AppLang.getText("The length of system path is more than 80."));
            }
            try {
                try {
                    socket = new DatagramSocket();
                    serverInet = InetAddress.getByName(this.sCardIP);
                    out = new DatagramPacket(sendBuf, 132, serverInet, this.iMessagePort);
                    System.arraycopy(CNFUploadThread.intToByteArray(0), 0, sendBuf, 0, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(1), 0, sendBuf, 4, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(2), 0, sendBuf, 8, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(1), 0, sendBuf, 12, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(132), 0, sendBuf, 16, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(2), 0, sendBuf, 20, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(0), 0, sendBuf, 24, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(0), 0, sendBuf, 28, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(0), 0, sendBuf, 32, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(0), 0, sendBuf, 36, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(0), 0, sendBuf, 40, 4);
                    System.arraycopy(CNFUploadThread.intToByteArray(pathLen), 0, sendBuf, 44, 4);
                    System.arraycopy(systemPath.getBytes(), 0, sendBuf, 48, pathLen);
                    if (this.bRestart.booleanValue()) {
                        System.arraycopy(CNFUploadThread.intToByteArray(1), 0, sendBuf, 128, 4);
                    } else {
                        System.arraycopy(CNFUploadThread.intToByteArray(0), 0, sendBuf, 128, 4);
                    }
                    socket.send(out);
                    in = new DatagramPacket(recvBuf, 1024);
                    do {
                        socket.receive(in);
                    } while (in.getLength() == 0);
                    System.arraycopy(in.getData(), 24, recvResult, 0, 4);
                    switch (CNFUploadThread.byteArrayToInt(recvResult)) {
                        case 1: {
                            isUpdating = false;
                            break;
                        }
                        case 13: {
                            this.panelCard.lbUPdateStatus.setText(AppLang.getText("OS Error ..."));
                            isUpdating = true;
                            break;
                        }
                        case 15: {
                            this.panelCard.lbUPdateStatus.setText(AppLang.getText("Set DB Error ..."));
                            isUpdating = true;
                            break;
                        }
                        case 17: {
                            this.panelCard.lbUPdateStatus.setText(AppLang.getText("Timeout Error ..."));
                            isUpdating = true;
                            break;
                        }
                        case 20: {
                            this.panelCard.lbUPdateStatus.setText(AppLang.getText("Invalid Process ..."));
                            isUpdating = true;
                            break;
                        }
                        case 29: {
                            this.panelCard.lbUPdateStatus.setText(AppLang.getText("Busy Updaing ..."));
                            isUpdating = true;
                            break;
                        }
                        default: {
                            this.panelCard.lbUPdateStatus.setText(AppLang.getText("Unknown Error ..."));
                            isUpdating = true;
                        }
                    }
                    if (isUpdating) break block21;
                    this.ftpUpload(this.sFilePath, systemPath);
                    System.arraycopy(CNFUploadThread.intToByteArray(3), 0, sendBuf, 20, 4);
                    socket.send(out);
                    int ii = 0;
                    Task m_task = new Task();
                    m_task.execute();
                    while (true) {
                        socket.receive(in);
                        if (in.getLength() == 0) continue;
                        System.arraycopy(in.getData(), 20, recvMsgID, 0, 4);
                        if (CNFUploadThread.byteArrayToInt(recvMsgID) == 7) {
                            System.arraycopy(in.getData(), 40, recvResult, 0, 4);
                            if (CNFUploadThread.byteArrayToInt(recvResult) == 0) {
                                this.panelCard.lbUPdateStatus.setText(AppLang.getText("Update complete."));
                                ret = true;
                            } else {
                                this.panelCard.lbUPdateStatus.setText(AppLang.getText("Update fail."));
                            }
                            this.m_progress = 100;
                            m_task = null;
                            break;
                        }
                        if (CNFUploadThread.byteArrayToInt(recvMsgID) != 6) continue;
                        this.panelCard.lbUPdateStatus.setText(AppLang.getText("Updating ..."));
                        System.out.println(String.valueOf(AppLang.getText("Updating")) + " " + ++ii);
                        this.m_progress = 0;
                    }
                }
                catch (Exception e2) {
                    System.out.println(e2.getMessage());
                    System.out.println(AppLang.getText("exception"));
                    e2.printStackTrace();
                    socket.close();
                }
            }
            finally {
                socket.close();
            }
        }
        return ret;
    }

    public boolean CardRestart() {
        boolean ret = false;
        AppRequestInfo reqCardInfo = new AppRequestInfo("6301", -48, -16);
        ret = AppComm.getInstance().requestDownload(reqCardInfo.getPageInfo());
        ArrayList recVdata = new ArrayList();
        if (ret) {
            recVdata = reqCardInfo.getPageInfo().getRecvData();
            ArrayList cardInfoData = (ArrayList)recVdata.get(0);
            cardInfoData.set(2 + (this.iCabinet - 1) * 122 + 2 + (this.iSlot - 1) * 10 + 3, "1");
            recVdata.set(0, cardInfoData);
            ret = AppComm.getInstance().requestUpload(reqCardInfo.getPageInfo());
        }
        return ret;
    }

    public void ftpUpload(String localFile, String serverFile) throws IOException {
        SunFtpWrapper_cf ftp = new SunFtpWrapper_cf();
        ftp.openServer(this.sCardIP, this.iCardFTPPort);
        ftp.login("admin", "samsung");
        ftp.binary();
        if (this.sCardName.equals("CNF")) {
            boolean ret = ftp.uploadFile(localFile, PATH_CNF + serverFile, this.panelCard);
        } else {
            boolean bl2 = ftp.uploadFile(localFile, PATH_SVMi20i + serverFile, this.panelCard);
        }
        ftp.closeServer();
    }

    private static byte[] intToByteArray(int integer) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.order(ByteOrder.BIG_ENDIAN);
        buff.putInt(integer);
        return buff.array();
    }

    private static int byteArrayToInt(byte[] bytes) {
        int size = 4;
        ByteBuffer buff = ByteBuffer.allocate(4);
        byte[] newBytes = new byte[4];
        int i2 = 0;
        while (i2 < 4) {
            newBytes[i2] = i2 + bytes.length < 4 ? (byte)0 : bytes[i2 + bytes.length - 4];
            ++i2;
        }
        buff.order(ByteOrder.BIG_ENDIAN);
        buff = ByteBuffer.wrap(newBytes);
        return buff.getInt();
    }

    private static long byteArrayToUnsignedInt(byte[] bytes) {
        long l2 = 0L;
        int pos = 0;
        l2 += (long)(CNFUploadThread.unsignedByteToInt(bytes[pos++]) << 24);
        l2 += (long)(CNFUploadThread.unsignedByteToInt(bytes[pos++]) << 16);
        l2 += (long)(CNFUploadThread.unsignedByteToInt(bytes[pos++]) << 8);
        return l2 += (long)(CNFUploadThread.unsignedByteToInt(bytes[pos++]) << 0);
    }

    private static int unsignedByteToInt(byte b2) {
        return b2 & 0xFF;
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            CNFUploadThread.this.m_progress = 0;
            while (CNFUploadThread.this.m_progress <= 95) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CNFUploadThread cNFUploadThread = CNFUploadThread.this;
                cNFUploadThread.m_progress = cNFUploadThread.m_progress + CNFUploadThread.this.m_random.nextInt(4);
                ((CNFUploadThread)CNFUploadThread.this).panelCard.barProgress.setValue(CNFUploadThread.this.m_progress);
            }
            return null;
        }

        @Override
        public void done() {
        }
    }
}

