/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import jxl.biff.IntegerHelper;

public abstract class BaseCompoundFile {
    protected static final byte[] IDENTIFIER = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    protected static final int NUM_BIG_BLOCK_DEPOT_BLOCKS_POS = 44;
    protected static final int SMALL_BLOCK_DEPOT_BLOCK_POS = 60;
    protected static final int ROOT_START_BLOCK_POS = 48;
    protected static final int BIG_BLOCK_SIZE = 512;
    protected static final int SMALL_BLOCK_SIZE = 64;
    protected static final int EXTENSION_BLOCK_POS = 68;
    protected static final int NUM_EXTENSION_BLOCK_POS = 72;
    protected static final int PROPERTY_STORAGE_BLOCK_SIZE = 128;
    protected static final int BIG_BLOCK_DEPOT_BLOCKS_POS = 76;
    protected static final int SMALL_BLOCK_THRESHOLD = 4096;
    private static final int SIZE_OF_NAME_POS = 64;
    private static final int TYPE_POS = 66;
    private static final int PREVIOUS_POS = 68;
    private static final int NEXT_POS = 72;
    private static final int DIRECTORY_POS = 76;
    private static final int START_BLOCK_POS = 116;
    private static final int SIZE_POS = 120;

    protected BaseCompoundFile() {
    }

    protected class PropertyStorage {
        public String name;
        public int type;
        public int startBlock;
        public int size;
        public int previous;
        public int next;
        public int directory;
        public byte[] data;

        public PropertyStorage(byte[] d2) {
            this.data = d2;
            int nameSize = IntegerHelper.getInt(this.data[64], this.data[65]);
            this.type = this.data[66];
            this.startBlock = IntegerHelper.getInt(this.data[116], this.data[117], this.data[118], this.data[119]);
            this.size = IntegerHelper.getInt(this.data[120], this.data[121], this.data[122], this.data[123]);
            int chars = 0;
            if (nameSize > 2) {
                chars = (nameSize - 1) / 2;
            }
            StringBuffer n2 = new StringBuffer("");
            for (int i2 = 0; i2 < chars; ++i2) {
                n2.append((char)this.data[i2 * 2]);
            }
            this.name = n2.toString();
        }

        public PropertyStorage(String name) {
            this.data = new byte[128];
            Assert.verify(name.length() < 32);
            IntegerHelper.getTwoBytes((name.length() + 1) * 2, this.data, 64);
            for (int i2 = 0; i2 < name.length(); ++i2) {
                this.data[i2 * 2] = (byte)name.charAt(i2);
            }
        }

        public void setType(int t2) {
            this.type = t2;
            this.data[66] = (byte)t2;
            this.data[67] = 1;
        }

        public void setStartBlock(int sb) {
            this.startBlock = sb;
            IntegerHelper.getFourBytes(sb, this.data, 116);
        }

        public void setSize(int s2) {
            this.size = s2;
            IntegerHelper.getFourBytes(s2, this.data, 120);
        }

        public void setPrevious(int prev) {
            this.previous = prev;
            IntegerHelper.getFourBytes(prev, this.data, 68);
        }

        public void setNext(int nxt) {
            this.next = nxt;
            IntegerHelper.getFourBytes(this.next, this.data, 72);
        }

        public void setDirectory(int dir) {
            this.directory = dir;
            IntegerHelper.getFourBytes(this.directory, this.data, 76);
        }
    }
}

