/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.io.IOException;
import java.io.OutputStream;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.write.biff.CompoundFile;

public final class File {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$File == null ? (class$jxl$write$biff$File = File.class$("jxl.write.biff.File")) : class$jxl$write$biff$File);
    private byte[] data;
    private int pos;
    private OutputStream outputStream;
    private int initialFileSize;
    private int arrayGrowSize;
    private WorkbookSettings workbookSettings;
    static /* synthetic */ Class class$jxl$write$biff$File;

    File(OutputStream os, WorkbookSettings ws) {
        this.initialFileSize = ws.getInitialFileSize();
        this.arrayGrowSize = ws.getArrayGrowSize();
        this.data = new byte[this.initialFileSize];
        this.pos = 0;
        this.outputStream = os;
        this.workbookSettings = ws;
    }

    void close(boolean cs2) throws IOException {
        CompoundFile cf2 = new CompoundFile(this.data, this.pos, this.outputStream);
        cf2.write();
        this.outputStream.flush();
        if (cs2) {
            this.outputStream.close();
        }
        this.data = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public void write(ByteData record) throws IOException {
        byte[] bytes = record.getBytes();
        while (this.pos + bytes.length > this.data.length) {
            byte[] newdata = new byte[this.data.length + this.arrayGrowSize];
            System.arraycopy(this.data, 0, newdata, 0, this.pos);
            this.data = newdata;
        }
        System.arraycopy(bytes, 0, this.data, this.pos, bytes.length);
        this.pos += bytes.length;
    }

    int getPos() {
        return this.pos;
    }

    void setData(byte[] newdata, int pos) {
        System.arraycopy(newdata, 0, this.data, pos, newdata.length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

