/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.CellType;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.Number;
import jxl.write.biff.CellValue;
import jxl.write.biff.File;
import jxl.write.biff.MulRKRecord;
import jxl.write.biff.StringRecord;

class RowRecord
extends WritableRecordData {
    private byte[] data;
    private CellValue[] cells;
    private int rowHeight;
    private boolean collapsed;
    private int rowNumber;
    private int numColumns;
    private static final int growSize = 10;
    private static final int maxRKValue = 0x1FFFFFFF;
    private static final int minRKValue = -536870912;
    private static int defaultHeightIndicator = 255;

    public RowRecord(int rn) {
        super(Type.ROW);
        this.rowNumber = rn;
        this.cells = new CellValue[0];
        this.numColumns = 0;
        this.rowHeight = defaultHeightIndicator;
        this.collapsed = false;
    }

    public void setRowHeight(int h2) {
        if (h2 == 0) {
            this.setCollapsed(true);
        } else {
            this.rowHeight = h2;
        }
    }

    void setRowDetails(int height, boolean col) {
        this.rowHeight = height;
        this.collapsed = col;
    }

    public void setCollapsed(boolean c2) {
        this.collapsed = c2;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void addCell(CellValue cv2) {
        int col = cv2.getColumn();
        if (col >= this.cells.length) {
            CellValue[] oldCells = this.cells;
            this.cells = new CellValue[Math.max(oldCells.length + 10, col + 1)];
            System.arraycopy(oldCells, 0, this.cells, 0, oldCells.length);
            Object var3_3 = null;
        }
        this.cells[col] = cv2;
        this.numColumns = Math.max(col + 1, this.numColumns);
    }

    public void removeCell(int col) {
        if (col >= this.numColumns) {
            return;
        }
        this.cells[col] = null;
    }

    public void write(File outputFile) throws IOException {
        outputFile.write(this);
    }

    public void writeCells(File outputFile) throws IOException {
        ArrayList<CellValue> integerValues = new ArrayList<CellValue>();
        boolean integerValue = false;
        for (int i2 = 0; i2 < this.numColumns; ++i2) {
            integerValue = false;
            if (this.cells[i2] != null) {
                Number nc;
                if (this.cells[i2].getType() == CellType.NUMBER && (nc = (Number)this.cells[i2]).getValue() == (double)((int)nc.getValue()) && nc.getValue() < 5.36870911E8 && nc.getValue() > -5.36870912E8) {
                    integerValue = true;
                }
                if (integerValue) {
                    integerValues.add(this.cells[i2]);
                    continue;
                }
                this.writeIntegerValues(integerValues, outputFile);
                outputFile.write(this.cells[i2]);
                if (this.cells[i2].getType() != CellType.STRING_FORMULA) continue;
                StringRecord sr = new StringRecord(this.cells[i2].getContents());
                outputFile.write(sr);
                continue;
            }
            this.writeIntegerValues(integerValues, outputFile);
        }
        this.writeIntegerValues(integerValues, outputFile);
    }

    private void writeIntegerValues(ArrayList integerValues, File outputFile) throws IOException {
        if (integerValues.size() == 0) {
            return;
        }
        if (integerValues.size() >= 3) {
            MulRKRecord mulrk = new MulRKRecord(integerValues);
            outputFile.write(mulrk);
        } else {
            Iterator i2 = integerValues.iterator();
            while (i2.hasNext()) {
                outputFile.write((CellValue)i2.next());
            }
        }
        integerValues.clear();
    }

    public byte[] getData() {
        byte[] data = new byte[16];
        IntegerHelper.getTwoBytes(this.rowNumber, data, 0);
        IntegerHelper.getTwoBytes(this.numColumns, data, 4);
        IntegerHelper.getTwoBytes(this.rowHeight, data, 6);
        int options = 256;
        if (this.collapsed) {
            options |= 0x20;
        }
        if (this.rowHeight != defaultHeightIndicator) {
            options |= 0x40;
        }
        IntegerHelper.getTwoBytes(options, data, 12);
        return data;
    }

    public int getMaxColumn() {
        return this.numColumns;
    }

    public CellValue getCell(int col) {
        return col >= 0 && col < this.numColumns ? this.cells[col] : null;
    }

    void incrementRow() {
        ++this.rowNumber;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].incrementRow();
        }
    }

    void decrementRow() {
        --this.rowNumber;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].decrementRow();
        }
    }

    void insertColumn(int col) {
        if (col >= this.numColumns) {
            return;
        }
        CellValue[] oldCells = this.cells;
        this.cells = this.numColumns >= this.cells.length - 1 ? new CellValue[oldCells.length + 10] : new CellValue[oldCells.length];
        System.arraycopy(oldCells, 0, this.cells, 0, col);
        System.arraycopy(oldCells, col, this.cells, col + 1, this.numColumns - col);
        for (int i2 = col + 1; i2 <= this.numColumns; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].incrementColumn();
        }
        ++this.numColumns;
    }

    void removeColumn(int col) {
        if (col >= this.numColumns) {
            return;
        }
        CellValue[] oldCells = this.cells;
        this.cells = new CellValue[oldCells.length];
        System.arraycopy(oldCells, 0, this.cells, 0, col);
        System.arraycopy(oldCells, col + 1, this.cells, col, this.numColumns - (col + 1));
        for (int i2 = col; i2 < this.numColumns; ++i2) {
            if (this.cells[i2] == null) continue;
            this.cells[i2].decrementColumn();
        }
        --this.numColumns;
    }

    public boolean isDefaultHeight() {
        return this.rowHeight == defaultHeightIndicator;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }
}

