/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.oroinc.net.ftp.FTPClient;
import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPReply;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class AppFTPClient {
    private FTPClient m_ftpClient = null;
    private String m_ipServer = null;
    private int m_ftpPort = 0;

    public AppFTPClient() {
        Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        this.m_ipServer = (String)linkInfo.get("IP_ADDRESS");
        this.m_ftpPort = Integer.parseInt((String)linkInfo.get("FTP_PORT"));
        this.m_ftpClient = new FTPClient();
    }

    public void setServerIP(String server) {
        this.m_ipServer = server;
    }

    public void setFtpPort(int port) {
        this.m_ftpPort = port;
    }

    public boolean connect(String id, String pwd) {
        try {
            if (this.m_ftpClient.isConnected()) {
                this.disConnect();
            }
            this.m_ftpClient.connect(this.m_ipServer, this.m_ftpPort);
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to connect to FTP server."));
            return false;
        }
        int reply = this.m_ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            this.disConnect();
            AppGlobal.showErrorMessage("", AppLang.getText("FTP server refused connection."));
            return false;
        }
        try {
            this.m_ftpClient.login(id, pwd);
            return true;
        }
        catch (IOException e3) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to login to FTP server"));
            return false;
        }
    }

    public HashMap<String, String> getFileSize(String directory) {
        HashMap<String, String> hmSize = new HashMap<String, String>();
        try {
            FTPFile[] files = this.m_ftpClient.listFiles(directory);
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    if (files[i2].isFile()) {
                        hmSize.put(files[i2].getName(), String.format("%s", files[i2].getSize()));
                    }
                    ++i2;
                }
            }
        }
        catch (FileNotFoundException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("File not found."));
        }
        catch (IOException e3) {
            AppGlobal.showErrorMessage("", AppLang.getText("There are not files."));
        }
        return hmSize;
    }

    public HashMap<String, String> getFileDate(String directory) {
        HashMap<String, String> hmSize = new HashMap<String, String>();
        try {
            FTPFile[] files = this.m_ftpClient.listFiles(directory);
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    if (files[i2].isFile()) {
                        hmSize.put(files[i2].getName(), String.format("%s", files[i2].getTimestamp().getTime()));
                    }
                    ++i2;
                }
            }
        }
        catch (FileNotFoundException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("File not found."));
        }
        catch (IOException e3) {
            AppGlobal.showErrorMessage("", AppLang.getText("There are not files."));
        }
        return hmSize;
    }

    public ArrayList getList(String dir) {
        ArrayList<String> alResult = new ArrayList<String>();
        try {
            FTPFile[] files = this.m_ftpClient.listFiles(dir);
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    alResult.add(files[i2].getName());
                    ++i2;
                }
            }
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("There are not files."));
        }
        return alResult;
    }

    public ArrayList getDirList(String dir) {
        ArrayList<String> alResult = new ArrayList<String>();
        try {
            FTPFile[] files = this.m_ftpClient.listFiles(dir);
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    if (files[i2].isDirectory()) {
                        alResult.add(files[i2].getName());
                    }
                    ++i2;
                }
            }
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("There are not directories."));
        }
        return alResult;
    }

    public ArrayList getFileList(String dir) {
        ArrayList<String> alResult = new ArrayList<String>();
        try {
            FTPFile[] files = this.m_ftpClient.listFiles(dir);
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    if (files[i2].isFile()) {
                        alResult.add(files[i2].getName());
                    }
                    ++i2;
                }
            }
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("There are not files."));
        }
        return alResult;
    }

    public ArrayList getFileList(String dir, String ext) {
        ArrayList<String> alResult = new ArrayList<String>();
        try {
            FTPFile[] files = this.m_ftpClient.listFiles(dir);
            if (files != null) {
                int i2 = 0;
                while (i2 < files.length) {
                    if (files[i2].isFile() && files[i2].getName().endsWith("." + ext)) {
                        alResult.add(files[i2].getName());
                    }
                    ++i2;
                }
            }
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("There are not specified files."));
        }
        return alResult;
    }

    public boolean getFile(String source, String target) {
        boolean result = false;
        File tFile = new File(target);
        if (tFile.exists()) {
            tFile.delete();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(tFile);
            result = this.m_ftpClient.retrieveFile(source, os);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("File not found."));
        }
        catch (Exception e3) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to get file."));
        }
        return result;
    }

    public ArrayList getFileContents(String file) {
        ArrayList<String> alResult = new ArrayList<String>();
        StringTokenizer token = null;
        byte[] bytes = new byte[0xA00000];
        int count = 0;
        int offset = 0;
        InputStream is = null;
        try {
            is = this.m_ftpClient.retrieveFileStream(file);
            Object str = null;
            while ((count = is.read(bytes, offset, bytes.length - offset)) != -1) {
                offset += count;
            }
            is.close();
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("There are not files."));
        }
        String strData = new String(bytes, 0, offset, Charset.forName("UTF-8"));
        if (strData != null && !strData.equals("")) {
            token = new StringTokenizer(strData, "\n");
            while (token.hasMoreTokens()) {
                alResult.add(token.nextToken());
            }
        }
        return alResult;
    }

    public Hashtable getFileContents(ArrayList fileDir, ArrayList fileName) {
        Hashtable htResult = new Hashtable();
        int i2 = 0;
        while (i2 < fileDir.size()) {
            StringTokenizer token = null;
            byte[] bytes = new byte[0x100000];
            int count = 0;
            int offset = 0;
            try {
                InputStream is = this.m_ftpClient.retrieveFileStream((String)fileDir.get(i2));
                while ((count = is.read(bytes, offset, bytes.length - offset)) != -1) {
                    offset += count;
                }
                is.close();
                this.m_ftpClient.completePendingCommand();
            }
            catch (IOException e2) {
                AppGlobal.showErrorMessage("", String.valueOf((String)fileDir.get(i2)) + " >> " + AppLang.getText("There are not files."));
            }
            String strData = new String(bytes, 0, offset, Charset.forName("UTF-8"));
            if (strData != null && !strData.equals("")) {
                token = new StringTokenizer(strData, "\n");
                ArrayList<String> alResult = new ArrayList<String>();
                while (token.hasMoreTokens()) {
                    alResult.add(token.nextToken());
                }
                htResult.put((String)fileName.get(i2), alResult);
            }
            ++i2;
        }
        return htResult;
    }

    public Hashtable getFileContentsAll(ArrayList fileDir, ArrayList fileName) {
        Hashtable htResult = new Hashtable();
        int i2 = 0;
        while (i2 < fileDir.size()) {
            StringTokenizer token = null;
            byte[] bytes = new byte[0x100000];
            int count = 0;
            int offset = 0;
            try {
                InputStream is = this.m_ftpClient.retrieveFileStream((String)fileDir.get(i2));
                while ((count = is.read(bytes, offset, bytes.length - offset)) != -1) {
                    offset += count;
                }
                is.close();
                this.m_ftpClient.completePendingCommand();
            }
            catch (IOException e2) {
                AppGlobal.showErrorMessage("", String.valueOf((String)fileDir.get(i2)) + " >> " + AppLang.getText("There are not files."));
            }
            String strData = new String(bytes, 0, offset, Charset.forName("UTF-8"));
            token = new StringTokenizer(strData, "\n");
            ArrayList<String> alResult = new ArrayList<String>();
            while (token.hasMoreTokens()) {
                alResult.add(token.nextToken());
            }
            htResult.put((String)fileName.get(i2), alResult);
            ++i2;
        }
        return htResult;
    }

    public boolean putFile(String source, String target) {
        boolean result = false;
        File putFile = new File(source);
        FileInputStream is = null;
        try {
            is = new FileInputStream(putFile);
            result = this.m_ftpClient.storeFile(target, is);
            if (!result) {
                AppGlobal.showErrorMessage("", "storeFile() - " + this.m_ftpClient.getReplyString());
            }
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("File not found."));
        }
        catch (IOException e3) {
            AppGlobal.showErrorMessage("", e3.getMessage());
        }
        return result;
    }

    public boolean putFiles(String source, String target) {
        boolean result = false;
        File putFile = new File(source);
        FileInputStream is = null;
        try {
            this.m_ftpClient.setFileType(2);
            this.m_ftpClient.setFileTransferMode(10);
            is = new FileInputStream(putFile);
            result = this.m_ftpClient.storeFile(target, is);
            if (!result) {
                AppGlobal.showErrorMessage("", "storeFile() - " + this.m_ftpClient.getReplyString());
            }
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("File not found."));
        }
        catch (IOException e3) {
            AppGlobal.showErrorMessage("", e3.getMessage());
        }
        return result;
    }

    public boolean makeDir(String dir) {
        try {
            return this.m_ftpClient.makeDirectory(dir);
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to make directory."));
            return false;
        }
    }

    public boolean changeDir(String dir) {
        try {
            return this.m_ftpClient.changeWorkingDirectory(dir);
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to change directory."));
            return false;
        }
    }

    public boolean removeDir(String dir) {
        try {
            return this.m_ftpClient.removeDirectory(dir);
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to delete directory."));
            return false;
        }
    }

    public boolean removeFile(String file) {
        try {
            return this.m_ftpClient.deleteFile(file);
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to delete file."));
            return false;
        }
    }

    public void disConnect() {
        try {
            if (this.m_ftpClient != null) {
                this.m_ftpClient.logout();
                this.m_ftpClient.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void abort() {
        try {
            if (this.m_ftpClient != null) {
                this.m_ftpClient.disconnect();
            }
        }
        catch (IOException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed abort file."));
        }
    }
}

