/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppDateTimer;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.view.StatusLabel;
import com.sec.osdm.pages.utils.AppCountry;
import com.sec.osdm.pages.utils.AppSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.JPanel;

public class AppStatusBar
extends JPanel {
    private AppDateTimer m_panTime = new AppDateTimer();
    private StatusLabel m_lbLink = new StatusLabel(AppLang.getText("Normal"), AppLang.getText("Link Type"));
    private StatusLabel m_lbTarget = new StatusLabel(AppLang.getText("None"), AppLang.getText("Connected/Opened Target"));
    private StatusLabel m_lbMessage = new StatusLabel("", AppLang.getText("Status Message"));
    private StatusLabel m_lbSystem = new StatusLabel(AppLang.getText("None"), AppLang.getText("System Type"));
    private StatusLabel m_lbCountry = new StatusLabel(AppLang.getText("None"), AppLang.getText("Country"));

    public AppStatusBar() {
        super(new BorderLayout());
        JPanel panStatusWest = AppImages.getImage(AppImages.Img_Status1);
        JPanel panStatusCenter = AppImages.getImage(AppImages.Img_Status2, AppGlobal.g_maxWidth, 23);
        JPanel panStatusEast = AppImages.getImage(AppImages.Img_Status3);
        panStatusWest.setPreferredSize(new Dimension(AppImages.Img_Status1.getIconWidth(), AppImages.Img_Status1.getIconHeight()));
        panStatusEast.setPreferredSize(new Dimension(AppImages.Img_Status3.getIconWidth(), AppImages.Img_Status3.getIconHeight()));
        panStatusCenter.setLayout(new BorderLayout());
        JPanel panStatusInfo1 = new JPanel(new BorderLayout());
        panStatusInfo1.setOpaque(false);
        panStatusInfo1.add((Component)this.m_lbLink, "West");
        panStatusInfo1.add((Component)this.m_lbTarget, "Center");
        JPanel panStatusInfo2 = new JPanel(new GridLayout(1, 2));
        panStatusInfo2.setOpaque(false);
        panStatusInfo2.add(this.m_lbSystem);
        panStatusInfo2.add(this.m_lbCountry);
        JPanel panStatusInfo3 = new JPanel(new BorderLayout());
        panStatusInfo3.setOpaque(false);
        panStatusInfo3.add((Component)panStatusInfo1, "Center");
        panStatusInfo3.add((Component)this.m_lbMessage, "East");
        panStatusCenter.add((Component)panStatusInfo3, "Center");
        panStatusCenter.add((Component)panStatusInfo2, "East");
        panStatusEast.setLayout(new BorderLayout());
        panStatusEast.add((Component)this.m_panTime, "Center");
        this.add((Component)panStatusWest, "West");
        this.add((Component)panStatusCenter, "Center");
        this.add((Component)panStatusEast, "East");
        this.setPreferredSize(new Dimension(AppGlobal.g_maxWidth, 23));
    }

    public void setStatusBar() {
        Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        if (AppRunInfo.getRunMode() == 0) {
            this.m_lbLink.setText(AppLang.getText("Normal"));
            this.m_lbTarget.setText(AppLang.getText("None"));
            this.m_lbTarget.setToolTipText(AppLang.getText("Connected/Opened Target"));
            this.m_lbSystem.setText(AppLang.getText("None"));
            this.m_lbCountry.setText(AppLang.getText("None"));
            this.m_lbMessage.setText(AppLang.getText(""));
        } else {
            if (AppRunInfo.getRunMode() == 1) {
                this.m_lbLink.setText(AppLang.getText("DB File"));
                this.m_lbTarget.setText(AppRunInfo.getFileName());
                this.m_lbTarget.setToolTipText(AppRunInfo.getFilePath());
            } else {
                this.m_lbLink.setText("LAN-" + AppProperty.m_properties.get("USER_ID"));
                String sSiteName = (String)linkInfo.get("SITE_NAME");
                if (sSiteName == null) {
                    sSiteName = "Quick";
                }
                String sValue = String.valueOf(sSiteName) + "-" + (String)linkInfo.get("IP_ADDRESS");
                if (((String)linkInfo.get("LINK_KIND")).equals("MODEM")) {
                    this.m_lbLink.setText("MODEM-" + AppProperty.m_properties.get("USER_ID"));
                    sValue = String.valueOf(sSiteName) + "-" + (String)linkInfo.get("TEL_NUMBER") + ":";
                    sValue = String.valueOf(sValue) + "COM" + (String)linkInfo.get("COM_PORT") + ":" + (String)linkInfo.get("BAUD_RATE") + "bps";
                }
                this.m_lbTarget.setText(sValue);
            }
            this.m_lbSystem.setText(AppSystem.getSystemName(AppRunInfo.getSystem()));
            this.m_lbCountry.setText(AppCountry.getCountryName(AppRunInfo.getCountry()));
            this.m_lbMessage.setText(AppRunInfo.getSysVersion());
        }
    }

    public void setStatusMessage(String message) {
        this.m_lbMessage.setText(message);
    }
}

