/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.systemcontrol;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class P6501CPUMemoryUsage
extends AppPage {
    private RefreshThread m_thread = null;
    private JComboBox m_cbRefresh = null;
    private JLabel m_lbRefresh = null;
    private int m_refTime = 10;
    private int m_curTime = 0;

    public P6501CPUMemoryUsage(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        pageInfo.setDownMsgType((byte)-48);
        this.requestDownload();
    }

    @Override
    public void createPage() {
        this.createComponents();
        this.createTable();
    }

    public void createComponents() {
        String[] strSec = new String[]{"10", "20", "30", "60"};
        this.m_lbRefresh = new JLabel(AppLang.getText("Refresh Timer(sec)"));
        this.m_cbRefresh = new JComboBox<String>(strSec);
        this.m_cbRefresh.addItemListener(new GroupChangeListener());
        JPanel topPan1 = new JPanel();
        topPan1.add(this.m_lbRefresh);
        topPan1.add(this.m_cbRefresh);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)topPan1, "Before");
        this.m_jspTop.getViewport().setView(topPanel);
        this.m_jspTop.setVisible(true);
        this.setComponents();
    }

    private void setComponents() {
        if (this.m_recvData != null && this.m_recvData.size() > 0) {
            this.resetComponent();
            ArrayList recvData = (ArrayList)this.m_recvData.get(0);
            ArrayList<Object> compData = null;
            int i2 = 0;
            while (i2 < this.m_rowTitle.length) {
                compData = new ArrayList<Object>();
                compData.add(0, this.createComponent(i2, (String)recvData.get(this.m_pageInfo.getDataPosition(i2))));
                this.m_components.add(i2, compData);
                ++i2;
            }
        }
    }

    private void resetComponent() {
        this.m_components.clear();
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.removePrintTable(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
    }

    @Override
    public void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return ((ArrayList)P6501CPUMemoryUsage.this.m_components.get(row)).get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setRowWidth(new int[]{200});
        this.m_model.setColWidth(new int[]{200});
        this.m_table = new AppTable(this.m_model);
        this.m_table.setPreferredSize(new Dimension(600, this.m_model.getRowHdrRowCount() * 25));
        this.m_contentPane.add((Component)this.m_table, "Center");
        if (this.m_thread == null) {
            this.m_thread = new RefreshThread();
            this.m_thread.start();
            AppGlobal.g_threadList.add(this.m_thread);
        }
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("Reload")) {
            this.m_curTime = 0;
        } else if (command.equals("Close") && this.m_thread != null) {
            this.m_thread.stop();
            this.m_thread = null;
            AppGlobal.g_threadList.remove(this.m_thread);
        }
        this.actionPageToolButton(command);
    }

    class GroupChangeListener
    implements ItemListener {
        GroupChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e2) {
            if (e2.getStateChange() == 1) {
                P6501CPUMemoryUsage.this.m_curTime = 0;
                P6501CPUMemoryUsage.this.m_refTime = Integer.parseInt((String)P6501CPUMemoryUsage.this.m_cbRefresh.getSelectedItem());
            }
        }
    }

    class RefreshThread
    extends Thread {
        private boolean m_bResult = false;

        RefreshThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    RefreshThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                P6501CPUMemoryUsage p6501CPUMemoryUsage = P6501CPUMemoryUsage.this;
                p6501CPUMemoryUsage.m_curTime = p6501CPUMemoryUsage.m_curTime + 1;
                if (P6501CPUMemoryUsage.this.m_refTime != P6501CPUMemoryUsage.this.m_curTime) continue;
                P6501CPUMemoryUsage.this.m_recvData.clear();
                this.m_bResult = AppComm.getInstance().requestDownload(P6501CPUMemoryUsage.this.m_pageInfo);
                if (this.m_bResult) {
                    P6501CPUMemoryUsage.this.m_recvData = P6501CPUMemoryUsage.this.m_pageInfo.getRecvData();
                    P6501CPUMemoryUsage.this.setComponents();
                    P6501CPUMemoryUsage.this.createTable();
                    P6501CPUMemoryUsage.this.setPrintableComponent(P6501CPUMemoryUsage.this.m_table);
                    P6501CPUMemoryUsage.this.m_contentPane.repaint();
                }
                P6501CPUMemoryUsage.this.m_curTime = 0;
            }
        }
    }
}

