/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.io.AppLockOut;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import javax.swing.JTable;
import javax.swing.SizeSequence;
import javax.swing.table.TableModel;

public class AppHiddenTable
extends JTable
implements KeyListener,
MouseListener {
    public AppHiddenTable(TableModel tm) {
        super(tm);
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public AppHiddenTable(int row, int column) {
        super(row, column);
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        try {
            Class<JTable> jTableClass = JTable.class;
            Method getRowModelMethod = jTableClass.getDeclaredMethod("getRowModel", null);
            getRowModelMethod.setAccessible(true);
            SizeSequence rowModel = (SizeSequence)getRowModelMethod.invoke((Object)this, null);
            if (rowHeight < 0) {
                throw new IllegalArgumentException("New row height less than 0");
            }
            rowModel.setSize(row, rowHeight);
            this.resizeAndRepaint();
        }
        catch (Exception ex) {
            super.setRowHeight(row, rowHeight);
        }
    }

    protected boolean isRowHidden(int row) {
        return this.getRowHeight(row) == 0;
    }

    protected boolean isColHidden(int col) {
        return this.getTableHeader().getColumnModel().getColumn(col).getPreferredWidth() == 0;
    }

    protected void adjustRightSelection(boolean fModifier) {
        int newCol = this.getLastSelectedColumn();
        if (!this.isColHidden(newCol)) {
            return;
        }
        do {
            if (++newCol < this.getColumnCount()) continue;
            this.adjustLeftSelection(fModifier);
            return;
        } while (this.isColHidden(newCol));
        this.changeSelection(this.getLastSelectedRow(), newCol, false, fModifier);
    }

    protected void adjustLeftSelection(boolean fModifier) {
        int newCol = this.getLastSelectedColumn();
        if (!this.isColHidden(newCol)) {
            return;
        }
        do {
            if (--newCol >= 0) continue;
            this.adjustRightSelection(fModifier);
            return;
        } while (this.isColHidden(newCol));
        this.changeSelection(this.getLastSelectedRow(), newCol, false, fModifier);
    }

    protected void adjustUpSelection(boolean fModifier) {
        int newRow = this.getLastSelectedRow();
        if (!this.isRowHidden(newRow)) {
            return;
        }
        do {
            if (--newRow >= 0) continue;
            this.adjustDownSelection(fModifier);
            return;
        } while (this.isRowHidden(newRow));
        this.changeSelection(newRow, this.getLastSelectedColumn(), false, fModifier);
    }

    protected void adjustEnterMove() {
        int newRow = this.getSelectedRow();
        int newCol = this.getSelectedColumn();
        if (newRow >= 0 && this.isRowHidden(newRow)) {
            this.adjustDownSelection(false);
        }
        if (newCol >= 0 && this.isColHidden(newCol)) {
            this.adjustRightSelection(false);
        }
    }

    protected void adjustDownSelection(boolean fModifier) {
        int newRow = this.getLastSelectedRow();
        if (!this.isRowHidden(newRow)) {
            return;
        }
        do {
            if (++newRow < this.getRowCount()) continue;
            this.adjustUpSelection(fModifier);
            return;
        } while (this.isRowHidden(newRow));
        this.changeSelection(newRow, this.getLastSelectedColumn(), false, fModifier);
    }

    private void setLockout() {
        AppLockOut.m_eventLock = true;
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        this.setLockout();
        boolean fModifier = false;
        int keyCode = e2.getKeyCode();
        if ((e2.getModifiersEx() & 0x40) == 64) {
            fModifier = true;
        }
        switch (keyCode) {
            case 39: {
                this.adjustRightSelection(fModifier);
                break;
            }
            case 37: {
                this.adjustLeftSelection(fModifier);
                break;
            }
            case 38: {
                this.adjustUpSelection(fModifier);
                break;
            }
            case 10: {
                this.adjustEnterMove();
                break;
            }
            case 40: {
                this.adjustDownSelection(fModifier);
            }
        }
    }

    protected int getAnchorRow() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    protected int getAnchorColumn() {
        return this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
    }

    protected int getLastSelectedColumn() {
        int nSelectedCount = this.getSelectedColumnCount();
        if (nSelectedCount == 0) {
            return -1;
        }
        int[] arrSelectedColumn = this.getSelectedColumns();
        if (this.getAnchorColumn() == arrSelectedColumn[0]) {
            return arrSelectedColumn[nSelectedCount - 1];
        }
        return arrSelectedColumn[0];
    }

    protected int getLastSelectedRow() {
        int nSelectedCount = this.getSelectedRowCount();
        if (nSelectedCount == 0) {
            return -1;
        }
        int[] arrSelectedRow = this.getSelectedRows();
        if (this.getAnchorRow() == arrSelectedRow[0]) {
            return arrSelectedRow[nSelectedCount - 1];
        }
        return arrSelectedRow[0];
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.setLockout();
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }
}

