/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.pages.AppRequestInfo;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.vmaa.P2006PromptEncodeMain;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P2006PromptUploadDlg
extends JDialog
implements ActionListener {
    private P2006PromptUploadDlg m_oThis = null;
    private AppFTPClient m_ftp = new AppFTPClient();
    private AppRequestInfo m_reqInfo = null;
    private AppTable m_table = null;
    private AppTableModel m_model = null;
    private String[][] strRowNames = new String[10][1];
    private String[][] strColNames = new String[][]{{"No", "File", "Select"}};
    private JFileChooser m_jfc = null;
    private File m_selFile = null;
    private JButton m_btnClose = new JButton(AppLang.getText("Close"));
    private JButton m_btnUpload = new JButton(AppLang.getText("Upload"));
    private JButton[] m_btnFile = new JButton[10];
    private JLabel[] m_lblNo = new JLabel[10];
    private JLabel[] m_lblFile = new JLabel[10];
    private ArrayList m_compList = new ArrayList();
    private String m_dirPath = null;
    private String[] m_fileName = new String[10];
    private int nCount = 0;
    private ArrayList nList = null;
    private String m_path = null;
    private String[] m_name = new String[10];
    private String[] m_ext = new String[10];
    private JTextArea m_txtArea = null;

    public P2006PromptUploadDlg(String path) {
        super(AppGlobal.g_frmMain, AppLang.getText("Upload Prompt"), true);
        AppGlobal.g_dialogList.add(this);
        this.setIconImage(AppImages.Img_Logo);
        this.setDialog(path);
        this.createTable();
        this.m_txtArea = new JTextArea();
        this.m_txtArea.setEditable(false);
        this.m_txtArea.setBorder(BorderFactory.createLineBorder(new Color(113, 184, 255)));
        String txtDesc = "  " + AppLang.getText("[ Supported Voice File Format ]") + " \n" + "  " + AppLang.getText("wav : 8000Hz/Mono/16bit signed/128kbps") + " \n";
        this.m_txtArea.setText(txtDesc);
        txtDesc = AppRunInfo.getSystem() == 23 || AppRunInfo.getSystem() == 55 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50 || AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 ? String.valueOf(txtDesc) + "  " + AppLang.getText("G.711 : 8000Hz/Mono/mulaw/64kbps") + " \n" : String.valueOf(txtDesc) + "  " + AppLang.getText("G.726 8000Hz/Mono/32kbps") + " \n";
        this.m_txtArea.setText(txtDesc);
        JPanel btnPan = new JPanel();
        btnPan.add(this.m_btnUpload);
        btnPan.add(this.m_btnClose);
        this.add((Component)this.m_txtArea, "North");
        this.add((Component)this.m_table, "Center");
        this.add((Component)btnPan, "South");
        this.setVisible(true);
    }

    private void setDialog(String path) {
        this.m_oThis = this;
        this.m_dirPath = path;
        this.m_btnFile = new JButton[10];
        ArrayList<JComponent> compList = null;
        int i2 = 0;
        while (i2 < 10) {
            this.m_btnFile[i2] = new JButton(AppLang.getText("File"));
            this.m_btnFile[i2].setActionCommand("file" + i2);
            this.m_btnFile[i2].addActionListener(this);
            this.m_lblNo[i2] = new JLabel("" + (i2 + 1), 0);
            this.m_lblFile[i2] = new JLabel("");
            compList = new ArrayList<JComponent>();
            compList.add(this.m_lblNo[i2]);
            compList.add(this.m_lblFile[i2]);
            compList.add(this.m_btnFile[i2]);
            this.m_compList.add(compList);
            ++i2;
        }
        this.m_btnUpload.setActionCommand("upload");
        this.m_btnClose.setActionCommand("close");
        this.m_btnUpload.addActionListener(this);
        this.m_btnClose.addActionListener(this);
        AppGlobal.fixSize(this.m_btnUpload, new Dimension(120, 22));
        AppGlobal.fixSize(this.m_btnClose, new Dimension(120, 22));
        this.setSize(550, 395);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                P2006PromptUploadDlg.this.m_btnClose.doClick();
            }
        });
    }

    private void createTable() {
        int i2 = 0;
        while (i2 < 10) {
            this.strRowNames[i2][0] = "";
            ++i2;
        }
        this.m_model = new AppTableModel(this.strRowNames, this.strColNames, ""){

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 2) {
                    return P2006PromptUploadDlg.this.m_btnFile[row];
                }
                return (JLabel)((ArrayList)P2006PromptUploadDlg.this.m_compList.get(row)).get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 2;
            }
        };
        this.m_model.setRowHeaderHidden();
        this.m_model.setColWidth(new int[]{40, 400, 80});
        this.m_table = new AppTable(this.m_model);
    }

    private boolean checkName(String name) {
        if (name.length() != 4) {
            return false;
        }
        try {
            int temp = Integer.parseInt(name);
        }
        catch (Exception e2) {
            return false;
        }
        return name.charAt(0) != '\u0000' || name.charAt(1) != '\u0000' || name.charAt(2) != '\u0000' || name.charAt(3) != '\u0000';
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        if (command.equals("close")) {
            this.m_oThis.dispose();
            if (AppGlobal.g_dialogList.size() > 0) {
                AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
            }
        } else if (command.equals("upload")) {
            this.nCount = 0;
            this.nList = new ArrayList();
            this.m_path = new String();
            int i2 = 0;
            while (i2 < 10) {
                if (this.m_fileName[i2] != null) {
                    this.m_name[i2] = this.m_fileName[i2].substring(0, this.m_fileName[i2].lastIndexOf("."));
                    this.m_ext[i2] = this.m_fileName[i2].substring(this.m_fileName[i2].lastIndexOf(".") + 1, this.m_fileName[i2].length());
                    switch (AppRunInfo.getSystem()) {
                        case 1: 
                        case 19: 
                        case 34: 
                        case 49: {
                            if (this.checkName(this.m_name[i2]) && (this.m_ext[i2].toUpperCase().equals("WAV") || this.m_ext[i2].equals("726") || this.m_ext[i2].toUpperCase().equals("TXT"))) break;
                            AppGlobal.showErrorMessage("Error", "(" + this.m_fileName[i2] + ") " + AppLang.getText("Filename is not correct.") + "\n" + AppLang.getText("Prompts are numbered 0001 to 9999 and extensions should be") + "\n" + AppLang.getText("wav, 726(for voice) or txt(for description).") + "\n" + AppLang.getText("ex) 9876.wav, 8765.726, 7777.txt"));
                            return;
                        }
                        case 2: 
                        case 4: 
                        case 23: 
                        case 50: 
                        case 52: 
                        case 55: {
                            if (this.checkName(this.m_name[i2]) && (this.m_ext[i2].toUpperCase().equals("WAV") || this.m_ext[i2].equals("711") || this.m_ext[i2].toUpperCase().equals("TXT"))) break;
                            AppGlobal.showErrorMessage("Error", "(" + this.m_fileName[i2] + ") " + AppLang.getText("Filename is not correct.") + "\n" + AppLang.getText("Prompts are numbered 0001 to 9999 and extensions should be") + "\n" + AppLang.getText("wav, 711(for voice) or txt(for description).") + "\n" + AppLang.getText("ex) 9876.wav, 8765.711, 7777.txt"));
                            return;
                        }
                        default: {
                            AppGlobal.showErrorMessage("Error", String.valueOf(AppLang.getText("Upload is only available for")) + AppLang.getText(" OS7100, OS7030, OS7200, OS7200S, OS7070, OS7400"));
                            return;
                        }
                    }
                }
                ++i2;
            }
            upload m_upload = new upload();
            m_upload.start();
        } else {
            int yn;
            if (this.m_jfc == null) {
                this.m_jfc = new JFileChooser();
                FileNameExtensionFilter filter = null;
                filter = AppRunInfo.getSystem() == 23 || AppRunInfo.getSystem() == 55 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50 || AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 ? new FileNameExtensionFilter(String.valueOf(AppLang.getText("Prompt Files")) + "(*.wav;*.711;*.txt)", "wav", "711", "txt") : new FileNameExtensionFilter(String.valueOf(AppLang.getText("Prompt Files")) + "(*.wav;*.726;*.txt)", "wav", "726", "txt");
                this.m_jfc.setFileFilter(filter);
            }
            if ((yn = this.m_jfc.showOpenDialog(null)) == 0) {
                this.m_selFile = this.m_jfc.getSelectedFile();
                int i3 = 0;
                while (i3 < 10) {
                    if (command.equals("file" + i3)) {
                        this.m_fileName[i3] = this.m_selFile.getName();
                        this.m_lblFile[i3].setText("  " + this.m_selFile);
                        break;
                    }
                    ++i3;
                }
            }
            this.m_table.tableChanged(null);
        }
    }

    class upload
    extends Thread {
        upload() {
        }

        @Override
        public void run() {
            AppGlobal.showProgress(String.valueOf(AppLang.getText("Prompt Uploading")) + "...", "");
            int i2 = 0;
            while (i2 < 10) {
                String filename = new String();
                byte[] upData = new byte[65];
                P2006PromptUploadDlg.this.m_path = P2006PromptUploadDlg.this.m_lblFile[i2].getText().trim();
                filename = P2006PromptUploadDlg.this.m_fileName[i2];
                if (!P2006PromptUploadDlg.this.m_path.equals("")) {
                    switch (AppRunInfo.getSystem()) {
                        case 1: 
                        case 19: 
                        case 34: 
                        case 49: {
                            P2006PromptEncodeMain encode;
                            if (P2006PromptUploadDlg.this.m_ext[i2].toUpperCase().equals("WAV")) {
                                encode = new P2006PromptEncodeMain(P2006PromptUploadDlg.this.m_path, "g726");
                                P2006PromptUploadDlg.this.m_path = String.valueOf(P2006PromptUploadDlg.this.m_path.substring(0, P2006PromptUploadDlg.this.m_path.lastIndexOf("."))) + ".726";
                                filename = String.valueOf(P2006PromptUploadDlg.this.m_fileName[i2].substring(0, P2006PromptUploadDlg.this.m_fileName[i2].lastIndexOf("."))) + ".726";
                            }
                            filename = filename.toUpperCase();
                            if (!P2006PromptUploadDlg.this.m_ftp.connect("admin", "samsung") || !P2006PromptUploadDlg.this.m_ftp.putFile(P2006PromptUploadDlg.this.m_path, String.valueOf(P2006PromptUploadDlg.this.m_dirPath) + filename)) break;
                            P2006PromptUploadDlg.this.m_ftp.disConnect();
                            upData[0] = 1;
                            AppFunctions.str2byte(upData, 1, 64, String.valueOf(P2006PromptUploadDlg.this.m_dirPath) + filename);
                            P2006PromptUploadDlg.this.m_reqInfo = new AppRequestInfo("2007");
                            P2006PromptUploadDlg.this.m_reqInfo.setDownMsgType((byte)-56);
                            P2006PromptUploadDlg.this.m_reqInfo.setReqData(upData);
                            P2006PromptUploadDlg.this.m_reqInfo.setResult(AppComm.getInstance().requestDownload(P2006PromptUploadDlg.this.m_reqInfo.getPageInfo()));
                            if (!P2006PromptUploadDlg.this.m_reqInfo.getResult()) break;
                            P2006PromptUploadDlg p2006PromptUploadDlg = P2006PromptUploadDlg.this;
                            p2006PromptUploadDlg.nCount = p2006PromptUploadDlg.nCount + 1;
                            P2006PromptUploadDlg.this.nList.add(filename);
                            break;
                        }
                        case 2: 
                        case 4: 
                        case 50: 
                        case 52: {
                            if (AppRunInfo.getSystem() == 4 || AppRunInfo.getSystem() == 52 || AppRunInfo.getSystem() == 2 || AppRunInfo.getSystem() == 50) {
                                P2006PromptUploadDlg.this.m_ftp.setServerIP(AppNetwork.m_address_SVMi20i);
                                P2006PromptUploadDlg.this.m_ftp.setFtpPort(AppNetwork.m_ftp_port_SVMi20i);
                            }
                        }
                        case 23: 
                        case 55: {
                            P2006PromptEncodeMain encode;
                            if (P2006PromptUploadDlg.this.m_ext[i2].toUpperCase().equals("WAV")) {
                                encode = new P2006PromptEncodeMain(P2006PromptUploadDlg.this.m_path, "g711u");
                                P2006PromptUploadDlg.this.m_path = String.valueOf(P2006PromptUploadDlg.this.m_path.substring(0, P2006PromptUploadDlg.this.m_path.lastIndexOf("."))) + ".711";
                                filename = String.valueOf(P2006PromptUploadDlg.this.m_fileName[i2].substring(0, P2006PromptUploadDlg.this.m_fileName[i2].lastIndexOf("."))) + ".711";
                            }
                            filename = filename.toUpperCase();
                            if (!P2006PromptUploadDlg.this.m_ftp.connect("admin", "samsung") || !P2006PromptUploadDlg.this.m_ftp.putFile(P2006PromptUploadDlg.this.m_path, String.valueOf(P2006PromptUploadDlg.this.m_dirPath) + filename)) break;
                            P2006PromptUploadDlg.this.m_ftp.disConnect();
                            upData[0] = 1;
                            AppFunctions.str2byte(upData, 1, 64, String.valueOf(P2006PromptUploadDlg.this.m_dirPath) + filename);
                            P2006PromptUploadDlg.this.m_reqInfo = new AppRequestInfo("2007");
                            P2006PromptUploadDlg.this.m_reqInfo.setDownMsgType((byte)-56);
                            P2006PromptUploadDlg.this.m_reqInfo.setReqData(upData);
                            P2006PromptUploadDlg.this.m_reqInfo.setResult(AppComm.getInstance().requestDownload(P2006PromptUploadDlg.this.m_reqInfo.getPageInfo()));
                            if (!P2006PromptUploadDlg.this.m_reqInfo.getResult()) break;
                            P2006PromptUploadDlg p2006PromptUploadDlg = P2006PromptUploadDlg.this;
                            p2006PromptUploadDlg.nCount = p2006PromptUploadDlg.nCount + 1;
                            P2006PromptUploadDlg.this.nList.add(filename);
                            break;
                        }
                        default: {
                            AppGlobal.showErrorMessage("Error", String.valueOf(AppLang.getText("Upload is only available in")) + AppLang.getText(" OS7100, OS7030, OS7200, OS7200S, OS7070, OS7400"));
                            return;
                        }
                    }
                }
                ++i2;
            }
            AppGlobal.hideProgress();
            if (P2006PromptUploadDlg.this.nCount > 0) {
                JOptionPane.showMessageDialog(null, String.valueOf(AppLang.getText("Completed upload")) + " " + P2006PromptUploadDlg.this.nCount + " " + AppLang.getText("files") + "." + "\n" + P2006PromptUploadDlg.this.nList);
            }
        }
    }
}

