/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.telnet;

import com.oroinc.net.telnet.TelnetClient;
import com.oroinc.net.telnet.TelnetOption;
import java.io.IOException;
import java.io.OutputStream;

final class TelnetOutputStream
extends OutputStream {
    private TelnetClient __client;
    private boolean __convertCRtoCRLF = true;
    private boolean __lastWasCR = false;

    TelnetOutputStream(TelnetClient telnetClient) {
        this.__client = telnetClient;
    }

    public void write(int n2) throws IOException {
        TelnetClient telnetClient = this.__client;
        synchronized (telnetClient) {
            n2 &= 0xFF;
            if (this.__client._requestedWont(TelnetOption.BINARY)) {
                if (this.__lastWasCR) {
                    if (this.__convertCRtoCRLF) {
                        this.__client._sendByte(10);
                        if (n2 == 10) {
                            this.__lastWasCR = false;
                            return;
                        }
                    } else if (n2 != 10) {
                        this.__client._sendByte(0);
                    }
                }
                this.__lastWasCR = false;
                switch (n2) {
                    case 13: {
                        this.__client._sendByte(13);
                        this.__lastWasCR = true;
                        break;
                    }
                    case 255: {
                        this.__client._sendByte(255);
                        this.__client._sendByte(255);
                        break;
                    }
                    default: {
                        this.__client._sendByte(n2);
                        break;
                    }
                }
            } else if (n2 == 255) {
                this.__client._sendByte(n2);
                this.__client._sendByte(255);
            } else {
                this.__client._sendByte(n2);
            }
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        TelnetClient telnetClient = this.__client;
        synchronized (telnetClient) {
            while (n3-- > 0) {
                this.write(byArray[n2++]);
            }
        }
    }

    public void flush() throws IOException {
        this.__client._flushOutputStream();
    }

    public void close() throws IOException {
        this.__client._closeOutputStream();
    }
}

