/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppRunInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class AppFunctions {
    public static short byte2short(byte[] data, int pos) {
        int result = 0;
        try {
            int i2 = pos;
            int j2 = 8;
            while (i2 < pos + 2) {
                result = data[i2] < 0 ? (result += data[i2] + 256 << j2) : (result += data[i2] << j2);
                ++i2;
                j2 -= 8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (short)result;
    }

    public static int byte2int(byte[] data, int pos) {
        long result = 0L;
        try {
            int i2 = pos;
            int j2 = 24;
            while (i2 < pos + 4) {
                result = data[i2] < 0 ? (result += (long)(data[i2] + 256 << j2)) : (result += (long)(data[i2] << j2));
                ++i2;
                j2 -= 8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (int)result;
    }

    public static String byte2str(byte[] data, int pos, int len) {
        String str = new String(data, pos, len);
        return str.trim();
    }

    public static String byte2tel(byte data1, byte data2) {
        String tel = "";
        tel = String.format("%02x", data1).toUpperCase().replaceAll("F", "");
        tel = String.valueOf(tel) + String.format("%02x", data2).toUpperCase().replaceAll("F", "");
        tel = tel.replaceAll("A", "*");
        tel = tel.replaceAll("B", "#");
        return tel.trim();
    }

    public static String byte2ip(byte[] data, int pos, int len) {
        String ipAddr = "";
        try {
            if (AppRunInfo.getIPType() == 0 || len == 4) {
                int i2 = len - 4;
                while (i2 < len - 1) {
                    ipAddr = String.valueOf(ipAddr) + AppFunctions.unsignedValue(data[pos + i2]) + ".";
                    ++i2;
                }
                ipAddr = String.valueOf(ipAddr) + AppFunctions.unsignedValue(data[pos + (len - 1)]);
            } else {
                ipAddr = AppFunctions.byte2ipV6(data, pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipAddr;
    }

    public static String byte2ipV6(byte[] data, int pos) {
        String ipAddr = "";
        try {
            String[] addr = new String[8];
            int i2 = pos;
            int j2 = 0;
            while (i2 < pos + 16) {
                addr[j2] = String.format("%04x", AppFunctions.byte2short(data, i2)).trim().toUpperCase();
                i2 += 2;
                ++j2;
            }
            int cntZero = 0;
            int i3 = 0;
            while (i3 < 8) {
                if (addr[i3].equals("0000")) {
                    ++cntZero;
                } else {
                    ipAddr = cntZero == 0 ? String.valueOf(ipAddr) + addr[i3] : (cntZero == 1 ? String.valueOf(ipAddr) + "0:" + addr[i3] : String.valueOf(ipAddr) + "::" + addr[i3]);
                    cntZero = 0;
                }
                if (i3 != 7 && !addr[i3].equals("0000")) {
                    ipAddr = String.valueOf(ipAddr) + ":";
                }
                ++i3;
            }
            if (ipAddr.equals("")) {
                ipAddr = "::";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipAddr;
    }

    public static String byte2mac(byte[] data, int pos) {
        String mac = "";
        try {
            int i2 = 0;
            while (i2 < 5) {
                mac = String.valueOf(mac) + String.format("%02x", data[pos + i2]).toUpperCase() + ":";
                ++i2;
            }
            mac = String.valueOf(mac) + String.format("%02x", data[pos + 5]).toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mac;
    }

    public static byte[] byte2nibble(byte data) {
        byte[] nibble = new byte[2];
        try {
            if (data == -1) {
                nibble[0] = 15;
                nibble[1] = 15;
            } else if (data > 0) {
                nibble[0] = (byte)((data & 0xF0) / 16);
                nibble[1] = (byte)(data & 0xF);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nibble;
    }

    public static String byte2bit(int val, boolean isMSB) {
        String bit = "";
        try {
            if (val == 0) {
                bit = "00000000";
            } else if (val == 255) {
                bit = "11111111";
            } else if (isMSB) {
                int i2 = 7;
                while (i2 >= 0) {
                    bit = String.valueOf(bit) + (val >> i2 & 1);
                    --i2;
                }
            } else {
                int i3 = 0;
                while (i3 < 8) {
                    bit = String.valueOf(bit) + (val >> i3 & 1);
                    ++i3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bit;
    }

    public static void short2byte(byte[] data, int pos, short val) {
        int temp = val < 0 ? val + 65536 : val;
        try {
            int i2 = pos;
            int j2 = 8;
            while (i2 < pos + 2) {
                data[i2] = (byte)(temp >> j2);
                ++i2;
                j2 -= 8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void int2byte(byte[] data, int pos, int val) {
        long temp = val < 0 ? (long)val + 0x100000000L : (long)val;
        try {
            int i2 = pos;
            int j2 = 24;
            while (i2 < pos + 4) {
                data[i2] = (byte)(temp >> j2);
                ++i2;
                j2 -= 8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void str2byte(byte[] data, int pos, int len, String val) {
        byte[] temp = new byte[len];
        Arrays.fill(temp, 0, len - 1, (byte)0);
        try {
            if (val != null && val.length() > 0) {
                byte[] strBytes = val.getBytes();
                System.arraycopy(strBytes, 0, temp, 0, strBytes.length);
            }
            System.arraycopy(temp, 0, data, pos, len);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void tel2byte(byte[] data, int pos, String val) {
        String tel = val;
        try {
            data[pos] = -1;
            data[pos + 1] = -1;
            tel = tel.replaceAll("\\*", "A");
            tel = tel.replaceAll("#", "B");
            if (tel.length() == 1) {
                tel = String.valueOf(tel) + "F";
                data[pos] = (byte)Integer.parseInt(tel, 16);
            } else if (tel.length() == 2) {
                data[pos] = (byte)Integer.parseInt(tel, 16);
            } else if (tel.length() == 3) {
                data[pos] = (byte)Integer.parseInt(tel.substring(0, 2), 16);
                tel = String.valueOf(tel.substring(2, 3)) + "F";
                data[pos + 1] = (byte)Integer.parseInt(tel, 16);
            } else if (tel.length() == 4) {
                data[pos] = (byte)Integer.parseInt(tel.substring(0, 2), 16);
                data[pos + 1] = (byte)Integer.parseInt(tel.substring(2, 4), 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ip2byte(byte[] data, int pos, int len, String val) {
        byte[] address = new byte[len];
        if (val.equals("")) {
            return;
        }
        try {
            if (AppFunctions.checkIPAddress(address, val)) {
                if (AppRunInfo.getIPType() == 0 && len == 16) {
                    Arrays.fill(data, pos, pos + 10, (byte)0);
                    Arrays.fill(data, pos + 10, pos + 12, (byte)-1);
                    System.arraycopy(address, 0, data, pos + 12, 4);
                } else {
                    System.arraycopy(address, 0, data, pos, len);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void mac2byte(byte[] data, int pos, String mac) {
        String[] macByte = mac.split(":");
        try {
            int i2 = 0;
            while (i2 < 6) {
                data[pos + i2] = (byte)Integer.parseInt(macByte[i2], 16);
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte nibble2byte(byte high, byte low) {
        return (byte)(high * 16 + low);
    }

    public static int bit2byte(String bit, boolean isMSB) {
        int val = 0;
        try {
            if (bit.equals("") || bit.equals("00000000")) {
                val = 0;
            } else if (bit.equals("11111111")) {
                val = 255;
            } else if (isMSB) {
                int i2 = 0;
                int j2 = 7;
                while (i2 < 8) {
                    if (bit.substring(i2, i2 + 1).equals("1")) {
                        val += 1 << j2;
                    }
                    ++i2;
                    --j2;
                }
            } else {
                int i3 = 0;
                while (i3 < 8) {
                    if (bit.substring(i3, i3 + 1).equals("1")) {
                        val += 1 << i3;
                    }
                    ++i3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static String unsignedValue(byte val) {
        int result = val < 0 ? val + 256 : val;
        return "" + result;
    }

    public static String unsignedValue(short val) {
        int result = val < 0 ? val + 65536 : val;
        return "" + result;
    }

    public static String unsignedValue(int val) {
        long result = val < 0 ? (long)val + 0x100000000L : (long)val;
        return "" + result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIPAddress(byte[] addr, String ipAddr) {
        String v6Pattern = "[a-fA-F0-9:]*";
        String v4Pattern = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
        if (ipAddr.equals("")) {
            return true;
        }
        try {
            if (Pattern.matches(v4Pattern, ipAddr)) {
                String[] v4Address = ipAddr.split("\\.");
                int i2 = 0;
                while (i2 < v4Address.length) {
                    if (Integer.parseInt(v4Address[i2]) > 255) {
                        AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Invalid IP address."));
                        return false;
                    }
                    if (addr != null) {
                        addr[i2] = (byte)Integer.parseInt(v4Address[i2]);
                    }
                    ++i2;
                }
                return true;
            }
            if (Pattern.matches(v6Pattern, ipAddr)) {
                if (ipAddr.equals("::")) {
                    if (addr != null) {
                        Arrays.fill(addr, 0, 16, (byte)0);
                    }
                    return true;
                }
                if (ipAddr.lastIndexOf(":") == ipAddr.length() - 1 || ipAddr.indexOf(":") > 0 && !ipAddr.substring(0, 2).equals("::")) {
                    AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Invalid IP address."));
                    return false;
                }
                Object[] tempAddr = new String[8];
                Arrays.fill(tempAddr, 0, 8, "0");
                String[] v6Address = ipAddr.split("::");
                if (v6Address.length == 1) {
                    String[] address = v6Address[0].split(":");
                    if (address.length == 8) {
                        int i3 = 0;
                        while (i3 < 8) {
                            if (address[i3].length() > 4) {
                                AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Invalid IP address."));
                                return false;
                            }
                            tempAddr[i3] = address[i3];
                            ++i3;
                        }
                        if (addr != null) {
                            byte[] temp = new byte[16];
                            temp = AppFunctions.convertAddress((String[])tempAddr);
                            System.arraycopy(temp, 0, addr, 0, 16);
                        }
                        return true;
                    }
                } else if (v6Address.length == 2) {
                    String[] second;
                    String[] first = null;
                    first = v6Address[0].equals("") ? new String[]{} : v6Address[0].split(":");
                    if (first.length + (second = v6Address[1].split(":")).length < 8) {
                        int i4 = 0;
                        while (i4 < first.length) {
                            if (first[i4].length() > 4) {
                                AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Invalid IP address."));
                                return false;
                            }
                            tempAddr[i4] = first[i4];
                            ++i4;
                        }
                        i4 = 8 - second.length;
                        while (i4 < 8) {
                            if (second[i4 - (8 - second.length)].length() > 4) {
                                AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Invalid IP address."));
                                return false;
                            }
                            tempAddr[i4] = second[i4 - (8 - second.length)];
                            ++i4;
                        }
                        if (addr != null) {
                            byte[] temp = new byte[16];
                            temp = AppFunctions.convertAddress((String[])tempAddr);
                            System.arraycopy(temp, 0, addr, 0, 16);
                        }
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AppGlobal.showErrorMessage(AppLang.getText("Error"), AppLang.getText("Invalid IP address."));
        return false;
    }

    private static byte[] convertAddress(String[] addr) {
        byte[] address = new byte[16];
        Arrays.fill(address, (byte)0);
        try {
            int i2 = 0;
            int j2 = 0;
            while (i2 < addr.length) {
                if (addr[i2].length() <= 2) {
                    address[j2 + 1] = (byte)Integer.parseInt(addr[i2], 16);
                } else if (addr[i2].length() == 3) {
                    address[j2] = (byte)Integer.parseInt(addr[i2].substring(0, 1), 16);
                    address[j2 + 1] = (byte)Integer.parseInt(addr[i2].substring(1, 3), 16);
                } else if (addr[i2].length() == 4) {
                    address[j2] = (byte)Integer.parseInt(addr[i2].substring(0, 2), 16);
                    address[j2 + 1] = (byte)Integer.parseInt(addr[i2].substring(2, 4), 16);
                }
                ++i2;
                j2 += 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }

    public static String formatToSV(String Value) {
        if (!Value.equals("") && !Value.equals("65535")) {
            String val = String.format("%04x", Integer.parseInt(Value));
            String retValue = val.substring(0, 1).equals("0") ? "V" + val.substring(1, 2) + "." + val.substring(2, 4) : "V" + val.substring(0, 2) + "." + val.substring(2, 4);
            return retValue;
        }
        return "";
    }

    public static int signedValue(int valByte) {
        int result = valByte > 127 ? valByte - 256 : valByte;
        return result;
    }

    public static TreeMap<String, ArrayList> receiveDataToSort(ArrayList recvData, int keyIdx) {
        TreeMap<String, ArrayList> result = new TreeMap<String, ArrayList>();
        int i2 = 0;
        while (i2 < recvData.size()) {
            ArrayList arrValue = (ArrayList)recvData.get(i2);
            String key = (String)arrValue.get(keyIdx);
            if (!key.equals("")) {
                result.put(key, arrValue);
            }
            ++i2;
        }
        return result;
    }
}

