/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AppLanguageTest
extends JFrame {
    private JLabel m_label = new JLabel("Please enter the word");
    private JTextField m_value = new JTextField();
    private JTextField m_result = new JTextField();
    private JButton m_ok = new JButton("OK");
    private JButton m_close = new JButton("Close");
    private Hashtable m_language;
    private String m_langDirectory = "/resources/files/languages/";
    private String[] m_langFiles = new String[]{"Korean.ini", "Russian.ini", "German.ini", "Italian.ini", "Chinese.ini"};

    public AppLanguageTest() {
        this.m_language = (Hashtable)AppProperty.readDataFromFile(AppLanguageTest.class.getResourceAsStream(String.valueOf(this.m_langDirectory) + this.m_langFiles[0]));
        this.init();
        this.setVisible(true);
    }

    public void init() {
        this.setTitle("Language Test");
        this.setSize(new Dimension(500, 300));
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel(new BorderLayout());
        final JComboBox<String> combo = new JComboBox<String>(this.m_langFiles);
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AppLanguageTest.this.m_language = (Hashtable)AppProperty.readDataFromFile(AppLanguageTest.class.getResourceAsStream(String.valueOf(AppLanguageTest.this.m_langDirectory) + AppLanguageTest.this.m_langFiles[combo.getSelectedIndex()]));
            }
        });
        top.add((Component)this.m_label, "Before");
        top.add(combo, "After");
        JPanel centerPane = new JPanel(new GridLayout(2, 1));
        this.m_value.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e2) {
            }

            @Override
            public void keyPressed(KeyEvent e2) {
            }

            @Override
            public void keyReleased(KeyEvent e2) {
                if (e2.getKeyCode() == 10) {
                    AppLanguageTest.this.m_ok.doClick();
                }
            }
        });
        centerPane.add(this.m_value);
        this.m_result.setEditable(false);
        centerPane.add(this.m_result);
        JPanel boot = new JPanel(new FlowLayout());
        boot.add(this.m_ok);
        boot.add(this.m_close);
        this.m_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String strLang = AppLanguageTest.this.getText(AppLanguageTest.this.m_value.getText());
                AppLanguageTest.this.m_result.setText(strLang);
            }
        });
        this.m_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        this.add((Component)top, "North");
        this.add((Component)centerPane, "Center");
        this.add((Component)boot, "South");
    }

    public String getText(String str) {
        if (str == null) {
            return "\ub2e8\uc5b4\uac00 \uc815\uc758\ub418\uc5b4\uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
        }
        str = str.trim();
        if (this.m_language != null && this.m_language.containsKey(str)) {
            String retStr = (String)this.m_language.get(str);
            return retStr.equals("") ? "\ubc88\uc5ed\ub418\uc5b4\uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4." : retStr;
        }
        return "\ub2e8\uc5b4\uac00 \uc815\uc758\ub418\uc5b4\uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
    }

    public static void main(String[] args) {
        new AppLanguageTest();
    }
}

