/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.pages.utils.AppCards;

public class AppRunInfo {
    public static final String APP_OSDM_DATE = "V1.02c 2011.03.18 \n";
    public static final int APP_OSDM_VERSION = 339;
    public static byte[] m_linkData = null;
    private static int m_runMode = 0;
    private static int m_tenantNo = 0;
    private static String m_fileName = "";
    private static String m_filePath = "";

    public static void setLinkData(byte[] link) {
        m_linkData = link;
        AppGlobal.g_bIsCoference = AppRunInfo.checkRunConference();
    }

    public static byte[] getLinkData() {
        return m_linkData;
    }

    public static int getRunMode() {
        return m_runMode;
    }

    public static void setRunMode(int mode) {
        m_runMode = mode;
    }

    public static int getSystem() {
        return m_linkData[0];
    }

    public static int getCountry() {
        return m_linkData[1];
    }

    public static String getSysVersion() {
        return AppFunctions.byte2str(m_linkData, 2, 16);
    }

    public static void setSysVersion(String version) {
        AppFunctions.str2byte(m_linkData, 2, 16, version);
    }

    public static int getRunVersion() {
        int version = 339;
        try {
            String tmmc = String.valueOf(String.format("%02x", m_linkData[18])) + String.format("%02x", m_linkData[19]);
            return Integer.parseInt(tmmc, 16);
        }
        catch (Exception exception) {
            return version;
        }
    }

    public static void setRunVersion(int version) {
        AppFunctions.short2byte(m_linkData, 18, (short)version);
    }

    public static int getAliveTime() {
        return m_linkData[20];
    }

    public static int getLockOut() {
        return m_linkData[21];
    }

    public static int getMinSpeed() {
        return AppFunctions.byte2short(m_linkData, 22);
    }

    public static int getIPType() {
        return m_linkData[24];
    }

    public static int getPCMCoding() {
        return m_linkData[25];
    }

    public static int getWBSType() {
        return m_linkData[26];
    }

    public static int getTenantNo() {
        return m_tenantNo;
    }

    public static int getMaxTenantNo() {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[1092]));
    }

    public static void setTenantNo(int tenant) {
        m_tenantNo = tenant;
    }

    public static int getUserLevel() {
        return m_linkData[29];
    }

    public static String getFileName() {
        return m_fileName;
    }

    public static void setFileName(String file) {
        m_fileName = file;
    }

    public static String getFilePath() {
        return m_filePath;
    }

    public static void setFilePath(String path) {
        m_filePath = path;
    }

    public static int getRealCabinet() {
        return m_linkData[27];
    }

    public static int getVirtCabinet() {
        return m_linkData[28];
    }

    public static int getConnState(int cabNo) {
        return m_linkData[cabNo * 220 + 32];
    }

    public static int getCabinetType(int cabNo) {
        return m_linkData[cabNo * 220 + 33];
    }

    public static int getRealCabSlot(int cabNo) {
        return m_linkData[cabNo * 220 + 34];
    }

    public static int getPrevCard(int cabNo, int slotNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + 36]));
    }

    public static int getCurrCard(int cabNo, int slotNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + 37]));
    }

    public static int getMaxService(int cabNo, int slotNo) {
        return m_linkData[cabNo * 220 + slotNo * 18 + 38];
    }

    public static int getMaxChannel(int cabNo, int slotNo, int chNo) {
        return m_linkData[cabNo * 220 + slotNo * 18 + (chNo + 39)];
    }

    public static int getStartPort(int cabNo, int slotNo, int chNo) {
        return AppFunctions.byte2short(m_linkData, cabNo * 220 + slotNo * 18 + (chNo * 2 + 42));
    }

    public static int getServiceCard(int cabNo, int slotNo, int chNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + (chNo + 48)]));
    }

    public static int getNewService(int cabNo, int slotNo, int chNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 220 + slotNo * 18 + (chNo + 51)]));
    }

    public static int getVirtSlot(int cabNo) {
        return m_linkData[cabNo * 38 + 692];
    }

    public static int getVirtChannel(int cabNo) {
        return m_linkData[cabNo * 38 + 693];
    }

    public static int getVirtCard(int cabNo, int slotNo) {
        return Integer.parseInt(AppFunctions.unsignedValue(m_linkData[cabNo * 38 + slotNo + 694]));
    }

    public static int getVirtStartPort(int cabNo, int slotNo) {
        return AppFunctions.byte2short(m_linkData, cabNo * 38 + slotNo * 2 + 706);
    }

    public static int getStationStart() {
        return AppFunctions.byte2short(m_linkData, 1072);
    }

    public static int getStationCount() {
        return AppFunctions.byte2short(m_linkData, 1074);
    }

    public static int getTrunkStart() {
        return AppFunctions.byte2short(m_linkData, 1076);
    }

    public static int getTrunkCount() {
        return AppFunctions.byte2short(m_linkData, 1078);
    }

    public static int getFeatStart() {
        return AppFunctions.byte2short(m_linkData, 1080);
    }

    public static int getFeatCount() {
        return AppFunctions.byte2short(m_linkData, 1082);
    }

    public static int getQlcrStart() {
        return AppFunctions.byte2short(m_linkData, 1084);
    }

    public static int getQlcrCount() {
        return AppFunctions.byte2short(m_linkData, 1086);
    }

    private static boolean checkRunConference() {
        int i2 = 0;
        while (i2 < 3) {
            int j2 = 0;
            while (j2 < 12) {
                if (AppRunInfo.getCurrCard(i2, j2) == 136 && AppCards.checkUseCard(136)) {
                    return true;
                }
                ++j2;
            }
            ++i2;
        }
        return false;
    }
}

