/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.utils.AppAllUpThread;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AppAllUpLoad
extends AppDialog {
    private final int SIZE_WIDTH = 600;
    private final int SIZE_HEIGHT = 500;
    private AppAllUpThread m_upThread = null;
    public AppComboBox m_group = new AppComboBox(new String[]{"All", "2:2. Configuration", "3. Call Routing", "4. Group & Table", "5. Features", "6. System Control"});
    private JCheckBox m_select = new JCheckBox(AppLang.getText("All Select"), true);
    private JCheckBox m_verify = new JCheckBox(AppLang.getText("Verify after uploading"), false);
    public JLabel m_lbCount = new JLabel();
    private JLabel m_lbSelect = new JLabel("", 0);
    public JProgressBar m_progBar = new JProgressBar(0, 100);
    private Hashtable m_readData = new Hashtable();
    private ArrayList m_upList = new ArrayList();
    private int m_cntTotal = 0;
    private int m_cntFixed = 0;
    private int m_cntSelect = 0;
    private boolean m_addConf = false;
    private boolean m_addQuick = false;
    private String[] m_fixedList = new String[]{"2100", "2102", "2105", "2200", "2300", "2401", "2608", "2800", "3101", "3302", "3304", "3305", "4101", "4102", "4201", "5301", "5303", "6205"};

    public AppAllUpLoad(Hashtable readData) {
        this.m_layout = new AppLayout(this.m_contentPane, 600, 500);
        this.m_readData = readData;
        this.createComponents();
        this.createUpList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppAllUpLoad.this.openDialog("DB Control - Upload", 600, 500);
            }
        });
    }

    private void createComponents() {
        JLabel lbTitle = new JLabel(AppLang.getText("Group"), 4);
        JLabel lbTitle1 = new JLabel(AppLang.getText("Selected item(s)"), 4);
        JButton btUp = new JButton(AppLang.getText("Upload"));
        JButton btCancel = new JButton(AppLang.getText("Cancel"));
        btUp.setActionCommand("Up");
        btCancel.setActionCommand("Cancel");
        btUp.addActionListener(this);
        btCancel.addActionListener(this);
        this.m_group.addListener(this);
        this.m_select.setActionCommand("Select");
        this.m_select.addActionListener(this);
        this.m_progBar.setBorder(new LineBorder(Color.darkGray));
        this.m_progBar.setStringPainted(true);
        this.m_layout.addComponent(lbTitle, 5, 5, 60, 20);
        this.m_layout.addComponent(this.m_group.getComponent(), 70, 5, 150, 20);
        this.m_layout.addComponent(this.m_select, 230, 5, 100, 20);
        this.m_layout.addComponent(lbTitle1, 350, 5, 120, 20);
        this.m_layout.addComponent(this.m_lbSelect, 475, 5, 75, 20);
        this.m_layout.addComponent(btUp, 350, 30, 90, 20);
        this.m_layout.addComponent(btCancel, 470, 30, 80, 20);
        this.m_layout.addComponent(this.m_progBar, 5, 440, 530, 20);
        this.m_layout.addComponent(this.m_lbCount, 540, 440, 60, 20);
    }

    private void createUpList() {
        this.m_upList.clear();
        this.m_cntFixed = 0;
        int i2 = 0;
        while (i2 < this.m_fixedList.length) {
            if (AppGlobal.g_useMenu.containsKey(this.m_fixedList[i2]) && ((String)AppGlobal.g_useMenu.get(this.m_fixedList[i2])).equals("0")) {
                this.m_upList.add(this.m_upList.size(), this.m_fixedList[i2]);
                ++this.m_cntFixed;
            }
            ++i2;
        }
        Vector vtTemp = new Vector(AppGlobal.g_useMenu.keySet());
        Collections.sort(vtTemp);
        for (String key : vtTemp) {
            if (!((String)AppGlobal.g_useMenu.get(key)).equals("0") || !AppProperty.m_allMmcList.containsKey(key) || !((AppTreeNode)AppProperty.m_allMmcList.get(key)).getAllUpload()) continue;
            this.m_upList.add(this.m_upList.size(), key);
            if (this.m_addConf || Integer.parseInt(key, 16) < 37121 || Integer.parseInt(key, 16) > 37126) continue;
            this.m_group.addItem("9.Conference", 9);
            this.m_addConf = true;
        }
        this.m_cntSelect = this.m_cntTotal = this.m_upList.size();
        this.setComponents();
    }

    private void setComponents() {
        ArrayList<JComponent> compData = null;
        this.m_corner = new String[][]{{"Menu", "Description"}};
        this.m_colTitle = new String[][]{{"Select", "Status"}};
        this.m_rowTitle = new String[this.m_upList.size()][2];
        int i2 = 0;
        while (i2 < this.m_rowTitle.length) {
            this.m_rowTitle[i2][0] = ((AppTreeNode)AppProperty.m_allMmcList.get((String)this.m_upList.get(i2))).getIndex();
            this.m_rowTitle[i2][1] = ((AppTreeNode)AppProperty.m_allMmcList.get((String)this.m_upList.get(i2))).getTitle();
            compData = new ArrayList<JComponent>();
            JCheckBox compCheck = new JCheckBox();
            compCheck.setSelected(true);
            compCheck.addActionListener(new CheckActionListener());
            compCheck.setHorizontalAlignment(0);
            compData.add(0, compCheck);
            JLabel compStatus = new JLabel("", 0);
            compData.add(1, compStatus);
            this.m_components.add(i2, compData);
            ++i2;
        }
        this.createTable();
        this.showSelectCount();
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppAllUpLoad.this.m_components.get(row);
                if (col == 0) {
                    return (JCheckBox)compData.get(0);
                }
                return (JLabel)compData.get(1);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0 && row >= AppAllUpLoad.this.m_cntFixed;
            }
        };
        this.m_model.setRowWidth(new int[]{80, 270});
        this.m_model.setColWidth(new int[]{50, 160});
        this.m_table = new AppTable(this.m_model, 2);
        this.m_layout.addComponent(this.m_table, 5, 55, 585, 375);
    }

    private void showSelectCount() {
        this.m_lbSelect.setText(String.valueOf(this.m_cntSelect) + "/" + this.m_cntTotal);
        if (this.m_cntSelect != this.m_cntTotal) {
            this.m_select.setSelected(false);
        } else {
            this.m_select.setSelected(true);
        }
    }

    public void changeItemGroup(int idx) {
        String index = "";
        int i2 = 0;
        while (i2 < this.m_model.getRowHdrRowCount()) {
            this.m_table.setRowHidden(i2);
            index = (String)this.m_model.getRowHdrName(i2, 0);
            if (idx == 0 || index.startsWith("" + idx)) {
                this.m_table.setRowHeight(i2, 22);
            }
            ++i2;
        }
    }

    private void requestUpload() {
        ArrayList<String> reqList = new ArrayList<String>();
        int i2 = 0;
        int k2 = 0;
        while (i2 < this.m_model.getRowHdrRowCount()) {
            this.m_table.setRowHidden(i2);
            ((JLabel)this.m_model.getValueAt(i2, 1)).setText("");
            if (((JCheckBox)this.m_model.getValueAt(i2, 0)).isSelected()) {
                this.m_table.setRowHeight(i2, 22);
                reqList.add(k2, i2 + ":" + (String)this.m_upList.get(i2));
                ++k2;
            }
            ++i2;
        }
        this.m_progBar.setMaximum(reqList.size());
        this.m_progBar.setValue(0);
        this.m_upThread = new AppAllUpThread();
        this.m_upThread.setReadData(this.m_readData, this.m_verify.isSelected());
        this.m_upThread.setRequestList(reqList);
        this.m_upThread.setComponents(this);
        this.m_upThread.start();
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Up")) {
            this.requestUpload();
        } else if (command.equals("Cancel")) {
            if (this.m_upThread == null || !this.m_upThread.getStatus()) {
                this.closeDialog();
            } else {
                this.m_upThread.stopUpload();
            }
        } else if (command.equals("Select")) {
            this.m_cntSelect = this.m_select.isSelected() ? this.m_cntTotal : this.m_cntFixed;
            int i2 = 0;
            while (i2 < this.m_model.getRowHdrRowCount()) {
                if (i2 >= this.m_cntFixed) {
                    ((JCheckBox)this.m_model.getValueAt(i2, 0)).setSelected(this.m_select.isSelected());
                }
                this.m_table.repaint();
                ++i2;
            }
            this.showSelectCount();
        }
    }

    @Override
    public void runItemChangeEvent(ItemEvent ie) {
        this.changeItemGroup(this.m_group.getSelectedIndex());
    }

    class CheckActionListener
    implements ActionListener {
        CheckActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (((JCheckBox)ae.getSource()).isSelected()) {
                AppAllUpLoad appAllUpLoad = AppAllUpLoad.this;
                appAllUpLoad.m_cntSelect = appAllUpLoad.m_cntSelect + 1;
            } else {
                AppAllUpLoad appAllUpLoad = AppAllUpLoad.this;
                appAllUpLoad.m_cntSelect = appAllUpLoad.m_cntSelect - 1;
            }
            AppAllUpLoad.this.showSelectCount();
        }
    }
}

