/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AppDialog
extends JDialog
implements ActionListener,
ItemListener {
    public AppPage m_page = new AppPage();
    public AppPageInfo m_pageInfo = null;
    public AppTable m_table = null;
    public AppTableModel m_model = null;
    public DoDownload m_downLoad = null;
    public ArrayList m_recvData = null;
    public ArrayList m_components = new ArrayList();
    public String[][] m_corner = null;
    public String[][] m_colTitle = null;
    public String[][] m_rowTitle = null;
    public JPanel m_contentPane = new JPanel();
    public AppLayout m_layout = null;

    public AppDialog() {
        AppGlobal.g_dialogList.add(AppGlobal.g_dialogList.size(), this);
    }

    public void openDialog(String title, int width, int height) {
        this.setTitle(AppLang.getText(title));
        this.setModal(true);
        this.setIconImage(AppImages.Img_Logo);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppDialog.this.closeDialog();
            }
        });
        this.add(this.m_contentPane);
        this.setSize(width, height);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
        this.setVisible(true);
    }

    public void closeDialog() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.runActionEvent(ae.getActionCommand());
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            this.runItemChangeEvent(ie);
        }
    }

    public void setTableModel() {
        int i2;
        int[] rowWidth = this.m_pageInfo.getRowWidth();
        int[] colWidth = null;
        String[] cellSpan = this.m_pageInfo.getCellSpan();
        this.m_model.setRowWidth(rowWidth);
        if (this.m_pageInfo.getColWidth().length == 1) {
            colWidth = new int[this.m_model.getColHdrColCount()];
            i2 = 0;
            while (i2 < colWidth.length) {
                colWidth[i2] = this.m_pageInfo.getColWidth()[0];
                ++i2;
            }
        } else {
            colWidth = this.m_pageInfo.getColWidth();
        }
        this.m_model.setColWidth(colWidth);
        i2 = 0;
        while (i2 < cellSpan.length) {
            try {
                String[] span = cellSpan[i2].split(",");
                int row = Integer.parseInt(span[1]);
                int col = Integer.parseInt(span[2]);
                int count = Integer.parseInt(span[3]);
                if (span[0].equals("0")) {
                    this.m_model.setRowHeaderRowSpan(row, col, count);
                } else if (span[0].equals("1")) {
                    this.m_model.setRowHeaderColSpan(row, col, count);
                } else if (span[0].equals("2")) {
                    this.m_model.setColHeaderRowSpan(row, col, count);
                } else if (span[0].equals("3")) {
                    this.m_model.setColHeaderColSpan(row, col, count);
                } else if (span[0].equals("4")) {
                    this.m_model.setCornerHeaderRowSpan(row, col, count);
                } else if (span[0].equals("5")) {
                    this.m_model.setCornerHeaderColSpan(row, col, count);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.m_table = new AppTable(this.m_model, 2);
    }

    public void setTableRowHidden() {
        int i2 = 0;
        while (i2 < this.m_model.getRowHdrRowCount()) {
            if (this.m_pageInfo.getFieldType(this.m_pageInfo.getDataPosition(i2)) == 255) {
                this.m_table.setRowHidden(i2);
            }
            ++i2;
        }
    }

    public void setTableColHidden() {
        int i2 = 0;
        while (i2 < this.m_model.getColHdrColCount()) {
            if (this.m_pageInfo.getFieldType(this.m_pageInfo.getDataPosition(i2)) == 255) {
                this.m_table.setColHidden(i2);
            }
            ++i2;
        }
    }

    public void requestDownload() {
        this.m_page.m_pageInfo.setRecvData(new ArrayList());
        this.m_downLoad = new DoDownload();
        this.m_downLoad.start();
    }

    public void createPage() {
    }

    public void runActionEvent(String command) {
    }

    public void runItemChangeEvent(ItemEvent ie) {
    }

    public class DoDownload
    extends Thread {
        @Override
        public void run() {
            AppGlobal.showProgress(AppDialog.this.m_page.m_tnInfo.getTabTitle(), "Downloading data...");
            if (AppComm.getInstance().requestDownload(AppDialog.this.m_pageInfo)) {
                try {
                    AppDialog.this.m_recvData = AppDialog.this.m_pageInfo.getRecvData();
                    AppDialog.this.m_page.setTableTitle();
                    AppDialog.this.createPage();
                    AppDialog.this.m_contentPane.repaint();
                }
                catch (Exception e2) {
                    AppGlobal.hideProgress();
                    AppGlobal.showErrorMessage("", AppLang.getText("Failed create page."));
                }
                AppGlobal.hideProgress();
            }
            AppDialog.this.m_downLoad = null;
        }
    }
}

