/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppNewCombo;
import com.sec.osdm.pages.utils.components.AppNewText;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import jxl.Workbook;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class AppExport
extends AppDialog {
    private final int SIZE_WIDTH = 800;
    private final int SIZE_HEIGHT = 600;
    private JLabel m_file = new JLabel();
    private JComboBox m_cbSheet = new JComboBox();
    private JComboBox m_cbFeature = new JComboBox();
    private String[] m_mmcList = new String[]{"2402", "2403", "2601", "3203", "3205", "3206", "4400", "4502", "4503", "5F06", "5F07"};

    public AppExport() {
        this.m_layout = new AppLayout(this.m_contentPane, 800, 600);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppExport.this.openDialog("DB Export", 800, 600);
            }
        });
    }

    private void createComponents() {
        String[] btTitle = new String[]{"File", "New", "Export", "Close"};
        JButton[] buttons = new JButton[4];
        this.m_file.setBorder(new LineBorder(Color.darkGray));
        int i2 = 0;
        while (i2 < buttons.length) {
            buttons[i2] = new JButton(AppLang.getText(btTitle[i2]));
            buttons[i2].setActionCommand(btTitle[i2]);
            buttons[i2].setFont(new Font("SansSerif", 0, 12));
            buttons[i2].setMargin(new Insets(0, 0, 0, 0));
            buttons[i2].addActionListener(this);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_mmcList.length) {
            this.m_cbFeature.addItem(((AppTreeNode)AppProperty.m_allMmcList.get(this.m_mmcList[i2])).getTabTitle());
            ++i2;
        }
        this.m_cbFeature.addItemListener(this);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Export File"), 4), 5, 5, 60, 20);
        this.m_layout.addComponent(this.m_file, 68, 5, 580, 20);
        this.m_layout.addComponent(buttons[0], 653, 5, 50, 20);
        this.m_layout.addComponent(buttons[3], 719, 5, 70, 20);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Sheet"), 4), 5, 30, 60, 20);
        this.m_layout.addComponent(this.m_cbSheet, 68, 30, 250, 20);
        this.m_layout.addComponent(buttons[1], 320, 30, 50, 20);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Feature"), 4), 390, 30, 60, 20);
        this.m_layout.addComponent(this.m_cbFeature, 453, 30, 250, 20);
        this.m_layout.addComponent(buttons[2], 719, 30, 70, 20);
        this.setComponents();
    }

    private void setComponents() {
        String msgId = this.m_mmcList[this.m_cbFeature.getSelectedIndex()];
        this.m_pageInfo = new AppPageInfo(msgId);
        this.m_page.setPageInfo(this.m_pageInfo);
        this.requestDownload();
    }

    @Override
    public void createPage() {
        this.m_corner = this.m_page.m_corner;
        this.m_colTitle = this.m_page.m_colTitle;
        this.m_rowTitle = this.m_page.m_rowTitle;
        this.m_components.clear();
        if (this.m_recvData != null && this.m_recvData.size() > 0) {
            ArrayList recvData = new ArrayList();
            ArrayList<Object> compData = null;
            String sValue = "";
            this.m_rowTitle = new String[this.m_recvData.size()][1];
            int i2 = 0;
            while (i2 < this.m_recvData.size()) {
                recvData = (ArrayList)this.m_recvData.get(i2);
                this.m_rowTitle[i2][0] = this.m_pageInfo.getMsgId().equals("3203") || this.m_pageInfo.getMsgId().equals("4502") || this.m_pageInfo.getMsgId().equals("4503") ? (String)recvData.get(2) : (String)recvData.get(0);
                compData = new ArrayList<Object>();
                int j2 = 0;
                while (j2 < this.m_colTitle[0].length) {
                    sValue = (String)recvData.get(this.m_pageInfo.getDataPosition(j2));
                    compData.add(j2, this.m_page.createComponent(j2, sValue));
                    ++j2;
                }
                this.m_components.add(i2, compData);
                ++i2;
            }
        }
        this.createTable();
    }

    private void createTable() {
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return ((ArrayList)AppExport.this.m_components.get(row)).get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.setTableModel();
        this.setTableColHidden();
        if (this.m_pageInfo.getMsgId().equals("5F07")) {
            int cnt = 1;
            int i2 = 1;
            while (i2 < this.m_model.getRowHdrRowCount()) {
                if (((String)this.m_model.getRowHdrName(i2 - 1, 0)).equals((String)this.m_model.getRowHdrName(i2, 0))) {
                    ++cnt;
                } else {
                    this.m_model.setRowHeaderRowSpan(i2 - cnt, 0, cnt);
                    cnt = 1;
                }
                ++i2;
            }
            if (cnt > 1) {
                this.m_model.setRowHeaderRowSpan(this.m_model.getRowHdrRowCount() - cnt, 0, cnt);
            }
        }
        this.m_layout.addComponent(this.m_table, 5, 55, 785, 510);
    }

    private void createExcelFile() {
        JFileChooser jfc = new JFileChooser((String)AppProperty.m_properties.get("USER_DIR"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter(String.valueOf(AppLang.getText("Excel File")) + "(*.xls)", "xls");
        jfc.setFileFilter(filter);
        jfc.setDialogType(1);
        int yn = jfc.showOpenDialog(null);
        if (yn == 0) {
            AppProperty.m_properties.put("USER_DIR", jfc.getSelectedFile().getParent());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            String xlsFile = jfc.getSelectedFile().getAbsolutePath();
            if (!xlsFile.endsWith(".xls")) {
                xlsFile = String.valueOf(xlsFile) + ".xls";
            }
            this.m_cbSheet.removeAllItems();
            File fd = new File(xlsFile);
            if (fd.exists()) {
                try {
                    Workbook workbook = Workbook.getWorkbook(fd);
                    String[] items = workbook.getSheetNames();
                    int i2 = 0;
                    while (i2 < items.length) {
                        this.m_cbSheet.addItem(items[i2]);
                        ++i2;
                    }
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, e2.getMessage());
                }
            }
            this.m_file.setText(xlsFile);
        }
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("File")) {
            this.createExcelFile();
        } else if (command.equals("New")) {
            String sheet;
            if (!this.m_file.getText().trim().equals("") && (sheet = JOptionPane.showInputDialog(AppLang.getText("Input the new sheet name."))) != null && !sheet.trim().equals("")) {
                int i2 = 0;
                while (i2 < this.m_cbSheet.getItemCount()) {
                    if (sheet.equals((String)this.m_cbSheet.getItemAt(i2))) {
                        this.m_cbSheet.setSelectedIndex(i2);
                        return;
                    }
                    ++i2;
                }
                this.m_cbSheet.addItem(sheet);
                this.m_cbSheet.setSelectedItem(sheet);
            }
        } else if (command.equals("Export")) {
            if (!this.m_file.getText().trim().equals("") && this.m_cbSheet.getSelectedIndex() >= 0) {
                AppGlobal.showProgress("Export data to excel file...", (String)this.m_cbFeature.getSelectedItem());
                ExecuteExport export = new ExecuteExport();
                export.start();
            }
        } else if (command.equals("Close")) {
            this.closeDialog();
        }
    }

    @Override
    public void runItemChangeEvent(ItemEvent ie) {
        this.setComponents();
    }

    class ExecuteExport
    extends Thread {
        ExecuteExport() {
        }

        @Override
        public void run() {
            File file = new File(AppExport.this.m_file.getText().trim());
            WritableWorkbook m_workBook = null;
            try {
                int j2;
                if (file.exists()) {
                    Workbook workbook = Workbook.getWorkbook(file);
                    m_workBook = Workbook.createWorkbook(file, workbook);
                } else {
                    m_workBook = Workbook.createWorkbook(file);
                }
                String[] sheetNames = m_workBook.getSheetNames();
                int i2 = 0;
                while (i2 < sheetNames.length) {
                    if (sheetNames[i2].equals((String)AppExport.this.m_cbSheet.getSelectedItem())) {
                        m_workBook.removeSheet(i2);
                        break;
                    }
                    ++i2;
                }
                WritableSheet sheet = m_workBook.createSheet((String)AppExport.this.m_cbSheet.getSelectedItem(), AppExport.this.m_cbSheet.getSelectedIndex());
                WritableCellFormat fColumns = new WritableCellFormat();
                WritableCellFormat fData = new WritableCellFormat();
                fColumns.setBackground(Colour.GRAY_25);
                fColumns.setBorder(Border.ALL, BorderLineStyle.THIN);
                Label label = null;
                String data = "";
                int row = 1;
                int col = 1;
                int i3 = 0;
                while (i3 < AppExport.this.m_model.getCornerHdrColCount()) {
                    j2 = 0;
                    while (j2 < AppExport.this.m_model.getCornerHdrRowCount()) {
                        data = (String)AppExport.this.m_model.getCornerHdrNames(j2, i3);
                        label = new Label(col + i3, row + j2, data, (CellFormat)fColumns);
                        sheet.addCell(label);
                        ++j2;
                    }
                    ++i3;
                }
                col += AppExport.this.m_model.getCornerHdrColCount();
                i3 = 0;
                while (i3 < AppExport.this.m_model.getColHdrColCount()) {
                    if (!AppExport.this.m_model.isColHidden(i3)) {
                        j2 = 0;
                        while (j2 < AppExport.this.m_model.getColHdrRowCount()) {
                            data = (String)AppExport.this.m_model.getColHdrName(j2, i3);
                            label = new Label(col, row + j2, data, (CellFormat)fColumns);
                            sheet.addCell(label);
                            ++j2;
                        }
                        ++col;
                    }
                    ++i3;
                }
                col = 1;
                row += AppExport.this.m_model.getCornerHdrRowCount();
                i3 = 0;
                while (i3 < AppExport.this.m_model.getRowHdrColCount()) {
                    j2 = 0;
                    while (j2 < AppExport.this.m_model.getRowHdrRowCount()) {
                        data = (String)AppExport.this.m_model.getRowHdrName(j2, i3);
                        label = new Label(col + i3, row + j2, data, (CellFormat)fColumns);
                        sheet.addCell(label);
                        ++j2;
                    }
                    ++i3;
                }
                row = AppExport.this.m_model.getCornerHdrRowCount() + 1;
                col = AppExport.this.m_model.getCornerHdrColCount() + 1;
                fData.setBorder(Border.ALL, BorderLineStyle.THIN);
                i3 = 0;
                while (i3 < AppExport.this.m_model.getColHdrColCount()) {
                    if (!AppExport.this.m_model.isColHidden(i3)) {
                        j2 = 0;
                        while (j2 < AppExport.this.m_model.getRowHdrRowCount()) {
                            Object obj = AppExport.this.m_model.getValueAt(j2, i3);
                            label = obj instanceof AppComboBox ? new Label(col, row + j2, ((AppComboBox)obj).getSelectedItem(), (CellFormat)fData) : (obj instanceof AppTextBox ? new Label(col, row + j2, ((AppTextBox)obj).getText().trim(), (CellFormat)fData) : (obj instanceof AppNewCombo ? new Label(col, row + j2, (String)((AppNewCombo)obj).getSelectedItem(), (CellFormat)fData) : new Label(col, row + j2, ((AppNewText)obj).getText().trim(), (CellFormat)fData)));
                            sheet.addCell(label);
                            ++j2;
                        }
                        ++col;
                    }
                    ++i3;
                }
                m_workBook.write();
                m_workBook.close();
            }
            catch (Exception e1) {
                AppGlobal.hideProgress();
                JOptionPane.showMessageDialog(null, e1.getMessage());
            }
            AppGlobal.hideProgress();
        }
    }
}

