/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.AppKeyProgram;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AppPartRequest
extends AppDialog
implements MouseListener,
KeyListener {
    private final int SIZE_WIDTH = 600;
    private final int SIZE_HEIGHT = 470;
    private final int TYPE_LIST = 0;
    private final int TYPE_COUNT = 1;
    private final int TYPE_DATA = 2;
    private final int TYPE_RANGE = 3;
    private AppPageInfo m_pageInfo = null;
    private AppTreeNode m_tnInfo = null;
    private DefaultListModel m_lmSource = new DefaultListModel();
    private DefaultListModel m_lmTarget = new DefaultListModel();
    private JList m_source = new JList(this.m_lmSource);
    private JList m_target = new JList(this.m_lmTarget);
    private JPanel m_panLeft = new JPanel();
    private JPanel m_panRight = new JPanel(new BorderLayout());
    private JRadioButton m_jbArray = new JRadioButton(AppLang.getText("Array"));
    private JRadioButton m_jbRange = new JRadioButton(AppLang.getText("Range"));
    private JRadioButton m_jbAll = new JRadioButton(AppLang.getText("All"), true);
    private JTextField m_txtArray = new JTextField();
    private JComboBox m_cbStart = new JComboBox();
    private JComboBox m_cbEnd = new JComboBox();
    private Hashtable m_isSource = new Hashtable();
    private Vector m_data = new Vector();
    private byte[] m_recvData = null;

    public AppPartRequest(String msgId) {
        this.m_layout = new AppLayout(this.m_contentPane, 600, 470);
        this.m_pageInfo = new AppPageInfo(msgId);
        this.m_tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(msgId);
        this.m_pageInfo.setDownMsgType(this.m_tnInfo.getMessageType(0));
        if (AppComm.getInstance().partialRequest(this.m_pageInfo)) {
            this.m_recvData = this.m_pageInfo.getRespData();
            this.setRecvData();
        }
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppPartRequest.this.openDialog("Partial Request", 600, 470);
            }
        });
    }

    private void setRecvData() {
        int i2;
        this.m_data.clear();
        if (this.m_tnInfo.getMessageType(0) == -62) {
            i2 = 0;
            while (i2 < this.m_recvData.length) {
                String data = AppFunctions.byte2tel(this.m_recvData[i2], this.m_recvData[i2 + 1]);
                if (data != null && !data.equals("")) {
                    this.m_data.add(data);
                }
                i2 += 2;
            }
            Collections.sort(this.m_data);
        } else {
            i2 = 0;
            while (i2 < this.m_recvData.length) {
                int val = Integer.parseInt(AppFunctions.unsignedValue(AppFunctions.byte2short(this.m_recvData, i2)));
                String msgId = this.m_pageInfo.getMsgId();
                if (val < 65535) {
                    if (msgId.equals("3104")) {
                        this.m_data.add("Route " + String.format("%02d", val + 1));
                    } else if (msgId.equals("4702")) {
                        this.m_data.add("COS " + String.format("%02d", val + 1));
                    } else if (msgId.equals("4901")) {
                        this.m_data.add(AppKeyProgram.getKeyset(val));
                    } else if (msgId.equals("5214")) {
                        this.m_data.add("Table " + String.format("%02d", val + 1));
                    } else if (msgId.equals("5217")) {
                        this.m_data.add("Table " + String.format("%03d", val));
                    } else {
                        this.m_data.add("" + (val + 1));
                    }
                }
                i2 += 2;
            }
        }
        this.m_cbStart.addItem(" ");
        this.m_cbEnd.addItem(" ");
        this.m_isSource.clear();
        i2 = 0;
        while (i2 < this.m_data.size()) {
            this.m_isSource.put((String)this.m_data.get(i2), false);
            this.m_cbStart.addItem((String)this.m_data.get(i2));
            this.m_cbEnd.addItem((String)this.m_data.get(i2));
            ++i2;
        }
        this.resetCompData();
        this.showDataList();
    }

    private void createComponents() {
        this.m_source.setSelectionMode(2);
        this.m_source.setLayoutOrientation(2);
        this.m_source.setVisibleRowCount(9);
        this.m_source.addMouseListener(this);
        JScrollPane jspSource = new JScrollPane(this.m_source);
        JPanel panSource = new JPanel(new BorderLayout());
        panSource.setBorder(new TitledBorder(AppLang.getText("Total Item(s)")));
        panSource.add((Component)jspSource, "Center");
        this.m_target.setSelectionMode(2);
        this.m_target.setLayoutOrientation(2);
        this.m_target.setVisibleRowCount(7);
        this.m_target.addMouseListener(this);
        JScrollPane jspTarget = new JScrollPane(this.m_target);
        JPanel panTarget = new JPanel(new GridLayout(1, 2));
        panTarget.setBorder(new TitledBorder(AppLang.getText("Wanted Item(s)")));
        this.createLeftPanel();
        this.m_panRight.setBorder(new TitledBorder(""));
        this.m_panRight.add((Component)jspTarget, "Center");
        panTarget.add(this.m_panLeft);
        panTarget.add(this.m_panRight);
        this.m_layout.addComponent(panSource, 5, 5, 585, 230);
        this.m_layout.addComponent(panTarget, 5, 235, 585, 200);
        this.getContentPane().add(this.m_contentPane);
    }

    private void createLeftPanel() {
        AppLayout layout = new AppLayout(this.m_panLeft, 290, 200);
        JLabel lbRange = new JLabel("-", 0);
        ButtonGroup btGroup = new ButtonGroup();
        JButton btOk = new JButton(AppLang.getText("OK"));
        JButton btCancel = new JButton(AppLang.getText("Cancel"));
        this.m_panLeft.setBorder(new TitledBorder(""));
        btGroup.add(this.m_jbArray);
        btGroup.add(this.m_jbRange);
        btGroup.add(this.m_jbAll);
        btOk.setActionCommand("OK");
        btCancel.setActionCommand("Cancel");
        btOk.addActionListener(this);
        btCancel.addActionListener(this);
        this.m_jbArray.addItemListener(this);
        this.m_jbRange.addItemListener(this);
        this.m_jbAll.addItemListener(this);
        this.m_txtArray.addKeyListener(this);
        this.m_cbStart.addItemListener(this);
        this.m_cbEnd.addItemListener(this);
        layout.addComponent(this.m_jbArray, 5, 10, 70, 25);
        layout.addComponent(this.m_txtArray, 80, 10, 200, 25);
        layout.addComponent(this.m_jbRange, 5, 45, 70, 25);
        layout.addComponent(this.m_cbStart, 80, 45, 95, 25);
        layout.addComponent(lbRange, 178, 45, 4, 25);
        layout.addComponent(this.m_cbEnd, 184, 45, 95, 25);
        layout.addComponent(this.m_jbAll, 5, 80, 70, 25);
        layout.addComponent(btOk, 110, 148, 80, 20);
        layout.addComponent(btCancel, 200, 148, 80, 20);
    }

    private void showDataList() {
        this.m_lmSource.removeAllElements();
        this.m_lmTarget.removeAllElements();
        int i2 = 0;
        while (i2 < this.m_data.size()) {
            if (((Boolean)this.m_isSource.get((String)this.m_data.get(i2))).booleanValue()) {
                this.m_lmSource.addElement("  " + (String)this.m_data.get(i2));
            } else {
                this.m_lmTarget.addElement("  " + (String)this.m_data.get(i2));
            }
            ++i2;
        }
    }

    private void setSourceData(boolean status) {
        int i2 = 0;
        while (i2 < this.m_data.size()) {
            this.m_isSource.put((String)this.m_data.get(i2), status);
            ++i2;
        }
    }

    private void resetCompData() {
        this.m_txtArray.setText("");
        if (this.m_cbStart.getItemCount() > 0) {
            this.m_cbStart.setSelectedIndex(0);
            this.m_cbEnd.setSelectedIndex(0);
        }
        this.m_target.setEnabled(false);
        this.m_cbStart.setEnabled(false);
        this.m_cbEnd.setEnabled(false);
        this.m_txtArray.setEnabled(false);
    }

    private void partRequestDownload() {
        try {
            this.m_pageInfo.setPartialRequest(true);
            Class<?> klass = Class.forName(((AppTreeNode)AppProperty.m_allMmcList.get(this.m_pageInfo.getMsgId())).getClassName());
            Class[] param = new Class[]{AppPageInfo.class};
            Constructor<?> cons = klass.getConstructor(param);
            Object[] args = new Object[]{this.m_pageInfo};
            AppPage objPage = (AppPage)cons.newInstance(args);
            String tabTitle = ((AppTreeNode)AppProperty.m_allMmcList.get(this.m_pageInfo.getMsgId())).getTabTitle();
            AppGlobal.g_frmMain.m_pagePane.add((Component)objPage, AppGlobal.g_frmMain.m_pagePane.getTabCount());
            AppGlobal.g_frmMain.m_pagePane.setTitleAt(AppGlobal.g_frmMain.m_pagePane.getTabCount() - 1, tabTitle);
            AppGlobal.g_frmMain.m_pagePane.setSelectedIndex(AppGlobal.g_frmMain.m_pagePane.getTabCount() - 1);
            AppGlobal.g_frmMain.m_menuBar.addNewTabMenu(tabTitle);
            AppGlobal.g_frmMain.m_toolBar.addHistoryPopupItem((AppTreeNode)AppProperty.m_allMmcList.get(this.m_pageInfo.getMsgId()));
            this.closeDialog();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("OK")) {
            if (this.m_jbAll.isSelected()) {
                this.m_pageInfo.setDownMsgType((byte)-48);
                this.m_pageInfo.setReqData(new byte[0]);
                this.partRequestDownload();
            } else if (this.m_lmTarget.getSize() > 0) {
                if (this.m_jbArray.isSelected()) {
                    byte[] reqData = new byte[this.m_lmTarget.getSize() * 2];
                    String sValue = "";
                    int i2 = 0;
                    while (i2 < this.m_lmTarget.getSize()) {
                        sValue = ((String)this.m_lmTarget.getElementAt(i2)).trim();
                        if (this.m_tnInfo.getMessageType(0) == -62) {
                            AppFunctions.tel2byte(reqData, i2 * 2, sValue);
                        } else if (this.m_pageInfo.getMsgId().equals("4901")) {
                            AppFunctions.short2byte(reqData, i2 * 2, (short)AppKeyProgram.getKeyset(sValue));
                        } else {
                            int j2 = 0;
                            while (j2 < this.m_data.size()) {
                                if (((String)this.m_data.get(j2)).equals(sValue)) {
                                    AppFunctions.short2byte(reqData, i2 * 2, (short)j2);
                                }
                                ++j2;
                            }
                        }
                        ++i2;
                    }
                    this.m_pageInfo.setDownMsgType(this.m_tnInfo.getMessageType(2));
                    this.m_pageInfo.setRecordSize(2);
                    this.m_pageInfo.setReqData(reqData);
                    this.partRequestDownload();
                } else {
                    byte[] reqCount = new byte[4];
                    String start = ((String)this.m_cbStart.getSelectedItem()).trim();
                    String end = ((String)this.m_cbEnd.getSelectedItem()).trim();
                    if (!start.equals("") && !end.equals("")) {
                        if (this.m_tnInfo.getMessageType(0) == -62) {
                            AppFunctions.tel2byte(reqCount, 0, start);
                            AppFunctions.tel2byte(reqCount, 2, end);
                        } else if (this.m_pageInfo.getMsgId().equals("4901")) {
                            AppFunctions.short2byte(reqCount, 0, (short)AppKeyProgram.getKeyset(start));
                            AppFunctions.short2byte(reqCount, 2, (short)AppKeyProgram.getKeyset(end));
                        } else {
                            AppFunctions.short2byte(reqCount, 0, (short)(this.m_cbStart.getSelectedIndex() - 1));
                            AppFunctions.short2byte(reqCount, 2, (short)(this.m_cbEnd.getSelectedIndex() - 1));
                        }
                        this.m_pageInfo.setDownMsgType(this.m_tnInfo.getMessageType(1));
                        this.m_pageInfo.setRecordSize(4);
                        this.m_pageInfo.setReqData(reqCount);
                        if (AppComm.getInstance().partialRequest(this.m_pageInfo)) {
                            byte[] resData = this.m_pageInfo.getRespData();
                            byte[] reqData = new byte[4];
                            Arrays.fill(reqData, (byte)0);
                            reqData[2] = resData[0];
                            reqData[3] = resData[1];
                            this.m_pageInfo.setDownMsgType(this.m_tnInfo.getMessageType(3));
                            this.m_pageInfo.setReqData(reqData);
                            this.partRequestDownload();
                        }
                    }
                }
            }
        } else if (command.equals("Cancel")) {
            this.closeDialog();
        }
    }

    @Override
    public void runItemChangeEvent(ItemEvent ie) {
        if (ie.getSource() instanceof JRadioButton) {
            this.resetCompData();
            if (ie.getItem() == this.m_jbAll) {
                this.setSourceData(false);
                this.m_lmSource.removeAllElements();
            } else {
                this.setSourceData(true);
                if (ie.getItem() == this.m_jbArray) {
                    this.m_txtArray.setEnabled(true);
                } else {
                    this.m_cbStart.setEnabled(true);
                    this.m_cbEnd.setEnabled(true);
                }
                this.m_target.setEnabled(true);
            }
        } else {
            if (this.m_pageInfo.getMsgId().equals("4901")) {
                int start = this.m_cbStart.getSelectedIndex();
                int end = this.m_cbEnd.getSelectedIndex();
                if (start > 0 && end > 0 && start > end) {
                    this.m_cbStart.setSelectedIndex(end);
                    this.m_cbEnd.setSelectedIndex(start);
                }
            } else {
                String end;
                String start = ((String)this.m_cbStart.getSelectedItem()).trim();
                if (start.compareTo(end = ((String)this.m_cbEnd.getSelectedItem()).trim()) > 0) {
                    this.m_cbStart.setSelectedItem(end);
                    this.m_cbEnd.setSelectedItem(start);
                }
            }
            this.setSourceData(true);
            int i2 = this.m_cbStart.getSelectedIndex();
            while (i2 <= this.m_cbEnd.getSelectedIndex()) {
                this.m_isSource.put((String)this.m_cbStart.getItemAt(i2), false);
                ++i2;
            }
        }
        this.showDataList();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getClickCount() >= 2) {
            int idx;
            String val;
            if (me.getSource() == this.m_source) {
                int idx2 = this.m_source.locationToIndex(me.getPoint());
                String val2 = (String)this.m_lmSource.getElementAt(idx2);
                if (this.m_isSource.containsKey(val2.trim())) {
                    this.m_isSource.put(val2.trim(), false);
                }
            } else if (this.m_target.isEnabled() && this.m_isSource.containsKey((val = (String)this.m_lmTarget.getElementAt(idx = this.m_target.locationToIndex(me.getPoint()))).trim())) {
                this.m_isSource.put(val.trim(), true);
            }
            this.showDataList();
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getSource() == this.m_txtArray && ke.getKeyCode() == 10) {
            this.setSourceData(true);
            if (!this.m_txtArray.getText().trim().equals("")) {
                String[] arrData = this.m_txtArray.getText().trim().split(",");
                int i2 = 0;
                while (i2 < arrData.length) {
                    String[] range = arrData[i2].trim().split("-");
                    if (range.length < 2) {
                        if (this.m_isSource.containsKey(range[0].trim())) {
                            this.m_isSource.put(range[0].trim(), false);
                        }
                    } else if (!range[0].equals("") && !range[1].equals("")) {
                        int start = Integer.parseInt(range[0]);
                        int end = Integer.parseInt(range[1]);
                        int temp = 0;
                        String val = "";
                        if (start > end) {
                            temp = start;
                            start = end;
                            end = temp;
                        }
                        int j2 = start;
                        while (j2 <= end) {
                            val = "" + j2;
                            if (this.m_isSource.containsKey(val)) {
                                this.m_isSource.put(val, false);
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
            }
            this.showDataList();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }
}

