/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils.convert;

import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.utils.convert.AppConvertInfo;
import com.sec.osdm.main.utils.convert.AppGetITData;
import com.sec.osdm.main.utils.convert.AppRefConvert;
import com.sec.osdm.pages.utils.components.AppComboBox;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class AppDBConvert
extends AppDialog {
    private final int SIZE_WIDTH = 720;
    private final int SIZE_HEIGHT = 270;
    private AppGetITData m_itData = null;
    private AppConvertInfo m_convInfo = new AppConvertInfo();
    private JLabel[] m_lbData = new JLabel[7];
    private String[] m_lbTitles = new String[]{"", "Kind", "", "Version", "", "", "Version"};
    private AppComboBox m_cbVersion = new AppComboBox();
    private Hashtable m_readData = new Hashtable();
    private ArrayList m_cvtList = new ArrayList();
    private TreeMap m_verList = null;
    private TreeMap m_convList = null;
    private String m_source = "";
    private String m_target = "";
    private int m_version = 0;
    private boolean m_isDbOsdm = true;

    public AppDBConvert() {
        this.m_layout = new AppLayout(this.m_contentPane, 720, 270);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppDBConvert.this.openDialog("DB Conversion", 720, 270);
            }
        });
    }

    private void createComponents() {
        JPanel panSource = new JPanel();
        JPanel panTarget = new JPanel();
        AppLayout layout1 = new AppLayout(panSource, 700, 100);
        AppLayout layout2 = new AppLayout(panTarget, 700, 100);
        String[] titles = new String[]{"...", "...", AppLang.getText("Start"), AppLang.getText("Close")};
        String[] command = new String[]{"File1", "File2", "Start", "Close"};
        JButton[] buttons = new JButton[4];
        panSource.setBorder(new TitledBorder(new LineBorder(Color.darkGray), AppLang.getText("Source File")));
        panTarget.setBorder(new TitledBorder(new LineBorder(Color.darkGray), AppLang.getText("Target File")));
        int i2 = 0;
        while (i2 < 4) {
            buttons[i2] = new JButton(titles[i2]);
            buttons[i2].setActionCommand(command[i2]);
            buttons[i2].addActionListener(this);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_lbData.length) {
            this.m_lbData[i2] = new JLabel(AppLang.getText(this.m_lbTitles[i2]));
            ++i2;
        }
        this.m_lbData[1].setHorizontalAlignment(4);
        this.m_lbData[2].setHorizontalAlignment(0);
        this.m_lbData[3].setHorizontalAlignment(4);
        this.m_lbData[4].setHorizontalAlignment(0);
        this.m_lbData[6].setHorizontalAlignment(4);
        this.m_lbData[0].setBorder(new LineBorder(Color.darkGray));
        this.m_lbData[2].setBorder(new LineBorder(Color.darkGray));
        this.m_lbData[4].setBorder(new LineBorder(Color.darkGray));
        this.m_lbData[5].setBorder(new LineBorder(Color.darkGray));
        layout1.addComponent(this.m_lbData[0], 5, 30, 660, 20);
        layout1.addComponent(buttons[0], 670, 30, 30, 20);
        layout1.addComponent(this.m_lbData[1], 5, 60, 80, 20);
        layout1.addComponent(this.m_lbData[2], 90, 60, 150, 20);
        layout1.addComponent(this.m_lbData[3], 260, 60, 80, 20);
        layout1.addComponent(this.m_lbData[4], 345, 60, 150, 20);
        layout2.addComponent(this.m_lbData[5], 5, 30, 660, 20);
        layout2.addComponent(buttons[1], 670, 30, 30, 20);
        layout2.addComponent(this.m_lbData[6], 5, 60, 80, 20);
        layout2.addComponent(this.m_cbVersion.getComponent(), 90, 60, 150, 20);
        this.m_cbVersion.addListener(this);
        this.m_layout.addComponent(panSource, 5, 10, 705, 90);
        this.m_layout.addComponent(panTarget, 5, 120, 705, 90);
        this.m_layout.addComponent(buttons[2], 555, 213, 70, 20);
        this.m_layout.addComponent(buttons[3], 638, 213, 70, 20);
        this.m_convList = this.m_convInfo.getConvertList();
    }

    private void openBackupDatabase() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("Backup Database")) + "(*.IUD;*.odm)", "IUD", "odm");
        if (browser.openBrowser()) {
            this.m_source = browser.getFilePath();
            boolean bl2 = this.m_isDbOsdm = this.m_source.indexOf(".IUD") < 0;
            if (this.m_isDbOsdm) {
                if (browser.checkDatabaseFile()) {
                    this.m_readData = browser.getDatabase();
                    if (this.checkPassword()) {
                        this.setDatabaseInfo();
                    }
                }
            } else {
                this.m_itData = new AppGetITData(this.m_source);
                this.m_readData = this.m_itData.getITData();
                if (this.m_readData != null) {
                    this.setDatabaseInfo();
                }
            }
        }
    }

    private boolean checkPassword() {
        String m_password;
        while ((m_password = JOptionPane.showInputDialog(AppLang.getText("Input the password of Installation DB."))) != null) {
            if (m_password.equals(AppFunctions.byte2str((byte[])this.m_readData.get("0001"), 0, 50))) {
                return true;
            }
            AppGlobal.showErrorMessage("", "Inputted password is wrong. Again input the password.");
        }
        return false;
    }

    private void setDatabaseInfo() {
        AppRunInfo.setLinkData((byte[])this.m_readData.get("0000"));
        this.m_lbData[0].setText(this.m_source);
        if (this.m_isDbOsdm) {
            this.m_lbData[2].setText("OSDM Database");
        } else {
            this.m_lbData[2].setText("Installation Database");
        }
        this.m_verList = this.m_convInfo.getVersionList();
        this.m_version = AppRunInfo.getRunVersion();
        this.m_lbData[4].setText(this.m_verList.containsKey(this.m_version) ? (String)this.m_verList.get(this.m_version) : "Unknown");
        this.createVersionSelect();
    }

    private void createDatabase() {
        AppFileBrowser browser = new AppFileBrowser();
        browser.setFileFilter(String.valueOf(AppLang.getText("OSDM File")) + "(*.odm)", "odm");
        if (browser.saveBrowserWithExtender("odm")) {
            this.m_target = browser.getFilePath();
            this.m_lbData[5].setText(this.m_target);
        }
    }

    private void saveConversionDataToFile() {
        File fd = new File(this.m_target);
        FileOutputStream m_fos = null;
        ObjectOutputStream m_oos = null;
        byte[] linkinfo = (byte[])this.m_readData.get("0000");
        AppRunInfo.setLinkData(linkinfo);
        AppRunInfo.setSysVersion((String)this.m_verList.get(this.m_cbVersion.getSelectedIndex()));
        AppRunInfo.setRunVersion(this.m_cbVersion.getSelectedIndex());
        this.m_readData.put("0000", linkinfo);
        try {
            m_fos = new FileOutputStream(fd);
            m_oos = new ObjectOutputStream(m_fos);
            m_oos.writeObject(this.m_readData);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            m_oos.close();
            m_fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_source = "";
        this.m_target = "";
        this.clearComponents();
        AppGlobal.showInfoMessage("", "Completed to convert database.");
    }

    @Override
    public void closeDialog() {
        if (AppGlobal.g_accessProcess != null && this.m_itData != null) {
            this.m_itData.disconnect();
        }
        this.dispose();
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Start")) {
            if (this.m_lbData[0].getText().trim().equals("") || this.m_lbData[5].getText().trim().equals("")) {
                if (!this.m_target.equals("")) {
                    this.deleteExistFile();
                }
                return;
            }
            if (this.m_cbVersion.getSelectedIndex() == 0 || this.m_version >= this.m_cbVersion.getSelectedIndex()) {
                if (!this.m_isDbOsdm) {
                    this.saveConversionDataToFile();
                } else {
                    this.deleteExistFile();
                }
                return;
            }
            this.createConvertList();
            new StartConversion().start();
        } else if (command.equals("File1")) {
            this.clearComponents();
            this.openBackupDatabase();
        } else if (command.equals("File2")) {
            this.m_lbData[5].setText("");
            this.createDatabase();
        } else if (command.equals("Close")) {
            this.closeDialog();
        }
    }

    private void deleteExistFile() {
        File file = new File(this.m_target);
        if (file.exists()) {
            file.delete();
        }
    }

    private void clearComponents() {
        this.m_lbData[0].setText("");
        this.m_lbData[2].setText("");
        this.m_lbData[4].setText("");
        this.m_lbData[5].setText("");
        this.m_cbVersion.removeAllItems();
        this.m_itData = null;
    }

    private void createVersionSelect() {
        this.m_cbVersion.removeAllItems();
        for (Integer key : this.m_verList.keySet()) {
            if (key <= this.m_version) continue;
            this.m_cbVersion.addItem((String)this.m_verList.get(key), key);
        }
    }

    private void createConvertList() {
        this.m_cvtList.clear();
        for (Integer key : this.m_convList.keySet()) {
            if (key <= this.m_version || key > this.m_cbVersion.getSelectedIndex()) continue;
            this.m_cvtList.add(key + ":" + (String)this.m_convList.get(key));
        }
    }

    private boolean startDatabaseConvert() {
        String path = "com.sec.osdm.main.utils.convert.";
        for (Object lst : this.m_cvtList) {
            String[] info = ((String)lst).split(":");
            int key = Integer.parseInt(info[0].trim());
            try {
                Class<?> klass = Class.forName(String.valueOf(path) + info[1].trim());
                Class[] param = new Class[]{Hashtable.class};
                Constructor<?> cons = klass.getConstructor(param);
                Object[] args = new Object[]{this.m_readData};
                AppRefConvert convert = (AppRefConvert)cons.newInstance(args);
                convert.startConvert();
                this.m_readData = convert.getConvertData();
                if (this.m_readData != null) continue;
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return true;
    }

    class StartConversion
    extends Thread {
        StartConversion() {
        }

        @Override
        public void run() {
            AppGlobal.showProgress("Converting....", "Wait a moment...");
            boolean result = AppDBConvert.this.startDatabaseConvert();
            AppGlobal.hideProgress();
            if (result) {
                AppDBConvert.this.saveConversionDataToFile();
            } else {
                AppGlobal.showInfoMessage("", "Failed to convert database.");
            }
        }
    }
}

