/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class AppBookMark
extends AppDialog {
    private final int SIZE_WIDTH = 500;
    private final int SIZE_HEIGHT = 400;
    private AppTextBox m_compText = null;
    private AppComboBox m_bookItem = new AppComboBox();
    private JCheckBox m_compCheck = null;

    public AppBookMark() {
        this.m_layout = new AppLayout(this.m_contentPane, 500, 400);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppBookMark.this.openDialog("Bookmarks", 500, 400);
            }
        });
    }

    private void createComponents() {
        String[] btTitle = new String[]{"Delete", "Delete All", "Add", "Close"};
        JButton[] buttons = new JButton[4];
        JLabel label = new JLabel(AppLang.getText("Item"), 4);
        AppTreeNode tnInfo = null;
        int i2 = 0;
        while (i2 < buttons.length) {
            buttons[i2] = new JButton(AppLang.getText(btTitle[i2]));
            buttons[i2].setActionCommand(btTitle[i2]);
            buttons[i2].addActionListener(this);
            ++i2;
        }
        Vector vtTemp = new Vector(AppGlobal.g_useMenu.keySet());
        Collections.sort(vtTemp);
        for (String key : vtTemp) {
            if (!((String)AppGlobal.g_useMenu.get(key)).equals("0") || !AppProperty.m_allMmcList.containsKey(key)) continue;
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(key);
            this.m_bookItem.addItem(tnInfo.getTabTitle());
        }
        this.m_layout.addComponent(label, 5, 8, 60, 20);
        this.m_layout.addComponent(this.m_bookItem.getComponent(), 70, 8, 200, 20);
        this.m_layout.addComponent(buttons[2], 280, 8, 80, 20);
        this.m_layout.addComponent(buttons[0], 5, 342, 80, 20);
        this.m_layout.addComponent(buttons[1], 100, 342, 110, 20);
        this.m_layout.addComponent(buttons[3], 410, 342, 80, 20);
        this.setComponents();
    }

    private void setComponents() {
        ArrayList<Object> compData = null;
        AppTreeNode tnInfo = null;
        ArrayList bookInfo = new ArrayList();
        AppProperty.m_bookmark = (ArrayList)AppProperty.readDataFromFile(AppProperty.m_fileBook);
        this.m_rowTitle = new String[AppProperty.m_bookmark.size()][1];
        int i2 = 0;
        while (i2 < this.m_rowTitle.length) {
            this.m_rowTitle[i2][0] = "" + (i2 + 1);
            bookInfo = (ArrayList)AppProperty.m_bookmark.get(i2);
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get((String)bookInfo.get(1));
            compData = new ArrayList<Object>();
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)bookInfo.get(1));
            compData.add(0, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText(tnInfo.getIndex());
            compData.add(1, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText(tnInfo.getTitle());
            compData.add(2, this.m_compText);
            this.m_compCheck = new JCheckBox("", false);
            this.m_compCheck.setHorizontalAlignment(0);
            compData.add(3, this.m_compCheck);
            this.m_components.add(i2, compData);
            ++i2;
        }
        this.createTable();
    }

    private void createTable() {
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.m_model = new AppTableModel(this.m_rowTitle, new String[][]{{"MsgId", "Menu", "Description", "Select"}}, new String[][]{{"No"}}){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppBookMark.this.m_components.get(row);
                if (col == 3) {
                    return (JCheckBox)compData.get(col);
                }
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 3;
            }
        };
        this.m_model.setRowWidth(new int[]{40});
        int[] nArray = new int[4];
        nArray[1] = 60;
        nArray[2] = 300;
        nArray[3] = 60;
        this.m_model.setColWidth(nArray);
        this.m_table = new AppTable(this.m_model, 2);
        this.m_table.setColHidden(0);
        this.m_layout.addComponent(this.m_table, 5, 35, 485, 300);
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Close")) {
            this.closeDialog();
        } else {
            if (command.equals("Delete")) {
                int i2 = 0;
                while (i2 < this.m_model.getRowHdrRowCount()) {
                    if (((JCheckBox)this.m_model.getValueAt(i2, 3)).isSelected()) {
                        AppGlobal.g_frmMain.m_toolBar.removeBookPopupItem(i2 + 2);
                    }
                    ++i2;
                }
            } else if (command.equals("Delete All")) {
                AppGlobal.g_frmMain.m_toolBar.removeAllBookPopupItems();
            } else if (command.equals("Add")) {
                for (String key : AppProperty.m_allMmcList.keySet()) {
                    AppTreeNode tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(key);
                    if (!this.m_bookItem.getSelectedItem().equals(tnInfo.getTabTitle())) continue;
                    AppGlobal.g_frmMain.m_toolBar.addBookPopupItem(tnInfo);
                }
            }
            this.setComponents();
        }
    }
}

