/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AppSearchPane
extends JPanel
implements ActionListener,
KeyListener {
    private AppTable m_table = null;
    private AppTableModel m_model = null;
    private String[][] m_corner = new String[][]{new String[0]};
    private String[][] m_colTitle = new String[][]{{AppLang.getText("Go"), AppLang.getText("Result")}};
    private String[][] m_rowTitle = new String[][]{new String[0]};
    private ArrayList m_component = new ArrayList();
    private AppTextBox m_compText = null;
    private JButton m_compBtn = null;
    private JPanel m_panSub = new JPanel(new BorderLayout());
    private Hashtable m_mmcList = new Hashtable();
    private Hashtable m_menuList = new Hashtable();
    private JRadioButton m_rbMenu = new JRadioButton(AppLang.getText("by Menu"));
    private JRadioButton m_rbMMC = new JRadioButton(AppLang.getText("by MMC"), true);
    private JButton m_btSearch = new JButton(AppLang.getText("Search"));
    private JTextField m_txtSearch = new JTextField();
    private ArrayList m_result = new ArrayList();
    private String m_search = "";

    public AppSearchPane() {
        this.setLayout(new BorderLayout());
    }

    public void setMMCList() {
        for (String key : AppProperty.m_allMmcList.keySet()) {
            String val = ((AppTreeNode)AppProperty.m_allMmcList.get(key)).getMmcList();
            if (!AppGlobal.g_useMenu.containsKey(key)) continue;
            this.m_menuList.put(key, ((AppTreeNode)AppProperty.m_allMmcList.get(key)).getTabTitle());
            if (val.equals("")) continue;
            this.m_mmcList.put(key, val);
        }
        this.createComponents();
    }

    private void createComponents() {
        JPanel panOption = new JPanel();
        ButtonGroup btGroup = new ButtonGroup();
        btGroup.add(this.m_rbMenu);
        btGroup.add(this.m_rbMMC);
        panOption.add(this.m_rbMenu);
        panOption.add(this.m_rbMMC);
        this.m_rbMenu.setFont(new Font("SansSerif", 0, 12));
        this.m_rbMMC.setFont(new Font("SansSerif", 0, 12));
        panOption.setPreferredSize(new Dimension(300, 30));
        JPanel panSearch = new JPanel(new BorderLayout());
        this.m_txtSearch.setPreferredSize(new Dimension(220, 23));
        this.m_txtSearch.addKeyListener(this);
        this.m_btSearch.setPreferredSize(new Dimension(60, 23));
        this.m_btSearch.setFont(new Font("SansSerif", 0, 12));
        this.m_btSearch.setMargin(new Insets(0, 0, 0, 0));
        this.m_btSearch.setActionCommand("Search");
        this.m_btSearch.addActionListener(this);
        panSearch.add((Component)this.m_txtSearch, "Center");
        panSearch.add((Component)this.m_btSearch, "East");
        panSearch.setPreferredSize(new Dimension(300, 23));
        this.m_panSub.add((Component)panSearch, "North");
        this.add((Component)panOption, "North");
        this.add((Component)this.m_panSub, "Center");
    }

    private void searchByMenu() {
        ArrayList<String> result = null;
        for (String key : this.m_menuList.keySet()) {
            String val = (String)this.m_menuList.get(key);
            if (val.toUpperCase().indexOf(this.m_search.toUpperCase()) < 0 || !((String)AppGlobal.g_useMenu.get(key)).equals("0")) continue;
            result = new ArrayList<String>();
            result.add(0, key);
            result.add(1, val);
            this.m_result.add(this.m_result.size(), result);
        }
        this.setComponents();
    }

    private void searchByMMC() {
        ArrayList<String> result = null;
        AppTreeNode tnInfo = null;
        for (String key : this.m_mmcList.keySet()) {
            String val = (String)this.m_mmcList.get(key);
            if (val.indexOf(this.m_search) < 0 || !((String)AppGlobal.g_useMenu.get(key)).equals("0")) continue;
            result = new ArrayList<String>();
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(key);
            result.add(0, key);
            result.add(1, String.valueOf(tnInfo.getIndex()) + " - MMC " + val);
            this.m_result.add(this.m_result.size(), result);
        }
        this.setComponents();
    }

    private void setComponents() {
        if (this.m_table != null) {
            this.m_panSub.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        ArrayList result = new ArrayList();
        ArrayList<Object> compData = null;
        this.m_component.clear();
        this.m_rowTitle = new String[this.m_result.size()][1];
        int i2 = 0;
        while (i2 < this.m_rowTitle.length) {
            result = (ArrayList)this.m_result.get(i2);
            compData = new ArrayList<Object>();
            this.m_compBtn = new JButton("...");
            this.m_compBtn.setFont(new Font("SansSerif", 0, 11));
            this.m_compBtn.setMargin(new Insets(0, 0, 0, 0));
            this.m_compBtn.setActionCommand((String)result.get(0));
            this.m_compBtn.addActionListener(this);
            compData.add(0, this.m_compBtn);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)result.get(1));
            compData.add(1, this.m_compText);
            this.m_component.add(i2, compData);
            ++i2;
        }
        this.createTable();
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppSearchPane.this.m_component.get(row);
                if (col == 0) {
                    return (JButton)compData.get(col);
                }
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 1;
            }
        };
        this.m_model.setColWidth(new int[]{40, 250});
        this.m_model.setRowHeaderHidden();
        this.m_table = new AppTable(this.m_model, 2);
        this.m_panSub.add((Component)this.m_table, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        this.m_search = this.m_txtSearch.getText().trim();
        if (command.equals("Search")) {
            if (!this.m_search.equals("")) {
                this.m_result.clear();
                if (this.m_rbMenu.isSelected()) {
                    this.searchByMenu();
                } else {
                    this.searchByMMC();
                }
            }
        } else {
            AppTreeNode tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(command);
            AppGlobal.g_frmMain.m_pagePane.openNewPage(tnInfo.getTreeNode());
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        if (e2.getKeyCode() == 10) {
            this.m_btSearch.doClick();
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }
}

