/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.view.AppTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class AppTreePane {
    private JPanel m_panTree = new JPanel(new BorderLayout());
    private JTree m_treeFunc = null;
    private JTree m_treeKmmc = null;
    private JScrollPane m_jspFunc = null;
    private JScrollPane m_jspKmmc = null;
    private DefaultMutableTreeNode m_tnRoot = new DefaultMutableTreeNode("");
    private DefaultMutableTreeNode m_topNode = null;
    private DefaultMutableTreeNode m_subNode = null;
    private DefaultMutableTreeNode m_leafNode = null;
    private DefaultMutableTreeNode m_tnRootK = new DefaultMutableTreeNode("");
    private DefaultMutableTreeNode m_topNodeK = null;
    private DefaultMutableTreeNode m_subNodeK = null;
    private DefaultMutableTreeNode m_leafNodeK = null;
    private boolean m_bUseVMAA = false;
    private String[] m_topTitle = new String[]{"1xx", "2xx", "3xx", "4xx", "5xx", "6xx", "7xx", "8xx", "9xx", "?"};
    private TreeMap[] m_topList = new TreeMap[10];
    private JButton m_btnMode = new JButton("");
    private String m_menuMode = "";

    public JPanel createTreeNodes() {
        this.m_bUseVMAA = false;
        this.m_menuMode = (String)AppProperty.m_properties.get("USER_MENU_MODE");
        if (AppRunInfo.getRunMode() == 2 && (AppRunInfo.getSystem() == 19 || AppRunInfo.getSystem() == 23 || AppRunInfo.getSystem() == 34 || AppRunInfo.getSystem() == 1)) {
            this.m_bUseVMAA = true;
        }
        this.m_btnMode.setText(this.m_menuMode);
        this.m_btnMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AppTreePane.this.m_menuMode = AppTreePane.this.m_menuMode.equals("KMMC") ? AppLang.getText("Functional") : AppLang.getText("KMMC");
                AppTreePane.this.m_panTree.remove(AppTreePane.this.m_menuMode.equals("KMMC") ? AppTreePane.this.m_jspFunc : AppTreePane.this.m_jspKmmc);
                AppTreePane.this.m_panTree.add((Component)(AppTreePane.this.m_menuMode.equals("KMMC") ? AppTreePane.this.m_jspKmmc : AppTreePane.this.m_jspFunc), "Center");
                AppTreePane.this.m_btnMode.setText(AppTreePane.this.m_menuMode);
                AppProperty.m_properties.put("USER_MENU_MODE", AppTreePane.this.m_menuMode);
                AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
                AppTreePane.this.m_panTree.repaint();
            }
        });
        this.createTreeMenu();
        this.createKMMCTreeMenu();
        this.m_panTree.add((Component)this.m_btnMode, "North");
        this.m_panTree.add((Component)(this.m_menuMode.equals("KMMC") ? this.m_jspKmmc : this.m_jspFunc), "Center");
        this.m_panTree.repaint();
        return this.m_panTree;
    }

    public void createTreeMenu() {
        this.makeFuncTreeList();
        this.m_treeFunc = new JTree(this.m_tnRoot);
        this.m_jspFunc = new JScrollPane(this.m_treeFunc);
        BasicTreeUI ui = (BasicTreeUI)this.m_treeFunc.getUI();
        ui.setExpandedIcon(AppImages.Img_Tree_Minus);
        ui.setCollapsedIcon(AppImages.Img_Tree_Plus);
        this.m_treeFunc.setCellRenderer(new MainTreeCellRender());
        this.m_treeFunc.getSelectionModel().setSelectionMode(1);
        this.m_treeFunc.setRootVisible(false);
        this.m_treeFunc.setToggleClickCount(2);
        this.m_treeFunc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                AppTreePane.this.valueChanged(null);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.m_treeFunc);
        ToolTipManager.sharedInstance().setInitialDelay(500);
    }

    private void makeFuncTreeList() {
        Hashtable menu = AppProperty.m_treemenu;
        ArrayList TreeMenu = (ArrayList)menu.get("TREE_MENU");
        AppProperty.m_useMmcList.clear();
        int i2 = 0;
        while (i2 < TreeMenu.size()) {
            Hashtable topMenu = (Hashtable)TreeMenu.get(i2);
            this.m_topNode = new DefaultMutableTreeNode(" " + AppLang.getText((String)topMenu.get("TITLE")));
            ArrayList topList = (ArrayList)topMenu.get("LIST");
            int j2 = 0;
            while (j2 < topList.size()) {
                Hashtable subMenu = (Hashtable)topList.get(j2);
                if (subMenu.containsKey("LIST")) {
                    this.m_subNode = new DefaultMutableTreeNode(AppLang.getText((String)subMenu.get("TITLE")));
                    ArrayList subList = (ArrayList)subMenu.get("LIST");
                    if (subList != null && subList.size() > 0) {
                        int k2 = 0;
                        while (k2 < subList.size()) {
                            Hashtable leafMenu = (Hashtable)subList.get(k2);
                            this.m_leafNode = this.createTreeNode(leafMenu);
                            if (this.m_leafNode != null) {
                                this.m_subNode.add(this.m_leafNode);
                            }
                            ++k2;
                        }
                    }
                    if (this.m_subNode.getChildCount() > 0) {
                        this.m_topNode.add(this.m_subNode);
                    }
                } else {
                    this.m_leafNode = this.createTreeNode(subMenu);
                    if (this.m_leafNode != null) {
                        this.m_topNode.add(this.createTreeNode(subMenu));
                    }
                }
                ++j2;
            }
            if (this.m_topNode.getChildCount() > 0) {
                this.m_tnRoot.add(this.m_topNode);
            }
            ++i2;
        }
    }

    public void createKMMCTreeMenu() {
        this.makeKmmcTreeList();
        this.m_treeKmmc = new JTree(this.m_tnRootK);
        this.m_jspKmmc = new JScrollPane(this.m_treeKmmc);
        BasicTreeUI ui = (BasicTreeUI)this.m_treeKmmc.getUI();
        ui.setExpandedIcon(AppImages.Img_Tree_Minus);
        ui.setCollapsedIcon(AppImages.Img_Tree_Plus);
        this.m_treeKmmc.setCellRenderer(new MainTreeCellRender());
        this.m_treeKmmc.getSelectionModel().setSelectionMode(1);
        this.m_treeKmmc.setRootVisible(false);
        this.m_treeKmmc.setToggleClickCount(2);
        this.m_treeKmmc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                AppTreePane.this.valueChanged(null);
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.m_treeKmmc);
        ToolTipManager.sharedInstance().setInitialDelay(500);
    }

    private void makeKmmcTreeList() {
        int mmcNo;
        AppTreeNode tnInfo = null;
        TreeMap<Integer, ArrayList> leafNode = new TreeMap<Integer, ArrayList>();
        ArrayList leafList = null;
        String mmcList = "";
        for (Object msgId : AppProperty.m_useMmcList) {
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get((String)msgId);
            mmcList = tnInfo.getMmcList();
            if (mmcList == null || mmcList.equals("")) {
                leafList = leafNode.containsKey(1000) ? (ArrayList)leafNode.get(1000) : new ArrayList();
                leafList.add(leafList.size(), tnInfo);
                leafNode.put(1000, leafList);
                continue;
            }
            String[] stringArray = mmcList.split(";");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String mmc = stringArray[n3];
                mmcNo = Integer.parseInt(mmc);
                leafList = leafNode.containsKey(mmcNo) ? (ArrayList)leafNode.get(mmcNo) : new ArrayList();
                leafList.add(leafList.size(), tnInfo);
                leafNode.put(mmcNo, leafList);
                ++n3;
            }
        }
        Iterator it = leafNode.keySet().iterator();
        while (it.hasNext()) {
            mmcNo = (Integer)it.next();
            int index = mmcNo / 100 - 1;
            if (this.m_topList[index] == null) {
                this.m_topList[index] = new TreeMap();
            }
            this.m_topList[index].put(mmcNo, (ArrayList)leafNode.get(mmcNo));
        }
        int i2 = 0;
        while (i2 < this.m_topList.length) {
            if (this.m_topList[i2] != null) {
                this.m_topNodeK = new DefaultMutableTreeNode(" " + this.m_topTitle[i2]);
                Iterator it2 = this.m_topList[i2].keySet().iterator();
                while (it2.hasNext()) {
                    mmcNo = (Integer)it2.next();
                    if (mmcNo == 1000) {
                        for (Object tn : (ArrayList)this.m_topList[i2].get(mmcNo)) {
                            this.m_leafNodeK = this.createTreeNode((AppTreeNode)tn);
                            this.m_topNodeK.add(this.m_leafNodeK);
                        }
                        continue;
                    }
                    this.m_subNodeK = new DefaultMutableTreeNode("" + mmcNo);
                    for (Object tn : (ArrayList)this.m_topList[i2].get(mmcNo)) {
                        this.m_leafNodeK = this.createTreeNode((AppTreeNode)tn);
                        this.m_subNodeK.add(this.m_leafNodeK);
                    }
                    this.m_topNodeK.add(this.m_subNodeK);
                }
                this.m_tnRootK.add(this.m_topNodeK);
            }
            ++i2;
        }
    }

    public void valueChanged(TreeSelectionEvent e2) {
        DefaultMutableTreeNode node = null;
        node = this.m_menuMode.equals("KMMC") ? (DefaultMutableTreeNode)this.m_treeKmmc.getLastSelectedPathComponent() : (DefaultMutableTreeNode)this.m_treeFunc.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            AppTreeNode tnInfo = (AppTreeNode)node.getUserObject();
            tnInfo.setTopPanel(null);
            AppGlobal.g_frmMain.m_pagePane.openNewPage(node);
        }
    }

    public DefaultMutableTreeNode createTreeNode(Hashtable menu) {
        DefaultMutableTreeNode treenode = new DefaultMutableTreeNode();
        String msgId = (String)menu.get("MENU_MSGID");
        AppTreeNode tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(msgId);
        if (AppRunInfo.getRunMode() == 1) {
            if (Integer.parseInt(msgId, 16) >= 25344 && Integer.parseInt(msgId, 16) < 36864) {
                return null;
            }
            if (Integer.parseInt(msgId, 16) >= 37127) {
                return null;
            }
        }
        if (AppGlobal.g_useMenu.containsKey(msgId) && (tnInfo.getMenuKind() == 0 || tnInfo.getMenuKind() == 2) && ((String)AppGlobal.g_useMenu.get(msgId)).equals("0")) {
            tnInfo.setTreeNode(treenode);
            treenode.setUserObject(tnInfo);
            AppProperty.m_useMmcList.add(AppProperty.m_useMmcList.size(), msgId);
            return treenode;
        }
        if (this.m_bUseVMAA && tnInfo.getMenuKind() == 1) {
            tnInfo.setTreeNode(treenode);
            treenode.setUserObject(tnInfo);
            return treenode;
        }
        return null;
    }

    public DefaultMutableTreeNode createTreeNode(AppTreeNode tnInfo) {
        DefaultMutableTreeNode treenode = new DefaultMutableTreeNode();
        tnInfo.setTreeNode(treenode);
        treenode.setUserObject(tnInfo);
        return treenode;
    }

    public class MainTreeCellRender
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if (obj instanceof AppTreeNode) {
                AppTreeNode tnInfo = (AppTreeNode)obj;
                this.setIcon(null);
                this.setToolTipText(tnInfo.getToolTipText());
            } else {
                this.setIcon(null);
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

