/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages;

import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.view.AppTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class AppPageInfo
implements Serializable {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_BPLUS = 1;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_SPLUS = 3;
    public static final int TYPE_INT = 4;
    public static final int TYPE_IPLUS = 5;
    public static final int TYPE_IP = 6;
    public static final int TYPE_STRING = 7;
    public static final int TYPE_TEL = 8;
    public static final int TYPE_PORT = 9;
    public static final int TYPE_MAC = 10;
    public static final int TYPE_MBIT = 11;
    public static final int TYPE_LBIT = 12;
    public static final int TYPE_BNULL = 13;
    public static final int TYPE_SNULL = 14;
    public static final int TYPE_NPORT = 15;
    public static final int TYPE_NULL = 255;
    public static final int COMP_LABEL = 0;
    public static final int COMP_CHECK = 1;
    public static final int COMP_IP = 2;
    public static final int COMP_PORT = 3;
    public static final int COMP_SELECT = 4;
    public static final int COMP_TEXT = 5;
    public static final int COMP_MAC = 6;
    public static final int COMP_BVER = 7;
    public static final int COMP_SVER = 8;
    public static final int COMP_NONE = 255;
    private Hashtable m_pageInfo = new Hashtable();
    private Hashtable m_structure = new Hashtable();
    private String[] m_useItems = null;
    private boolean m_partial = false;

    public AppPageInfo() {
        this("");
    }

    public AppPageInfo(AppTreeNode tnInfo) {
        this(tnInfo.getMsgId());
    }

    public AppPageInfo(String msgId) {
        this.m_pageInfo.put("MSG_ID", msgId);
        this.m_pageInfo.put("MSG_DOWN_TYPE", (byte)-48);
        this.m_pageInfo.put("MSG_UP_TYPE", (byte)-16);
        this.m_pageInfo.put("RECORD_SIZE", 0);
        this.m_pageInfo.put("MSG_LEN", 0);
        this.m_pageInfo.put("MSG_RESP", (byte)-1);
        this.m_pageInfo.put("FIELD_COUNT", 0);
        this.m_pageInfo.put("RECV_DATA", new ArrayList());
        this.m_pageInfo.put("SAVE_DATA", new ArrayList());
        this.m_pageInfo.put("REQ_DATA", new byte[0]);
        this.m_pageInfo.put("RESP_DATA", new byte[0]);
        if (!msgId.equals("") && AppProperty.m_structure.containsKey(msgId)) {
            this.m_structure = (Hashtable)AppProperty.m_structure.get(msgId);
            this.setItemInfo();
        }
    }

    public String getMsgId() {
        return (String)this.m_pageInfo.get("MSG_ID");
    }

    public void setMsgId(String id) {
        this.m_pageInfo.put("MSG_ID", id);
    }

    public byte getDownMsgType() {
        return (Byte)this.m_pageInfo.get("MSG_DOWN_TYPE");
    }

    public void setDownMsgType(byte type) {
        this.m_pageInfo.put("MSG_DOWN_TYPE", type);
    }

    public byte getUpMsgType() {
        return (Byte)this.m_pageInfo.get("MSG_UP_TYPE");
    }

    public void setUpMsgType(byte type) {
        this.m_pageInfo.put("MSG_UP_TYPE", type);
    }

    public int getRecordSize() {
        return (Integer)this.m_pageInfo.get("RECORD_SIZE");
    }

    public void setRecordSize(int size) {
        this.m_pageInfo.put("RECORD_SIZE", size);
    }

    public int getMsgLength() {
        return (Integer)this.m_pageInfo.get("MSG_LEN");
    }

    public void setMsgLength(int len) {
        this.m_pageInfo.put("MSG_LEN", len);
    }

    public byte getMsgResponse() {
        return (Byte)this.m_pageInfo.get("MSG_RESP");
    }

    public void setMsgResponse(byte resp) {
        this.m_pageInfo.put("MSG_RESP", resp);
    }

    public ArrayList getRecvData() {
        return (ArrayList)this.m_pageInfo.get("RECV_DATA");
    }

    public void setRecvData(ArrayList data) {
        this.m_pageInfo.put("RECV_DATA", data);
    }

    public ArrayList getSaveData() {
        return (ArrayList)this.m_pageInfo.get("SAVE_DATA");
    }

    public void setSaveData(ArrayList data) {
        this.m_pageInfo.put("SAVE_DATA", data);
    }

    public byte[] getReqData() {
        return (byte[])this.m_pageInfo.get("REQ_DATA");
    }

    public void setReqData(byte[] data) {
        this.m_pageInfo.put("REQ_DATA", data);
    }

    public byte[] getRespData() {
        return (byte[])this.m_pageInfo.get("RESP_DATA");
    }

    public void setRespData(byte[] data) {
        this.m_pageInfo.put("RESP_DATA", data);
    }

    public boolean getPartialRequest() {
        return this.m_partial;
    }

    public void setPartialRequest(boolean status) {
        this.m_partial = status;
    }

    private void setItemInfo() {
        this.m_useItems = this.getUseItems((Hashtable)this.m_structure.get("ITEM_USABLE"));
        for (String key : this.m_structure.keySet()) {
            if (key.equals("ITEM_USABLE")) continue;
            Object info = this.m_structure.get(key);
            if (info instanceof ArrayList) {
                this.makeItemInfo(key, (ArrayList)info);
                continue;
            }
            if (!(info instanceof Hashtable)) continue;
            this.makeItemInfo(key, (Hashtable)info);
        }
    }

    private String[] getUseItems(Hashtable items) {
        String[] useItems = null;
        ArrayList uses = new ArrayList();
        for (String key : items.keySet()) {
            String[] version = key.split(";");
            if (Integer.parseInt(version[0], 16) > AppRunInfo.getRunVersion() || AppRunInfo.getRunVersion() > Integer.parseInt(version[1], 16)) continue;
            uses = (ArrayList)items.get(key);
            useItems = new String[uses.size()];
            int i2 = 0;
            while (i2 < uses.size()) {
                useItems[i2] = (String)uses.get(i2);
                ++i2;
            }
            break block0;
        }
        return useItems;
    }

    private void makeItemInfo(String key, ArrayList info) {
        ArrayList<String> items = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.m_useItems.length) {
            if (this.m_useItems[i2].equals("1")) {
                items.add(items.size(), (String)info.get(i2));
            }
            ++i2;
        }
        int[] iItems = new int[items.size()];
        String[] sItems = new String[items.size()];
        int rcdSize = 0;
        int i3 = 0;
        while (i3 < iItems.length) {
            if (key.equals("DATA_TYPE")) {
                iItems[i3] = this.convertDataType((String)items.get(i3));
            } else if (key.equals("DATA_SIZE")) {
                iItems[i3] = Integer.parseInt((String)items.get(i3));
                rcdSize += (short)iItems[i3];
            } else if (key.equals("FIELD_TYPE")) {
                iItems[i3] = this.convertFieldType((String)items.get(i3));
            } else if (key.equals("FIELD_DEFAULT")) {
                sItems[i3] = (String)items.get(i3);
            } else {
                iItems[i3] = Integer.parseInt((String)items.get(i3));
            }
            ++i3;
        }
        if (key.equals("FIELD_DEFAULT")) {
            this.m_pageInfo.put(key, sItems);
        } else if (key.equals("DATA_SIZE")) {
            this.m_pageInfo.put(key, iItems);
            this.m_pageInfo.put("RECORD_SIZE", rcdSize);
            this.m_pageInfo.put("FIELD_COUNT", iItems.length);
        } else {
            this.m_pageInfo.put(key, iItems);
        }
    }

    private void makeItemInfo(String key, Hashtable info) {
        String value = "";
        if (key.equals("TABLE_INFO")) {
            for (String item : info.keySet()) {
                this.m_pageInfo.put(item, info.get(item));
            }
        } else if (key.equals("ROW_TITLE")) {
            String titles = (String)this.getValidItem(info);
            String[][] titleInfo = this.getRowTitles(titles);
            this.m_pageInfo.put(key, titleInfo);
        } else if (key.equals("COL_TITLE") || key.equals("CORNER_TITLE")) {
            String titles = (String)this.getValidItem(info);
            String[][] titleInfo = this.getItemTitles(titles);
            this.m_pageInfo.put(key, titleInfo);
        } else if (key.equals("DATA_POSITION")) {
            ArrayList position = (ArrayList)this.getValidItem(info);
            int[] posInfo = new int[position.size()];
            int i2 = 0;
            while (i2 < posInfo.length) {
                value = (String)position.get(i2);
                if (value != null && !value.equals("")) {
                    posInfo[i2] = Integer.parseInt((String)position.get(i2));
                }
                ++i2;
            }
            this.m_pageInfo.put(key, posInfo);
        } else if (key.equals("CELL_SPAN")) {
            String[] cellSpan = ((String)this.getValidItem(info)).split(";");
            this.m_pageInfo.put(key, cellSpan);
        } else if (key.equals("ROW_WIDTH")) {
            String[] width = ((String)this.getValidItem(info)).split(";");
            int[] rowWidth = new int[width.length];
            int i3 = 0;
            while (i3 < rowWidth.length) {
                if (width[i3] != null && !width[i3].equals("")) {
                    rowWidth[i3] = Integer.parseInt(width[i3]);
                }
                ++i3;
            }
            this.m_pageInfo.put(key, rowWidth);
        } else if (key.equals("COL_WIDTH")) {
            ArrayList width = (ArrayList)this.getValidItem(info);
            int[] colWidth = new int[width.size()];
            int i4 = 0;
            while (i4 < colWidth.length) {
                value = (String)width.get(i4);
                if (value != null && !value.equals("")) {
                    colWidth[i4] = Integer.parseInt(value);
                }
                ++i4;
            }
            this.m_pageInfo.put(key, colWidth);
        }
    }

    public String getCheckTable() {
        if (this.m_pageInfo.containsKey("CHECK_TABLE")) {
            return (String)this.m_pageInfo.get("CHECK_TABLE");
        }
        return "";
    }

    public int[] getDataType() {
        return (int[])this.m_pageInfo.get("DATA_TYPE");
    }

    public int getDataType(int index) {
        int[] dataType = this.getDataType();
        return dataType[index];
    }

    public void setDataType(int index, int type) {
        int[] dataType = this.getDataType();
        dataType[index] = type;
        this.m_pageInfo.put("DATA_TYPE", dataType);
    }

    public int[] getDataSize() {
        return (int[])this.m_pageInfo.get("DATA_SIZE");
    }

    public int getDataSize(int index) {
        int[] dataSize = this.getDataSize();
        return dataSize[index];
    }

    public void setDataSize(int index, int size) {
        int[] dataSize = this.getDataSize();
        dataSize[index] = size;
        this.m_pageInfo.put("DATA_SIZE", dataSize);
    }

    public int[] getDataPosition() {
        return (int[])this.m_pageInfo.get("DATA_POSITION");
    }

    public int getDataPosition(int index) {
        int[] position = this.getDataPosition();
        return position[index];
    }

    public int[] getFieldType() {
        return (int[])this.m_pageInfo.get("FIELD_TYPE");
    }

    public int getFieldType(int index) {
        int[] fieldType = this.getFieldType();
        return fieldType[index];
    }

    public void setFieldType(int[] type) {
        this.m_pageInfo.put("FIELD_TYPE", type);
    }

    public void setFieldType(byte[] type) {
        int[] fieldType = this.getFieldType();
        int[] dataSize = this.getDataSize();
        int offset = 0;
        int i2 = 0;
        while (i2 < this.getFieldCount()) {
            if (type[offset] == 0) {
                fieldType[i2] = 255;
            }
            offset += dataSize[i2];
            ++i2;
        }
        this.m_pageInfo.put("FIELD_TYPE", fieldType);
    }

    public void setFieldType(int index, int type) {
        int[] fieldType = this.getFieldType();
        fieldType[index] = type;
        this.m_pageInfo.put("FIELD_TYPE", fieldType);
    }

    public int[] getFieldPattern() {
        return (int[])this.m_pageInfo.get("FIELD_PATTERN");
    }

    public int getFieldPattern(int index) {
        int[] fieldPattern = this.getFieldPattern();
        return fieldPattern[index];
    }

    public void setFieldPattern(int index, int pattern) {
        int[] fieldPattern = this.getFieldPattern();
        fieldPattern[index] = pattern;
        this.m_pageInfo.put("FIELD_PATTERN", fieldPattern);
    }

    public int[] getFieldItem() {
        return (int[])this.m_pageInfo.get("FIELD_ITEM");
    }

    public int getFieldItem(int index) {
        int[] fieldItem = this.getFieldItem();
        return fieldItem[index];
    }

    public void setFieldItem(int index, int item) {
        int[] fieldItem = this.getFieldItem();
        fieldItem[index] = item;
        this.m_pageInfo.put("FIELD_ITEM", fieldItem);
    }

    public int[] getFieldMin() {
        return (int[])this.m_pageInfo.get("FIELD_MIN");
    }

    public int getFieldMin(int index) {
        int[] fieldMin = this.getFieldMin();
        return fieldMin[index];
    }

    public void setFieldMin(int index, int min) {
        int[] fieldMin = this.getFieldMin();
        fieldMin[index] = min;
        this.m_pageInfo.put("FIELD_MIN", fieldMin);
    }

    public int[] getFieldMax() {
        return (int[])this.m_pageInfo.get("FIELD_MAX");
    }

    public int getFieldMax(int index) {
        int[] fieldMax = this.getFieldMax();
        return fieldMax[index];
    }

    public void setFieldMax(int index, int max) {
        int[] fieldMax = this.getFieldMin();
        fieldMax[index] = max;
        this.m_pageInfo.put("FIELD_MAX", fieldMax);
    }

    public String[] getFieldDefault() {
        return (String[])this.m_pageInfo.get("FIELD_DEFAULT");
    }

    public String getFieldDefault(int index) {
        String[] fieldDefault = this.getFieldDefault();
        return fieldDefault[index];
    }

    public void setFieldDefault(int index, String val) {
        String[] fieldDefault = this.getFieldDefault();
        fieldDefault[index] = val;
        this.m_pageInfo.put("FIELD_DEFAULT", fieldDefault);
    }

    public int[] getFieldLength() {
        return (int[])this.m_pageInfo.get("FIELD_LENGTH");
    }

    public int getFieldLength(int index) {
        int[] fieldLength = this.getFieldLength();
        return fieldLength[index];
    }

    public void setFieldLength(int index, int len) {
        int[] fieldLength = this.getFieldLength();
        fieldLength[index] = len;
        this.m_pageInfo.put("FIELD_LENGTH", fieldLength);
    }

    public int[] getFieldEnable() {
        return (int[])this.m_pageInfo.get("FIELD_ENABLE");
    }

    public int getFieldEnable(int index) {
        int[] fieldEnable = this.getFieldEnable();
        return fieldEnable[index];
    }

    public void setFieldEnable(int index, int enable) {
        int[] fieldEnable = this.getFieldEnable();
        fieldEnable[index] = enable;
        this.m_pageInfo.put("FIELD_ENABLE", fieldEnable);
    }

    public int getFieldCount() {
        return (Integer)this.m_pageInfo.get("FIELD_COUNT");
    }

    public void setFieldCount(int count) {
        this.m_pageInfo.put("FIELD_COUNT", count);
    }

    public Hashtable getTableInfo() {
        return (Hashtable)this.m_pageInfo.get("TABLE_INFO");
    }

    public String[][] getRowTitle() {
        return (String[][])this.m_pageInfo.get("ROW_TITLE");
    }

    public String[][] getColTitle() {
        return (String[][])this.m_pageInfo.get("COL_TITLE");
    }

    public String[][] getCornerTitle() {
        return (String[][])this.m_pageInfo.get("CORNER_TITLE");
    }

    public String[] getCellSpan() {
        return (String[])this.m_pageInfo.get("CELL_SPAN");
    }

    public int[] getRowWidth() {
        return (int[])this.m_pageInfo.get("ROW_WIDTH");
    }

    public int[] getColWidth() {
        return (int[])this.m_pageInfo.get("COL_WIDTH");
    }

    private String[][] getRowTitles(String title) {
        String[][] titleItems = null;
        if (title == null || title.equals("")) {
            titleItems = new String[0][0];
        } else {
            String[] titles = title.split(";");
            titleItems = new String[titles.length][titles[0].split("-").length];
            int i2 = 0;
            while (i2 < titleItems.length) {
                String[] items = titles[i2].split("-");
                int j2 = 0;
                while (j2 < titleItems[i2].length) {
                    titleItems[i2][j2] = items[j2].trim();
                    ++j2;
                }
                ++i2;
            }
        }
        return titleItems;
    }

    private String[][] getItemTitles(String title) {
        String[][] titleItems = null;
        if (title == null || title.equals("")) {
            titleItems = new String[0][0];
        } else {
            String[] titles = title.split(";");
            titleItems = new String[titles[0].split("-").length][titles.length];
            int i2 = 0;
            while (i2 < titleItems[0].length) {
                String[] items = titles[i2].split("-");
                int j2 = 0;
                while (j2 < items.length) {
                    titleItems[j2][i2] = items[j2].trim();
                    ++j2;
                }
                ++i2;
            }
        }
        return titleItems;
    }

    private Object getValidItem(Hashtable items) {
        Object useItem = null;
        for (String key : items.keySet()) {
            String[] version = key.split(";");
            if (Integer.parseInt(version[0], 16) > AppRunInfo.getRunVersion() || AppRunInfo.getRunVersion() > Integer.parseInt(version[1], 16)) continue;
            useItem = items.get(key);
            break;
        }
        return useItem;
    }

    private int convertDataType(String type) {
        if (type.equals("byte")) {
            return 0;
        }
        if (type.equals("bplus")) {
            return 1;
        }
        if (type.equals("short")) {
            return 2;
        }
        if (type.equals("splus")) {
            return 3;
        }
        if (type.equals("int")) {
            return 4;
        }
        if (type.equals("iplus")) {
            return 5;
        }
        if (type.equals("ip")) {
            return 6;
        }
        if (type.equals("string")) {
            return 7;
        }
        if (type.equals("tel")) {
            return 8;
        }
        if (type.equals("port")) {
            return 9;
        }
        if (type.equals("mac")) {
            return 10;
        }
        if (type.equals("mbit")) {
            return 11;
        }
        if (type.equals("lbit")) {
            return 12;
        }
        if (type.equals("bnull")) {
            return 13;
        }
        if (type.equals("snull")) {
            return 14;
        }
        if (type.equals("nport")) {
            return 15;
        }
        return 255;
    }

    private int convertFieldType(String type) {
        if (type.equals("C")) {
            return 1;
        }
        if (type.equals("I")) {
            return 2;
        }
        if (type.equals("L")) {
            return 0;
        }
        if (type.equals("P")) {
            return 3;
        }
        if (type.equals("S")) {
            return 4;
        }
        if (type.equals("T")) {
            return 5;
        }
        if (type.equals("M")) {
            return 6;
        }
        if (type.equals("BV")) {
            return 7;
        }
        if (type.equals("SV")) {
            return 8;
        }
        return 255;
    }
}

