/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.conference;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunConference;
import com.sec.osdm.pages.AppConference;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.conference.PA202ViewDetailConference;
import com.sec.osdm.pages.conference.PA203ViewPartyList;
import com.sec.osdm.pages.conference.PA204CancelConference;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

public class PA201ViewConferenceInProgress
extends AppConference {
    private final int SIZE_WIDTH = 817;
    private final int SIZE_HEIGHT = 510;
    private JButton[] m_buttons = new JButton[6];
    private JLabel m_lbDuration = new JLabel("", 0);
    private int m_curWeek = 0;

    public PA201ViewConferenceInProgress(AppConference parent, int curWeek) {
        this.m_parent = parent;
        this.m_curWeek = curWeek;
        this.m_colTitle = new String[][]{{"Select", "Card", "Conference ID", "Subject", "Members", "Start Time", "End Time", "Owner Station", "Status"}};
        this.m_layout = new AppLayout(this.m_panMain, 817, 510);
        this.initParentData();
        this.createComponents();
        this.openDialog("Conference In Progress", 817, 510);
    }

    public void createComponents() {
        String[] titles = new String[]{"<", ">", "Detail", "Cancel", "Participant Info", "Close"};
        int i2 = 0;
        while (i2 < this.m_buttons.length) {
            this.m_buttons[i2] = new JButton(AppLang.getText(titles[i2]));
            this.m_buttons[i2].setMargin(new Insets(0, 0, 0, 0));
            this.m_buttons[i2].setActionCommand(titles[i2]);
            this.m_buttons[i2].addActionListener(this);
            ++i2;
        }
        this.m_buttons[3].setEnabled(false);
        this.m_layout.addComponent(this.m_buttons[0], 5, 10, 50, 22);
        this.m_lbDuration.setFont(new Font("SansSerif", 0, 15));
        this.m_layout.addComponent(this.m_lbDuration, 150, 10, 535, 22);
        this.m_layout.addComponent(this.m_buttons[1], 756, 10, 50, 22);
        this.m_layout.addComponent(this.m_buttons[2], 435, 451, 120, 22);
        this.m_layout.addComponent(this.m_buttons[3], 561, 451, 120, 22);
        this.m_buttons[4].setVisible(false);
        this.m_layout.addComponent(this.m_buttons[4], 265, 451, 120, 22);
        this.m_layout.addComponent(this.m_buttons[5], 686, 451, 120, 22);
        this.getConferenceListInProgress();
    }

    public boolean getConferenceListInProgress() {
        this.m_buttons[2].setEnabled(false);
        this.m_buttons[3].setEnabled(false);
        this.m_buttons[4].setEnabled(false);
        this.m_reqData = new byte[22];
        int[] cols = this.m_parent.m_table.getTable().getSelectedColumns();
        int[] rows = this.m_parent.m_table.getTable().getSelectedRows();
        if (cols.length < 1 || rows.length < 1) {
            System.arraycopy(AppRunConference.addDate(AppRunConference.getSystemTime(), this.m_curWeek), 0, this.m_reqData, 0, 8);
            this.m_reqData[0] = 0;
            this.m_reqData[1] = 0;
            this.m_reqData[2] = 0;
            System.arraycopy(AppRunConference.addDate(AppRunConference.getSystemTime(), this.m_curWeek), 0, this.m_reqData, 8, 8);
            this.m_reqData[8] = 0;
            this.m_reqData[9] = 59;
            this.m_reqData[10] = 23;
        } else {
            int diffMinute = ((cols[cols.length - 1] - cols[0]) * 4 * 24 + rows[rows.length - 1] - rows[0] + 1) * 15;
            Calendar myCal = Calendar.getInstance();
            byte[] myArray = new byte[8];
            System.arraycopy((byte[])this.m_parent.m_reqList.get(cols[0]), 0, myArray, 0, 8);
            int selTime = rows[0];
            myArray[0] = 0;
            myArray[1] = (byte)(selTime % 4 * 15);
            myArray[2] = (byte)(selTime / 4);
            AppRunConference.vArrayList2Calendar(myCal, myArray);
            myCal.add(12, diffMinute * this.m_curWeek);
            AppRunConference.vCalendar2ArrayList(myArray, myCal);
            System.arraycopy(myArray, 0, this.m_reqData, 0, 8);
            System.arraycopy((byte[])this.m_parent.m_reqList.get(cols[cols.length - 1]), 0, myArray, 0, 8);
            selTime = rows[rows.length - 1];
            myArray[0] = 0;
            myArray[1] = (byte)(selTime % 4 * 15 + 14);
            myArray[2] = (byte)(selTime / 4);
            AppRunConference.vArrayList2Calendar(myCal, myArray);
            myCal.add(12, diffMinute * this.m_curWeek);
            AppRunConference.vCalendar2ArrayList(myArray, myCal);
            System.arraycopy(myArray, 0, this.m_reqData, 8, 8);
        }
        System.arraycopy(this.m_cardPos, 0, this.m_reqData, 16, 2);
        AppFunctions.tel2byte(this.m_reqData, 18, "");
        this.m_reqData[20] = 3;
        this.m_reqData[21] = -1;
        this.m_pageInfo = new AppPageInfo("A201");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        if (!this.readDataFromSystem()) {
            return false;
        }
        this.setComponents();
        return true;
    }

    public void setComponents() {
        ArrayList recvData = new ArrayList();
        ArrayList<Object> compData = null;
        byte[] date = new byte[8];
        System.arraycopy(this.m_reqData, 0, date, 0, 8);
        this.m_lbDuration.setText(String.valueOf(AppRunConference.getCurrentDate(date)) + " ~ ");
        System.arraycopy(this.m_reqData, 8, date, 0, 8);
        this.m_lbDuration.setText(String.valueOf(this.m_lbDuration.getText().trim()) + AppRunConference.getCurrentDate(date));
        this.m_components.clear();
        int i2 = 0;
        while (i2 < this.m_recvData.size()) {
            String sValue;
            recvData = (ArrayList)this.m_recvData.get(i2);
            compData = new ArrayList<Object>();
            this.m_compRadio = new JRadioButton();
            this.m_compRadio.setActionCommand("" + i2);
            this.m_compRadio.addActionListener(new SelectListener());
            this.m_compRadio.setHorizontalAlignment(0);
            compData.add(0, this.m_compRadio);
            this.m_compText = new AppTextBox();
            this.m_compText.setText("C" + (this.m_parent.m_cardPos[0] + 1) + "-S" + (this.m_parent.m_cardPos[1] + 1));
            compData.add(1, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(18));
            compData.add(2, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(25));
            compData.add(3, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(19));
            compData.add(4, this.m_compText);
            int j2 = 0;
            while (j2 < 8) {
                sValue = (String)recvData.get(j2 + 1);
                sValue = sValue.equals("") ? "255" : sValue;
                date[j2] = (byte)Integer.parseInt(sValue);
                ++j2;
            }
            this.m_compText = new AppTextBox();
            this.m_compText.setText(AppRunConference.getCurrentDate(date));
            compData.add(5, this.m_compText);
            j2 = 0;
            while (j2 < 8) {
                sValue = (String)recvData.get(j2 + 9);
                sValue = sValue.equals("") ? "255" : sValue;
                date[j2] = (byte)Integer.parseInt(sValue);
                ++j2;
            }
            this.m_compText = new AppTextBox();
            this.m_compText.setText(AppRunConference.getCurrentDate(date));
            compData.add(6, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(17));
            compData.add(7, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText(((String)recvData.get(21)).equals("2") ? "Active" : "Inactive");
            compData.add(8, this.m_compText);
            this.m_components.add(i2, compData);
            ++i2;
        }
        this.m_rowTitle = new String[this.m_components.size()][1];
        this.createTable();
    }

    public void createTable() {
        if (this.m_table != null) {
            this.m_panMain.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                return ((ArrayList)PA201ViewConferenceInProgress.this.m_components.get(row)).get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        this.m_model.setColWidth(new int[]{50, 50, 55, 175, 65, 110, 110, 105, 80});
        this.m_model.setRowHeaderHidden();
        this.m_table = new AppTable(this.m_model);
        this.m_table.getTable().setColumnSelectionAllowed(true);
        this.m_layout.addComponent(this.m_table, 5, 33, 803, 415);
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("<")) {
            --this.m_curWeek;
            if (this.getConferenceListInProgress()) {
                if (!this.m_buttons[1].isEnabled()) {
                    this.m_buttons[1].setEnabled(true);
                }
            } else {
                JOptionPane.showMessageDialog(null, AppLang.getText("No Data exists for Previous Week."));
                ++this.m_curWeek;
                this.m_buttons[0].setEnabled(false);
            }
        } else if (command.equals(">")) {
            ++this.m_curWeek;
            if (this.getConferenceListInProgress()) {
                if (!this.m_buttons[0].isEnabled()) {
                    this.m_buttons[0].setEnabled(true);
                }
            } else {
                JOptionPane.showMessageDialog(null, AppLang.getText("No Data exists for Next Week."));
                --this.m_curWeek;
                this.m_buttons[1].setEnabled(false);
            }
        } else if (command.equals("Close")) {
            this.closeDialog();
        } else if (this.m_selRow >= 0) {
            this.setVisible(false);
            if (command.equals("Detail")) {
                this.m_pageSource = 0;
                new PA202ViewDetailConference(this);
            } else if (command.equals("Cancel")) {
                new PA204CancelConference(this);
            } else if (command.equals("Participant Info")) {
                new PA203ViewPartyList(this);
            }
        }
    }

    class SelectListener
    implements ActionListener {
        SelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            PA201ViewConferenceInProgress.this.m_selRow = Integer.parseInt(e2.getActionCommand());
            int i2 = 0;
            while (i2 < PA201ViewConferenceInProgress.this.m_model.getRowHdrRowCount()) {
                if (i2 != PA201ViewConferenceInProgress.this.m_selRow) {
                    ((JRadioButton)PA201ViewConferenceInProgress.this.m_model.getValueAt(i2, 0)).setSelected(false);
                } else {
                    ArrayList recvData = (ArrayList)PA201ViewConferenceInProgress.this.m_recvData.get(PA201ViewConferenceInProgress.this.m_selRow);
                    switch (Integer.parseInt((String)recvData.get(21))) {
                        case 2: {
                            PA201ViewConferenceInProgress.this.m_buttons[2].setEnabled(true);
                            PA201ViewConferenceInProgress.this.m_buttons[3].setEnabled(false);
                            break;
                        }
                        case 4: {
                            PA201ViewConferenceInProgress.this.m_buttons[2].setEnabled(true);
                            PA201ViewConferenceInProgress.this.m_buttons[3].setEnabled(true);
                        }
                    }
                }
                ++i2;
            }
            PA201ViewConferenceInProgress.this.m_table.repaint();
        }
    }
}

