/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.utils.table.TablePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AppSearchTableDlg
extends JDialog
implements ActionListener,
KeyListener {
    public static AppSearchTableDlg s_dlg = null;
    public static Dimension DIMENSION_BUTTON = new Dimension(90, 30);
    protected static String ACTION_FIND_NEXT = "Find Next";
    protected static String ACTION_FIND_PREV = "Find Prev";
    protected static String ACTION_CLOSE = "Close";
    protected JTextField m_txtSearch = new JTextField(15);
    protected JCheckBox m_checkOpt1 = new JCheckBox(AppLang.getText("Case sensitive"), true);
    protected JCheckBox m_checkOpt2 = new JCheckBox(AppLang.getText("Wrap at the end of file"), true);
    protected Toolkit m_toolkit = Toolkit.getDefaultToolkit();
    protected JTable m_table = null;

    public AppSearchTableDlg() {
        super(AppGlobal.g_frmMain, AppLang.getText("Find Dialog"), true);
        this.setPanel();
        this.addKeyListener(this);
        this.setDefaultCloseOperation(2);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.pack();
    }

    public void setPanel() {
        JPanel innerPanel = new JPanel(new FlowLayout(0));
        innerPanel.add(this.getLeftPanel());
        innerPanel.add(this.getRightPanel());
        Container panContent = this.getContentPane();
        panContent.setLayout(new BorderLayout());
        panContent.add(Box.createRigidArea(new Dimension(0, 5)), "First");
        panContent.add(Box.createRigidArea(new Dimension(0, 5)), "Last");
        panContent.add(Box.createRigidArea(new Dimension(5, 0)), "Before");
        panContent.add(Box.createRigidArea(new Dimension(5, 0)), "After");
        panContent.add((Component)innerPanel, "Center");
    }

    public JPanel getLeftPanel() {
        JPanel txtPanel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(AppLang.getText("Find what :"));
        txtPanel.add(label);
        txtPanel.add(this.m_txtSearch);
        this.m_txtSearch.setActionCommand(ACTION_FIND_NEXT);
        this.m_txtSearch.addActionListener(this);
        this.m_txtSearch.addKeyListener(this);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 1));
        searchPanel.add(txtPanel);
        searchPanel.add(this.m_checkOpt1);
        searchPanel.add(this.m_checkOpt2);
        searchPanel.add(Box.createVerticalGlue());
        return searchPanel;
    }

    public JPanel getRightPanel() {
        JButton btnFindNext = new JButton(AppLang.getText("Find Next"));
        btnFindNext.setActionCommand(ACTION_FIND_NEXT);
        btnFindNext.addActionListener(this);
        AppGlobal.fixSize(btnFindNext, DIMENSION_BUTTON);
        JButton btnFindPrev = new JButton(AppLang.getText("Find Prev"));
        btnFindPrev.setActionCommand(ACTION_FIND_PREV);
        btnFindPrev.addActionListener(this);
        AppGlobal.fixSize(btnFindPrev, DIMENSION_BUTTON);
        JButton btnClose = new JButton(AppLang.getText("Close"));
        btnClose.setActionCommand(ACTION_CLOSE);
        btnClose.addActionListener(this);
        AppGlobal.fixSize(btnClose, DIMENSION_BUTTON);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 1));
        btnPanel.add(btnFindNext);
        btnPanel.add(btnFindPrev);
        btnPanel.add(btnClose);
        return btnPanel;
    }

    protected void initDlg(JTable table) {
        this.m_table = table;
        this.m_txtSearch.requestFocusInWindow();
        int row = this.m_table.getSelectedRow();
        int col = this.m_table.getSelectedColumn();
        if (row == -1 || col == -1) {
            this.m_txtSearch.setText("");
        } else {
            this.m_txtSearch.setText(this.m_table.getValueAt(row, col).toString());
        }
        this.m_txtSearch.selectAll();
    }

    protected void deinitDlg() {
    }

    public static void showDlg(JTable table) {
        if (s_dlg == null) {
            s_dlg = new AppSearchTableDlg();
            s_dlg.setDefaultCloseOperation(2);
        }
        s_dlg.initDlg(table);
        s_dlg.setLocation(AppGlobal.getCenterPoint(s_dlg.getWidth(), s_dlg.getHeight()));
        s_dlg.setVisible(true);
        s_dlg.pack();
    }

    protected boolean compareString(boolean caseSens, String str1, String str2) {
        if (str2.equals("")) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < str1.length()) {
            if (str1.regionMatches(!caseSens, i2, str2, 0, str2.length())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    protected boolean isRowHidden(int row) {
        return this.m_table.getRowHeight(row) == 0;
    }

    protected boolean isColHidden(int col) {
        return this.m_table.getTableHeader().getColumnModel().getColumn(col).getPreferredWidth() == 0;
    }

    protected TablePoint incPoint(TablePoint point) {
        int newCol = point.col + 1;
        point.col = newCol % this.m_table.getColumnCount();
        int newRow = point.row + newCol / this.m_table.getColumnCount();
        point.row = newRow % this.m_table.getRowCount();
        return point;
    }

    public TablePoint incPointWithHidden(TablePoint point) {
        TablePoint newPoint = point;
        do {
            newPoint = this.incPoint(newPoint);
        } while (this.isColHidden(newPoint.col) || this.isRowHidden(newPoint.row));
        return newPoint;
    }

    public TablePoint decPointWithHidden(TablePoint point) {
        TablePoint newPoint = point;
        do {
            newPoint = this.decPoint(newPoint);
        } while (this.isColHidden(newPoint.col) || this.isRowHidden(newPoint.row));
        return newPoint;
    }

    protected TablePoint decPoint(TablePoint point) {
        --point.col;
        if (point.col < 0) {
            point.col = this.m_table.getColumnCount() - 1;
            --point.row;
            if (point.row < 0) {
                point.row = this.m_table.getRowCount() - 1;
            }
        }
        return point;
    }

    public void search(TablePoint point, boolean isNext) {
        String strSearch = this.m_txtSearch.getText();
        String strTableValue = null;
        TablePoint newPoint = new TablePoint(point);
        do {
            Object obj;
            if (isNext) {
                this.incPointWithHidden(newPoint);
            } else {
                this.decPointWithHidden(newPoint);
            }
            if (isNext && newPoint.row == 0 && newPoint.col == 0 || !isNext && newPoint.row == this.m_table.getRowCount() - 1 && newPoint.col == this.m_table.getColumnCount() - 1) {
                this.m_toolkit.beep();
                if (!this.m_checkOpt2.isSelected()) {
                    JOptionPane.showMessageDialog(this, "Cann't Found Symbol : " + strSearch);
                    return;
                }
            }
            strTableValue = (obj = this.m_table.getValueAt(newPoint.row, newPoint.col)) == null ? null : obj.toString();
            if (!this.compareString(this.m_checkOpt1.isSelected(), strTableValue, strSearch)) continue;
            this.m_table.changeSelection(newPoint.row, newPoint.col, false, false);
            return;
        } while (!newPoint.equals(point));
        this.m_toolkit.beep();
        JOptionPane.showMessageDialog(this, "Cann't Found Symbol : " + strSearch);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String strCommand = e2.getActionCommand();
        if (strCommand.equals(ACTION_FIND_NEXT)) {
            int row = this.m_table.getSelectedRow();
            int col = this.m_table.getSelectedColumn();
            if (row == -1 || col == -1) {
                row = 0;
                col = 0;
            }
            TablePoint p2 = new TablePoint(row, col);
            this.search(p2, true);
        } else if (strCommand.equals(ACTION_FIND_PREV)) {
            int row = this.m_table.getSelectedRow();
            int col = this.m_table.getSelectedColumn();
            if (row == -1 || col == -1) {
                row = 0;
                col = 0;
            }
            TablePoint p3 = new TablePoint(row, col);
            this.search(p3, false);
        } else if (strCommand.equals(ACTION_CLOSE)) {
            s_dlg.deinitDlg();
            s_dlg.setVisible(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 27) {
            s_dlg.deinitDlg();
            s_dlg.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }
}

